/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MJWindow;
import com.mathworks.mwswing.MacFullScreenUtils;
import com.mathworks.mwswing.MouseWheelRedirector;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.mwswing.modality.ModalManager;
import com.mathworks.mwswing.modality.ModalManagerImpl;
import com.mathworks.mwswing.modality.ModalParticipant;
import com.mathworks.mwswing.window.MJFullWindowRegistry;
import com.mathworks.util.HWndProvider;
import com.mathworks.util.NativeEvent;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class MJFrame
extends JFrame
implements HWndProvider,
ModalParticipant {
    private boolean fNativeEventsEnabled;
    private Action fEscapeAction;
    private boolean fDragResizeInProgress;
    private boolean fLayoutPending;
    private Image fIconImage;
    private Image fSmallIconImage;
    private boolean fModal;
    private ModalManager fModalManager;
    private List<NativeEvent.Listener> fNativeListeners;
    private static Insets sCachedInsets;
    private static boolean sCachedInsetsCalculated;
    private static Insets sCachedNoresizeInsets;
    private static boolean sCachedNoresizeInsetsCalculated;
    protected static final int MAXIMIZE_BOTH = 6;
    private MinimizeAction fMinimizeAction;
    private boolean fAllowsFullScreen;
    private boolean fIsFullScreen;
    private Object fFullScreenListener = null;
    private boolean fUseToFront = true;

    public MJFrame() {
        this((String)null);
    }

    public MJFrame(String string) {
        super(string);
        this.init();
    }

    public MJFrame(GraphicsConfiguration graphicsConfiguration) {
        this((String)null, graphicsConfiguration);
    }

    public MJFrame(String string, GraphicsConfiguration graphicsConfiguration) {
        super(string, graphicsConfiguration);
        this.init();
    }

    private void init() {
        this.initializeIcons();
        this.addWindowListener(new WindowTracker());
        MJFullWindowRegistry.register(this);
        if (MouseWheelRedirector.isEnabled()) {
            this.getRootPane().addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                }
            });
        }
        this.fModalManager = MJFrame.getModalManager();
        this.fModalManager.addParticipant(this, false);
        this.enableEvents(64L);
    }

    public void setAllowsFullScreen(boolean bl) {
        this.fAllowsFullScreen = bl;
    }

    public boolean isFullScreen() {
        return this.fIsFullScreen;
    }

    public static ImageIcon getMatlabIcon() {
        return ApplicationIcon.MATLAB_32x32.getIcon();
    }

    public static ImageIcon getSmallMatlabIcon() {
        return ApplicationIcon.MATLAB.getIcon();
    }

    private void initializeIcons() {
        if (!PlatformInfo.isMacintosh()) {
            this.setIconImage(ApplicationIcon.MATLAB_32x32.getIcon().getImage());
            this.setSmallIconImage(ApplicationIcon.MATLAB.getIcon().getImage());
        }
    }

    protected void useToFront(boolean bl) {
        this.fUseToFront = bl;
    }

    private boolean isThisProcessInForeground() {
        if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows()) {
            return NativeJava.isThisProcessInForeground((long)this.getHWnd());
        }
        return true;
    }

    @Override
    public void hide() {
        super.hide();
        if (this.fModal) {
            this.fModalManager.setParticipantModal(this, false);
        }
    }

    @Override
    public void show() {
        boolean bl = NativeJava.nativeLibraryExists() && PlatformInfo.isWindows();
        super.show();
        if (bl && this.getState() != 1 && (this.fUseToFront || this.isThisProcessInForeground())) {
            this.toFront();
        }
        if (this.fModal) {
            this.fModalManager.setParticipantModal(this, true);
        }
    }

    public static MJFrame getFrame(Component component) {
        Component component2 = SwingUtilities.getRoot(component);
        return component2 instanceof MJFrame ? (MJFrame)component2 : null;
    }

    public long getHWnd() {
        return NativeJava.getHWnd((Frame)this);
    }

    public String getSpecifiedTitle() {
        return super.getTitle();
    }

    public void setCloseOnEscapeEnabled(boolean bl) {
        if (bl && this.fEscapeAction == null) {
            this.fEscapeAction = new MJWindow.EscapeAction();
            ((MJWindow.EscapeAction)this.fEscapeAction).attachTo(this);
        }
        if (this.fEscapeAction != null) {
            this.fEscapeAction.setEnabled(bl);
        }
    }

    public boolean isCloseOnEscapeEnabled() {
        return this.fEscapeAction != null && this.fEscapeAction.isEnabled();
    }

    protected void beginDragResize() {
        this.fDragResizeInProgress = true;
    }

    protected void endDragResize() {
        this.fDragResizeInProgress = false;
        if (this.fLayoutPending) {
            this.doLayout();
        }
    }

    @Override
    public void doLayout() {
        if (this.fDragResizeInProgress && !Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
            this.fLayoutPending = true;
        } else {
            super.doLayout();
        }
    }

    @Override
    public void addNotify() {
        try {
            super.addNotify();
        }
        catch (NullPointerException nullPointerException) {
            super.addNotify();
        }
        if (NativeJava.nativeLibraryExists() && PlatformInfo.isWindows() && !this.fNativeEventsEnabled) {
            MJWindow.enableNativeEvents(this);
            this.fNativeEventsEnabled = true;
        }
        if (PlatformInfo.isMacintosh() && this.fAllowsFullScreen) {
            try {
                Class<?> clazz = Class.forName("com.apple.eawt.FullScreenListener");
                this.fFullScreenListener = Proxy.newProxyInstance(MJFrame.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new FullScreenListenerDelegator());
                MacFullScreenUtils.AddMacFullScreenListener(this, this.fFullScreenListener);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        MJUtilities.runOnEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (PlatformInfo.isMacintosh() && MJFrame.this.fMinimizeAction == null) {
                    MJFrame.this.fMinimizeAction = new MinimizeAction();
                    MJFrame.this.fMinimizeAction.attachTo(MJFrame.this);
                }
            }
        });
    }

    @Override
    public void removeNotify() {
        if (PlatformInfo.isMacintosh() && this.fAllowsFullScreen && this.fFullScreenListener != null) {
            MacFullScreenUtils.RemoveMacFullScreenListener(this, this.fFullScreenListener);
            this.fFullScreenListener = null;
        }
        MJUtilities.runOnEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (MJFrame.this.fMinimizeAction != null) {
                    MJFrame.this.fMinimizeAction.removeFrom(MJFrame.this);
                    MJFrame.this.fMinimizeAction = null;
                }
            }
        });
        super.removeNotify();
    }

    @Override
    public void dispose() {
        MJFullWindowRegistry.unregister(this);
        if (this.fNativeEventsEnabled) {
            MJWindow.disableNativeEvents(this);
            this.fNativeEventsEnabled = false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            super.dispose();
        } else {
            if (this.isVisible() && Thread.currentThread().getName().equals("main")) {
                this.setVisible(false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MJFrame.super.dispose();
                }
            });
        }
        assert (this.fModalManager != null);
        this.fModalManager.removeParticipant(this);
        this.disableEvents(64L);
    }

    @Override
    public void toFront() {
        if (!PlatformInfo.isMacintosh() && this.isMinimized()) {
            this.setMinimized(false);
        }
        super.toFront();
    }

    public boolean isMinimized() {
        return this.getState() == 1;
    }

    public void setMinimized(boolean bl) {
        this.setState(bl ? 1 : 0);
    }

    public boolean isMaximized() {
        int n = this.getExtendedState();
        return (n & 6) == 6;
    }

    public void setMaximized(boolean bl) {
        this.setExtendedState(bl ? 6 : 0);
    }

    public Dimension getRestoredSize() {
        return NativeJava.getRestoredSize((Window)this);
    }

    public void setRestoredSize(Dimension dimension) {
        NativeJava.setRestoredSize((Window)this, (Dimension)dimension);
    }

    public void setRestoredSize(int n, int n2) {
        NativeJava.setRestoredSize((Window)this, (int)n, (int)n2);
    }

    public Point getRestoredLocation() {
        return NativeJava.getRestoredLocation((Window)this);
    }

    public void setRestoredLocation(Point point) {
        NativeJava.setRestoredLocation((Window)this, (Point)point);
    }

    public void setRestoredLocation(int n, int n2) {
        NativeJava.setRestoredLocation((Window)this, (int)n, (int)n2);
    }

    public void setSmallIconImage(Image image) {
        this.fSmallIconImage = image;
        this.updateIconImages();
    }

    @Override
    public void setIconImage(Image image) {
        this.fIconImage = image;
        if (image != ApplicationIcon.MATLAB_32x32.getIcon().getImage() && this.fSmallIconImage == ApplicationIcon.MATLAB.getIcon().getImage()) {
            this.fSmallIconImage = null;
        }
        this.updateIconImages();
    }

    private void updateIconImages() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        if (this.fIconImage != null) {
            arrayList.add(this.fIconImage);
        }
        if (this.fSmallIconImage != null) {
            arrayList.add(this.fSmallIconImage);
        }
        this.setIconImages(arrayList);
    }

    private void calculateMargins() {
        if (this.isMaximized() || this.isResizable() && sCachedInsetsCalculated || !this.isResizable() && sCachedNoresizeInsetsCalculated) {
            return;
        }
        try {
            Insets insets = this.getInsets();
            if (insets != null) {
                if (this.isResizable()) {
                    sCachedInsetsCalculated = true;
                    sCachedInsets = insets;
                } else {
                    sCachedNoresizeInsetsCalculated = true;
                    sCachedNoresizeInsets = insets;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Insets getCachedInsets(boolean bl) {
        if (bl) {
            return sCachedInsets;
        }
        return sCachedNoresizeInsets;
    }

    private void superToFront() {
        super.toFront();
    }

    @Override
    public boolean isModal() {
        return this.fModal;
    }

    @Override
    public void setModal(boolean bl) {
        if (this.fModal == bl) {
            return;
        }
        this.fModal = bl;
        if (this.isVisible()) {
            this.fModalManager.setParticipantModal(this, bl);
        }
        if (this.fModal) {
            this.requestFocusInWindow();
            this.toFront();
        }
    }

    private static ModalManager getModalManager() {
        return ModalManagerImpl.getInstance();
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 205: {
                super.processWindowEvent(windowEvent);
                this.fModalManager.updateFocus(this);
                break;
            }
            case 201: {
                if (!this.fModalManager.isAcceptingInput(this)) break;
                super.processWindowEvent(windowEvent);
                break;
            }
            default: {
                super.processWindowEvent(windowEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNativeListener(NativeEvent.Listener listener) {
        if (this.fNativeListeners == null) {
            this.fNativeListeners = new ArrayList<NativeEvent.Listener>();
        }
        List<NativeEvent.Listener> list = this.fNativeListeners;
        synchronized (list) {
            this.fNativeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNativeListener(NativeEvent.Listener listener) {
        if (this.fNativeListeners != null) {
            List<NativeEvent.Listener> list = this.fNativeListeners;
            synchronized (list) {
                this.fNativeListeners.remove(listener);
            }
        }
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof NativeEvent) {
            this.fireNativeEvent((NativeEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fireNativeEvent(NativeEvent nativeEvent) {
        if (this.fNativeListeners == null) return;
        NativeEvent.Listener[] listenerArray = this.fNativeListeners;
        synchronized (this.fNativeListeners) {
            NativeEvent.Listener[] listenerArray2 = this.fNativeListeners.toArray(new NativeEvent.Listener[this.fNativeListeners.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (NativeEvent.Listener listener : listenerArray2) {
                if (nativeEvent.getNativeMessage() == NativeEvent.JM_FRAMEPRESSED) {
                    listener.framePressed(nativeEvent);
                    continue;
                }
                if (nativeEvent.getNativeMessage() != NativeEvent.JM_FRAMERELEASED) continue;
                listener.frameReleased(nativeEvent);
            }
            return;
        }
    }

    private class FullScreenListenerDelegator
    implements InvocationHandler {
        private FullScreenListenerDelegator() {
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if ("windowEnteredFullScreen".equals(string)) {
                MJFrame.this.fIsFullScreen = true;
                if (MJFrame.this.fMinimizeAction != null) {
                    MJFrame.this.fMinimizeAction.setEnabled(false);
                }
            } else if ("windowExitedFullScreen".equals(string)) {
                MJFrame.this.fIsFullScreen = false;
                if (MJFrame.this.fMinimizeAction != null) {
                    MJFrame.this.fMinimizeAction.setEnabled(true);
                }
            }
            return null;
        }
    }

    private class WindowTracker
    extends WindowAdapter {
        private WindowTracker() {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null && menuElementArray.length >= 1 && !(menuElementArray[0] instanceof JPopupMenu)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                if (windowEvent.getOppositeWindow() != null && PlatformInfo.isWindows()) {
                    windowEvent.getOppositeWindow().toFront();
                }
            }
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            if (MJFrame.this.isVisible()) {
                MJFrame.this.calculateMargins();
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            JPopupMenu jPopupMenu;
            Window window;
            MenuElement[] menuElementArray;
            if (PlatformInfo.isWindows() && (menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()) != null && menuElementArray.length >= 1 && menuElementArray[0] instanceof JPopupMenu && (window = SwingUtilities.windowForComponent((jPopupMenu = (JPopupMenu)menuElementArray[0]).getComponent())) != null && window.getOwner() != null) {
                window.dispose();
            }
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            if (PlatformInfo.isMacintosh() && MJFrame.this.isVisible()) {
                MJFrame.this.superToFront();
            }
            if (PlatformInfo.isWindows() && MJFrame.this.isActive()) {
                MJFrame.this.rootPane.revalidate();
                MJFrame.this.rootPane.repaint();
            }
        }
    }

    private class MinimizeAction
    extends AbstractAction {
        private static final String MINIMIZE_ACTION = "minimize-window";

        private MinimizeAction() {
        }

        void attachTo(JFrame jFrame) {
            this.attachTo(jFrame.getRootPane());
        }

        private void attachTo(JRootPane jRootPane) {
            InputMap inputMap = jRootPane.getInputMap(2);
            ComponentInputMap componentInputMap = new ComponentInputMap(jRootPane);
            ((InputMap)componentInputMap).setParent(inputMap);
            ((InputMap)componentInputMap).put(KeyStroke.getKeyStroke(77, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK), MINIMIZE_ACTION);
            jRootPane.setInputMap(2, componentInputMap);
            ActionMap actionMap = jRootPane.getActionMap();
            actionMap.put(MINIMIZE_ACTION, this);
            this.setEnabled(!MJFrame.this.fIsFullScreen);
        }

        void removeFrom(JFrame jFrame) {
            this.removeFrom(jFrame.getRootPane());
        }

        private void removeFrom(JRootPane jRootPane) {
            this.setEnabled(false);
            InputMap inputMap = jRootPane.getInputMap(2);
            inputMap.remove(KeyStroke.getKeyStroke(77, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK));
            jRootPane.setInputMap(2, inputMap);
            ActionMap actionMap = jRootPane.getActionMap();
            actionMap.remove(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJFrame.this.setState(1);
        }
    }
}

