/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WeakPropertyChangeCoupler;
import com.mathworks.mwswing.plaf.MBasicMenuItemUI;
import com.mathworks.mwswing.plaf.MWindowsMenuItemUI;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class MJMenuItem
extends JMenuItem {
    private PropertyChangeListener fActionPropertyHandler;
    private boolean fTreatAmpersandAsMnemonic = true;
    protected static final String BASE_NAME = "MenuItem";

    public MJMenuItem() {
    }

    public MJMenuItem(Action action) {
        this.setAction(action);
    }

    public MJMenuItem(Icon icon) {
        super(icon);
    }

    public MJMenuItem(String string) {
        this(string, true);
    }

    public MJMenuItem(String string, boolean bl) {
        this.fTreatAmpersandAsMnemonic = bl;
        this.setText(string);
    }

    public MJMenuItem(String string, Icon icon) {
        super(icon);
        this.setText(string);
    }

    public MJMenuItem(String string, int n) {
        super(MJUtilities.exciseAmpersand(string), n);
    }

    @Override
    public void updateUI() {
        if (PlafUtils.isWindowsLookAndFeel()) {
            this.setUI(new MWindowsMenuItemUI());
        } else if (PlafUtils.isPlasticLookAndFeel()) {
            this.setUI(new MBasicMenuItemUI());
        } else {
            super.updateUI();
        }
    }

    @Override
    public Color getForeground() {
        return PlatformInfo.isWindowsVistaAppearance() && !this.isEnabled() ? UIManager.getColor("MenuItem.foreground") : super.getForeground();
    }

    @Override
    public void setText(String string) {
        if (string == null) {
            super.setText(null);
            this.setMnemonic('\u0000');
            return;
        }
        if (this.fTreatAmpersandAsMnemonic) {
            super.setText(MJUtilities.exciseAmpersand(string));
            if (this.getAction() == null || this.getAction().getValue("Name") != string || this.getAction().getValue("AmpersandIsMnemonic") == null) {
                MJUtilities.setMnemonicFromText(this, string);
            }
        } else {
            super.setText(string);
        }
    }

    @Override
    public void setAction(Action action) {
        this.setAction(action, action != null && action.getValue("AmpersandIsMnemonic") != null ? (Boolean)action.getValue("AmpersandIsMnemonic") : true);
    }

    private void setAction(Action action, boolean bl) {
        String string;
        Integer n;
        Action action2 = this.getAction();
        if (action2 != null) {
            WeakPropertyChangeCoupler.detach(action2, this.fActionPropertyHandler);
            if (action2.getValue("AcceleratorKey") != null) {
                this.setAccelerator(null);
            }
        }
        this.fTreatAmpersandAsMnemonic = bl;
        super.setAction(action);
        if (action == null) {
            if (action2 instanceof MJAbstractAction) {
                this.setName(BASE_NAME);
            }
            return;
        }
        if (action.getValue("ShortDescription") != null) {
            this.setToolTipText(null);
        }
        if (this.fActionPropertyHandler == null) {
            this.fActionPropertyHandler = new ActionPropertyHandler();
        }
        WeakPropertyChangeCoupler.attach(action, this.fActionPropertyHandler);
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke != null) {
            this.setAccelerator(keyStroke);
        }
        if ((n = (Integer)action.getValue("MnemonicIndex")) != null) {
            this.setDisplayedMnemonicIndex(n);
        }
        if ((string = (String)action.getValue("ComponentName")) != null) {
            this.setName(string + BASE_NAME);
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        InputMap inputMap = this.getInputMap(n);
        ActionMap actionMap = this.getActionMap();
        if (inputMap != null && actionMap != null && this.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                boolean bl2 = MJMenuItem.isInDisabledParent(this);
                return !bl2 && super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    static boolean isInDisabledParent(JComponent jComponent) {
        if (jComponent instanceof JPopupMenu) {
            if (!(((JPopupMenu)jComponent).getInvoker() instanceof JMenuItem) && !(((JPopupMenu)jComponent).getInvoker() instanceof JPopupMenu)) {
                return false;
            }
            return MJMenuItem.isInDisabledParent((JComponent)((JPopupMenu)jComponent).getInvoker());
        }
        if (jComponent == null) {
            return false;
        }
        if (!jComponent.isVisible() || !jComponent.isEnabled()) {
            return true;
        }
        if (!(jComponent.getParent() instanceof JMenuItem) && !(jComponent.getParent() instanceof JPopupMenu)) {
            return false;
        }
        return MJMenuItem.isInDisabledParent((JComponent)jComponent.getParent());
    }

    private class ActionPropertyHandler
    implements PropertyChangeListener {
        private ActionPropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            if (propertyChangeEvent.getPropertyName().equals("AcceleratorKey")) {
                MJMenuItem.this.setAccelerator((KeyStroke)propertyChangeEvent.getNewValue());
                MJMenuItem.this.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("AcceleratorSequence")) {
                if (propertyChangeEvent.getNewValue() != null) {
                    MJMenuItem.this.setAccelerator(null);
                }
                MJMenuItem.this.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                MJMenuItem.this.setToolTipText(null);
            } else if (propertyChangeEvent.getPropertyName().equals("MnemonicKey")) {
                if (MJMenuItem.this.getMnemonic() != 0 && MJPopupMenu.isInContextMenu(MJMenuItem.this)) {
                    MJPopupMenu.removeMnemonic(MJMenuItem.this);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("ComponentName") && (string = (String)propertyChangeEvent.getNewValue()) != null) {
                MJMenuItem.this.setName(string + MJMenuItem.BASE_NAME);
            }
        }
    }
}

