/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJTree;
import com.mathworks.util.PlatformInfo;
import java.awt.event.MouseEvent;
import javax.swing.ListSelectionModel;

public enum MultiSelectionEventType {
    REMOVE_SELECTION{

        @Override
        public void performOnTable(ListSelectionModel listSelectionModel, int n) {
            listSelectionModel.removeSelectionInterval(n, n);
        }

        @Override
        public void performOnTree(MJTree mJTree, int n) {
            mJTree.removeSelectionInterval(n, n);
        }
    }
    ,
    EXTEND_SELECTION{

        @Override
        public void performOnTable(ListSelectionModel listSelectionModel, int n) {
            listSelectionModel.setLeadSelectionIndex(n);
        }

        @Override
        public void performOnTree(MJTree mJTree, int n) {
            mJTree.extendSelection(mJTree.getPathForRow(n));
        }
    }
    ,
    SET_SELECTION{

        @Override
        public void performOnTable(ListSelectionModel listSelectionModel, int n) {
            listSelectionModel.setSelectionInterval(n, n);
        }

        @Override
        public void performOnTree(MJTree mJTree, int n) {
            mJTree.setSelectionInterval(n, n);
        }
    }
    ,
    DO_NOTHING{

        @Override
        public void performOnTable(ListSelectionModel listSelectionModel, int n) {
        }

        @Override
        public void performOnTree(MJTree mJTree, int n) {
        }
    };


    public static MultiSelectionEventType getMouseReleasedSelectionType(MouseEvent mouseEvent, boolean bl) {
        MultiSelectionEventType multiSelectionEventType = PlatformInfo.isMacintosh() && mouseEvent.isControlDown() ? DO_NOTHING : (bl && (mouseEvent.isControlDown() || PlatformInfo.isMacintosh() && mouseEvent.isMetaDown()) ? REMOVE_SELECTION : (mouseEvent.isShiftDown() ? EXTEND_SELECTION : SET_SELECTION));
        return multiSelectionEventType;
    }

    public abstract void performOnTable(ListSelectionModel var1, int var2);

    public abstract void performOnTree(MJTree var1, int var2);
}

