/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.StringTrimmer;
import java.awt.FontMetrics;

public class SimpleStringTrimmer
implements StringTrimmer {
    public static final String ELLIPSIS = "...";
    public static final int BACKWARD = 1;
    public static final int FORWARD = 2;
    protected int fDirection = 1;
    protected int fStartIndex = -1;
    protected String fLastFullString;
    protected String fLastShortenedString;
    protected char[] fLastChars;
    private static SimpleStringTrimmer sEndTrimmer;
    private static SimpleStringTrimmer sBeginningTrimmer;

    public SimpleStringTrimmer() {
    }

    public SimpleStringTrimmer(int n) {
        this.fDirection = n;
    }

    public SimpleStringTrimmer(int n, int n2) {
        this.fDirection = n;
        this.fStartIndex = n2;
    }

    public static SimpleStringTrimmer getSharedEndTrimmer() {
        if (sEndTrimmer == null) {
            sEndTrimmer = new SimpleStringTrimmer(1);
        }
        return sEndTrimmer;
    }

    public static SimpleStringTrimmer getSharedBeginningTrimmer() {
        if (sBeginningTrimmer == null) {
            sBeginningTrimmer = new SimpleStringTrimmer(2);
        }
        return sBeginningTrimmer;
    }

    public int getDirection() {
        return this.fDirection;
    }

    public int getStartIndex() {
        return this.fStartIndex;
    }

    @Override
    public String shortenString(String string, FontMetrics fontMetrics, int n) {
        int n2 = fontMetrics.stringWidth(string);
        if (n2 <= n) {
            return string;
        }
        int n3 = string.length();
        if (string != this.fLastFullString) {
            this.fLastChars = new char[n3];
            string.getChars(0, n3, this.fLastChars, 0);
            this.fLastShortenedString = null;
        }
        n -= fontMetrics.stringWidth("... ");
        int n4 = this.fDirection;
        int n5 = this.fStartIndex;
        int n6 = 0;
        int n7 = 0;
        if (this.fStartIndex == -1) {
            n5 = this.fDirection == 2 ? 0 : n3 - 1;
        } else if (this.fDirection == 2) {
            n6 = this.fStartIndex;
            n7 = fontMetrics.charsWidth(this.fLastChars, 0, n6);
            if (n7 > n) {
                n4 = 1;
                n2 = n7;
                n6 = 0;
            } else {
                n -= n7;
            }
        } else {
            n6 = n3 - this.fStartIndex;
            n7 = fontMetrics.charsWidth(this.fLastChars, this.fStartIndex, n6);
            if (n7 > n) {
                n4 = 2;
                n2 = n7;
                n6 = 0;
            } else {
                n -= n7;
            }
        }
        if (n4 == 2) {
            int n8 = n3 - n5;
            if (n2 > n) {
                if (n >= n2 / 2) {
                    n8 = n3 - n5;
                    while (n2 > n && n8 > 0) {
                        n2 = fontMetrics.charsWidth(this.fLastChars, ++n5, --n8);
                    }
                } else {
                    n8 = 0;
                    n2 = 0;
                    while (n2 <= n && n8++ < n3 - n5) {
                        n2 = fontMetrics.charsWidth(this.fLastChars, n3 - n8, n8);
                    }
                    if (n8 > 0) {
                        --n8;
                    }
                }
            }
            if (this.fLastShortenedString == null || this.fLastShortenedString.length() != n6 + n8 + 3) {
                this.fLastShortenedString = (n6 > 0 ? string.substring(0, n6) : "") + ELLIPSIS + string.substring(n3 - n8, n3);
            }
        } else {
            int n9 = n5 + 1;
            if (n2 > n) {
                if (n >= n2 / 2) {
                    n9 = n5 + 1;
                    while (n2 > n && n9 > 0) {
                        n2 = fontMetrics.charsWidth(this.fLastChars, 0, --n9);
                    }
                } else {
                    n9 = 0;
                    n2 = 0;
                    while (n2 <= n && n9++ < n5 + 1) {
                        n2 = fontMetrics.charsWidth(this.fLastChars, 0, n9);
                    }
                    if (n9 > 0) {
                        --n9;
                    }
                }
            }
            if (this.fLastShortenedString == null || this.fLastShortenedString.length() != n6 + n9 + 3) {
                this.fLastShortenedString = string.substring(0, n9) + ELLIPSIS;
                if (n6 > 0) {
                    this.fLastShortenedString = this.fLastShortenedString + string.substring(n3 - n6, n3);
                }
            }
        }
        return this.fLastShortenedString;
    }
}

