/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.KeyStroke;

public final class KeyStrokeList {
    private final List<KeyStroke> fStrokeList;

    public KeyStrokeList() {
        this.fStrokeList = Collections.emptyList();
    }

    public KeyStrokeList(KeyStroke ... keyStrokeArray) {
        this.fStrokeList = Collections.unmodifiableList(Arrays.asList(keyStrokeArray));
    }

    public List<KeyStroke> getKeyStrokes() {
        return this.fStrokeList;
    }

    public boolean isEmpty() {
        return this.fStrokeList.isEmpty();
    }

    public KeyStroke[] toKeyStrokeArray() {
        return this.fStrokeList.toArray(new KeyStroke[0]);
    }

    public boolean isMultiStroke() {
        return this.getKeyStrokes().size() > 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyStrokeList)) {
            return false;
        }
        KeyStrokeList keyStrokeList = (KeyStrokeList)object;
        return ((Object)keyStrokeList.getKeyStrokes()).equals(this.getKeyStrokes());
    }

    public int hashCode() {
        return ((Object)this.getKeyStrokes()).hashCode();
    }

    public String toString() {
        String string = "KeyStrokeList-- isMulti = " + this.isMultiStroke() + " with KeyStroke(s) =";
        for (KeyStroke keyStroke : this.getKeyStrokes()) {
            string = string + " " + keyStroke;
        }
        return string;
    }
}

