/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceEntityRequest;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.DocCenterReferenceRetrievalStrategy;
import com.mathworks.mlwidgets.help.DocCenterSearchHelper;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.ReferencePageInfo;
import com.mathworks.product.util.ProductIdentifier;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Vector;

public class FunctionReferenceUtils {
    private static FunctionReferenceUtils sSingleton = new FunctionReferenceUtils();
    private final FunctionDataAccessor fClassicDocFunctionDataAccessor = new ClassicDocFunctionDataAccessor();
    private final FunctionDataAccessor fDocCenterFunctionDataAccessor = new DocCenterFunctionDataAccessor();
    private FunctionDataAccessor fFunctionDataAccessor;

    private FunctionReferenceUtils() {
        HelpPrefs.addPrefsListeners(new UsingDocCenterPrefsListener(), "HelpUseDocCenterBrowser");
        this.setFunctionDataAccesser(HelpPrefs.isUsingDocCenterBrowser() ? this.fDocCenterFunctionDataAccessor : this.fClassicDocFunctionDataAccessor);
    }

    private static FunctionReferenceUtils getInstance() {
        return sSingleton;
    }

    public static List<String> getAllReferencePageUrls(String string, boolean bl) {
        return FunctionReferenceUtils.getInstance().getFunctionDataAccesser().getAllReferencePageUrls(string, bl);
    }

    public static String getUrlPrefix(String string) {
        return FunctionReferenceUtils.getInstance().getFunctionDataAccesser().getUrlPrefix(string);
    }

    public static String getFullUrlForProduct(String string, String string2) {
        return FunctionReferenceUtils.getInstance().getFunctionDataAccesser().getFullUrl(string, string2);
    }

    public static String getHelpLocation(String string) {
        return FunctionReferenceUtils.getInstance().getFunctionDataAccesser().getHelpLocation(string);
    }

    public static String getProductShortName(String string) {
        return FunctionReferenceUtils.getInstance().getFunctionDataAccesser().getProductShortName(string);
    }

    public static List<String> getInstalledProductShortNames(boolean bl) {
        return FunctionReferenceUtils.getInstance().getFunctionDataAccesser().getInstalledProductShortNames(bl);
    }

    public static List<FunctionProductData> getInstalledFunctionData(boolean bl) {
        return FunctionReferenceUtils.getInstance().getFunctionDataAccesser().getInstalledFunctionData(bl);
    }

    public static String getLocalizedFilename(String string) {
        return FunctionReferenceUtils.getInstance().getFunctionDataAccesser().getLocalizedFilename(string);
    }

    public static List<FunctionProductData> getToplevelProductFunctionData() {
        return FunctionReferenceUtils.getInstance().getFunctionDataAccesser().getToplevelProductFunctionData();
    }

    private synchronized FunctionDataAccessor getFunctionDataAccesser() {
        return this.fFunctionDataAccessor;
    }

    private synchronized void setFunctionDataAccesser(FunctionDataAccessor functionDataAccessor) {
        this.fFunctionDataAccessor = functionDataAccessor;
    }

    private class UsingDocCenterPrefsListener
    implements PrefListener {
        private UsingDocCenterPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            FunctionReferenceUtils.this.setFunctionDataAccesser(HelpPrefs.isUsingDocCenterBrowser() ? FunctionReferenceUtils.this.fDocCenterFunctionDataAccessor : FunctionReferenceUtils.this.fClassicDocFunctionDataAccessor);
        }
    }

    private static class ClassicFunctionProductData
    implements FunctionProductData {
        private final HelpInfoItem iHelpInfoItem;

        private ClassicFunctionProductData(HelpInfoItem helpInfoItem) {
            this.iHelpInfoItem = helpInfoItem;
        }

        @Override
        public String getShortName() {
            return this.iHelpInfoItem.getShortName();
        }

        @Override
        public String getProductName() {
            return this.iHelpInfoItem.getProductName();
        }

        @Override
        public boolean isSelected() {
            return this.iHelpInfoItem.isSelected();
        }

        @Override
        public boolean hasRefPages() {
            return this.iHelpInfoItem.hasRefPages();
        }
    }

    private static class ClassicDocFunctionDataAccessor
    implements FunctionDataAccessor {
        private ClassicDocFunctionDataAccessor() {
        }

        @Override
        public List<String> getAllReferencePageUrls(String string, boolean bl) {
            ReferencePageInfo[] referencePageInfoArray = HelpInfo.getAllReferencePageUrls(string, bl);
            if (referencePageInfoArray == null || referencePageInfoArray.length == 0) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ReferencePageInfo referencePageInfo : referencePageInfoArray) {
                arrayList.add(referencePageInfo.getFullUrl());
            }
            return arrayList;
        }

        @Override
        public String getUrlPrefix(String string) {
            String string2 = null;
            HelpInfoItem helpInfoItem = HelpInfo.getHelpInfoItemByShortName(string);
            if (helpInfoItem != null) {
                string2 = helpInfoItem.getUrlPrefix();
            }
            return string2;
        }

        @Override
        public String getFullUrl(String string, String string2) {
            return HelpInfo.getHelpInfoItemByShortName(string).getUrlPrefix() + string2;
        }

        @Override
        public String getHelpLocation(String string) {
            return HelpInfo.getHelpLocationForShortName(string);
        }

        @Override
        public String getProductShortName(String string) {
            return HelpInfo.getProductShortName(string);
        }

        @Override
        public List<String> getInstalledProductShortNames(boolean bl) {
            HelpInfoItem[] helpInfoItemArray = ClassicDocFunctionDataAccessor.getInstalledProductHelpInfo(bl);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (HelpInfoItem helpInfoItem : helpInfoItemArray) {
                arrayList.add(helpInfoItem.getShortName());
            }
            return arrayList;
        }

        @Override
        public List<FunctionProductData> getInstalledFunctionData(boolean bl) {
            HelpInfoItem[] helpInfoItemArray = ClassicDocFunctionDataAccessor.getInstalledProductHelpInfo(bl);
            ArrayList<FunctionProductData> arrayList = new ArrayList<FunctionProductData>();
            for (HelpInfoItem helpInfoItem : helpInfoItemArray) {
                arrayList.add(new ClassicFunctionProductData(helpInfoItem));
            }
            return arrayList;
        }

        @Override
        public String getLocalizedFilename(String string) {
            return HelpUtils.getLocalizedFilename(string);
        }

        @Override
        public List<FunctionProductData> getToplevelProductFunctionData() {
            HelpInfoItem[] helpInfoItemArray = HelpInfo.getToplevelProductHelpInfo();
            ArrayList<FunctionProductData> arrayList = new ArrayList<FunctionProductData>();
            for (HelpInfoItem helpInfoItem : helpInfoItemArray) {
                arrayList.add(new ClassicFunctionProductData(helpInfoItem));
            }
            return arrayList;
        }

        private static HelpInfoItem[] getInstalledProductHelpInfo(boolean bl) {
            HelpInfoItem[] helpInfoItemArray;
            bl = bl && HelpPrefs.getProductFilterEnabled();
            Vector<HelpInfoItem> vector = new Vector<HelpInfoItem>();
            for (HelpInfoItem helpInfoItem : helpInfoItemArray = HelpInfo.getInstalledProductHelpInfo()) {
                if (bl && !helpInfoItem.isSelected() || !helpInfoItem.hasRefPages()) continue;
                vector.add(helpInfoItem);
            }
            HelpInfoItem[] helpInfoItemArray2 = new HelpInfoItem[vector.size()];
            for (int i = 0; i < helpInfoItemArray2.length; ++i) {
                helpInfoItemArray2[i] = (HelpInfoItem)vector.elementAt(i);
            }
            return helpInfoItemArray2;
        }
    }

    private static class DocCenterFunctionProductData
    implements FunctionProductData {
        private final DocProduct fDocProduct;

        public DocCenterFunctionProductData(DocProduct docProduct) {
            this.fDocProduct = docProduct;
        }

        @Override
        public String getShortName() {
            return this.fDocProduct.getShortName();
        }

        @Override
        public String getProductName() {
            return this.fDocProduct.getDisplayName();
        }

        @Override
        public boolean isSelected() {
            return HelpPrefs.isInstalledDocProductSelected(this.fDocProduct);
        }

        @Override
        public boolean hasRefPages() {
            return true;
        }
    }

    private static class ProductIdentifierFunctionProductData
    implements FunctionProductData {
        private final ProductIdentifier fProductIdentifier;

        public ProductIdentifierFunctionProductData(ProductIdentifier productIdentifier) {
            this.fProductIdentifier = productIdentifier;
        }

        @Override
        public String getShortName() {
            return this.fProductIdentifier.getName();
        }

        @Override
        public String getProductName() {
            return this.fProductIdentifier.getName();
        }

        @Override
        public boolean isSelected() {
            return HelpPrefs.isInstalledProductSelected(this.getProductName());
        }

        @Override
        public boolean hasRefPages() {
            return true;
        }
    }

    private static class DocCenterFunctionDataAccessor
    implements FunctionDataAccessor {
        private DocCenterFunctionDataAccessor() {
        }

        @Override
        public List<String> getAllReferencePageUrls(String string, boolean bl) {
            List<ReferenceData> list = DocCenterFunctionDataAccessor.getReferenceData(string, DocCenterFunctionDataAccessor.getRefEntityTypes(bl));
            if (list.isEmpty()) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ReferenceData referenceData : list) {
                arrayList.add(DocCenterFunctionDataAccessor.getPageLocation(MLHelpServices.getDocRoot(), referenceData));
            }
            return arrayList;
        }

        @Override
        public String getUrlPrefix(String string) {
            return this.getHelpLocation(string);
        }

        @Override
        public String getFullUrl(String string, String string2) {
            String string3 = DocCenterFunctionDataAccessor.getDocProductHelpLocation(string);
            if (string3 == null) {
                return null;
            }
            return DocCenterFunctionDataAccessor.getPageLocation(MLHelpServices.getDocRoot(), string3, string2);
        }

        @Override
        public String getHelpLocation(String string) {
            String string2 = DocCenterFunctionDataAccessor.getDocProductHelpLocation(string);
            if (string2 == null) {
                return null;
            }
            return DocCenterFunctionDataAccessor.getPageLocation(MLHelpServices.getDocRoot(), string2);
        }

        @Override
        public String getProductShortName(String string) {
            List<DocProduct> list = DocCenterFunctionDataAccessor.getAllDocProducts();
            if (list != null && !list.isEmpty()) {
                for (DocProduct docProduct : list) {
                    if (!docProduct.getDisplayName().equalsIgnoreCase(string)) continue;
                    return docProduct.getShortName();
                }
            }
            return null;
        }

        @Override
        public List<String> getInstalledProductShortNames(boolean bl) {
            Collection<DocProduct> collection = HelpPrefs.getInstalledDocProducts();
            ArrayList<String> arrayList = new ArrayList<String>();
            DocumentationSet documentationSet = DocCenterFunctionDataAccessor.getDocumentationSet();
            for (DocProduct docProduct : collection) {
                if (bl && !DocCenterFunctionDataAccessor.isInstalledDocProductSelected(docProduct, documentationSet)) continue;
                arrayList.add(this.getProductShortName(docProduct.getDisplayName()));
            }
            return arrayList;
        }

        @Override
        public List<FunctionProductData> getInstalledFunctionData(boolean bl) {
            Collection<DocProduct> collection = HelpPrefs.getInstalledDocProducts();
            ArrayList<FunctionProductData> arrayList = new ArrayList<FunctionProductData>();
            DocumentationSet documentationSet = DocCenterFunctionDataAccessor.getDocumentationSet();
            for (DocProduct docProduct : collection) {
                if (bl && !DocCenterFunctionDataAccessor.isInstalledDocProductSelected(docProduct, documentationSet)) continue;
                arrayList.add(new DocCenterFunctionProductData(docProduct));
            }
            return arrayList;
        }

        @Override
        public String getLocalizedFilename(String string) {
            return HelpUtils.getLocalizedFilename(string);
        }

        @Override
        public List<FunctionProductData> getToplevelProductFunctionData() {
            Collection<ProductIdentifier> collection = HelpPrefs.getInstalledProducts();
            ArrayList<FunctionProductData> arrayList = new ArrayList<FunctionProductData>();
            for (ProductIdentifier productIdentifier : collection) {
                arrayList.add(new ProductIdentifierFunctionProductData(productIdentifier));
            }
            return arrayList;
        }

        private static boolean isInstalledDocProductSelected(DocProduct docProduct, DocumentationSet documentationSet) {
            return HelpPrefs.isInstalledDocProductSelected(docProduct, documentationSet);
        }

        private static DocumentationSet getDocumentationSet() {
            DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
            DocumentationSet documentationSet = docCenterSearchHelper.getDocumentationSet();
            return documentationSet;
        }

        private static String getDocProductHelpLocation(String string) {
            DocProduct docProduct = DocCenterFunctionDataAccessor.getDocProductByIndexString(string);
            return docProduct != null ? docProduct.getHelpLocation() : null;
        }

        private static DocProduct getDocProductByIndexString(String string) {
            DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
            DocumentationSet documentationSet = docCenterSearchHelper.getDocumentationSet();
            return documentationSet.getProductByIndexString(string);
        }

        private static List<DocProduct> getAllDocProducts() {
            DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
            DocumentationSet documentationSet = docCenterSearchHelper.getDocumentationSet();
            return documentationSet.getAllProducts();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static List<ReferenceData> getReferenceData(String string, Collection<RefEntityType> collection) {
            ReferenceEntityRequest referenceEntityRequest = new ReferenceEntityRequest(string, collection);
            ReferenceDataRetriever referenceDataRetriever = DocCenterReferenceRetrievalStrategy.createDataRetriever();
            try {
                List list;
                List list2 = list = referenceDataRetriever.getReferenceData((ReferenceRequest)referenceEntityRequest);
                return list2;
            }
            finally {
                try {
                    referenceDataRetriever.close();
                }
                catch (IOException iOException) {}
            }
        }

        private static Collection<RefEntityType> getRefEntityTypes(boolean bl) {
            EnumSet<RefEntityType> enumSet = EnumSet.of(RefEntityType.FUNCTION, RefEntityType.CLASS, RefEntityType.SYSTEM_OBJECT);
            if (bl) {
                enumSet.add(RefEntityType.METHOD);
                enumSet.add(RefEntityType.PROPERTY);
            }
            return enumSet;
        }

        private static String getPageLocation(String string, String string2) {
            return HelpBrowserUtils.concatenatePaths((String[])new String[]{string, string2});
        }

        private static String getPageLocation(String string, ReferenceData referenceData) {
            return DocCenterFunctionDataAccessor.getPageLocation(string, referenceData.getProduct().getHelpLocation(), referenceData.getRelativePath());
        }

        private static String getPageLocation(String string, String string2, String string3) {
            return HelpBrowserUtils.concatenatePaths((String[])new String[]{string, string2, string3});
        }
    }

    public static interface FunctionProductData {
        public String getShortName();

        public String getProductName();

        public boolean isSelected();

        public boolean hasRefPages();
    }

    private static interface FunctionDataAccessor {
        public List<String> getAllReferencePageUrls(String var1, boolean var2);

        public String getUrlPrefix(String var1);

        public String getFullUrl(String var1, String var2);

        public String getHelpLocation(String var1);

        public String getProductShortName(String var1);

        public List<String> getInstalledProductShortNames(boolean var1);

        public List<FunctionProductData> getInstalledFunctionData(boolean var1);

        public String getLocalizedFilename(String var1);

        public List<FunctionProductData> getToplevelProductFunctionData();
    }
}

