/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.plugin;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPlugin;
import com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPluginUtils;
import com.mathworks.mlwidgets.configeditor.plugin.PublishConfigurationPlugin;
import com.mathworks.mlwidgets.configeditor.plugin.RunConfigurationPlugin;
import com.mathworks.widgets.glazedlists.DisposableList;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationPluginManager {
    private boolean fPluginsLoaded = false;
    private final Map<AbstractFileConfiguration.Type, ConfigurationPlugin> fPlugins = new HashMap<AbstractFileConfiguration.Type, ConfigurationPlugin>();
    private final EventList<AbstractFileConfiguration> fConfigurations = new BasicEventList();
    private final Map<AbstractFileConfiguration.Type, Map<File, AbstractFileConfiguration>> fMostRecentlyRunConfigurationsMap = new HashMap<AbstractFileConfiguration.Type, Map<File, AbstractFileConfiguration>>();

    public ConfigurationPluginManager() {
        this.createPlugins();
        this.loadPlugins();
    }

    private void createPlugins() {
        RunConfigurationPlugin runConfigurationPlugin = new RunConfigurationPlugin();
        this.fPlugins.put(runConfigurationPlugin.getConfigurationType(), runConfigurationPlugin);
        PublishConfigurationPlugin publishConfigurationPlugin = new PublishConfigurationPlugin();
        this.fPlugins.put(publishConfigurationPlugin.getConfigurationType(), publishConfigurationPlugin);
    }

    public <E extends AbstractFileConfiguration> void doConfigurationAction(E e, Component component, @Nullable MatlabExecutionErrorHandler matlabExecutionErrorHandler) {
        this.getPlugin(e.getType()).doConfigurationAction(e, component, matlabExecutionErrorHandler);
    }

    public Set<AbstractFileConfiguration.Type> getPluginTypes() {
        TreeSet<AbstractFileConfiguration.Type> treeSet = new TreeSet<AbstractFileConfiguration.Type>(ConfigurationPluginUtils.getConfigurationPluginTypeImportanceComparator());
        treeSet.addAll(this.fPlugins.keySet());
        return treeSet;
    }

    public <E extends AbstractFileConfiguration> ConfigurationPlugin<E> getPlugin(AbstractFileConfiguration.Type<E> type) {
        return this.fPlugins.get(type);
    }

    private void loadPlugins() {
        Set<AbstractFileConfiguration.Type> set = this.fPlugins.keySet();
        for (AbstractFileConfiguration.Type type : set) {
            ConfigurationPlugin configurationPlugin = this.fPlugins.get(type);
            ConfigurationPlugin.LoadBundle loadBundle = configurationPlugin.load();
            this.fConfigurations.addAll(loadBundle.getConfiguraitonsList());
            this.fMostRecentlyRunConfigurationsMap.put(type, loadBundle.getMostRecentlyActionedConfigurations());
        }
        this.fPluginsLoaded = true;
    }

    public EventList<AbstractFileConfiguration> getConfigurations() {
        return this.fConfigurations;
    }

    public Map<File, AbstractFileConfiguration> getMostRecentlyActionedConfigurations(AbstractFileConfiguration.Type type) {
        return this.fMostRecentlyRunConfigurationsMap.get(type);
    }

    public void persist(boolean bl) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                ConfigurationPluginManager.this.doPersist();
            }
        };
        if (bl) {
            thread.start();
        } else {
            thread.run();
        }
    }

    private <E extends AbstractFileConfiguration> void doPersist() {
        if (this.fPluginsLoaded) {
            Set<AbstractFileConfiguration.Type> set = this.fPlugins.keySet();
            for (AbstractFileConfiguration.Type type : set) {
                ConfigurationPlugin configurationPlugin = this.fPlugins.get(type);
                DisposableList disposableList = ConfigurationManager.getInstance().getConfigurationsForType(configurationPlugin.getConfigurationType());
                configurationPlugin.persist(disposableList, this.getMostRecentlyActionedConfigurations(type));
                disposableList.dispose();
            }
        }
    }
}

