/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.ui.AbstractConfigurationGroup;
import com.mathworks.mlwidgets.configeditor.ui.ComponentDetailsEditor;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationGroupByFile;
import com.mathworks.mlwidgets.configeditor.ui.ValidateableTextFieldWithEllipsisButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConfigurationGroupByFileDetailsEditor
implements ComponentDetailsEditor<ConfigurationGroupByFile.FileGroupingConfiguration> {
    private MJPanel fEditorComponent = new MJPanel();
    private AbstractConfigurationGroup.GroupingConfiguration fCurrentConfiguration;
    private MJLabel fUserMessageTitle = new MJLabel();
    private MJLabel fUserMessage = new MJLabel();
    private ValidateableTextFieldWithEllipsisButton fTextFieldWithEllipsis = new ValidateableTextFieldWithEllipsisButton();
    private boolean fShouldPropogateEvents = false;
    private DocumentListener fFileNameDocumentListener;

    public ConfigurationGroupByFileDetailsEditor() {
        this.init();
    }

    private void init() {
        this.initNames();
        this.initListeners();
        MJLabel mJLabel = new MJLabel(ConfigurationUtils.lookup("details.mFileName.label"));
        FormLayout formLayout = new FormLayout("d, 3dlu, d:grow, 2dlu, d", "d, 8dlu, d, 3dlu, d:grow");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this.fEditorComponent);
        panelBuilder.add((Component)mJLabel, cellConstraints.xywh(1, 1, 1, 1, "right, center"));
        panelBuilder.add((Component)this.fTextFieldWithEllipsis.getMFileName(), cellConstraints.xywh(3, 1, 1, 1, "fill, center"));
        panelBuilder.add((Component)this.fTextFieldWithEllipsis.getMFileNameEllipsis(), cellConstraints.xywh(5, 1, 1, 1, "fill, fill"));
        panelBuilder.add((Component)this.fUserMessageTitle, cellConstraints.xywh(3, 3, 3, 1, "left, center"));
        panelBuilder.add((Component)this.fUserMessage, cellConstraints.xywh(3, 5, 3, 1, "fill, top"));
        this.edit(null);
    }

    private void initNames() {
        this.fEditorComponent.setName("ConfigurarationGroupDetailsPanel");
    }

    private void initListeners() {
        this.fFileNameDocumentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ConfigurationGroupByFileDetailsEditor.this.doMFileNameViewChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ConfigurationGroupByFileDetailsEditor.this.doMFileNameViewChanged();
            }
        };
        this.fTextFieldWithEllipsis.getMFileName().getDocument().addDocumentListener(this.fFileNameDocumentListener);
    }

    private void doMFileNameViewChanged() {
        if (this.fShouldPropogateEvents) {
            File file = new File(this.fTextFieldWithEllipsis.getMFileName().getText());
            ConfigurationManager.getInstance().reassociateConfigurations(this.fCurrentConfiguration.getAssociatedFile(), file);
            this.fCurrentConfiguration.setAssociatedFile(file);
        }
        this.doUpdateUserMessage();
    }

    private void doUpdateUserMessage() {
        if (this.fCurrentConfiguration == null) {
            this.fUserMessage.setText("");
        } else if (this.fTextFieldWithEllipsis.getMFileName().isTextValid()) {
            String string = MessageFormat.format(ConfigurationUtils.lookup("group.settings.infoMessage"), this.fCurrentConfiguration.getAssociatedFile().getName());
            this.fUserMessageTitle.setText("");
            this.fUserMessage.setText(string);
        } else {
            String string = this.fCurrentConfiguration.getAssociatedFile().getName().equals("") ? ConfigurationUtils.lookup("group.settings.noFileSpecified") : MessageFormat.format(ConfigurationUtils.lookup("group.settings.fileNotFound"), this.fCurrentConfiguration.getAssociatedFile().getName());
            this.fUserMessageTitle.setText(ConfigurationUtils.lookup("group.settings.fileNotFound.title"));
            this.fUserMessage.setText(string);
        }
    }

    @Override
    public void cleanup() {
        this.fTextFieldWithEllipsis.getMFileName().getDocument().removeDocumentListener(this.fFileNameDocumentListener);
    }

    @Override
    public void edit(ConfigurationGroupByFile.FileGroupingConfiguration fileGroupingConfiguration) {
        this.fShouldPropogateEvents = false;
        this.fTextFieldWithEllipsis.getMFileName().setText(fileGroupingConfiguration == null ? "" : fileGroupingConfiguration.getAssociatedFile().getPath());
        this.fCurrentConfiguration = fileGroupingConfiguration;
        this.doUpdateUserMessage();
        this.fShouldPropogateEvents = true;
    }

    @Override
    public Component getEditorComponent() {
        return this.fEditorComponent;
    }
}

