/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.util.DeferrableRetriever;
import com.mathworks.util.ParameterRunnable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

final class H1Retriever
implements DeferrableRetriever<String> {
    private final FileSystemEntry fFile;

    H1Retriever(FileSystemEntry fileSystemEntry) {
        this.fFile = fileSystemEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ParameterRunnable<String> parameterRunnable, Runnable runnable) {
        InputStream inputStream = null;
        try {
            if (this.fFile.isFolder()) {
                FileLocation fileLocation = this.fFile.getLocation();
                String string = Locale.getDefault().getLanguage();
                if (!string.equals("en")) {
                    FileLocation fileLocation2 = new FileLocation(this.fFile.getLocation(), string);
                    if (this.fFile.getSystem().exists(fileLocation2)) {
                        fileLocation = fileLocation2;
                    }
                }
                fileLocation = new FileLocation(fileLocation, "Contents.m");
                if (!this.fFile.getSystem().exists(fileLocation)) {
                    parameterRunnable.run((Object)"");
                    return;
                }
                inputStream = this.fFile.getSystem().getInputStream(fileLocation);
            } else {
                inputStream = this.fFile.getSystem().getInputStream(this.fFile.getLocation());
            }
            parameterRunnable.run((Object)this.trimFileName(MLFileUtils.getH1Line((InputStream)inputStream)));
        }
        catch (IOException iOException) {
            parameterRunnable.run(null);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String trimFileName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.toUpperCase().startsWith(this.fFile.getName().toUpperCase())) {
            return string2.substring(this.fFile.getName().length()).trim();
        }
        int n = this.fFile.getName().lastIndexOf(46);
        if (n > 0) {
            String string3;
            String string4 = this.fFile.getName().substring(0, n);
            if (string2.toUpperCase().startsWith(string4.toUpperCase()) && !(string3 = string2.substring(string4.length()).trim()).startsWith("(")) {
                return string2.substring(string4.length()).trim();
            }
        }
        return string;
    }
}

