/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model;

import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.AbstractFileList;
import com.mathworks.mlwidgets.explorer.model.DefaultNonRecursiveSearchList;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.CancellationDetectingReceiver;
import com.mathworks.util.FinishBlockingReceiver;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class DefaultRecursiveSearchList
extends AbstractFileList {
    private final FileSystem fSystem;
    private final FileLocation fRoot;
    private final SearchCriteria fCriteria;
    private final Predicate<FileSystemEntry> fRecursionPredicate;
    private final List<Context> fContexts;

    public DefaultRecursiveSearchList(FileSystem fileSystem, FileSystemEntry fileSystemEntry, SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) {
        super(fileSystem, fileSystemEntry);
        this.fSystem = fileSystem;
        this.fRoot = fileSystemEntry.getLocation();
        this.fCriteria = searchCriteria;
        this.fRecursionPredicate = predicate;
        this.fContexts = new LinkedList<Context>();
    }

    public DefaultRecursiveSearchList(FileSystem fileSystem, FileLocation fileLocation, SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) throws IOException {
        super(fileSystem, fileLocation);
        this.fSystem = fileSystem;
        this.fRoot = fileLocation;
        this.fCriteria = searchCriteria;
        this.fContexts = new LinkedList<Context>();
        this.fRecursionPredicate = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFilesAndFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
        Context context = new Context(asyncReceiver);
        List<Context> list = this.fContexts;
        synchronized (list) {
            this.fContexts.add(context);
        }
        context.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(ParameterRunnable<Runnable> parameterRunnable) {
        ArrayList<Context> arrayList;
        Object object = this.fContexts;
        synchronized (object) {
            arrayList = new ArrayList<Context>(this.fContexts);
        }
        object = new PauseAndResumeHandler(parameterRunnable);
        ((PauseAndResumeHandler)object).pause(arrayList);
    }

    protected FileList openNonRecursiveSearchList(FileLocation fileLocation, SearchCriteria searchCriteria) throws IOException {
        return new DefaultNonRecursiveSearchList(this.fSystem, fileLocation, searchCriteria);
    }

    private class Context
    implements Runnable {
        private final CancellationDetectingReceiver<FileSystemEntry> fReceiver;
        private final Queue<FileLocation> fQueue;
        private final List<ParameterRunnable<Runnable>> fPendingPauseRequests;

        Context(AsyncReceiver<FileSystemEntry> asyncReceiver) {
            this.fReceiver = new CancellationDetectingReceiver(asyncReceiver);
            this.fQueue = new LinkedList<FileLocation>();
            this.fPendingPauseRequests = new LinkedList<ParameterRunnable<Runnable>>();
            this.fQueue.offer(DefaultRecursiveSearchList.this.fRoot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause(ParameterRunnable<Runnable> parameterRunnable) {
            List<ParameterRunnable<Runnable>> list = this.fPendingPauseRequests;
            synchronized (list) {
                this.fPendingPauseRequests.add(parameterRunnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handlePauseRequest() {
            ArrayList<ParameterRunnable<Runnable>> arrayList;
            List<ParameterRunnable<Runnable>> list = this.fPendingPauseRequests;
            synchronized (list) {
                arrayList = new ArrayList<ParameterRunnable<Runnable>>(this.fPendingPauseRequests);
                this.fPendingPauseRequests.clear();
            }
            for (ParameterRunnable parameterRunnable : arrayList) {
                parameterRunnable.run((Object)this);
            }
            return !arrayList.isEmpty();
        }

        private boolean shouldContinue() {
            return !this.fQueue.isEmpty() && !this.handlePauseRequest() && !DefaultRecursiveSearchList.this.getClosedFlag().get() && !this.fReceiver.wasCanceled();
        }

        @Override
        public void run() {
            FileList fileList = null;
            while (this.shouldContinue()) {
                FileLocation fileLocation = this.fQueue.poll();
                try {
                    fileList = DefaultRecursiveSearchList.this.openNonRecursiveSearchList(fileLocation, DefaultRecursiveSearchList.this.fCriteria);
                    fileList.readFilesAndFolders((AsyncReceiver)new FinishBlockingReceiver(this.fReceiver));
                    FileList fileList2 = DefaultRecursiveSearchList.this.fSystem.getList(fileLocation);
                    fileList2.readFolders((AsyncReceiver)new AsyncReceiver<FileSystemEntry>(){

                        public boolean receive(FileSystemEntry fileSystemEntry) {
                            if (DefaultRecursiveSearchList.this.fRecursionPredicate.accept((Object)fileSystemEntry)) {
                                Context.this.fQueue.offer(fileSystemEntry.getLocation());
                            }
                            return true;
                        }
                    });
                }
                catch (IOException iOException) {
                    this.fQueue.clear();
                }
            }
            if (this.fQueue.isEmpty() || this.fReceiver.wasCanceled() || DefaultRecursiveSearchList.this.getClosedFlag().get()) {
                this.fReceiver.finished();
                DefaultRecursiveSearchList.this.fContexts.remove(this);
            }
        }
    }

    private class PauseAndResumeHandler {
        private final ParameterRunnable<Runnable> fRestartReceiver;
        private final List<Context> fLocalContexts;
        private final List<Runnable> fRestarters;

        PauseAndResumeHandler(ParameterRunnable<Runnable> parameterRunnable) {
            this.fRestartReceiver = parameterRunnable;
            this.fLocalContexts = new LinkedList<Context>();
            this.fRestarters = new LinkedList<Runnable>();
        }

        public void pause(List<Context> list) {
            assert (this.fLocalContexts.isEmpty());
            this.fLocalContexts.addAll(list);
            for (Context context : this.fLocalContexts) {
                context.pause(new ParameterRunnable<Runnable>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(Runnable runnable) {
                        boolean bl;
                        List list = PauseAndResumeHandler.this.fRestarters;
                        synchronized (list) {
                            PauseAndResumeHandler.this.fRestarters.add(runnable);
                            bl = PauseAndResumeHandler.this.fRestarters.size() == PauseAndResumeHandler.this.fLocalContexts.size();
                        }
                        if (bl) {
                            PauseAndResumeHandler.this.fRestartReceiver.run((Object)new Runnable(){

                                @Override
                                public void run() {
                                    PauseAndResumeHandler.this.resume();
                                }
                            });
                        }
                    }
                });
            }
        }

        private void resume() {
            for (Runnable runnable : this.fRestarters) {
                runnable.run();
            }
        }
    }
}

