/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.realfs;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.util.StringTokenizer;

final class WindowsNativeRecycle {
    private WindowsNativeRecycle() {
    }

    static boolean supportsNativeConfirmationDialog() {
        return PlatformInfo.isWindows();
    }

    static boolean supportsParentedConfirmationDialog() {
        return PlatformInfo.isWindows() && (!MJUtilities.hasMultipleMonitors() || PlatformInfo.isWindowsVistaAndAbove());
    }

    static void windowsNativeDelete(Component component, File[] fileArray, AsyncReceiver<File> asyncReceiver) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : fileArray) {
            stringBuilder.append(file.getAbsolutePath());
            stringBuilder.append("\u0000");
        }
        stringBuilder.append("\u0000");
        WindowsNativeRecycle.recycleFiles(component, stringBuilder.toString(), asyncReceiver);
    }

    private static void recycleFiles(Component component, String string, AsyncReceiver<File> asyncReceiver) {
        WindowsRecycleBin windowsRecycleBin = new WindowsRecycleBin(component, string, asyncReceiver);
        Thread thread = new Thread(windowsRecycleBin);
        thread.start();
    }

    private static class WindowsRecycleBin
    implements Runnable {
        private Component fComponent;
        private long fhWnd;
        private String fFiles;
        private AsyncReceiver<File> fReceiver;

        private WindowsRecycleBin(Component component, String string, AsyncReceiver<File> asyncReceiver) {
            this.fComponent = component;
            this.fhWnd = NativeJava.hWndFromComponent((Component)component);
            this.fFiles = string;
            this.fReceiver = asyncReceiver;
        }

        @Override
        public void run() {
            if (this.fhWnd != 0L) {
                if (!WindowsNativeRecycle.supportsParentedConfirmationDialog()) {
                    this.fhWnd = 0L;
                }
                NativeJava.recycleFile((long)this.fhWnd, (String)this.fFiles);
            }
            QueueEvent.postQueueEvent((QueueEvent)new QueueEvent(){

                public void dispatch() {
                    if (WindowsRecycleBin.this.fComponent != null) {
                        WindowsRecycleBin.this.fComponent.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
            StringTokenizer stringTokenizer = new StringTokenizer(this.fFiles, "\u0000");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (new File(string).exists() || this.fReceiver == null) continue;
                this.fReceiver.receive((Object)new File(string));
            }
            this.fReceiver.finished();
        }
    }
}

