/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.FileDecoration;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.FileDecorationModel;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.model.table.FileListExpansionContext;
import com.mathworks.mlwidgets.explorer.model.table.UiFileList;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.grouptable.ExpansionContext;
import com.mathworks.widgets.grouptable.ExpansionProvider;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FileSystemExpansionProvider
implements ExpansionProvider<FileSystemEntry> {
    private final NavigationContext fNavigationContext;
    private final Map<FileLocation, State> fContexts;
    private final Object fLock;
    private WeakReference<FileListExpansionContext> fSearchContext;

    public FileSystemExpansionProvider(NavigationContext navigationContext) {
        this.fNavigationContext = navigationContext;
        this.fLock = new Object();
        this.fContexts = new HashMap<FileLocation, State>();
    }

    public FileSystem getSystem() {
        return this.fNavigationContext.getSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpansionContext<FileSystemEntry> openContext(FileSystemEntry fileSystemEntry) {
        State state = null;
        Object object = this.fLock;
        synchronized (object) {
            if (this.fNavigationContext.isSearching() && fileSystemEntry.getLocation().equals((Object)this.fNavigationContext.getLocation())) {
                final FileList fileList = this.fNavigationContext.getList();
                FileListExpansionContext fileListExpansionContext = new FileListExpansionContext(this.fNavigationContext.getRequestQueue(), fileList, this.fNavigationContext.getExtensions(), true, this.fNavigationContext.getRefreshDaemon()){

                    @Override
                    public void close() {
                        if (!FileSystemExpansionProvider.this.fNavigationContext.isSearching() || !FileSystemExpansionProvider.this.fNavigationContext.getList().equals(fileList)) {
                            super.close();
                        }
                    }
                };
                this.fSearchContext = new WeakReference<1>(fileListExpansionContext);
                return fileListExpansionContext;
            }
            if (fileSystemEntry.isFolder() && (state = this.fContexts.get(fileSystemEntry.getLocation())) == null) {
                state = new State(fileSystemEntry.getLocation());
                this.fContexts.put(fileSystemEntry.getLocation(), state);
            }
        }
        return state == null ? null : state.addContext(fileSystemEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileListExpansionContext getContextIfOpen(FileLocation fileLocation) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fNavigationContext.isSearching() && fileLocation.equals((Object)this.fNavigationContext.getLocation()) && this.fSearchContext != null) {
                return (FileListExpansionContext)this.fSearchContext.get();
            }
            State state = this.fContexts.get(fileLocation);
            if (state != null) {
                return state.getOpenContext();
            }
            return null;
        }
    }

    public UiFileList getList(FileSystemEntry fileSystemEntry) {
        FileLocation fileLocation = fileSystemEntry.getLocation().getParent();
        if (fileLocation == null) {
            return null;
        }
        FileListExpansionContext fileListExpansionContext = this.getContextIfOpen(fileLocation);
        if (fileListExpansionContext != null) {
            return fileListExpansionContext.getList();
        }
        return null;
    }

    public <T> T getDecoration(FileSystemEntry fileSystemEntry, boolean bl, FileDecoration<T> fileDecoration) {
        UiFileList uiFileList = this.getList(fileSystemEntry);
        if (uiFileList == null) {
            return UiFileSystemUtils.getDecorationSynchronously(fileSystemEntry, fileDecoration, this.fNavigationContext.getExtensions());
        }
        return UiFileSystemUtils.getDecorationSynchronously(uiFileList, fileSystemEntry, fileDecoration, bl, this.fNavigationContext.getExtensions());
    }

    public <T> T getDecoration(FileSystemEntry fileSystemEntry, FileDecoration<T> fileDecoration) {
        return this.getDecoration(fileSystemEntry, true, fileDecoration);
    }

    public <T> void getDecorationAsynchronously(FileSystemEntry fileSystemEntry, FileDecoration<T> fileDecoration, ParameterRunnable<T> parameterRunnable) {
        UiFileList uiFileList = this.getList(fileSystemEntry);
        if (uiFileList == null) {
            new FileDecorationModel(this.fNavigationContext.getExtensions(), this.fNavigationContext.getRequestQueue(), fileSystemEntry).getDecorations().get(fileDecoration, false, parameterRunnable);
        } else {
            uiFileList.getDecorations(fileSystemEntry, this.fNavigationContext.getExtensions()).get(fileDecoration, true, parameterRunnable);
        }
    }

    private class State {
        private final FileLocation iLocation;
        private final List<WeakReference<FileListExpansionContext>> iContexts;

        State(FileLocation fileLocation) {
            this.iLocation = fileLocation;
            this.iContexts = new ArrayList<WeakReference<FileListExpansionContext>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FileListExpansionContext addContext(FileSystemEntry fileSystemEntry) {
            try {
                FileListExpansionContext fileListExpansionContext = new FileListExpansionContext(FileSystemExpansionProvider.this.fNavigationContext.getRequestQueue(), fileSystemEntry.getSystem().getList(fileSystemEntry.getLocation()), FileSystemExpansionProvider.this.fNavigationContext.getExtensions(), false, FileSystemExpansionProvider.this.fNavigationContext.getRefreshDaemon()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void close() {
                        super.close();
                        Object object = FileSystemExpansionProvider.this.fLock;
                        synchronized (object) {
                            Iterator iterator = State.this.iContexts.iterator();
                            while (iterator.hasNext()) {
                                WeakReference weakReference = (WeakReference)iterator.next();
                                if (weakReference.get() != this) continue;
                                iterator.remove();
                                break;
                            }
                            if (State.this.iContexts.isEmpty()) {
                                FileSystemExpansionProvider.this.fContexts.remove(State.this.iLocation);
                            }
                        }
                    }
                };
                Object object = FileSystemExpansionProvider.this.fLock;
                synchronized (object) {
                    this.iContexts.add(new WeakReference<1>(fileListExpansionContext));
                }
                return fileListExpansionContext;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FileListExpansionContext getOpenContext() {
            Object object = FileSystemExpansionProvider.this.fLock;
            synchronized (object) {
                Iterator<WeakReference<FileListExpansionContext>> iterator = this.iContexts.iterator();
                while (iterator.hasNext()) {
                    WeakReference<FileListExpansionContext> weakReference = iterator.next();
                    FileListExpansionContext fileListExpansionContext = (FileListExpansionContext)weakReference.get();
                    if (fileListExpansionContext == null || fileListExpansionContext.isClosed()) {
                        iterator.remove();
                        continue;
                    }
                    return fileListExpansionContext;
                }
                return null;
            }
        }
    }
}

