/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceEntityRequest;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.html.HtmlComponent;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.actionbrowser.FunctionReferenceUtils;
import com.mathworks.mlwidgets.actionbrowser.NekoHtmlSaxParser;
import com.mathworks.mlwidgets.graphics.IPlotModelChangeListener;
import com.mathworks.mlwidgets.graphics.ModelStateFactory;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.PlotCatalogCellRenderer;
import com.mathworks.mlwidgets.graphics.PlotMetadata;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mlwidgets.graphics.PlotPickerRenderer;
import com.mathworks.mlwidgets.graphics.PlotSignature;
import com.mathworks.mlwidgets.graphics.PlotWidgetsResources;
import com.mathworks.mlwidgets.graphics.StateNode;
import com.mathworks.mlwidgets.help.DocCenterReferenceRetrievalStrategy;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Log;
import com.mathworks.widgets.SearchTextField;
import com.mathworks.widgets.SearchTextFieldIntelliHints;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.TokenizerFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class PlotCatalogPanel
extends MJPanel
implements IPlotModelChangeListener,
ActionListener {
    protected static int DEFAULT_HEIGHT = 400;
    protected static int PLOT_TYPE_PANEL_MIN_WIDTH = 100;
    protected static int DOC_PANEL_MIN_WIDTH = 100;
    protected static Color SELECTION_COLOR = new Color(211, 221, 231);
    protected static Color FOREGROUND_COLOR = new Color(76, 83, 92);
    protected CategoryListModel fCategoryModel = new CategoryListModel();
    protected PlotTypeListModel fPlotTypeModel = new PlotTypeListModel(this.fCategoryModel);
    protected MJList fCategoryList;
    protected MJList fPlotTypeList;
    protected HtmlComponent<MatlabHtmlActions> fDocPanel;
    private MJSplitPane fSmallSplitPane;
    private MJSplitPane fBigSplitPane;
    private ListSelectionListener fCategoryListSelectionListener;
    private ListSelectionListener fPlotTypeListSelectionListener;
    protected PlotCatalogSignature fCurrentSelection;
    protected MJTextField fPlottedVarsTF;
    protected String fPlottedVarsString;
    protected String[] fPlottedVars;
    private ModelStateFactory.InterruptibleMatlabWorker fWorker;
    private boolean fIsTableUpdateQueued = false;
    private String fCurrentSearchString = "";
    private volatile StateNode fModelState;
    private PlotCatalogCellRenderer fPlotCatalogCellRenderer = new PlotCatalogCellRenderer();
    private HelpPanelUpdater fHelpPanelUpdater;
    private boolean fMousePressedState = false;
    private ArrayList<ListSelectionListener> fListSelectionListeners = new ArrayList();
    private Timer fTimer;
    private SearchTextField fSearchBox;
    private SearchTextFieldIntelliHints fIntelliHints;
    private boolean fLegacyPlotsOnly = false;
    private MJPopupMenu fPopup;
    private static boolean sIsHighContrast = false;

    public PlotCatalogPanel() {
        this(true);
    }

    private PlotCatalogPanel(boolean bl) {
        this.fLegacyPlotsOnly = bl;
        this.fModelState = ModelStateFactory.createNoSelectionModelState();
        this.updateLists();
        this.createUI();
        if (bl) {
            this.setPlottedVars(null);
        }
        this.fTimer = new Timer(750, this);
        this.fTimer.setRepeats(false);
    }

    static PlotCatalogPanel createPlotCatalogPanel() {
        return new PlotCatalogPanel(false);
    }

    boolean getLegacyPlotCatalogType() {
        return this.fLegacyPlotsOnly;
    }

    PlotTypeListModel getPlotTypeListModel() {
        return this.fPlotTypeModel;
    }

    protected void updateLists() {
        PlotCatalogSignature[] plotCatalogSignatureArray;
        int n;
        String string = null;
        String string2 = null;
        if (this.fCategoryList != null && this.fCategoryList.getSelectedIndex() >= 0) {
            string = ((Category)this.fCategoryList.getSelectedValue()).name;
        }
        if (this.fPlotTypeList != null && this.fPlotTypeList.getSelectedValue() != null) {
            string2 = ((PlotAction)((PlotCatalogSignature)this.fPlotTypeList.getSelectedValue()).getStateNode().getUserObject()).getID();
        }
        this.clearLists();
        if (this.fCurrentSearchString == null || this.fCurrentSearchString.length() == 0) {
            for (n = 0; n < this.fModelState.getChildCount(); ++n) {
                StateNode stateNode = (StateNode)this.fModelState.getChildAt(n);
                if (!this.fModelState.getChildAt(n).getAllowsChildren() || stateNode.getChildCount() <= 0 || (plotCatalogSignatureArray = PlotCatalogPanel.getCategorizedItems(stateNode, this.fLegacyPlotsOnly)) == null || plotCatalogSignatureArray.length <= 0) continue;
                String string3 = (String)stateNode.getUserObject();
                if (string3 != null && string3.startsWith("MATLAB ")) {
                    string3 = string3.substring(7);
                }
                this.addCategory(string3, plotCatalogSignatureArray);
            }
        } else {
            PlotCatalogSignature[] plotCatalogSignatureArray2 = PlotCatalogPanel.getCategorizedItems(this.fModelState, this.fLegacyPlotsOnly);
            if (plotCatalogSignatureArray2 != null && plotCatalogSignatureArray2.length > 0) {
                this.addCategory(PlotPicker.getResourceString("PlotCatalogPanel", "SearchResults"), plotCatalogSignatureArray2);
            }
            for (int i = 0; i < this.fModelState.getChildCount(); ++i) {
                plotCatalogSignatureArray = (PlotCatalogSignature[])this.fModelState.getChildAt(i);
                if (!plotCatalogSignatureArray.getAllowsChildren() || plotCatalogSignatureArray.getChildCount() <= 0 || (plotCatalogSignatureArray2 = PlotCatalogPanel.getCategorizedItems((StateNode)plotCatalogSignatureArray, this.fLegacyPlotsOnly)) == null || plotCatalogSignatureArray2.length <= 0) continue;
                this.addCategory((String)plotCatalogSignatureArray.getUserObject(), plotCatalogSignatureArray2);
            }
        }
        this.fPlotCatalogCellRenderer.setVarNames(this.fPlottedVars);
        this.fPlotCatalogCellRenderer.setFilterString(this.fCurrentSearchString);
        this.fPlotCatalogCellRenderer.setLegacyStyle(this.fLegacyPlotsOnly);
        this.fPlotTypeModel.fireContentsChanged();
        if (this.fCategoryList != null) {
            this.fPlotTypeList.repaint();
        }
        this.resetSelectionListeners();
        if (string != null) {
            for (n = 0; n < this.fCategoryModel.getSize(); ++n) {
                if (!string.equals(((Category)this.fCategoryModel.getElementAt((int)n)).name)) continue;
                this.fCategoryList.setSelectedIndex(n);
                break;
            }
        } else if (this.fCategoryList != null) {
            this.fCategoryList.setSelectedIndex(0);
        }
        if (string2 != null) {
            for (n = 0; n < this.fPlotTypeModel.getSize(); ++n) {
                String string4 = ((PlotAction)((PlotCatalogSignature)this.fPlotTypeModel.getElementAt(n)).getStateNode().getUserObject()).getID();
                if (!string2.equals(string4)) continue;
                this.fPlotTypeList.setSelectedIndex(n);
                break;
            }
        } else if (this.fPlotTypeList != null) {
            this.fPlotTypeList.setSelectedIndex(0);
        }
    }

    protected void addCategory(String string, PlotCatalogSignature[] plotCatalogSignatureArray) {
        this.fCategoryModel.addElement(new Category(string, plotCatalogSignatureArray));
    }

    MJList getPlotTypeList() {
        return this.fPlotTypeList;
    }

    MJList getCategoryList() {
        return this.fCategoryList;
    }

    protected void createUI() {
        this.fCategoryList = new MJList((ListModel)this.fCategoryModel);
        this.fCategoryList.setCellRenderer((ListCellRenderer)new CategoryCellRenderer());
        this.fCategoryList.setSelectionMode(0);
        this.fCategoryList.setSelectedIndex(0);
        this.fCategoryListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = PlotCatalogPanel.this.fCategoryList.getSelectedIndex();
                    if (n < 0 || PlotCatalogPanel.this.fPlotTypeModel == null || PlotCatalogPanel.this.fPlotTypeModel.getSize() <= 0) {
                        return;
                    }
                    PlotCatalogPanel.this.fPlotTypeModel.categorySelectionChanged(n);
                    PlotCatalogPanel.this.fPlotTypeList.setSelectedIndex(0);
                    PlotCatalogSignature plotCatalogSignature = (PlotCatalogSignature)PlotCatalogPanel.this.fPlotTypeModel.getElementAt(0);
                    if (plotCatalogSignature != null && (PlotCatalogPanel.this.fCurrentSelection == null || PlotCatalogPanel.this.fCurrentSelection.getStateNode().getPlotAction() != plotCatalogSignature.getStateNode().getPlotAction())) {
                        PlotCatalogPanel.this.showDocForCommand(plotCatalogSignature.getStateNode());
                    }
                    PlotCatalogPanel.this.fCurrentSelection = plotCatalogSignature;
                    for (ListSelectionListener listSelectionListener : PlotCatalogPanel.this.fListSelectionListeners) {
                        listSelectionListener.valueChanged(listSelectionEvent);
                    }
                }
            }
        };
        this.fCategoryList.addListSelectionListener(this.fCategoryListSelectionListener);
        this.fCategoryList.setName("Category.List");
        this.fPlotTypeList = new MJList((ListModel)this.fPlotTypeModel);
        this.fPlotTypeList.setCellRenderer((ListCellRenderer)this.fPlotCatalogCellRenderer);
        this.fPlotTypeList.setSelectionMode(0);
        this.fPlotTypeList.setSelectedIndex(0);
        this.fPlotTypeListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = PlotCatalogPanel.this.fPlotTypeList.getSelectedIndex();
                    if (n < 0) {
                        return;
                    }
                    PlotCatalogSignature plotCatalogSignature = (PlotCatalogSignature)PlotCatalogPanel.this.fPlotTypeModel.getElementAt(n);
                    if (plotCatalogSignature != null && (PlotCatalogPanel.this.fCurrentSelection == null || PlotCatalogPanel.this.fCurrentSelection.getStateNode().getPlotAction() != plotCatalogSignature.getStateNode().getPlotAction())) {
                        PlotCatalogPanel.this.showDocForCommand(plotCatalogSignature.getStateNode());
                    }
                    PlotCatalogPanel.this.fCurrentSelection = plotCatalogSignature;
                    for (ListSelectionListener listSelectionListener : PlotCatalogPanel.this.fListSelectionListeners) {
                        listSelectionListener.valueChanged(listSelectionEvent);
                    }
                }
            }
        };
        this.fPlotTypeList.addListSelectionListener(this.fPlotTypeListSelectionListener);
        this.fPlotTypeList.setName("PlotType.List");
        this.fDocPanel = HtmlComponentFactory.buildHtmlComponent(HtmlComponentFactory.HtmlComponentType.HTMLPANEL);
        this.fDocPanel.getComponent().setName("Doc.Panel");
        this.fPlottedVarsTF = new MJTextField();
        this.fPlottedVarsTF.setEnabled(!this.fLegacyPlotsOnly);
        this.fPlottedVarsTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotCatalogPanel.this.finishTextEditing();
            }
        });
        this.fPlottedVarsTF.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PlotCatalogPanel.this.finishTextEditing();
            }
        });
        this.fPlottedVarsTF.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    PlotCatalogPanel.this.finishTextEditing();
                }
            }
        });
        this.fPlottedVarsTF.setName("PlottedVars.TextField");
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(8, 8));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
        mJPanel.add((Component)new MJLabel(PlotWidgetsResources.getBundle().getString("PlotCatalog.label.plottedvariables")), (Object)"West");
        mJPanel.add((Component)this.fPlottedVarsTF, (Object)"Center");
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fCategoryList);
        MJScrollPane mJScrollPane2 = new MJScrollPane((Component)this.fPlotTypeList);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        mJPanel2.add((Component)mJPanel, (Object)"North");
        mJPanel2.add(this.fDocPanel.getComponent(), (Object)"Center");
        this.fSmallSplitPane = new InvisibleSplitPane(1, true, (Component)mJScrollPane, (Component)mJScrollPane2);
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        mJPanel3.add((Component)this.fSmallSplitPane, (Object)"Center");
        this.fBigSplitPane = new InvisibleSplitPane(1, true, (Component)mJPanel3, (Component)mJPanel2);
        this.fSmallSplitPane.setBorder(null);
        this.fBigSplitPane.setBorder(null);
        this.fSearchBox = new SearchTextField(PlotPicker.getResourceString("PlotPickerPanel", "SearchMsg"));
        this.fIntelliHints = new SearchTextFieldIntelliHints(this.fSearchBox);
        this.fSearchBox.getComponent().setName("PlotCatelogPanel:fSearchBox");
        this.fSearchBox.addSearchTextFieldListener(new SearchTextField.Listener(){

            public void search(String string) {
                PlotCatalogPanel.this.doSearch();
            }

            public void searchCleared() {
                PlotCatalogPanel.this.doSearch();
            }

            public void searchTextChanged(String string) {
                if (string == null || string.length() == 0) {
                    PlotCatalogPanel.this.fTimer.stop();
                    PlotCatalogPanel.this.doSearch();
                    return;
                }
                if (PlotCatalogPanel.this.fTimer.isRunning()) {
                    PlotCatalogPanel.this.fTimer.restart();
                    return;
                }
                PlotCatalogPanel.this.fTimer.start();
            }
        });
        mJPanel3.add((Component)this.fSearchBox.getComponent(), (Object)"North");
        mJPanel2.setMinimumSize(new Dimension(DOC_PANEL_MIN_WIDTH, 50));
        this.setLayout(new BorderLayout());
        this.add((Component)this.fBigSplitPane, "Center");
        mJScrollPane.setPreferredSize(new Dimension(this.fCategoryList.getPreferredSize().width + 50, DEFAULT_HEIGHT));
        mJScrollPane2.setPreferredSize(new Dimension(this.fPlotTypeList.getPreferredSize().width + 80, DEFAULT_HEIGHT));
        this.fDocPanel.getComponent().setPreferredSize(new Dimension(250, DEFAULT_HEIGHT));
        this.fPlotTypeList.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                PlotCatalogPanel.this.fPlotCatalogCellRenderer.mouseMovedCallback((JList)PlotCatalogPanel.this.fPlotTypeList, mouseEvent);
            }
        });
        this.fPlotTypeList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PlotCatalogPanel.this.fPlotCatalogCellRenderer.mouseMovedCallback((JList)PlotCatalogPanel.this.fPlotTypeList, mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PlotCatalogPanel.this.fMousePressedState = true;
                if (mouseEvent.isPopupTrigger()) {
                    PlotCatalogPanel.this.updatePopup(mouseEvent);
                    PlotCatalogPanel.this.fPopup.show((Component)PlotCatalogPanel.this.fPlotTypeList, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    PlotCatalogPanel.this.fPlotCatalogCellRenderer.mousePressedCallback((JList)PlotCatalogPanel.this.fPlotTypeList, mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    PlotCatalogPanel.this.updatePopup(mouseEvent);
                    PlotCatalogPanel.this.fPopup.show((Component)PlotCatalogPanel.this.fPlotTypeList, mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
                if (PlotCatalogPanel.this.fMousePressedState) {
                    PlotCatalogPanel.this.fMousePressedState = false;
                    PlotCatalogPanel.this.fPlotCatalogCellRenderer.mouseClickedCallback(PlotCatalogPanel.this, mouseEvent);
                }
                PlotCatalogPanel.this.fPlotCatalogCellRenderer.mouseMovedCallback((JList)PlotCatalogPanel.this.fPlotTypeList, mouseEvent);
            }
        });
        ModelStateFactory.addModelChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fTimer.stop();
        this.doSearch();
    }

    private void doSearch() {
        String string = this.fSearchBox.getSearchText().trim();
        this.clearLists();
        this.fCurrentSearchString = string;
        this.setVariableSelection();
        if (string != null && string.length() > 2) {
            this.fIntelliHints.addCurrentTextAsHint();
        }
    }

    void setDefaultSliderLocation(Dimension dimension) {
        this.fBigSplitPane.setDividerLocation(dimension.width / 2);
        this.fSmallSplitPane.setDividerLocation(dimension.width / 4);
    }

    private void clearLists() {
        this.fCurrentSelection = null;
        if (this.fPlotTypeList != null) {
            this.fPlotTypeList.removeListSelectionListener(this.fPlotTypeListSelectionListener);
        }
        if (this.fCategoryList != null) {
            this.fCategoryList.removeListSelectionListener(this.fCategoryListSelectionListener);
        }
        this.fCategoryModel.removeAllElements();
        this.fPlotTypeModel.removeAllElements();
    }

    @Override
    public void modelChanged(Object object) {
        this.setVariableSelection();
    }

    String getPlottedVarString() {
        return this.fPlottedVarsString;
    }

    private void setVariableSelection() {
        if (this.fWorker == null) {
            this.fWorker = new ModelStateFactory.InterruptibleMatlabWorker(){

                public void runOnAWTEventDispatchThread(Object object) {
                    if (PlotCatalogPanel.this.fIsTableUpdateQueued) {
                        PlotCatalogPanel.this.fIsTableUpdateQueued = false;
                        this.start();
                        return;
                    }
                    this.reset();
                    PlotCatalogPanel.this.updateLists();
                }

                public Object runOnMatlabThread() {
                    try {
                        PlotCatalogPanel.this.fModelState = (StateNode)PlotCatalogPanel.this.updateModelState(this);
                        return PlotCatalogPanel.this.fModelState;
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                        return null;
                    }
                }
            };
        }
        if (this.fPlottedVars == null || this.fPlottedVars.length == 0 || this.fPlottedVars[0] == null || this.fPlottedVars[0].trim().length() == 0) {
            if (this.fWorker.isRunning()) {
                this.fWorker.interrupt();
            }
            this.setNoSelectionState();
        } else {
            if (this.fWorker.isRunning()) {
                this.fWorker.interrupt();
                this.fIsTableUpdateQueued = true;
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!PlotCatalogPanel.this.fWorker.isRunning()) {
                        PlotCatalogPanel.this.fWorker.start();
                    } else {
                        PlotCatalogPanel.this.fIsTableUpdateQueued = true;
                    }
                }
            });
        }
    }

    private void setNoSelectionState() {
        if (this.fCurrentSearchString != null && this.fCurrentSearchString.length() >= 2) {
            StateNode stateNode = ModelStateFactory.createNoSelectionModelState();
            this.fModelState = ModelStateFactory.createModelStateForSearch(stateNode, this.fCurrentSearchString);
        } else {
            this.fModelState = ModelStateFactory.createNoSelectionModelState();
        }
        this.updateLists();
    }

    Object updateModelState(ModelStateFactory.InterruptibleMatlabWorker interruptibleMatlabWorker) {
        int n;
        assert (NativeMatlab.nativeIsMatlabThread());
        boolean bl = false;
        String[] stringArray = this.fPlottedVars;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String string = stringArray[n];
            try {
                string = string.replaceAll("\\(.*\\)", "");
                string = string.trim();
                double[] dArray = (double[])Matlab.mtFeval((String)"exist", (Object[])new Object[]{string, "var"}, (int)1);
                if (dArray != null && dArray.length == 1 && !(dArray[0] <= 0.5)) continue;
                bl = true;
            }
            catch (Exception exception) {
                bl = true;
            }
            break;
        }
        if (bl) {
            this.fModelState = ModelStateFactory.createNoSelectionModelState();
            if (this.fCurrentSearchString != null && this.fCurrentSearchString.length() >= 2) {
                this.fModelState = ModelStateFactory.createModelStateForSearch(this.fModelState, this.fCurrentSearchString);
            }
            for (int i = 0; i < this.fModelState.getChildCount(); ++i) {
                StateNode stateNode = (StateNode)this.fModelState.getChildAt(i);
                if (stateNode.getAllowsChildren() && stateNode.getChildCount() > 0) {
                    for (n = 0; n < stateNode.getChildCount(); ++n) {
                        ((StateNode)stateNode.getChildAt(n)).setEnabledByUnswappedVariables(true);
                        ((StateNode)stateNode.getChildAt(n)).setEnabledBySwappedVariables(this.fPlottedVars.length == 2);
                    }
                    continue;
                }
                stateNode.setEnabledByUnswappedVariables(true);
                stateNode.setEnabledBySwappedVariables(this.fPlottedVars.length == 2);
            }
            return this.fModelState;
        }
        if (this.fCurrentSearchString != null && this.fCurrentSearchString.length() >= 2) {
            this.fModelState = ModelStateFactory.createModelState(this.fPlottedVars, interruptibleMatlabWorker);
            if (this.fModelState != null) {
                return ModelStateFactory.createModelStateForSearch(this.fModelState, this.fCurrentSearchString);
            }
            return null;
        }
        if (this.fPlottedVars != null && this.fPlottedVars.length > 0) {
            this.fModelState = ModelStateFactory.createModelState(this.fPlottedVars, interruptibleMatlabWorker);
            return this.fModelState;
        }
        this.fModelState = ModelStateFactory.createNoSelectionModelState();
        return this.fModelState;
    }

    private static PlotCatalogSignature[] getCategorizedItems(StateNode stateNode, boolean bl) {
        ArrayList<PlotCatalogSignature> arrayList = new ArrayList<PlotCatalogSignature>();
        for (int i = 0; i < stateNode.getChildCount(); ++i) {
            if (stateNode.getChildAt(i).getAllowsChildren() && stateNode.getChildAt(i).getChildCount() != 0) continue;
            if (bl) {
                String string;
                PlotSignature plotSignature;
                StateNode stateNode2;
                PlotAction plotAction;
                if (stateNode.getProductID() != null && !"matlab".equalsIgnoreCase(stateNode.getProductID()) || (plotAction = (PlotAction)(stateNode2 = (StateNode)stateNode.getChildAt(i)).getUserObject()) == null || stateNode2.getProductID() != null && !"matlab".equalsIgnoreCase(stateNode2.getProductID()) || (plotSignature = PlotMetadata.getPlotSignature(string = plotAction.getFunctionName(), plotAction.getID())) == null) continue;
                arrayList.add(PlotCatalogSignature.createPlotCatalogSignature((StateNode)stateNode.getChildAt(i), plotSignature));
                continue;
            }
            arrayList.add(PlotCatalogSignature.createPlotCatalogSignature((StateNode)stateNode.getChildAt(i)));
        }
        return arrayList.toArray(new PlotCatalogSignature[arrayList.size()]);
    }

    public PlotSignature getPlotType() {
        if (this.fCurrentSelection != null) {
            return this.fCurrentSelection.getPlotSignature();
        }
        return null;
    }

    PlotAction getCurrentPlotAction() {
        if (this.fCurrentSelection == null) {
            return null;
        }
        StateNode stateNode = this.fCurrentSelection.getStateNode();
        if (stateNode != null && stateNode.getUserObject() instanceof PlotAction) {
            return (PlotAction)stateNode.getUserObject();
        }
        return null;
    }

    public void cleanupSplitPanes() {
        int n;
        Component component;
        Component component2 = this.fSmallSplitPane.getRightComponent();
        int n2 = (int)component2.getSize().getWidth();
        if ((float)n2 == 0.0f) {
            this.fSmallSplitPane.setDividerLocation(PLOT_TYPE_PANEL_MIN_WIDTH);
        }
        if ((component = this.fBigSplitPane.getRightComponent()) != null && (float)(n = (int)component.getSize().getWidth()) == 0.0f) {
            this.fBigSplitPane.setDividerLocation(200);
        }
    }

    public void setPlottedVars(String[] stringArray) {
        this.fPlottedVars = stringArray;
        if (stringArray == null) {
            this.fPlottedVarsString = "";
            this.fPlottedVarsTF.setText("");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            this.fPlottedVarsString = new String(stringBuffer);
            this.fPlottedVarsTF.setText(this.fPlottedVarsString);
        }
        this.setVariableSelection();
    }

    private void resetSelectionListeners() {
        if (this.fPlotTypeList != null) {
            this.fPlotTypeList.removeListSelectionListener(this.fPlotTypeListSelectionListener);
            this.fPlotTypeList.addListSelectionListener(this.fPlotTypeListSelectionListener);
        }
        if (this.fCategoryList != null) {
            this.fCategoryList.removeListSelectionListener(this.fCategoryListSelectionListener);
            this.fCategoryList.addListSelectionListener(this.fCategoryListSelectionListener);
        }
    }

    protected void finishTextEditing() {
        String string;
        this.fPlottedVarsString = string = this.fPlottedVarsTF.getText();
        Tokenizer.TokenInfo[] tokenInfoArray = TokenizerFactory.getMTokenizer().tokenize(string.trim());
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (Tokenizer.TokenInfo tokenInfo : tokenInfoArray) {
            switch (tokenInfo.getTokenID().getNumericID()) {
                case 52: {
                    ++n3;
                    break;
                }
                case 53: {
                    --n3;
                    break;
                }
                case 56: {
                    ++n;
                    break;
                }
                case 57: {
                    --n;
                    break;
                }
                case 54: {
                    ++n2;
                    break;
                }
                case 55: {
                    --n2;
                }
            }
            if (tokenInfo.getTokenID().getNumericID() != 51 || n != 0 || n2 != 0 || n3 != 0) continue;
            arrayList.add(string.substring(n4, tokenInfo.getOffset()));
            n4 = tokenInfo.getOffset() + tokenInfo.getLength();
        }
        if (n4 < string.length()) {
            arrayList.add(string.substring(n4));
        }
        this.fPlottedVars = arrayList.toArray(new String[arrayList.size()]);
        this.setVariableSelection();
    }

    void cleanup() {
        ModelStateFactory.removeModelChangeListener(this);
        if (this.fDocPanel != null) {
            this.fDocPanel.dispose();
        }
    }

    boolean isCurrentPlotEnabled() {
        return this.fCurrentSelection != null && this.fCurrentSelection.getStateNode().isEnabled();
    }

    public synchronized void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.fListSelectionListeners.add(listSelectionListener);
    }

    public synchronized void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.fListSelectionListeners.remove(listSelectionListener);
    }

    protected void showDocForCommand(StateNode stateNode) {
        if (!HelpUtils.isDocInstalled()) {
            return;
        }
        if (this.fHelpPanelUpdater == null) {
            this.fHelpPanelUpdater = new HelpPanelUpdater();
            this.fHelpPanelUpdater.setLegacyPlotsOnly(this.fLegacyPlotsOnly);
        }
        this.fHelpPanelUpdater.start(this.fDocPanel, stateNode, this.fCurrentSearchString);
    }

    private PlotCatalogSignature getPlotCatalogSignatureAt(int n) {
        if (n < 0) {
            return null;
        }
        Object object = this.fPlotTypeModel.getElementAt(n);
        if (object == null || !(object instanceof PlotCatalogSignature)) {
            return null;
        }
        return (PlotCatalogSignature)object;
    }

    private PlotCatalogSignature getSelectedPlotCatalogSignature() {
        return this.getPlotCatalogSignatureAt(this.fPlotTypeList.getSelectedIndex());
    }

    private StateNode getStateNodeAt(int n) {
        PlotCatalogSignature plotCatalogSignature = this.getPlotCatalogSignatureAt(n);
        if (plotCatalogSignature == null) {
            return null;
        }
        return plotCatalogSignature.getStateNode();
    }

    private PlotAction getPlotActionAt(int n) {
        StateNode stateNode = this.getStateNodeAt(n);
        if (stateNode == null) {
            return null;
        }
        Object object = stateNode.getUserObject();
        if (object == null || !(object instanceof PlotAction)) {
            return null;
        }
        return (PlotAction)object;
    }

    private PlotAction getSelectedPlotAction() {
        return this.getPlotActionAt(this.fPlotTypeList.getSelectedIndex());
    }

    private void updatePopup(MouseEvent mouseEvent) {
        int n = this.fPlotTypeList.locationToIndex(mouseEvent.getPoint());
        StateNode stateNode = this.getStateNodeAt(n);
        if (n < 0 || stateNode == null) {
            return;
        }
        this.fPlotTypeList.setSelectedIndex(n);
        if (this.fPopup == null) {
            this.fPopup = new MJPopupMenu();
        }
        this.fPopup.removeAll();
        MJMenuItem mJMenuItem = new MJMenuItem((Action)((Object)new ExecuteAction()));
        mJMenuItem.setEnabled(stateNode.isEnabled());
        this.fPopup.add((JMenuItem)mJMenuItem);
        this.fPopup.add((Action)((Object)new InsertAction()));
    }

    private static String getSelectionMessageHtml(String string) {
        String string2 = HTMLUtils.getURLStringFromFile(new File(Matlab.matlabRoot() + "/toolbox/matlab/icons/dialog_warning_16.png"));
        String string3 = PlotPicker.getResourceString("PlotPickerPanel", "ReqInputs");
        return "<table border='1'  width='100%' cellspacing='0' style=\"background-color:#ffffff\"><tr><td><table border='0' width='100%' cellspacing='0' cellpadding = '1' style=background-color:#FFFFFF> <COL width='20' align='left'> <tr><td width='20'> <img src='" + string2 + "'></td><td>" + string3 + "</td></tr><tr><td td width='25'></td><td><b>" + string + "</b></td></tr></table></td></tr></table>";
    }

    static {
        sIsHighContrast = MJUtilities.isHighContrast();
    }

    static class PlotCatalogSignature {
        private StateNode fStateNode;
        private boolean fSwapped = false;
        private PlotSignature fPlotSignature;

        public PlotCatalogSignature(StateNode stateNode) {
            this.fStateNode = stateNode;
        }

        public PlotCatalogSignature(StateNode stateNode, PlotSignature plotSignature) {
            this.fStateNode = stateNode;
            this.fPlotSignature = plotSignature;
        }

        static PlotCatalogSignature createPlotCatalogSignature(StateNode stateNode, PlotSignature plotSignature) {
            return new PlotCatalogSignature(stateNode, plotSignature);
        }

        static PlotCatalogSignature createPlotCatalogSignature(StateNode stateNode) {
            return new PlotCatalogSignature(stateNode);
        }

        PlotSignature getPlotSignature() {
            return this.fPlotSignature;
        }

        StateNode getStateNode() {
            return this.fStateNode;
        }

        boolean isSwapped() {
            return this.fSwapped;
        }

        void setSwapped(boolean bl) {
            this.fSwapped = bl;
        }

        String getName() {
            if (this.fStateNode != null) {
                return ((PlotAction)this.fStateNode.getUserObject()).getFunctionName();
            }
            return null;
        }

        String getCommand() {
            if (this.fStateNode != null) {
                return ((PlotAction)this.fStateNode.getUserObject()).getFunctionName();
            }
            return null;
        }

        URL getSmallIconURL() {
            if (this.fStateNode != null) {
                PlotAction plotAction = (PlotAction)this.fStateNode.getUserObject();
                return PlotAction.getIconURL(plotAction.getSmallIconPath());
            }
            return null;
        }

        URL getLargeIconURL() {
            if (this.fStateNode != null) {
                PlotAction plotAction = (PlotAction)this.fStateNode.getUserObject();
                return PlotAction.getIconURL(plotAction.getLargeIconPath());
            }
            return null;
        }

        public String toString() {
            if (this.fStateNode != null) {
                PlotAction plotAction = (PlotAction)this.fStateNode.getUserObject();
                return plotAction.getPlotLabel(null);
            }
            return super.toString();
        }
    }

    class InsertAction
    extends MJAbstractAction {
        public InsertAction() {
            super(PlotPicker.getResourceString("PlotPickerTreeTable", "Insert"));
            this.setComponentName("Insert");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlotAction plotAction = PlotCatalogPanel.this.getSelectedPlotAction();
            PlotCatalogSignature plotCatalogSignature = PlotCatalogPanel.this.getSelectedPlotCatalogSignature();
            if (plotAction == null) {
                return;
            }
            plotAction.insert(PlotCatalogPanel.this.fPlottedVars, plotCatalogSignature.isSwapped());
        }
    }

    class ExecuteAction
    extends MJAbstractAction {
        public ExecuteAction() {
            super(PlotPicker.getResourceString("PlotPickerTreeTable", "Execute"));
            this.setComponentName("Execute");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlotAction plotAction = PlotCatalogPanel.this.getSelectedPlotAction();
            PlotCatalogSignature plotCatalogSignature = PlotCatalogPanel.this.getSelectedPlotCatalogSignature();
            if (plotAction == null) {
                return;
            }
            plotAction.execute(PlotCatalogPanel.this.fPlottedVars, plotCatalogSignature.isSwapped(), PlotCatalogPanel.this.fPlotTypeList);
        }
    }

    static class HelpPanelUpdater {
        private volatile String iCurrentSearchString;
        private volatile StateNode iStateNode;
        private volatile HtmlComponent<MatlabHtmlActions> iDocPanel;
        private volatile boolean iIsRunning = false;
        private Thread iThread;
        private volatile boolean iRunRequestPending = false;
        private boolean iLegacyPlotsOnly = false;

        HelpPanelUpdater() {
        }

        private synchronized ArrayList<Object> getState() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.iStateNode);
            arrayList.add(this.iDocPanel);
            arrayList.add(this.iCurrentSearchString);
            return arrayList;
        }

        private synchronized void setState(StateNode stateNode, HtmlComponent<MatlabHtmlActions> htmlComponent, String string) {
            this.iStateNode = stateNode;
            this.iDocPanel = htmlComponent;
            this.iCurrentSearchString = string;
        }

        void setLegacyPlotsOnly(boolean bl) {
            this.iLegacyPlotsOnly = bl;
        }

        private void resetRunState() {
            if (this.iRunRequestPending) {
                this.iRunRequestPending = false;
                this.restart();
            } else {
                this.iIsRunning = false;
            }
        }

        private void update() {
            ArrayList<Object> arrayList = this.getState();
            StateNode stateNode = (StateNode)arrayList.get(0);
            final HtmlComponent htmlComponent = (HtmlComponent)arrayList.get(1);
            String string = (String)arrayList.get(2);
            PlotAction plotAction = (PlotAction)stateNode.getUserObject();
            String string2 = plotAction.getFunctionName();
            if (string2 == null || string2.length() == 0) {
                this.resetRunState();
                return;
            }
            String string3 = HelpPrefs.isUsingDocCenterBrowser() ? HelpPanelUpdater.getDocCenterRefPageUrl(string2) : HelpPanelUpdater.getClassicDocRefPageUrl(string2);
            if (string3 == null) {
                this.resetRunState();
                return;
            }
            NekoHtmlSaxParser nekoHtmlSaxParser = NekoHtmlSaxParser.getDescriptionParser(string3, string);
            try {
                nekoHtmlSaxParser.parse(string3);
            }
            catch (Exception exception) {
                this.resetRunState();
                return;
            }
            String string4 = nekoHtmlSaxParser.getDescription();
            String string5 = "matlab:doc " + string2;
            String string6 = PlotPicker.getResourceString("PlotCatalogPanel", "MoreHelp");
            if (!stateNode.isEnabled() && !this.iLegacyPlotsOnly) {
                string4 = "<br>" + PlotCatalogPanel.getSelectionMessageHtml(plotAction.getRuleDescription()) + "<br>" + string4;
            }
            final String string7 = string4 = "<p align=\"right\"><font size=\"1\"><a href=\"" + string5 + "\">" + string6 + "</a></font></p></div><p><font size=\"+2\" color=\"#990000\">" + string2 + "</font></p><i>" + plotAction.getDescription() + "</i><br>" + string4;
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (HelpPanelUpdater.this.iRunRequestPending) {
                        HelpPanelUpdater.this.iRunRequestPending = false;
                        HelpPanelUpdater.this.restart();
                    } else {
                        htmlComponent.setHtmlText("<html>" + string7 + "</html>");
                        HelpPanelUpdater.this.iIsRunning = false;
                    }
                }
            });
        }

        private void restart() {
            this.iThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    HelpPanelUpdater.this.update();
                }
            });
            this.iIsRunning = true;
            this.iThread.start();
        }

        void start(HtmlComponent<MatlabHtmlActions> htmlComponent, StateNode stateNode, String string) {
            this.setState(stateNode, htmlComponent, string);
            if (this.iIsRunning) {
                this.iRunRequestPending = true;
            } else {
                this.restart();
            }
        }

        private static String getDocCenterRefPageUrl(String string) {
            ReferenceEntityRequest referenceEntityRequest = new ReferenceEntityRequest(string, new RefEntityType[]{RefEntityType.FUNCTION});
            List<ReferenceData> list = HelpPanelUpdater.getReferenceData((ReferenceRequest)referenceEntityRequest);
            if (!list.isEmpty()) {
                String string2 = list.get(0).getProduct().getHelpLocation();
                String string3 = list.get(0).getRelativePath();
                return HelpPrefs.getDocRoot() + "/" + string2 + "/" + string3;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static List<ReferenceData> getReferenceData(ReferenceRequest referenceRequest) {
            ReferenceDataRetriever referenceDataRetriever = DocCenterReferenceRetrievalStrategy.createDataRetriever();
            try {
                List list = referenceDataRetriever.getReferenceData(referenceRequest);
                return list;
            }
            finally {
                try {
                    referenceDataRetriever.close();
                }
                catch (IOException iOException) {}
            }
        }

        private static String getClassicDocRefPageUrl(String string) {
            List<String> list = FunctionReferenceUtils.getAllReferencePageUrls(string, false);
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
    }

    class InvisibleSplitPane
    extends MJSplitPane {
        public InvisibleSplitPane(int n, boolean bl, Component component, Component component2) {
            super(n, bl, component, component2);
            if (this.getUI() instanceof BasicSplitPaneUI) {
                BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)this.getUI();
                basicSplitPaneUI.getDivider().setBorder(null);
            }
        }
    }

    class Category {
        public String name;
        public PlotCatalogSignature[] plotTypes;

        Category(String string, PlotCatalogSignature[] plotCatalogSignatureArray) {
            this.name = string;
            this.plotTypes = plotCatalogSignatureArray;
        }

        public String toString() {
            return this.name;
        }
    }

    class PlotTypeListModel
    extends DefaultListModel {
        protected CategoryListModel categoryModel;

        PlotTypeListModel(CategoryListModel categoryListModel) {
            this.categoryModel = categoryListModel;
        }

        @Override
        public void removeAllElements() {
            super.removeAllElements();
            this.categoryModel.removeAllElements();
        }

        @Override
        public Object getElementAt(int n) {
            if (PlotCatalogPanel.this.fCategoryList.getSelectedIndex() < 0) {
                return null;
            }
            Object e = this.categoryModel.get(PlotCatalogPanel.this.fCategoryList.getSelectedIndex());
            if (e instanceof Category) {
                Category category = (Category)e;
                return category.plotTypes[n];
            }
            return null;
        }

        void fireContentsChanged() {
            if (PlotCatalogPanel.this.fCategoryList == null || PlotCatalogPanel.this.fCategoryList.getSelectedIndex() < 0) {
                return;
            }
            Object e = this.categoryModel.get(PlotCatalogPanel.this.fCategoryList.getSelectedIndex());
            if (e instanceof Category) {
                Category category = (Category)e;
                this.fireContentsChanged(this, 0, category.plotTypes.length - 1);
            }
        }

        @Override
        public int getSize() {
            if (PlotCatalogPanel.this.fCategoryList == null || this.categoryModel.isEmpty() || PlotCatalogPanel.this.fCategoryList.getSelectedIndex() < 0) {
                return 0;
            }
            Object e = this.categoryModel.get(PlotCatalogPanel.this.fCategoryList.getSelectedIndex());
            if (e instanceof Category) {
                Category category = (Category)e;
                return category.plotTypes.length;
            }
            return 0;
        }

        public void categorySelectionChanged(int n) {
            Object e = this.categoryModel.get(n);
            if (e instanceof Category) {
                Category category = (Category)e;
                this.fireContentsChanged(this, 0, category.plotTypes.length - 1);
            }
        }
    }

    class CategoryListModel
    extends DefaultListModel {
        CategoryListModel() {
        }
    }

    class CategoryCellRenderer
    implements ListCellRenderer {
        StyledLabel iStyledLabel = new StyledLabel();

        CategoryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object e = jList.getModel().getElementAt(n);
            this.iStyledLabel.setText(e != null ? e.toString() : "");
            this.iStyledLabel.setOpaque(true);
            if (bl) {
                if (jList.hasFocus()) {
                    this.iStyledLabel.setBackground(UIManager.getColor("List.selectionBackground"));
                    this.iStyledLabel.setForeground(UIManager.getColor("List.selectionForeground"));
                } else {
                    this.iStyledLabel.setBackground(Color.white);
                    this.iStyledLabel.setForeground(Color.black);
                    this.iStyledLabel.setBackground(SELECTION_COLOR);
                    this.iStyledLabel.setForeground(FOREGROUND_COLOR);
                }
            } else if (sIsHighContrast) {
                this.iStyledLabel.setBackground(Color.black);
                this.iStyledLabel.setForeground(Color.white);
            } else {
                this.iStyledLabel.setBackground(Color.white);
                this.iStyledLabel.setForeground(Color.black);
            }
            if (!bl) {
                if (object instanceof String) {
                    PlotCatalogPanel.this.setBackground(new Color(210, 210, 210));
                } else {
                    PlotCatalogPanel.this.setBackground(Color.white);
                }
                this.hilight();
            } else {
                this.iStyledLabel.clearStyleRanges();
            }
            return this.iStyledLabel;
        }

        protected void hilight() {
            if (PlotCatalogPanel.this.fCurrentSearchString == null || PlotCatalogPanel.this.fCurrentSearchString.trim().length() <= 1) {
                this.iStyledLabel.clearStyleRanges();
            } else {
                StyleRange[] styleRangeArray = PlotPickerRenderer.createHiLightedStyleRanges(this.iStyledLabel.getText(), PlotCatalogPanel.this.fCurrentSearchString.split(" "), this.iStyledLabel.getFont().getStyle(), this.iStyledLabel.getForeground());
                this.iStyledLabel.setStyleRanges(styleRangeArray);
            }
        }
    }
}

