/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.jidesoft.grid.Row;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.PlotItemCellRenderer;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mlwidgets.graphics.PlotPickerRenderer;
import com.mathworks.mlwidgets.graphics.PlotPickerTableModel;
import com.mathworks.mlwidgets.graphics.PlotPickerTreeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

final class PlotPickerCellRenderer
extends PlotItemCellRenderer
implements TableCellRenderer {
    private CurrentButton fHighlightedButton = CurrentButton.NONE;
    private int fHighlightedRow = -1;
    private CurrentButton fPressedButton = CurrentButton.NONE;

    PlotPickerCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        assert (jTable instanceof PlotPickerTreeTable);
        PlotPickerTreeTable plotPickerTreeTable = (PlotPickerTreeTable)((Object)jTable);
        Row row = plotPickerTreeTable.getRowAt(n);
        PlotPickerTableModel.ActionRow actionRow = (PlotPickerTableModel.ActionRow)row;
        PlotAction plotAction = actionRow.getPlotAction();
        this.fPlotActionRenderer.resetLabelsForeground();
        this.fPlotActionRenderer.setEnabled(((PlotPickerTableModel.ActionRow)row).isEnabled());
        if (plotPickerTreeTable.getDragTargetRow() == n) {
            this.fPlotActionRenderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0), BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black)));
        } else if (plotPickerTreeTable.getDragTargetRow() + 1 == n) {
            this.fPlotActionRenderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0), BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black)));
        } else {
            this.fPlotActionRenderer.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }
        this.fPlotActionRenderer.setIcon(plotAction.getIcon());
        this.fPlotActionRenderer.setDescription(plotAction.getDescription());
        if (actionRow.isSwapped()) {
            if (actionRow.getSwappedCustomLabel() != null && actionRow.getSwappedCustomLabel().length() > 0) {
                this.fPlotActionRenderer.setPlotName(actionRow.getSwappedCustomLabel());
            } else {
                this.fPlotActionRenderer.setPlotName(plotAction.getSwappedPlotLabel(this.fVarNames));
            }
        } else if (actionRow.getCustomLabel() != null && actionRow.getCustomLabel().length() > 0) {
            this.fPlotActionRenderer.setPlotName(actionRow.getCustomLabel());
        } else {
            this.fPlotActionRenderer.setPlotName(plotAction.getPlotLabel(this.fVarNames));
        }
        if (actionRow.isSwapable()) {
            boolean bl3 = actionRow.isSwapped();
            if (!bl) {
                this.fPlotActionRenderer.getSwapLabel().setIcon((Icon)(bl3 ? YX_WATERMARK : XY_WATERMARK));
            } else if (this.fPressedButton == CurrentButton.SWAP) {
                this.fPlotActionRenderer.getSwapLabel().setIcon((Icon)(bl3 ? YX_BUTTONPRESSED : XY_BUTTONPRESSED));
            } else if (this.fHighlightedButton == CurrentButton.SWAP) {
                this.fPlotActionRenderer.getSwapLabel().setIcon((Icon)(bl3 ? YX_BUTTONHOVER : XY_BUTTONHOVER));
            } else {
                this.fPlotActionRenderer.getSwapLabel().setIcon((Icon)(bl3 ? YX_BUTTON : XY_BUTTON));
            }
            this.fPlotActionRenderer.getSwapLabel().setVisible(true);
        } else {
            this.fPlotActionRenderer.getSwapLabel().setVisible(false);
        }
        if (bl) {
            if (this.fPressedButton == CurrentButton.ICON) {
                ((PlotPickerRenderer.PlotIcon)this.fPlotActionRenderer.getIconLabel().getIcon()).setState(PlotPickerRenderer.PlotIcon.PRESSED);
            } else if (this.fHighlightedButton == CurrentButton.ICON) {
                ((PlotPickerRenderer.PlotIcon)this.fPlotActionRenderer.getIconLabel().getIcon()).setState(PlotPickerRenderer.PlotIcon.HOVER);
            } else {
                ((PlotPickerRenderer.PlotIcon)this.fPlotActionRenderer.getIconLabel().getIcon()).setState(PlotPickerRenderer.PlotIcon.UP);
            }
        } else {
            ((PlotPickerRenderer.PlotIcon)this.fPlotActionRenderer.getIconLabel().getIcon()).setState(PlotPickerRenderer.PlotIcon.INACTIVE);
        }
        if (bl) {
            if (plotPickerTreeTable.hasFocus()) {
                if (!sIsHighContrast) {
                    this.fPlotActionRenderer.setBackground(UIManager.getColor("List.selectionBackground"));
                    this.fPlotActionRenderer.setForeground(UIManager.getColor("List.selectionForeground"));
                } else {
                    this.fPlotActionRenderer.setBackground(Color.white);
                    this.fPlotActionRenderer.setForeground(Color.black);
                }
            } else {
                this.fPlotActionRenderer.setBackground(SELECTION_COLOR);
                if (sIsHighContrast) {
                    this.fPlotActionRenderer.setForeground(Color.black);
                } else {
                    this.fPlotActionRenderer.setForeground(FOREGROUND_COLOR);
                }
            }
        } else {
            this.fPlotActionRenderer.setBackground(BACKGROUND_COLOR);
        }
        if (!jTable.hasFocus() || !bl) {
            this.hilight();
        } else {
            this.clearhilight();
        }
        return this.fPlotActionRenderer;
    }

    boolean isOverActiveButton() {
        return this.fHighlightedButton != CurrentButton.NONE;
    }

    private CurrentButton getHoverButton(PlotPickerTreeTable plotPickerTreeTable, Point point) {
        if (PlotPickerCellRenderer.isMouseInHoverButton(plotPickerTreeTable, this.fSwapLabelBounds, point)) {
            return CurrentButton.SWAP;
        }
        if (PlotPickerCellRenderer.isMouseInHoverButton(plotPickerTreeTable, this.fIconLabelBounds, point)) {
            return CurrentButton.ICON;
        }
        return CurrentButton.NONE;
    }

    void clearButtonEffects(JTable jTable) {
        this.fPressedButton = CurrentButton.NONE;
        this.fHighlightedButton = CurrentButton.NONE;
        jTable.setToolTipText(null);
    }

    private void setButtonPressed(CurrentButton currentButton) {
        switch (currentButton) {
            case SWAP: {
                this.fPressedButton = CurrentButton.SWAP;
                break;
            }
            case ICON: {
                this.fPressedButton = CurrentButton.ICON;
                break;
            }
            case NONE: {
                this.fPressedButton = CurrentButton.NONE;
            }
        }
    }

    private void setButtonHighlighted(CurrentButton currentButton) {
        switch (currentButton) {
            case SWAP: {
                this.fHighlightedButton = CurrentButton.SWAP;
                break;
            }
            case ICON: {
                this.fHighlightedButton = CurrentButton.ICON;
                break;
            }
            case NONE: {
                this.fHighlightedButton = CurrentButton.NONE;
            }
        }
    }

    void mouseMovedCallback(PlotPickerTreeTable plotPickerTreeTable, MouseEvent mouseEvent, PlotPickerTableModel.ActionRow actionRow) {
        CurrentButton currentButton = this.getHoverButton(plotPickerTreeTable, mouseEvent.getPoint());
        int n = plotPickerTreeTable.rowAtPoint(mouseEvent.getPoint());
        if (currentButton == this.fHighlightedButton && this.fHighlightedRow == n) {
            return;
        }
        this.fHighlightedRow = n;
        this.setButtonPressed(CurrentButton.NONE);
        if (currentButton != CurrentButton.ICON || actionRow.isEnabled()) {
            this.setButtonHighlighted(currentButton);
        } else {
            this.setButtonHighlighted(CurrentButton.NONE);
        }
        switch (currentButton) {
            case SWAP: {
                if (actionRow.isSwapable()) {
                    plotPickerTreeTable.setToolTipText(PlotPicker.getResourceString("PlotPickerCellRenderer", "SwitchOrder"));
                    break;
                }
                plotPickerTreeTable.setToolTipText(null);
                this.setButtonHighlighted(CurrentButton.NONE);
                break;
            }
            case ICON: {
                if (actionRow.isEnabled()) {
                    plotPickerTreeTable.setToolTipText(PlotPicker.getResourceString("PlotPickerCellRenderer", "Create"));
                    break;
                }
                plotPickerTreeTable.setToolTipText(null);
                break;
            }
            case NONE: {
                plotPickerTreeTable.setToolTipText(null);
            }
        }
        if (((Component)mouseEvent.getSource()).getCursor().getType() != 3) {
            if (currentButton == CurrentButton.NONE) {
                plotPickerTreeTable.setCursor(new Cursor(12));
            } else {
                plotPickerTreeTable.setCursor(new Cursor(0));
            }
        }
        plotPickerTreeTable.repaint();
    }

    void mousePressedCallback(PlotPickerTreeTable plotPickerTreeTable, MouseEvent mouseEvent) {
        CurrentButton currentButton = this.getHoverButton(plotPickerTreeTable, mouseEvent.getPoint());
        if (this.fPressedButton == currentButton) {
            return;
        }
        this.setButtonPressed(currentButton);
        plotPickerTreeTable.repaint();
    }

    void mouseReleasedCallback(PlotPickerTreeTable plotPickerTreeTable, MouseEvent mouseEvent) {
        this.fPressedButton = CurrentButton.NONE;
    }

    void mouseClickedCallback(PlotPickerTreeTable plotPickerTreeTable, MouseEvent mouseEvent, PlotPickerTableModel.ActionRow actionRow) {
        if (PlotPickerCellRenderer.isMouseInHoverButton(plotPickerTreeTable, this.fSwapLabelBounds, mouseEvent.getPoint())) {
            actionRow.setSwapped(!actionRow.isSwapped());
            plotPickerTreeTable.repaint();
        } else if (PlotPickerCellRenderer.isMouseInHoverButton(plotPickerTreeTable, this.fIconLabelBounds, mouseEvent.getPoint()) && mouseEvent.getButton() == 1) {
            plotPickerTreeTable.execute(actionRow);
        }
    }

    public static enum CurrentButton {
        SWAP,
        ICON,
        NONE;

    }
}

