/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.mlwidgets.help.search.BooleanSearchOperator;
import com.mathworks.mlwidgets.help.search.CompoundSearchExpression;
import com.mathworks.mlwidgets.help.search.ExactPhraseSearchExpression;
import com.mathworks.mlwidgets.help.search.PartialWordSearchExpression;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchExpression;
import com.mathworks.mlwidgets.help.search.SearchVisitor;
import com.mathworks.mlwidgets.help.search.SimpleSearchExpression;
import com.mathworks.mlwidgets.help.search.WildcardSearchExpression;
import java.util.Iterator;

public class OnlineSearchStringVisitor
implements SearchVisitor {
    private String fSearchString;

    @Override
    public void visit(SimpleSearchExpression simpleSearchExpression) throws SearchException {
        this.setSearchString(simpleSearchExpression.getSearchString(), simpleSearchExpression.getBooleanOperator());
    }

    @Override
    public void visit(PartialWordSearchExpression partialWordSearchExpression) throws SearchException {
        this.setSearchString(partialWordSearchExpression.getSearchString() + "%2a", partialWordSearchExpression.getBooleanOperator());
    }

    @Override
    public void visit(WildcardSearchExpression wildcardSearchExpression) throws SearchException {
        String string = wildcardSearchExpression.getSearchString();
        int n = string.indexOf(42);
        if (n > -1) {
            string = string.substring(0, n) + "%2a";
        }
        this.setSearchString(string, wildcardSearchExpression.getBooleanOperator());
    }

    @Override
    public void visit(ExactPhraseSearchExpression exactPhraseSearchExpression) throws SearchException {
        String string = exactPhraseSearchExpression.getSearchString().replaceAll("\\s+", "-");
        this.setSearchString(string, exactPhraseSearchExpression.getBooleanOperator());
    }

    @Override
    public void visit(CompoundSearchExpression compoundSearchExpression) throws SearchException {
        StringBuilder stringBuilder = new StringBuilder("(");
        Iterator<SearchExpression> iterator = compoundSearchExpression.getExpressions().iterator();
        while (iterator.hasNext()) {
            SearchExpression searchExpression = iterator.next();
            searchExpression.accept(this);
            stringBuilder.append(this.getSearchString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        this.setSearchString(stringBuilder.toString(), compoundSearchExpression.getBooleanOperator());
    }

    public String getSearchString() {
        return this.fSearchString;
    }

    private void setSearchString(String string, BooleanSearchOperator booleanSearchOperator) {
        this.fSearchString = booleanSearchOperator.equals((Object)BooleanSearchOperator.MUST_NOT_OCCUR) ? "-" + string : string;
    }
}

