/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.search.DocPageType;
import com.mathworks.mlwidgets.help.search.DocSearchField;
import com.mathworks.mlwidgets.help.search.lucene.AnalyzerSource;
import com.mathworks.mlwidgets.help.search.lucene.DocumentHandler;
import com.mathworks.mlwidgets.help.search.lucene.DocumentHandlerException;
import com.mathworks.mlwidgets.help.search.lucene.DocumentInfo;
import com.mathworks.mlwidgets.help.search.lucene.LuceneIndexServices;
import com.mathworks.mlwidgets.help.search.lucene.NekoHtmlSaxDocumentHandler;
import com.mathworks.mlwidgets.html.LanguageLocale;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class LuceneDocIndexer {
    private static final String DOCROOT_ARG = "docroot";
    private static final String INDEXROOT_ARG = "indexroot";
    private static final String INDEX_DIR_ARG = "indexdir";
    private static final String EXCLUSIONS_ARG = "exclusions";
    private static final String EXCLUSIONS_COMMENT = "#";
    private static final String EXCLUSIONS_FILE = "help_search_exclusions.txt";
    private static final String HELP_FILE = "help.jar";
    private static final String HELPLOC_ARG = "helploc";
    private static final String JAPANESE_ARG = "japanese";
    private static final String LANG_ARG = "lang";
    private static final String MULTI_SECTIONS_ARG = "multisections";
    private static final String JAR_ARG = "jar";
    private static DocumentHandler sHandler;
    private static boolean sMultiSections;
    private AnalyzerSource fAnalyzerSource;
    private File fDocRoot;
    private File fIndexRoot;
    private boolean fJar;
    private String fIndexDirName;
    private String fExclusionsFileName;
    private static Map<String, RAMDirectory> sTestIndexes;

    public static synchronized void main(String[] stringArray) {
        try {
            boolean bl;
            String string = LuceneDocIndexer.getArgument(stringArray, DOCROOT_ARG);
            String string2 = LuceneDocIndexer.getArgument(stringArray, INDEXROOT_ARG);
            String string3 = LuceneDocIndexer.getArgument(stringArray, HELPLOC_ARG);
            String string4 = LuceneDocIndexer.getArgument(stringArray, JAR_ARG);
            String string5 = LuceneDocIndexer.getArgument(stringArray, INDEX_DIR_ARG);
            String string6 = LuceneDocIndexer.getArgument(stringArray, EXCLUSIONS_ARG);
            String string7 = LuceneDocIndexer.getArgument(stringArray, JAPANESE_ARG);
            String string8 = LuceneDocIndexer.getArgument(stringArray, LANG_ARG);
            String string9 = LuceneDocIndexer.getArgument(stringArray, MULTI_SECTIONS_ARG);
            if (string7 != null && string7.toLowerCase().startsWith("t")) {
                System.out.println("WARNING: \"-japanese=true\" is deprecated for LuceneDocIndexer. Use \"-lang=ja\" instead.");
                if (string8 == null) {
                    string8 = LanguageLocale.JAPANESE.getLanguage();
                } else if (!string8.equalsIgnoreCase(LanguageLocale.JAPANESE.getLanguage()) && !string8.equalsIgnoreCase(LanguageLocale.JAPANESE.getLocaleString())) {
                    System.out.println("WARNING: \"-lang=" + string8 + "\" overriding \"-japanese=true\". Will use " + string8 + " indexer.");
                }
            }
            sMultiSections = string9 != null && string9.toLowerCase().startsWith("t");
            boolean bl2 = bl = string4 != null && string4.toLowerCase().startsWith("t");
            if (string == null) {
                System.out.println("You must specify the docroot.");
            }
            System.out.println("Indexing doc using " + (string8 == null ? LanguageLocale.ENGLISH.getLanguage() : string8) + " indexer.");
            long l = System.currentTimeMillis();
            LuceneDocIndexer.indexDoc(string, string3, string2, bl, string5, string6, string8);
            long l2 = System.currentTimeMillis();
            System.out.println("Completed indexing in " + (l2 - l) + " milliseconds");
        }
        catch (Exception exception) {
            System.out.println("An error occurred during indexing.");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private LuceneDocIndexer(String string, String string2, boolean bl, String string3, String string4, String string5) {
        if (string != null) {
            string = LuceneDocIndexer.fixSeparators(string, true);
            this.fDocRoot = new File(string);
        }
        if ((string2 = string2 == null ? string : LuceneDocIndexer.fixSeparators(string2, true)) != null) {
            this.fIndexRoot = new File(string2);
        }
        this.fJar = bl;
        this.fIndexDirName = string3 == null ? "helpsearch" : string3;
        this.fExclusionsFileName = string4 == null ? EXCLUSIONS_FILE : string4;
        LanguageLocale languageLocale = string5 == null ? LanguageLocale.ENGLISH : LanguageLocale.getSupportedLanguageLocale(string5);
        this.fAnalyzerSource = new AnalyzerSource(languageLocale);
    }

    private static void initializeForTesting() {
        sTestIndexes = new HashMap<String, RAMDirectory>();
    }

    private static void cleanupForTesting() {
        if (sTestIndexes != null) {
            System.out.println("Cleaning up " + sTestIndexes.size() + " search indexes.");
            for (RAMDirectory rAMDirectory : sTestIndexes.values()) {
                rAMDirectory.close();
            }
            sTestIndexes.clear();
            sTestIndexes = null;
        } else {
            System.out.println("Warning: test index map is unexpectedly null.");
        }
    }

    private static RAMDirectory getTestIndexDir(String string) {
        if (sTestIndexes != null) {
            RAMDirectory rAMDirectory = sTestIndexes.get(string);
            if (rAMDirectory != null) {
                return sTestIndexes.get(string);
            }
            if (!sTestIndexes.isEmpty()) {
                System.out.println("Could not find index directory for " + string);
                System.out.println("Index directories exist for:");
                for (String string2 : sTestIndexes.keySet()) {
                    System.out.println("\t" + string2);
                }
            } else {
                System.out.println("No test indexes have been created.");
            }
        } else {
            System.out.println("Test index map is null.");
        }
        return null;
    }

    private static String getArgument(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            String string3;
            String string4 = string2.toLowerCase();
            if (!string4.startsWith(string3 = string.toLowerCase()) && !string4.startsWith("-" + string3)) continue;
            return string2.substring(string2.indexOf(61) + 1);
        }
        return null;
    }

    private static String fixSeparators(String string, boolean bl) {
        String string2 = File.separator;
        if (string2.equals("\\")) {
            string2 = "\\\\";
        }
        string = string.replaceAll("[\\\\/]", string2);
        if (bl && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    private void index(String string) throws Exception {
        File file;
        File file2 = this.fDocRoot == null ? new File(string) : new File(this.fDocRoot, string);
        File file3 = file = this.fIndexRoot == null ? new File(string) : new File(this.fIndexRoot, string);
        if (this.fJar) {
            File file4 = new File(file2, HELP_FILE);
            if (file4.exists()) {
                this.indexSingleJar(file4, file);
            } else {
                this.indexJars(file2, file);
            }
        } else {
            this.indexProduct(file2, file);
        }
    }

    static void indexDoc(String string, String string2) throws Exception {
        File file = new File(string, HELP_FILE);
        LuceneDocIndexer.indexDoc(null, string, null, file.exists(), "helpsearch", EXCLUSIONS_FILE, string2);
    }

    static void indexDoc(String string, String string2, String string3, boolean bl, String string4, String string5, String string6) throws Exception {
        LuceneDocIndexer luceneDocIndexer = new LuceneDocIndexer(string, string3, bl, string4, string5, string6);
        if (string2 == null) {
            string2 = "";
        }
        string2 = LuceneDocIndexer.fixSeparators(string2, true);
        luceneDocIndexer.index(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexSingleJar(File file, File file2) throws Exception {
        IndexWriter indexWriter = null;
        try {
            Object object;
            File file3 = new File(file2, this.fIndexDirName);
            if (sTestIndexes == null) {
                indexWriter = this.getIndexWriter((Directory)FSDirectory.getDirectory((File)file3, (boolean)true));
            } else {
                object = new RAMDirectory();
                indexWriter = this.getIndexWriter((Directory)object);
                sTestIndexes.put(file2.getCanonicalPath(), (RAMDirectory)object);
            }
            object = new ZipFile(file);
            File file4 = file.getParentFile();
            IndexerFileFilter indexerFileFilter = this.getFilterForDir(file4);
            if (indexerFileFilter == null) {
                indexerFileFilter = this.getFilterForJar(file4, (ZipFile)object);
            }
            this.indexJarFile((ZipFile)object, file4, indexWriter, indexerFileFilter);
            indexWriter.optimize();
        }
        finally {
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void indexJars(File file, File file2) throws Exception {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file3 : fileArray) {
            if (file3.isDirectory()) {
                this.indexJars(file3, new File(file2, file3.getName()));
                continue;
            }
            if (!file3.getName().equals(HELP_FILE)) continue;
            try {
                this.indexSingleJar(file3, file2);
            }
            catch (IOException iOException) {
                System.out.println("Could not index documentation at " + file3.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexerFileFilter getFilterForDir(File file) {
        File file2 = new File(file, this.fExclusionsFileName);
        if (file2.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                IndexerFileFilter indexerFileFilter = this.getFilter(file, fileInputStream);
                return indexerFileFilter;
            }
            catch (IOException iOException) {
                IndexerFileFilter indexerFileFilter = null;
                return indexerFileFilter;
            }
            finally {
                block13: {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception) {
                            if ($assertionsDisabled) break block13;
                            throw new AssertionError((Object)"Failed to close an input stream");
                        }
                    }
                }
            }
        }
        return null;
    }

    private IndexerFileFilter getFilterForJar(File file, ZipFile zipFile) {
        ZipEntry zipEntry = zipFile.getEntry(this.fExclusionsFileName);
        if (zipEntry != null) {
            try {
                return this.getFilter(file, zipFile.getInputStream(zipEntry));
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexerFileFilter getFilter(File file, InputStream inputStream) {
        BufferedReader bufferedReader = null;
        try {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String[] stringArray = bufferedReader.readLine();
            while (stringArray != null) {
                object = stringArray.trim();
                if (((String)object).length() > 0 && !((String)object).startsWith(EXCLUSIONS_COMMENT)) {
                    arrayList.add(LuceneDocIndexer.fixSeparators((String)object, false));
                }
                stringArray = bufferedReader.readLine();
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            object = new IndexerFileFilter(file, stringArray);
            return object;
        }
        catch (IOException iOException) {
            IndexerFileFilter indexerFileFilter = new IndexerFileFilter(file);
            return indexerFileFilter;
        }
        finally {
            block14: {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled) break block14;
                        throw new AssertionError((Object)"Failed to close a reader");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexProduct(File file, File file2) throws Exception {
        File file3 = new File(file2, "helpsearch");
        IndexWriter indexWriter = null;
        try {
            Object object;
            if (sTestIndexes == null) {
                indexWriter = this.getIndexWriter((Directory)FSDirectory.getDirectory((File)file3, (boolean)true));
            } else {
                object = new RAMDirectory();
                indexWriter = this.getIndexWriter((Directory)object);
                sTestIndexes.put(file2.getCanonicalPath(), (RAMDirectory)object);
            }
            object = this.getFilterForDir(file);
            this.indexDirectory(file, "", indexWriter, (IndexerFileFilter)object);
        }
        finally {
            if (indexWriter != null) {
                try {
                    indexWriter.optimize();
                    indexWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private IndexWriter getIndexWriter(Directory directory) throws IOException {
        IndexWriter indexWriter = new IndexWriter(directory, this.fAnalyzerSource.getIndexAnalyzer(), true);
        indexWriter.setUseCompoundFile(true);
        indexWriter.setMaxFieldLength(Integer.MAX_VALUE);
        return indexWriter;
    }

    private void indexDirectory(File file, String string, IndexWriter indexWriter, IndexerFileFilter indexerFileFilter) throws IOException, DocumentHandlerException {
        if (indexerFileFilter == null) {
            indexerFileFilter = new IndexerFileFilter(file);
        }
        String string2 = LuceneDocIndexer.getProductShortName(file);
        File file2 = new File(file, string);
        File[] fileArray = file2.listFiles(indexerFileFilter);
        if (fileArray == null) {
            return;
        }
        for (File file3 : fileArray) {
            if (file3.isDirectory()) {
                String string3 = string;
                string3 = string3.length() == 0 ? file3.getName() + File.separator : (!string3.endsWith(File.separator) ? string3 + File.separator + file3.getName() + File.separator : string3 + file3.getName() + File.separator);
                this.indexDirectory(file, string3, indexWriter, indexerFileFilter);
                continue;
            }
            if (!file3.getName().endsWith(".html")) continue;
            LuceneDocIndexer.indexFile(file3, string2, string, indexWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void indexFile(File file, String string, String string2, IndexWriter indexWriter) throws IOException, DocumentHandlerException {
        if (file.isHidden() || !file.exists() || !file.canRead()) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            LuceneDocIndexer.addToIndex(fileInputStream, string, string2 + file.getName(), indexWriter);
        }
        finally {
            block10: {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled) break block10;
                        throw new AssertionError((Object)"Failed to close a file input stream");
                    }
                }
            }
        }
    }

    private void indexJarFile(ZipFile zipFile, File file, IndexWriter indexWriter, IndexerFileFilter indexerFileFilter) throws DocumentHandlerException, IOException {
        if (indexerFileFilter == null) {
            indexerFileFilter = new IndexerFileFilter(file);
        }
        String string = LuceneDocIndexer.getProductShortName(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".html") || !indexerFileFilter.acceptInJar(zipEntry.getName())) continue;
            LuceneDocIndexer.addToIndex(zipFile.getInputStream(zipEntry), string, zipEntry.getName(), indexWriter);
        }
    }

    private static void addToIndex(InputStream inputStream, String string, String string2, IndexWriter indexWriter) throws DocumentHandlerException, IOException {
        List<DocumentInfo> list = LuceneDocIndexer.getHandler().getDocumentInfo(inputStream);
        if (list != null) {
            for (DocumentInfo documentInfo : list) {
                Object object;
                int n;
                Field field;
                if (!documentInfo.shouldBeIndexed()) continue;
                Document document = new Document();
                Field field2 = LuceneIndexServices.createField(DocSearchField.TITLE, documentInfo.getTitle().trim());
                field2.setBoost(1.5f);
                Field field3 = LuceneIndexServices.createField(DocSearchField.SECTION, documentInfo.getSection().trim());
                Field field4 = LuceneIndexServices.createField(DocSearchField.BODY, documentInfo.getBody());
                DocPageType docPageType = DocPageType.NOT_REFERENCE_PAGE;
                if (documentInfo.isReferencePage()) {
                    field = documentInfo.getRefPageEntities();
                    docPageType = field == null || field.isEmpty() ? DocPageType.REFERENCE_PAGE_TYPE_UNKNOWN : DocPageType.REFERENCE_PAGE_TYPE_KNOWN;
                }
                field = LuceneIndexServices.createField(DocSearchField.REFERENCE_PAGE, docPageType.getIndexString());
                String string3 = documentInfo.isStudent() ? "1" : "0";
                Field field5 = LuceneIndexServices.createField(DocSearchField.STUDENT_PAGE, string3);
                Field field6 = LuceneIndexServices.createField(DocSearchField.SUBSECTION, documentInfo.getSectionHeadings());
                field6.setBoost(0.5f);
                document.add(field3);
                document.add(field2);
                document.add(field4);
                document.add(field);
                document.add(field5);
                document.add(field6);
                string2 = LuceneDocIndexer.useForwardSlashes(string2);
                document.add(LuceneIndexServices.createField(DocSearchField.RELATIVE_PATH, string2));
                String string4 = documentInfo.getAnchor();
                if (string4 != null) {
                    document.add(LuceneIndexServices.createField(DocSearchField.ANCHOR, string4));
                }
                String string5 = (n = string2.lastIndexOf(47)) > -1 ? string2.substring(n + 1) : string2;
                document.add(LuceneIndexServices.createField(DocSearchField.FILENAME, string5));
                document.add(LuceneIndexServices.createField(DocSearchField.PRODUCT_SHORTNAME, string));
                if (documentInfo.isReferencePage()) {
                    Object object2;
                    Object object3;
                    if (string.equalsIgnoreCase("matlab")) {
                        document.setBoost(4.0f);
                    } else if (string.equalsIgnoreCase("simulink")) {
                        document.setBoost(3.0f);
                    } else {
                        document.setBoost(2.0f);
                    }
                    object = documentInfo.getRefPageSummary();
                    if (object != null) {
                        object3 = LuceneIndexServices.createField(DocSearchField.REFPAGE_SUMMARY, (String)object);
                        document.add((Field)object3);
                    }
                    if (docPageType == DocPageType.REFERENCE_PAGE_TYPE_KNOWN) {
                        object3 = documentInfo.getRefPageEntities().iterator();
                        while (object3.hasNext()) {
                            object2 = (String)object3.next();
                            Field field7 = LuceneIndexServices.createField(DocSearchField.REFPAGE_ENTITY, (String)object2);
                            document.add(field7);
                        }
                    }
                    if ((object3 = documentInfo.getFunctionName(string5)) != null) {
                        object2 = LuceneIndexServices.createField(DocSearchField.REFPAGE_FUNCTION_NAME, (String)object3);
                        document.add(object2);
                    }
                }
                if (documentInfo.getResultType() != null) {
                    object = LuceneIndexServices.createField(DocSearchField.RESULT_TYPE, documentInfo.getResultType().getKey());
                    document.add(object);
                }
                if (documentInfo.getCharset() != null) {
                    object = LuceneIndexServices.createField(DocSearchField.CHARSET, documentInfo.getCharset());
                    document.add(object);
                }
                indexWriter.addDocument(document);
            }
        }
    }

    private static synchronized DocumentHandler getHandler() {
        if (sHandler == null) {
            sHandler = new NekoHtmlSaxDocumentHandler(sMultiSections);
        }
        return sHandler;
    }

    private static String getProductShortName(File file) {
        String string = file.getName();
        if (string.equalsIgnoreCase("techdoc")) {
            string = "matlab";
        }
        return string;
    }

    private static String useForwardSlashes(String string) {
        return string.replaceAll("\\\\", "/");
    }

    static {
        sMultiSections = false;
    }

    private class IndexerFileFilter
    implements FileFilter {
        private String[] iGlobalPatterns = new String[]{"tocframe.html", "ixframe.html"};
        private String[] fLocalPatterns;
        private String fHelpLocPath;

        private IndexerFileFilter(File file) {
            this(file, (String[])null);
        }

        private IndexerFileFilter(File file, String[] stringArray) {
            try {
                this.fHelpLocPath = file.getCanonicalPath();
                this.fLocalPatterns = stringArray;
            }
            catch (IOException iOException) {
                this.fHelpLocPath = null;
            }
        }

        @Override
        public boolean accept(File file) {
            try {
                return this.accept(file.getCanonicalPath().toLowerCase());
            }
            catch (Exception exception) {
                return false;
            }
        }

        private boolean acceptInJar(String string) {
            if (!string.startsWith(this.fHelpLocPath)) {
                string = this.fHelpLocPath + File.separator + string;
            }
            string = LuceneDocIndexer.fixSeparators(string, false);
            return this.accept(string);
        }

        private boolean accept(String string) {
            if (string.contains(LuceneDocIndexer.this.fIndexDirName)) {
                return false;
            }
            if (string.contains(LuceneDocIndexer.this.fExclusionsFileName)) {
                return false;
            }
            if (this.iGlobalPatterns != null) {
                for (String string2 : this.iGlobalPatterns) {
                    if (!string.contains(string2)) continue;
                    return false;
                }
            }
            if (this.fLocalPatterns != null) {
                for (String string2 : this.fLocalPatterns) {
                    if (!string.contains(string2)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

