/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.search.DocSearchResult;
import com.mathworks.mlwidgets.help.search.lucene.DocIndexSearcher;
import com.mathworks.mlwidgets.help.search.lucene.DocMultiSearcher;
import com.mathworks.mlwidgets.help.search.lucene.LuceneDocSearchResult;
import com.mathworks.mlwidgets.help.search.lucene.LuceneSearchResults;
import com.mathworks.mlwidgets.help.search.lucene.MWHitCollector;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Searcher;

class LuceneDocSearchResults
extends LuceneSearchResults<DocSearchResult> {
    LuceneDocSearchResults(MWHitCollector mWHitCollector, Searcher searcher) {
        super(mWHitCollector, searcher);
    }

    @Override
    protected LuceneDocSearchResult createResult(int n, Document document, float f) {
        LuceneDocSearchResult luceneDocSearchResult = new LuceneDocSearchResult(document);
        DocIndexSearcher docIndexSearcher = this.getIndexSearcherForDoc(n);
        luceneDocSearchResult.setProduct(docIndexSearcher.getProduct());
        luceneDocSearchResult.setUrlPrefix(docIndexSearcher.getUrlPrefix());
        luceneDocSearchResult.setScore(f);
        return luceneDocSearchResult;
    }

    private DocIndexSearcher getIndexSearcherForDoc(int n) {
        Searcher searcher = this.getSearcher();
        if (searcher instanceof DocIndexSearcher) {
            return (DocIndexSearcher)searcher;
        }
        if (searcher instanceof DocMultiSearcher) {
            return ((DocMultiSearcher)searcher).getIndexSearchForDoc(n);
        }
        return null;
    }
}

