/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.html.CharsetDetectionStrategy;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.PlatformInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class HTMLUtils {
    public static final String DEFAULT_FILE_NOT_FOUND_TEMPLATE = HTMLUtils.getLocalizedFilename(Matlab.matlabRoot() + "/toolbox/local/linkerr.html");
    static final String RESDIR = "com.mathworks.mlwidgets.html.resources.";
    public static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.html.resources.RES_HTMLRenderer");
    private static String[] sHighlightColors = new String[]{"FFFF00", "90EE90", "ADD8E6", "FFA500", "FFC0CB"};
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("\\*");
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern INNER_TAG_PATTERN = Pattern.compile("(<[^>]+>)+");
    private static final Pattern BODY_TAG_PATTERN = Pattern.compile("<body.*</body>", 34);
    private static final Pattern URL_PATTERN = Pattern.compile("\\A[a-z:]{2,}://.*");
    private static final Pattern UNC_URL_PATTERN = Pattern.compile("file:/*(//\\w[^:].*)$");
    private static final Pattern QUERYSTRING_ENCODE_PATTERN = Pattern.compile("[^&=]+");
    private static final Pattern NON_ASCII_PATTERN = Pattern.compile("[^\\x00-\\x7f]+");
    private static final char TO_UPPER = ' ';
    private static final String MATLAB_URL_PREFIX = "matlab:";
    private static final Pattern MATLAB_FORM_DATA_PATTERN = Pattern.compile("^([\\w.]+)\\?");
    private static final Pattern JARFILE_PATTERN = Pattern.compile("^jar:file:(.+?)/([^\\/]+\\.jar)!/(.*)$");

    private HTMLUtils() {
    }

    public static String getFilenameFromURL(String string) {
        int n;
        if (HTMLUtils.needsDecoding(string)) {
            string = HTMLUtils.decodeUrl(string);
        }
        if ((n = HTMLUtils.getTagIndex(string = HTMLUtils.getCanonicalUrl(string))) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String getURLStringFromFile(File file) {
        String string;
        boolean bl = file.getAbsolutePath().startsWith("\\\\");
        try {
            string = file.toURI().toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        if (bl) {
            assert (Pattern.matches("file:\\/\\/\\/\\/[^\\/].*", string));
            string = "file:/" + string.substring(5);
            assert (Pattern.matches("file:\\/\\/\\/\\/\\/[^\\/].*", string));
        }
        return string;
    }

    public static String getAnchorFromURL(String string) {
        int n = HTMLUtils.getTagIndex(string);
        return n > -1 ? string.substring(n + 1) : null;
    }

    public static String getCanonicalFilepath(String string) {
        string = HTMLUtils.removeQueryString(string);
        String string2 = "";
        File file = new File(string);
        try {
            string2 = file.getCanonicalPath().replace('\\', '/');
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    static String removeQueryString(String string) {
        int n = string.lastIndexOf(63);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String createHyperlink(String string, String string2) {
        return "<a href=\"" + string + "\">" + string2 + "</a>";
    }

    static String getUrlStringFromLocation(String string) {
        return HTMLUtils.getUrlStringFromLocation(null, string);
    }

    public static String correctSlashes(String string) {
        if (string.contains(":")) {
            String string2 = string.substring(0, string.indexOf(58));
            if (string2.length() < 2 || string2.equals("matlab") || string2.equals("text")) {
                return string;
            }
            return string.replace('\\', '/');
        }
        return string.replace('\\', '/');
    }

    public static String getUrlStringFromLocation(String string, String string2) {
        String string3 = string2;
        URL uRL = HTMLUtils.getUrlFromLocation(string, HTMLUtils.getFilenameFromURL(string2));
        if (uRL != null) {
            string2 = uRL.toString();
            int n = HTMLUtils.getTagIndex(string3);
            if (n != -1) {
                string2 = string2 + string3.substring(n);
            }
        }
        if (HTMLUtils.needsEncoding(string2 = HTMLUtils.correctSlashes(string2))) {
            string2 = HTMLUtils.encodeUrl(string2);
        }
        return string2;
    }

    static URL getUrlFromLocation(String string, String string2) {
        URL uRL = null;
        if (string2 == null || string2.length() == 0) {
            return uRL;
        }
        File file = new File(string2);
        try {
            if (file.exists()) {
                if (PlatformInfo.isWindows() && !string2.startsWith("file://" + string) && string2.length() > 1 && (string2.charAt(1) == ':' || string == null && string2.startsWith("//") && !string2.startsWith("///"))) {
                    string2 = "///" + string2;
                }
                if (HTMLUtils.needsEncoding(string2)) {
                    string2 = HTMLUtils.encodeUrl(string2);
                }
                string2 = string2.replaceAll("#", "%23");
                uRL = new URL("file", string, string2);
            } else {
                uRL = new URL(string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public static String getCanonicalUrl(String string) {
        if (string != null) {
            if ((string = string.replace('\\', '/')).startsWith("file:/")) {
                String string2;
                Object object;
                if (PlatformInfo.isWindows() && ((Matcher)(object = UNC_URL_PATTERN.matcher(string))).find() && com.mathworks.util.FileUtils.fileExists((String)(string2 = ((Matcher)object).group(1)))) {
                    return string2;
                }
                try {
                    object = new URL(string);
                    string = HTMLUtils.getCanonicalFilepath(((URL)object).getFile());
                    if (PlatformInfo.isWindows() && string.length() > 2 && string.charAt(0) == '/' && string.charAt(2) == ':') {
                        string = string.substring(1);
                    }
                    if (((URL)object).getQuery() != null) {
                        string = string + "?" + ((URL)object).getQuery();
                    }
                    if (((URL)object).getRef() != null) {
                        string = string + "#" + ((URL)object).getRef();
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (string.startsWith("file:")) {
                string = string.substring(5);
            }
        } else {
            string = "";
        }
        return string;
    }

    private static int getTagIndex(String string) {
        int n = string.indexOf("html#");
        if (n != -1) {
            n += 4;
        } else {
            n = string.indexOf("htm#");
            if (n != -1) {
                n += 3;
            }
        }
        return n;
    }

    public static boolean isValidUrl(String string) {
        return URL_PATTERN.matcher(string).lookingAt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesFileExist(String string) {
        String string2 = HTMLUtils.getFilenameFromURL(string);
        if (string2.startsWith("jar:")) {
            JarInfo jarInfo = new JarInfo(string2);
            try {
                boolean bl = jarInfo.exists();
                return bl;
            }
            finally {
                jarInfo.close();
            }
        }
        string2 = string2.replaceFirst("^file://", "");
        File file = new File(string2);
        return file.exists();
    }

    public static String getSource(String string) {
        return HTMLUtils.getSource(string, CharsetDetectionStrategy.getDefaultCharsetStrategy());
    }

    public static String getSource(String string, Charset charset) {
        CharsetDetectionStrategy charsetDetectionStrategy = CharsetDetectionStrategy.getCharsetStrategy(charset);
        return HTMLUtils.getSource(string, charsetDetectionStrategy);
    }

    public static String getSource(String string, String string2) throws UnsupportedEncodingException {
        CharsetDetectionStrategy charsetDetectionStrategy = CharsetDetectionStrategy.getCharsetStrategy(string2);
        return HTMLUtils.getSource(string, charsetDetectionStrategy);
    }

    public static String getSource(String string, CharsetDetectionStrategy charsetDetectionStrategy) {
        Charset charset = charsetDetectionStrategy.getCharset(string);
        InputStream inputStream = HTMLUtils.getInputStreamForUrl(string);
        if (inputStream != null) {
            return HTMLUtils.readInputStream(inputStream, charset);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInputStream(InputStream inputStream, Charset charset) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuilder.append(string).append('\n');
                string = bufferedReader.readLine();
            }
            string = stringBuilder.toString();
            return string;
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
        finally {
            try {
                bufferedReader.close();
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    static InputStream getInputStreamForUrl(String string) {
        String string2 = HTMLUtils.getFilenameFromURL(string);
        if (!HTMLUtils.isValidUrl(string2) && com.mathworks.util.FileUtils.fileExists((String)string2)) {
            try {
                return new FileInputStream(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (string2.startsWith("jar:")) {
            JarInfo jarInfo = new JarInfo(string2);
            return jarInfo.getSourceInputSream();
        }
        if (string2.startsWith("file:")) {
            try {
                return new FileInputStream(HTMLUtils.getFilenameFromURL(string2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        try {
            URL uRL = new URL(string2);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            return uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String highlightHtml(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = stringArray.length;
        if (n > 5) {
            n = 5;
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("<style type=\"text/css\"><!--.highlight");
            stringBuilder.append(i).append("{background:#");
            stringBuilder.append(HTMLUtils.getHighlightColor(i));
            stringBuilder.append("; color:black}--></style>\n");
        }
        Matcher matcher = BODY_TAG_PATTERN.matcher(string);
        if (matcher.find()) {
            stringBuilder.append(string.substring(0, matcher.start()));
            String string2 = matcher.group();
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = HTMLUtils.highlightKeyword(string2, stringArray[i], i);
            }
            stringBuilder.append(string2);
            stringBuilder.append(string.substring(matcher.end()));
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                string = HTMLUtils.highlightKeyword(string, stringArray[i], i);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String highlightKeyword(String string, String string2, int n) {
        int n2 = n <= 4 ? n : 4;
        String string3 = "<font class=\"highlight" + n2 + "\">";
        boolean bl = HTMLUtils.useNoWordBreakHighlightRegexp(string2);
        Pattern pattern = HTMLUtils.buildKeywordPattern(string2, bl);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            Matcher matcher2 = INNER_TAG_PATTERN.matcher(matcher.group(2));
            String string4 = matcher2.replaceAll("</font>$0" + string3);
            string4 = string4.replaceAll("([\\$\\\\])", "\\\\$0");
            if (bl) {
                matcher.appendReplacement(stringBuffer, "$1" + string3 + string4 + "</font>");
                continue;
            }
            matcher.appendReplacement(stringBuffer, "$1" + string3 + string4 + "</font>$3");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static Pattern buildKeywordPattern(String string, boolean bl) {
        Matcher matcher = WILDCARD_PATTERN.matcher(string);
        string = matcher.replaceAll("\\\\w*");
        boolean bl2 = false;
        Matcher matcher2 = SPACE_PATTERN.matcher(string);
        if (matcher2.find()) {
            bl2 = true;
            string = matcher2.replaceAll("(?:<[^>]+>|[\\\\W_]|&(?:\\\\w+|#(?:\\\\d{3,4}|x[a-fA-F\\\\d]{2}));)+");
        }
        StringBuilder stringBuilder = new StringBuilder("\\G((?><[^>]*>|");
        if (!bl2) {
            stringBuilder.append("&").append(string).append(";|");
        }
        stringBuilder.append(".)*?");
        if (!bl) {
            stringBuilder.append("(?:\\b|_)");
        }
        stringBuilder.append(")");
        stringBuilder.append("(").append(string).append(")");
        if (!bl) {
            stringBuilder.append("(\\b|_)");
        }
        return Pattern.compile(stringBuilder.toString(), 34);
    }

    private static boolean useNoWordBreakHighlightRegexp(String string) {
        if (HTMLUtils.isLocaleNoWordBreak()) {
            char[] cArray;
            for (char c : cArray = string.toCharArray()) {
                if (c <= '\u00ff') continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLocaleNoWordBreak() {
        return LanguageUtils.getHelpLanguage().equals(Locale.JAPANESE.getLanguage()) || LanguageUtils.getHelpLocale().equals(Locale.SIMPLIFIED_CHINESE);
    }

    static String getHighlightColor(int n) {
        return sHighlightColors[n];
    }

    public static String encodeUrl(String string) {
        try {
            return HTMLUtils.encodeUrl(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false) : "We should be able to encode URLs using UTF-8";
            return string;
        }
    }

    public static String encodeUrl(String string, String string2) throws UnsupportedEncodingException {
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            int n = string.indexOf(63);
            if (n > -1) {
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1);
                return HTMLUtils.encodeBaseUrl(string3, string2) + '?' + HTMLUtils.encodeQueryString(string4, string2);
            }
            return HTMLUtils.encodeBaseUrl(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (RuntimeException runtimeException) {
            throw new UnsupportedEncodingException();
        }
    }

    public static String decodeUrl(String string) {
        try {
            return HTMLUtils.decodeUrl(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false) : "We should be able to decode URLs using UTF-8";
            return string;
        }
    }

    public static String decodeUrl(String string, String string2) throws UnsupportedEncodingException {
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            int n = string.indexOf(63);
            if (n > -1) {
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1);
                return HTMLUtils.decodeBaseUrl(string3, string2) + '?' + HTMLUtils.decodeQueryString(string4, string2);
            }
            return HTMLUtils.decodeBaseUrl(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (RuntimeException runtimeException) {
            throw new UnsupportedEncodingException();
        }
    }

    private static String encodeBaseUrl(String string, String string2) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            byte[] byArray;
            char c = string.charAt(i);
            if (c < '\u0080' && c != ' ' && c != '%') {
                stringBuilder.append(c);
                continue;
            }
            for (byte by : byArray = String.valueOf(c).getBytes(string2)) {
                char c2;
                stringBuilder.append('%');
                char c3 = Character.forDigit(by >> 4 & 0xF, 16);
                if (Character.isLetter(c3)) {
                    c3 = (char)(c3 - 32);
                }
                if (Character.isLetter(c2 = Character.forDigit(by & 0xF, 16))) {
                    c2 = (char)(c2 - 32);
                }
                stringBuilder.append(c3).append(c2);
            }
        }
        return stringBuilder.toString();
    }

    private static String decodeBaseUrl(String string, String string2) throws UnsupportedEncodingException {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '%') {
                byte[] byArray = new byte[(n - n2) / 3];
                int n3 = 0;
                do {
                    byArray[n3++] = (byte)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                    if ((n2 += 3) >= n) continue;
                    c = string.charAt(n2);
                } while (c == '%' && n2 + 2 < string.length());
                stringBuilder.append(new String(byArray, 0, n3, string2));
                continue;
            }
            stringBuilder.append(c);
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static String encodeQueryString(String string, String string2) {
        try {
            Matcher matcher = QUERYSTRING_ENCODE_PATTERN.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, URLEncoder.encode(matcher.group(), string2));
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private static String decodeQueryString(String string, String string2) {
        try {
            Matcher matcher = QUERYSTRING_ENCODE_PATTERN.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, URLDecoder.decode(matcher.group(), string2));
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static boolean needsEncoding(String string) {
        return HTMLUtils.checkUrlForEncoding(string) == EncodingStatus.NEEDS_ENCODING;
    }

    public static boolean needsDecoding(String string) {
        return HTMLUtils.checkUrlForEncoding(string) == EncodingStatus.NEEDS_DECODING;
    }

    private static EncodingStatus checkUrlForEncoding(String string) {
        if (string == null || string.length() == 0) {
            return EncodingStatus.OK;
        }
        int n = string.indexOf(63);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            EncodingStatus encodingStatus = HTMLUtils.checkUrlPartForEncoding(string2, false);
            if (encodingStatus == EncodingStatus.NEEDS_ENCODING) {
                return encodingStatus;
            }
            EncodingStatus encodingStatus2 = HTMLUtils.checkQueryStringForEncoding(string3);
            if (encodingStatus2 == EncodingStatus.NEEDS_ENCODING) {
                return encodingStatus2;
            }
            if (encodingStatus == EncodingStatus.NEEDS_DECODING || encodingStatus2 == EncodingStatus.NEEDS_DECODING) {
                return EncodingStatus.NEEDS_DECODING;
            }
            return EncodingStatus.OK;
        }
        return HTMLUtils.checkUrlPartForEncoding(string, false);
    }

    private static EncodingStatus checkUrlPartForEncoding(String string, boolean bl) {
        EncodingStatus encodingStatus = EncodingStatus.OK;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (HTMLUtils.isEscapedCharacter(string, i)) {
                    encodingStatus = EncodingStatus.NEEDS_DECODING;
                    i += 2;
                    continue;
                }
                return EncodingStatus.NEEDS_ENCODING;
            }
            if (bl && c == '+') {
                encodingStatus = EncodingStatus.NEEDS_DECODING;
                continue;
            }
            if (c < '\u0080' && c != ' ') continue;
            return EncodingStatus.NEEDS_ENCODING;
        }
        return encodingStatus;
    }

    private static EncodingStatus checkQueryStringForEncoding(String string) {
        EncodingStatus encodingStatus = EncodingStatus.OK;
        Matcher matcher = QUERYSTRING_ENCODE_PATTERN.matcher(string);
        while (matcher.find()) {
            switch (HTMLUtils.checkUrlPartForEncoding(matcher.group(), true)) {
                case NEEDS_ENCODING: {
                    return EncodingStatus.NEEDS_ENCODING;
                }
                case NEEDS_DECODING: {
                    encodingStatus = EncodingStatus.NEEDS_DECODING;
                    break;
                }
            }
        }
        return encodingStatus;
    }

    private static boolean isEscapedCharacter(String string, int n) {
        if (string.length() < n + 3) {
            return false;
        }
        String string2 = string.substring(n + 1, n + 3);
        return string2.matches("[0-9A-Fa-f]{2}");
    }

    public static boolean compareFiles(String string, String string2) {
        URI uRI = HTMLUtils.getUri(string);
        URI uRI2 = HTMLUtils.getUri(string2);
        return uRI != null && uRI2 != null && uRI.equals(uRI2);
    }

    private static URI getUri(String string) {
        if (com.mathworks.util.FileUtils.fileExists((String)(string = HTMLUtils.getCanonicalUrl(string)))) {
            return new File(string).toURI();
        }
        if (HTMLUtils.isValidUrl(string) && string.startsWith("file")) {
            try {
                String string2 = HTMLUtils.getCanonicalUrl(string);
                return new URL(string2).toURI();
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static boolean isTargetOnPage(String string, String string2) {
        if (string == null) {
            return false;
        }
        int n = string2.indexOf(35);
        if (n <= -1) {
            return false;
        }
        string2 = string2.substring(0, n);
        int n2 = string.indexOf(35);
        if (n2 > -1) {
            string = string.substring(0, n2);
        }
        return HTMLUtils.compareFiles(string, string2);
    }

    public static String encodeNonAscii(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = NON_ASCII_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, HTMLUtils.toHtmlEntities(matcher.group()));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static String toHtmlEntities(String string) {
        char[] cArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : cArray = string.toCharArray()) {
            stringBuilder.append("&#x");
            stringBuilder.append(Integer.toHexString(c));
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    static String buildMatlabEvalString(String string, int n) {
        int n2;
        string = HTMLUtils.cleanUpMatlabUrl(string);
        if (n > -1) {
            string = string.replaceAll("\\$browser", "webutils.Browser(" + String.valueOf(n) + ")");
        }
        if ((n2 = HTMLUtils.getMatlabUrlFormDataStart(string)) > -1) {
            String string2 = string.substring(n2);
            string = string.substring(0, n2);
            return HTMLUtils.buildMatlabFormEvalString(string, string2);
        }
        return string;
    }

    private static int getMatlabUrlFormDataStart(String string) {
        Matcher matcher = MATLAB_FORM_DATA_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.end(1);
        }
        return -1;
    }

    private static String cleanUpMatlabUrl(String string) {
        if (HTMLUtils.needsDecoding(string)) {
            string = HTMLUtils.decodeUrl(string);
        }
        if (string.startsWith(MATLAB_URL_PREFIX)) {
            string = string.substring(MATLAB_URL_PREFIX.length());
        }
        return string;
    }

    private static String buildMatlabFormEvalString(String string, String string2) {
        if (SPACE_PATTERN.matcher(string).find()) {
            return string + " " + string2;
        }
        return HTMLUtils.buildFunctionSyntaxEvalString(string, string2);
    }

    private static String buildFunctionSyntaxEvalString(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("('").append(string2).append("')");
        return stringBuilder.toString();
    }

    public static String convertJarFileUrlToFilePath(String string) {
        JarFileInfoWrapper jarFileInfoWrapper = HTMLUtils.parseUrlToJarFileInfo(string);
        if (jarFileInfoWrapper == null) {
            return string;
        }
        return jarFileInfoWrapper.getJarfiledir() + '/' + jarFileInfoWrapper.getEntryname();
    }

    private static JarFileInfoWrapper parseUrlToJarFileInfo(String string) {
        Matcher matcher = JARFILE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        if (PlatformInfo.isWindows()) {
            if (string2.startsWith("///")) {
                string2 = string2.substring(3);
            }
        } else {
            string2 = string2.replaceFirst("^/+", "/");
        }
        return new JarFileInfoWrapper(string2, string3, string4);
    }

    public static String getFileNotFoundText(String string, String string2, boolean bl) {
        return HTMLUtils.getFileNotFoundText(DEFAULT_FILE_NOT_FOUND_TEMPLATE, string, string2, bl);
    }

    public static String getFileNotFoundText(String string, String string2, String string3, boolean bl) {
        String string4 = HTMLUtils.getFileNotFoundTemplate(string);
        String string5 = bl ? sRes.getString("alert.noFileOrURL") : string2;
        String string6 = StringUtils.replaceOnce((String)string4, (String)"==TITLE===", (String)string5);
        String string7 = Matlab.matlabRoot() + "/toolbox";
        string7 = string7.replace('\\', '/');
        string6 = StringUtils.replaceOnce((String)string6, (String)"$toolbox", (String)string7);
        string6 = StringUtils.replaceOnce((String)string6, (String)"==BROKEN_URL===", (String)string2);
        string6 = StringUtils.replaceOnce((String)string6, (String)"==REASON===", (String)(string3 == null ? "" : string3));
        return string6;
    }

    private static String getFileNotFoundTemplate(String string) {
        try {
            return FileUtils.readFileToString((File)new File(string));
        }
        catch (IOException iOException) {
            return "<html><title>==TITLE===</title><body>File ==BROKEN_URL=== not found.</body></html>";
        }
    }

    static String getLocalizedFilename(String string) {
        File file;
        String string2;
        File file2;
        String string3 = string;
        String string4 = Locale.getDefault().getLanguage();
        if (!string4.equals("en") && (file2 = new File(string2 = (file = new File(string)).getParent() + File.separator + string4 + File.separator + file.getName())).exists()) {
            string3 = string2;
        }
        return string3;
    }

    private static class JarInfo {
        private JarFile iJarFile;
        private JarEntry iJarEntry;

        private JarInfo(String string) {
            JarFileInfoWrapper jarFileInfoWrapper = HTMLUtils.parseUrlToJarFileInfo(string);
            if (jarFileInfoWrapper == null) {
                return;
            }
            try {
                this.iJarFile = new JarFile(jarFileInfoWrapper.getJarfilepath());
                this.iJarEntry = this.iJarFile.getJarEntry(jarFileInfoWrapper.getEntryname());
            }
            catch (IOException iOException) {
                this.iJarFile = null;
                this.iJarEntry = null;
            }
        }

        private void close() {
            block3: {
                if (this.iJarFile != null) {
                    try {
                        this.iJarFile.close();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)"We should be able to close jar files that we have opened.");
                    }
                }
            }
        }

        private boolean exists() {
            return this.iJarEntry != null;
        }

        InputStream getSourceInputSream() {
            if (this.exists()) {
                try {
                    return this.iJarFile.getInputStream(this.iJarEntry);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return null;
        }
    }

    private static class JarFileInfoWrapper {
        private final String iJarfiledir;
        private final String iJarfilename;
        private final String iEntryname;

        private JarFileInfoWrapper(String string, String string2, String string3) {
            this.iJarfiledir = string;
            this.iJarfilename = string2;
            this.iEntryname = string3;
        }

        private String getJarfiledir() {
            return this.iJarfiledir;
        }

        private String getJarfilename() {
            return this.iJarfilename;
        }

        private String getEntryname() {
            return this.iEntryname;
        }

        private String getJarfilepath() {
            return this.getJarfiledir() + '/' + this.getJarfilename();
        }
    }

    private static enum EncodingStatus {
        OK,
        NEEDS_ENCODING,
        NEEDS_DECODING;

    }
}

