/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.StringUtils;
import ice.pilots.html4.DAllList;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.ThePilot;
import ice.storm.Viewport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ICERendererUtils {
    private ICERendererUtils() {
    }

    static void saveAs(Viewport viewport, String string, File file) {
        String string2 = file.getName();
        String string3 = file.getParent();
        if (viewport.getPilot() instanceof ThePilot) {
            String string4 = string.substring(0, string.lastIndexOf(47));
            String string5 = HTMLUtils.getSource(string);
            ThePilot thePilot = (ThePilot)viewport.getPilot();
            DDocument dDocument = (DDocument)thePilot.getDocument();
            HashSet<String> hashSet = null;
            String string6 = null;
            String string7 = null;
            DAllList dAllList = dDocument.getAll();
            for (int i = 0; i < dAllList.getLength(); ++i) {
                Node node = dAllList.item(i);
                if (node instanceof DAnchorElement) continue;
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Node node2 = namedNodeMap.item(j);
                    String string8 = node2.getNodeValue();
                    String string9 = node2.getNodeName();
                    if (!ICERendererUtils.isResourceRequired(string9, string8) || hashSet != null && hashSet.contains(string8)) continue;
                    if (hashSet == null) {
                        hashSet = new HashSet<String>();
                        int n = string2.lastIndexOf(46);
                        if (n == -1) {
                            n = string2.length();
                        }
                        string6 = string2.substring(0, n) + "_files";
                        string7 = string3 + File.separator + string6;
                        ICERendererUtils.makeNewSubfolder(string7);
                    }
                    hashSet.add(string8);
                    String string10 = string8;
                    if (string8.startsWith("file:")) {
                        string10 = HTMLUtils.getFilenameFromURL(string8);
                    }
                    String string11 = null;
                    try {
                        string11 = ICERendererUtils.copyResource(string4, string10, string7);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    string5 = StringUtils.replaceAllStrings((String)string5, (String)string8, (String)(string6 + "/" + string11));
                }
            }
            ICERendererUtils.writeNewFile(string5, string3 + File.separator + string2);
        }
    }

    private static void makeNewSubfolder(String string) {
        File file = new File(string);
        File file2 = new File(file.getParent());
        if (!file.exists() && file2.canWrite()) {
            file.mkdir();
        }
    }

    private static String copyResource(String string, String string2, String string3) throws IOException {
        String string4 = string2;
        String string5 = string2;
        if (string.startsWith("http")) {
            string4 = string + "/" + string2;
            string5 = string5.substring(string5.lastIndexOf(47) + 1);
            String string6 = string3 + File.separator + string5;
            ICERendererUtils.copyResourceFromWebServer(string4, string6);
        } else {
            Object object;
            if (string.startsWith("text")) {
                string4 = HTMLUtils.getFilenameFromURL(string4);
            } else {
                object = new File(string = FileUtils.fromJavaPath((String)string), string2);
                if (FileUtils.fileExists((File)object)) {
                    string4 = ((File)object).getAbsolutePath();
                }
            }
            string4 = FileUtils.normalizePathname((String)string4);
            object = string2.replace('\\', '/');
            int n = ((String)object).lastIndexOf(47);
            if (n != -1 && n < ((String)object).length()) {
                string5 = ((String)object).substring(n + 1);
            }
            string5 = FileUtils.fromJavaPath((String)string5);
            String string7 = string3 + File.separator + string5;
            File file = new File(string4);
            if (file.exists()) {
                FileUtils.copyFile((File)file, (File)new File(string7));
            }
        }
        return string5;
    }

    private static boolean isResourceRequired(String string, String string2) {
        boolean bl = false;
        if (string.equals("src")) {
            bl = true;
        } else if (string2.endsWith(".gif") || string2.endsWith(".jpe") || string2.endsWith(".jpg") || string2.endsWith(".png") || string2.endsWith(".js") || string2.endsWith(".css")) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeNewFile(String string, String string2) {
        File file = new File(string2);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyResourceFromWebServer(String string, String string2) {
        URL uRL;
        File file = new File(string2);
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        OutputStream outputStream = null;
        try {
            InputStream inputStream = uRL.openStream();
            outputStream = new FileOutputStream(file);
            FileUtils.copyStream((InputStream)inputStream, (OutputStream)outputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

