/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.FindInPageHandler;
import com.mathworks.html.FindOption;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindClientRegistry;
import com.mathworks.widgets.find.FindDialog;
import com.mathworks.widgets.find.FindEvent;
import com.mathworks.widgets.find.FindParentListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

class MatlabFindHandler
implements FindInPageHandler {
    private final HtmlComponent iComponent;
    private MatlabHtmlFindClient fFindClient;
    private final List<FindParentListener> fFindParentListeners = new LinkedList<FindParentListener>();

    MatlabFindHandler(HtmlComponent htmlComponent) {
        this.iComponent = htmlComponent;
    }

    public void openFindInPage() {
        if (this.fFindClient == null) {
            this.fFindClient = new MatlabHtmlFindClient(this.iComponent);
        }
        this.registerAndInvokeFindDialog(this.iComponent);
    }

    public void closeFindInPage() {
    }

    private void registerAndInvokeFindDialog(HtmlComponent htmlComponent) {
        Window window = SwingUtilities.windowForComponent(htmlComponent.getComponent());
        if (window != null) {
            Window window2;
            String string = "";
            String string2 = htmlComponent.getTitle();
            if (window instanceof Frame) {
                window2 = (Frame)window;
                string = string2 == null ? ((Frame)window2).getTitle() : string2;
            } else if (window instanceof Dialog) {
                window2 = (Dialog)window;
                string = string2 == null ? ((Dialog)window2).getTitle() : string2;
            }
            if (string != null) {
                window2 = new String[]{string};
                FindClientRegistry.register((FindClientInterface)this.fFindClient, (String[])window2, (boolean)false);
                htmlComponent.getSelectedText((HtmlDataListener)new HtmlDataListener<String>(){

                    public void dataRetrieved(String string) {
                        FindDialog.invoke((FindClientInterface)MatlabFindHandler.this.fFindClient, (String)string, (int)0);
                    }
                });
            }
        }
    }

    public void dispose() {
        for (FindParentListener findParentListener : this.fFindParentListeners) {
            findParentListener.closing((FindClientInterface)this.fFindClient);
        }
        FindClientRegistry.unregister((FindClientInterface)this.fFindClient);
    }

    private class MatlabHtmlFindClient
    implements FindClientInterface {
        private final HtmlComponent iHtmlComponent;

        private MatlabHtmlFindClient(HtmlComponent htmlComponent) {
            this.iHtmlComponent = htmlComponent;
        }

        public void addFindParentListener(FindParentListener findParentListener) {
            MatlabFindHandler.this.fFindParentListeners.add(findParentListener);
        }

        public void removeFindParentListener(FindParentListener findParentListener) {
            MatlabFindHandler.this.fFindParentListeners.remove(findParentListener);
        }

        public void findForward(FindEvent findEvent) {
            String string = findEvent.getFindString();
            Set<FindOption> set = this.getFindOptionsFromFindEvent(findEvent.getOptions(), false);
            this.iHtmlComponent.findInPage(string, set, null);
        }

        public void findBack(FindEvent findEvent) {
            String string = findEvent.getFindString();
            Set<FindOption> set = this.getFindOptionsFromFindEvent(findEvent.getOptions(), true);
            this.iHtmlComponent.findInPage(string, set, null);
        }

        private Map<FindOption, Integer> mapFindOptions() {
            EnumMap<FindOption, Integer> enumMap = new EnumMap<FindOption, Integer>(FindOption.class);
            enumMap.put(FindOption.MATCH_CASE, 1);
            enumMap.put(FindOption.SEARCH_BACKWARDS, 8);
            enumMap.put(FindOption.WHOLE_WORDS, 4);
            return enumMap;
        }

        private Set<FindOption> getFindOptionsFromFindEvent(int n, boolean bl) {
            EnumSet<FindOption> enumSet = EnumSet.noneOf(FindOption.class);
            for (Map.Entry<FindOption, Integer> entry : this.mapFindOptions().entrySet()) {
                if ((n & entry.getValue()) == 0) continue;
                enumSet.add(entry.getKey());
            }
            if (bl) {
                enumSet.add(FindOption.SEARCH_BACKWARDS);
            }
            return enumSet;
        }

        public void replace(FindEvent findEvent) {
        }

        public void replaceAll(FindEvent findEvent) {
        }

        public Component getInvoker() {
            return this.iHtmlComponent.getComponent();
        }

        public void bringForward() {
            Desktop desktop;
            Component component = this.getInvoker();
            SwingUtilities.windowForComponent(component).toFront();
            Component component2 = Desktop.getClientComponentAncestor((Component)component);
            if (component2 != null && (desktop = Desktop.getContainingDesktop((Component)component2)) != null) {
                desktop.toFront(component2);
            }
        }
    }
}

