/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool.popuplist;

import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupButton;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupListItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DelimiterPopupButton
extends EditablePopupButton
implements EditablePopupButton.EditablePopupListItemListener,
EditablePopupButton.EditablePopupListSelectionListener,
EditablePopupListItem.EditablePopupListItemEditListener {
    public static final String DEFAULT_EMPTY_DELIMITER = "";
    public static final int MAX_SUGGESTED_DELIMITERS = 3;
    private String customDelimiterName = ImportToolUtils.getResourceString("delimiter.custom");
    private EditablePopupListItem fStandardHeader;
    private EditablePopupListItem fCustomHeader;
    private EditablePopupListItem fSuggestionsHeader;
    private ArrayList<EditablePopupListItem> fSuggestedDelimiters = new ArrayList();
    private int fCustomItemCount = 0;
    private int fSuggestedItemCount = 0;

    public DelimiterPopupButton(String string) {
        super(string, true);
        this.getItemList().setName("DelimiterWindow");
        this.setComponentNames("DelimiterPopupButton");
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.fStandardHeader = new EditablePopupListItem(ImportToolUtils.getResourceString("delimiter.standardHeader"), DEFAULT_EMPTY_DELIMITER, EditablePopupListItem.ITEM_TYPE.HEADER, false);
        EditablePopupListItem editablePopupListItem = new EditablePopupListItem(ImportToolUtils.getResourceString("delimiter.tab"), "\t", EditablePopupListItem.ITEM_TYPE.CHECKBOX, false);
        editablePopupListItem.setName("DelimiterItem:Tab");
        EditablePopupListItem editablePopupListItem2 = new EditablePopupListItem(ImportToolUtils.getResourceString("delimiter.comma"), ",", EditablePopupListItem.ITEM_TYPE.CHECKBOX, false);
        editablePopupListItem2.setName("DelimiterItem:Comma");
        EditablePopupListItem editablePopupListItem3 = new EditablePopupListItem(ImportToolUtils.getResourceString("delimiter.space"), " ", EditablePopupListItem.ITEM_TYPE.CHECKBOX, false);
        editablePopupListItem3.setName("DelimiterItem:Space");
        EditablePopupListItem editablePopupListItem4 = new EditablePopupListItem(ImportToolUtils.getResourceString("delimiter.semicolon"), ";", EditablePopupListItem.ITEM_TYPE.CHECKBOX, false);
        editablePopupListItem4.setName("DelimiterItem:Semicolon");
        this.fSuggestionsHeader = new EditablePopupListItem(ImportToolUtils.getResourceString("delimiter.suggestedHeader"), DEFAULT_EMPTY_DELIMITER, EditablePopupListItem.ITEM_TYPE.HEADER, false);
        this.fCustomHeader = new EditablePopupListItem(ImportToolUtils.getResourceString("delimiter.customHeader"), DEFAULT_EMPTY_DELIMITER, EditablePopupListItem.ITEM_TYPE.HEADER, false);
        EditablePopupListItem editablePopupListItem5 = new EditablePopupListItem(this.customDelimiterName, this.customDelimiterName, EditablePopupListItem.ITEM_TYPE.CHECKBOX, true);
        editablePopupListItem5.addEditListener(this);
        editablePopupListItem5.setName("DelimiterItem:Custom:" + this.fCustomItemCount);
        this.addItem(this.fStandardHeader);
        this.addItem(editablePopupListItem);
        this.addItem(editablePopupListItem2);
        this.addItem(editablePopupListItem3);
        this.addItem(editablePopupListItem4);
        this.addItem(this.fCustomHeader);
        this.addItem(editablePopupListItem5);
        this.addItemListener(this);
        this.addSelectionListener(this);
    }

    public boolean isCommaDelimiterSelected() {
        for (EditablePopupListItem editablePopupListItem : this.fList.getItems()) {
            if (!",".equals(editablePopupListItem.getValue())) continue;
            return editablePopupListItem.isSelected();
        }
        return false;
    }

    public void clearCommaDelimiter() {
        for (EditablePopupListItem editablePopupListItem : this.fList.getItems()) {
            if (!",".equals(editablePopupListItem.getValue()) || !editablePopupListItem.isSelected()) continue;
            editablePopupListItem.setSelected(false);
        }
    }

    @Override
    public void itemAdded(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
        editablePopupEvent.getItem().addEditListener(this);
    }

    @Override
    public void itemRemoved(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
        editablePopupEvent.getItem().removeEditListener(this);
    }

    @Override
    public void itemNameModified(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
        if (!this.fIsAdjusting) {
            Object object;
            this.fIsAdjusting = true;
            if (editablePopupEvent.getItem().getValue().equals(this.customDelimiterName) && !editablePopupEvent.getItem().getDisplayName().equals(this.customDelimiterName) && editablePopupEvent.getItem().getDisplayName().length() > 0) {
                object = new EditablePopupListItem(this.customDelimiterName, this.customDelimiterName, EditablePopupListItem.ITEM_TYPE.CHECKBOX, true);
                this.addItem((EditablePopupListItem)((Object)object));
                ++this.fCustomItemCount;
                object.setName("DelimiterItem:Custom:" + this.fCustomItemCount);
            }
            object = this.escapeName(editablePopupEvent.getItem().getDisplayName());
            String string = this.escapeValue((String)object);
            editablePopupEvent.getItem().setDisplayName((String)object);
            editablePopupEvent.getItem().setValue(string);
            this.fIsAdjusting = false;
        }
    }

    private String escapeValue(String string) {
        string = string.replaceAll(this.getCaseInsensitiveStringRegex(ImportToolUtils.getResourceString("delimiter.tab")), "\t");
        string = string.replaceAll(this.getCaseInsensitiveStringRegex(ImportToolUtils.getResourceString("delimiter.comma")), ",");
        string = string.replaceAll(this.getCaseInsensitiveStringRegex(ImportToolUtils.getResourceString("delimiter.space")), " ");
        string = string.replaceAll(this.getCaseInsensitiveStringRegex(ImportToolUtils.getResourceString("delimiter.semicolon")), ";");
        string = string.replaceAll(this.getCaseInsensitiveStringRegex(ImportToolUtils.getResourceString("delimiter.return")), "\r");
        string = string.replaceAll(this.getCaseInsensitiveStringRegex(ImportToolUtils.getResourceString("delimiter.newline")), "\n");
        string = string.replaceAll(this.getCaseInsensitiveStringRegex(ImportToolUtils.getResourceString("delimiter.backslash")), "\\\\");
        return string;
    }

    private String escapeName(String string) {
        string = string.replace("\t", ImportToolUtils.getResourceString("delimiter.tab"));
        string = string.replace(",", ImportToolUtils.getResourceString("delimiter.comma"));
        string = string.replace(" ", ImportToolUtils.getResourceString("delimiter.space"));
        string = string.replace(";", ImportToolUtils.getResourceString("delimiter.semicolon"));
        string = string.replace("\r", ImportToolUtils.getResourceString("delimiter.return"));
        string = string.replace("\n", ImportToolUtils.getResourceString("delimiter.newline"));
        string = string.replace("\\", ImportToolUtils.getResourceString("delimiter.backslash"));
        return string;
    }

    public String getCaseInsensitiveStringRegex(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append("[");
            stringBuilder.append(Character.toUpperCase(string.charAt(i)));
            stringBuilder.append(Character.toLowerCase(string.charAt(i)));
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    @Override
    public void itemDescriptionModified(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
    }

    public void setSuggestedDelimiters(HashMap<String, Integer> hashMap) {
        int n;
        for (n = 0; n < this.fSuggestedDelimiters.size(); ++n) {
            this.removeItem(this.fSuggestedDelimiters.get(n));
        }
        this.removeItem(this.fSuggestionsHeader);
        this.fSuggestedDelimiters.clear();
        n = 0;
        for (String string : hashMap.keySet()) {
            this.addSuggestedDelimiter(this.escapeName(string));
            if (++n < 3) continue;
            break;
        }
    }

    public void addSuggestedDelimiter(String string) {
        if (!this.containsItem(string)) {
            int n;
            int n2 = -1;
            if (!this.containsItem(this.fSuggestionsHeader)) {
                for (n = 0; n < this.getItemCount(); ++n) {
                    if (!this.getItemAt(n).equals((Object)this.fCustomHeader)) continue;
                    n2 = n + 1;
                    this.addItemAt(this.fSuggestionsHeader, n);
                    break;
                }
            } else {
                for (n = 0; n < this.getItemCount(); ++n) {
                    if (!this.getItemAt(n).equals((Object)this.fCustomHeader)) continue;
                    n2 = n;
                    break;
                }
            }
            String string2 = this.escapeName(string);
            String string3 = this.escapeValue(string2);
            EditablePopupListItem editablePopupListItem = new EditablePopupListItem(string2, string3, EditablePopupListItem.ITEM_TYPE.CHECKBOX, false);
            this.addItemAt(editablePopupListItem, n2);
            editablePopupListItem.setDisplayName(string);
            editablePopupListItem.setName("DelimiterItem:SuggestedItem:" + this.fSuggestedItemCount);
            ++this.fSuggestedItemCount;
            this.fSuggestedDelimiters.add(editablePopupListItem);
        }
    }

    public void removeSuggestedDelimiter(String string) {
        for (int i = 0; i < this.fSuggestedDelimiters.size(); ++i) {
            if (!this.fSuggestedDelimiters.get(i).equals(string)) continue;
            EditablePopupListItem editablePopupListItem = this.fSuggestedDelimiters.get(i);
            this.removeItem(editablePopupListItem);
            this.fSuggestedDelimiters.remove(i);
            break;
        }
        if (this.fSuggestedDelimiters.size() <= 0) {
            this.removeItem(this.fSuggestionsHeader);
        }
    }

    public void setSelectedDelimiter(String string) {
        this.setSelectedItem(string);
    }

    public List<String> getSelectedFormat() {
        ArrayList<String> arrayList = new ArrayList<String>();
        EditablePopupListItem[] editablePopupListItemArray = this.getSelectedItems();
        if (editablePopupListItemArray != null) {
            if (editablePopupListItemArray.length > 0) {
                for (EditablePopupListItem editablePopupListItem : editablePopupListItemArray) {
                    arrayList.add(editablePopupListItem.getValue().toString());
                }
            } else {
                arrayList.add(DEFAULT_EMPTY_DELIMITER);
            }
        }
        return arrayList;
    }

    @Override
    public void selectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
        if (!this.fIsAdjusting) {
            this.fIsAdjusting = true;
            if (editablePopupEvent.getItem().getDisplayName().equals(this.customDelimiterName) && editablePopupEvent.getItem().isSelected()) {
                editablePopupEvent.getItem().setBlankOnEdit(true);
                editablePopupEvent.getItem().edit();
                if (!editablePopupEvent.getList().isVisible()) {
                    editablePopupEvent.getList().setVisible(true);
                }
                editablePopupEvent.getItem().setSelected(false);
                this.updateDisplayText();
            } else {
                editablePopupEvent.getItem().setBlankOnEdit(false);
            }
            this.fIsAdjusting = false;
        }
    }

    @Override
    public void temporarySelectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
    }

    @Override
    public void editStateChanged(EditablePopupListItem editablePopupListItem, EditablePopupListItem.EditState editState) {
        if (!this.fIsAdjusting && editState == EditablePopupListItem.EditState.EDITING) {
            this.fIsAdjusting = true;
            if (editablePopupListItem.getDisplayName().equals(this.customDelimiterName)) {
                editablePopupListItem.setEditText(DEFAULT_EMPTY_DELIMITER);
            } else {
                editablePopupListItem.setEditText(this.escapeValue(editablePopupListItem.getDisplayName()));
            }
            this.fIsAdjusting = false;
        } else if (!this.fIsAdjusting && editState == EditablePopupListItem.EditState.SAVED) {
            this.fIsAdjusting = true;
            if (editablePopupListItem.getDisplayName().equals(this.customDelimiterName)) {
                editablePopupListItem.setSelected(false);
                this.updateDisplayText();
            }
            this.fIsAdjusting = false;
        }
    }
}

