/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.grid.Row;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlwidgets.inspector.IPropertyTreeTableNode;
import com.mathworks.mlwidgets.inspector.JidePropertyItem;
import com.mathworks.mlwidgets.inspector.JidePropertyViewTable;
import com.mathworks.mlwidgets.inspector.PropertyItemNode;
import com.mathworks.mlwidgets.inspector.PropertyRootNode;
import com.mathworks.mlwidgets.inspector.PropertyTreeTableModel;
import com.mathworks.mlwidgets.inspector.TreeTableModelUpdateListener;
import com.mathworks.services.ObjectRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

final class JidePropertyTableModel
extends PropertyTableModel {
    private static boolean sDoGroupingOnInit = false;
    private static boolean sPrevTargetIsEmpty_EventThread = true;
    private PropertyTreeTableModel fTreeTableModel;
    private JidePropertyViewTable fTable = null;
    private List fPropertyList;

    JidePropertyTableModel(ObjectRegistry objectRegistry) {
        this.fTreeTableModel = new PropertyTreeTableModel(objectRegistry);
        this.fPropertyList = this.createNewList();
        this.setOriginalRows(this.fPropertyList);
        this.setCategoryOrder(1);
        this.setMiscCategoryName("Miscellaneous");
        sPrevTargetIsEmpty_EventThread = true;
    }

    void setTable(JidePropertyViewTable jidePropertyViewTable) {
        this.fTable = jidePropertyViewTable;
    }

    PropertyTreeTableModel getUnderlyingModel() {
        return this.fTreeTableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List buildRows(List list) {
        List list2 = list;
        synchronized (list2) {
            return super.buildRows(list);
        }
    }

    public void expandRow(ExpandableRow expandableRow, boolean bl) {
        if (expandableRow instanceof JidePropertyItem) {
            JidePropertyItem jidePropertyItem = (JidePropertyItem)expandableRow;
            if (jidePropertyItem.hasQueriedChildren()) {
                this.expandRowWithCheck_EventThread(expandableRow, bl);
            } else {
                ExpandTreeWorker expandTreeWorker = new ExpandTreeWorker(jidePropertyItem, expandableRow, bl);
                expandTreeWorker.start();
            }
        } else {
            super.expandRow(expandableRow, bl);
        }
    }

    void cleanup_EventThread() {
        if (!sPrevTargetIsEmpty_EventThread) {
            this.saveCurrentOrderStyle_EventThread();
        }
    }

    private void applySavedOrderStyle_EventThread() {
        if (sDoGroupingOnInit && this.fTreeTableModel.targetHasPropertyGroups()) {
            this.setOrder(0);
        } else {
            this.setOrder(1);
        }
    }

    private void saveCurrentOrderStyle_EventThread() {
        sDoGroupingOnInit = this.getOrder() == 0;
    }

    void refreshValues_MatlabThread() {
        this.fTreeTableModel.refreshValues_MatlabThread();
    }

    private void expandRowWithCheck_EventThread(ExpandableRow expandableRow, boolean bl) {
        int n = -1;
        if (this.getRowIndex((Row)expandableRow) != n) {
            try {
                super.expandRow(expandableRow, bl);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    boolean targetHasPropertyGroups() {
        if (this.fTreeTableModel != null) {
            return this.fTreeTableModel.targetHasPropertyGroups();
        }
        return false;
    }

    void addInspectorUpdateListener(TreeTableModelUpdateListener treeTableModelUpdateListener) {
        if (this.fTreeTableModel != null) {
            this.fTreeTableModel.addInspectorUpdateListener(treeTableModelUpdateListener);
        }
    }

    void setObjects_MatlabThread(JTable jTable, final Object[] objectArray) {
        if (this.fTreeTableModel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!sPrevTargetIsEmpty_EventThread) {
                        JidePropertyTableModel.this.saveCurrentOrderStyle_EventThread();
                    }
                }
            });
            this.fTreeTableModel.setObjects_MatlabThread(jTable, objectArray);
            final List list = this.loadPropertyList_MatlabThread();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JidePropertyTableModel.this.fPropertyList = list;
                    JidePropertyTableModel.this.setOriginalRows(JidePropertyTableModel.this.fPropertyList);
                    JidePropertyTableModel.this.refresh();
                    JidePropertyTableModel.this.applySavedOrderStyle_EventThread();
                    JidePropertyTableModel.this.fTreeTableModel.fireTreeTableUpdateEvent();
                    if (objectArray == null || objectArray.length < 1) {
                        sPrevTargetIsEmpty_EventThread = true;
                    } else {
                        sPrevTargetIsEmpty_EventThread = false;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Property getPropertyFromName_AnyThread(String string) {
        Property property = null;
        if (this.fPropertyList != null) {
            List list = this.fPropertyList;
            synchronized (list) {
                for (Object e : this.fPropertyList) {
                    Property property2;
                    if (!(e instanceof Property) || !(property2 = (Property)e).getName().equals(string)) continue;
                    property = property2;
                    break;
                }
            }
        }
        return property;
    }

    private List loadPropertyList_MatlabThread() {
        Object object;
        List list = this.createNewList();
        if (this.fTreeTableModel != null && (object = this.fTreeTableModel.getRoot()) instanceof PropertyRootNode) {
            PropertyRootNode propertyRootNode = (PropertyRootNode)object;
            IPropertyTreeTableNode[] iPropertyTreeTableNodeArray = propertyRootNode.getChildren();
            for (int i = 0; iPropertyTreeTableNodeArray != null && i < iPropertyTreeTableNodeArray.length; ++i) {
                if (!(iPropertyTreeTableNodeArray[i] instanceof PropertyItemNode)) continue;
                PropertyItemNode propertyItemNode = (PropertyItemNode)iPropertyTreeTableNodeArray[i];
                JidePropertyItem jidePropertyItem = new JidePropertyItem(propertyItemNode, this);
                list.add(jidePropertyItem);
            }
        }
        return list;
    }

    private List createNewList() {
        return Collections.synchronizedList(new ArrayList());
    }

    private class ExpandTreeWorker
    extends MatlabWorker {
        JidePropertyItem fItem;
        ExpandableRow fRow;
        boolean fExpanded;

        ExpandTreeWorker(JidePropertyItem jidePropertyItem, ExpandableRow expandableRow, boolean bl) {
            this.fItem = jidePropertyItem;
            this.fRow = expandableRow;
            this.fExpanded = bl;
        }

        public Object runOnMatlabThread() throws Exception {
            Object var1_1 = null;
            if (this.fItem != null) {
                this.fItem.loadChildren_MatlabThread();
            }
            return var1_1;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (this.fRow != null) {
                JidePropertyTableModel.this.expandRowWithCheck_EventThread(this.fRow, this.fExpanded);
                if (JidePropertyTableModel.this.fTable != null) {
                    JidePropertyTableModel.this.fTable.setSelectedRow((Row)this.fRow);
                }
            }
        }
    }
}

