/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.mlwidgets.inspector.InspectorUIResources;
import com.mathworks.mlwidgets.inspector.NamedEditor;
import com.mathworks.mlwidgets.inspector.PropertyCell;
import com.mathworks.mlwidgets.inspector.PropertyTarget;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToggleButton;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

class PropertyCellBoolean
extends PropertyCell {
    private MJPanel fRendererPanel;
    private MJCheckBox fCheckBox;
    private JToggleButton fToggleButton;
    private final ActionListener fActionListener;
    private static final String TRUE = "On";
    private static final String FALSE = "Off";
    private final Border fToggleOnBorder = BorderFactory.createBevelBorder(1, InspectorUIResources.getButtonHighlight(), InspectorUIResources.getButtonShadow());
    private final Border fToggleOffBorder = BorderFactory.createBevelBorder(0, InspectorUIResources.getButtonHighlight(), InspectorUIResources.getButtonShadow());

    PropertyCellBoolean(JComponent jComponent, PropertyTarget propertyTarget, int n, int n2, NamedEditor namedEditor) {
        super(jComponent, propertyTarget, n, n2, namedEditor);
        this.fActionListener = this.isEditable() ? this.createAction() : null;
    }

    @Override
    void updateComponent_EventThread() {
        if (this.fCheckBox != null) {
            Object object = this.getEditor().getValue();
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (this.fCheckBox != null) {
                    this.fCheckBox.setSelected(bl);
                }
                if (this.fToggleButton != null) {
                    this.fToggleButton.setSelected(bl);
                    Border border = bl ? this.fToggleOnBorder : this.fToggleOffBorder;
                    this.fToggleButton.setBorder(border);
                    this.fToggleButton.setIcon(this.getIcon());
                }
            }
            this.fCheckBox.setText(this.getEditor().getAsText());
        }
    }

    @Override
    MJPanel getRendererComponent() {
        if (this.fRendererPanel == null) {
            this.fRendererPanel = this.createRendererPanel();
        }
        return this.fRendererPanel;
    }

    @Override
    MJPanel getEditorComponent() {
        return this.getRendererComponent();
    }

    private void updateWidgets(boolean bl) {
        this.getEditor().setValue(bl);
        if (this.fCheckBox != null && this.fToggleButton != null) {
            this.fCheckBox.setSelected(bl);
            this.fCheckBox.setText(bl ? TRUE : FALSE);
            this.fToggleButton.setSelected(bl);
            this.fToggleButton.setIcon(this.getIcon());
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.getEditor().setValue(bl2);
        }
    }

    private ActionListener createAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JToggleButton) {
                    PropertyCellBoolean.this.updateWidgets(((JToggleButton)object).isSelected());
                } else if (object instanceof MJCheckBox) {
                    PropertyCellBoolean.this.updateWidgets(((MJCheckBox)object).isSelected());
                }
            }
        };
    }

    private MJPanel createRendererPanel() {
        this.fCheckBox = new MJCheckBox();
        this.fCheckBox.setOpaque(false);
        Object object = this.getEditor().getValue();
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            this.fCheckBox.setText(bl ? TRUE : FALSE);
            this.fCheckBox.setSelected(bl);
        }
        if (this.isEditable()) {
            this.fCheckBox.addActionListener(this.fActionListener);
        } else {
            this.fCheckBox.setEnabled(false);
        }
        return this.createMainPanelWithNoIcon(this.getEditor(), (JComponent)this.fCheckBox);
    }

    @Override
    protected AbstractButton createButton(PropertyEditor propertyEditor) {
        Icon icon = this.getIcon();
        if (icon == null) {
            return null;
        }
        this.fToggleButton = new MJToggleButton();
        this.fToggleButton.setIcon(icon);
        this.fToggleButton.setFocusPainted(false);
        Dimension dimension = new Dimension(icon.getIconWidth() + 6, icon.getIconHeight());
        this.fToggleButton.setOpaque(false);
        this.fToggleButton.setPreferredSize(dimension);
        Object object = this.getEditor().getValue();
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            Border border = bl ? this.fToggleOnBorder : this.fToggleOffBorder;
            this.fToggleButton.setBorder(border);
        }
        if (this.isEditable()) {
            this.fToggleButton.addActionListener(this.fActionListener);
        } else {
            this.fToggleButton.setEnabled(false);
        }
        return this.fToggleButton;
    }
}

