/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs.binding;

import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.DetailPanel;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mlwidgets.explorer.model.actions.ActionPredicates;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.prefs.binding.KeyBindingPanelUtils;
import com.mathworks.mlwidgets.prefs.binding.KeyboardShortcutsPrefPanel;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.binding.CustomKeyBindingSetUtils;
import com.mathworks.util.Predicate;
import com.mathworks.util.ThrowableClosure;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;

public class KeyboardShortcutSetInfoProvider
implements FileInfoProvider,
ActionProvider {
    private static final String FILE_DESCRIPTION = KeyBindingPanelUtils.lookup("explorer.infoProvider.description");

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        try {
            return fileSystemEntry.getLocation().checkExtension(new String[]{"xml"}) && fileSystemEntry.getSize() < 300000L && FileSystemUtils.withInputStream(fileSystemEntry, new ThrowableClosure<Boolean, InputStream, IOException>(){

                public Boolean run(InputStream inputStream) throws IOException {
                    return CustomKeyBindingSetUtils.startsWithCustomSetElement((InputStream)inputStream);
                }
            }) != false && FileSystemUtils.withInputStream(fileSystemEntry, new ThrowableClosure<Boolean, InputStream, IOException>(){

                public Boolean run(InputStream inputStream) throws IOException {
                    return CustomKeyBindingSetUtils.isValidCustomSet((InputStream)inputStream);
                }
            }) != false;
        }
        catch (StackOverflowError stackOverflowError) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void configureDecorations(FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
        fileDecorators.set(CoreFileDecoration.ICON, (Object)MiscellaneousIcon.KEYBOARD_KEY.getIcon());
        fileDecorators.set(CoreFileDecoration.TYPE_NAME, (Object)FILE_DESCRIPTION);
        if (fileSystemEntry.isReal() || FileSystemUtils.findZipParent(fileSystemEntry) != null) {
            fileDecorators.set(CoreFileDecoration.DETAIL_PANEL, ShortcutDetailPanel.class, new Object[]{fileSystemEntry});
        }
    }

    public void configureActions(ActionRegistry actionRegistry) {
        StatusRunnable<ActionInput> statusRunnable = new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                List list = actionInput.getSelection();
                assert (list.size() == 1) : " This action is only enabled for a single selected file";
                KeyboardShortcutSetInfoProvider.openFile(((FileSystemEntry)list.get(0)).getLocation().toFile());
                return Status.COMPLETED;
            }
        };
        actionRegistry.getAction(CoreActionID.OPEN).setCode(SelectionMode.EXPLICIT_SINGLE_FILE_SELECTION, (StatusRunnable)statusRunnable);
        actionRegistry.getAction(CoreActionID.OPEN).setEnabled((Predicate)ActionPredicates.ALL_REAL_FILE_SYSTEM_LOCATIONS);
        actionRegistry.getAction(CoreActionID.OPEN_AS_TEXT).setEnabled((Predicate)ActionPredicates.ALL_REAL_FILE_SYSTEM_LOCATIONS);
    }

    private static void openFile(File file) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
        MLPrefsDialogServices.showPrefsDialog((String)(resourceBundle.getString("area.keyboard") + "." + resourceBundle.getString("area.keyboard.shortcuts")));
        KeyboardShortcutsPrefPanel keyboardShortcutsPrefPanel = KeyboardShortcutsPrefPanel.getInstance();
        assert (keyboardShortcutsPrefPanel != null);
        keyboardShortcutsPrefPanel.addKeybindingFile(file);
    }

    public static class ShortcutDetailPanel
    implements DetailPanel {
        private final MJPanel fPanel = new MJPanel((LayoutManager)new GridBagLayout());

        public ShortcutDetailPanel(final FileSystemEntry fileSystemEntry) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.ipadx = 10;
            gridBagConstraints.fill = 0;
            this.fPanel.add((Component)new MJLabel((Icon)MiscellaneousIcon.KEYBOARD_KEY_32x32.getIcon()), (Object)gridBagConstraints);
            gridBagConstraints.gridx = 1;
            if (fileSystemEntry.isReal()) {
                String string = MessageFormat.format(KeyBindingPanelUtils.lookup("explorer.infoProvider.detailPanel"), fileSystemEntry.getName());
                HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string, new HyperlinkTextLabel.HyperlinkHandler(){

                    public void processHyperlink(String string) {
                        KeyboardShortcutSetInfoProvider.openFile(fileSystemEntry.getLocation().toFile());
                    }
                });
                this.fPanel.add((Component)hyperlinkTextLabel.getComponent(), (Object)gridBagConstraints);
            } else {
                FileLocation fileLocation = FileSystemUtils.findZipParent(fileSystemEntry);
                assert (fileLocation != null) : "The detail panel is only supposed to be enabled for real files and zipped files";
                String string = MessageFormat.format(KeyBindingPanelUtils.lookup("explorer.infoProvider.detailPanel.zip"), fileLocation.getName());
                MJLabel mJLabel = new MJLabel(string);
                this.fPanel.add((Component)mJLabel, (Object)gridBagConstraints);
            }
        }

        public JComponent getComponent() {
            return this.fPanel;
        }

        public Status getLoadStatus() {
            return Status.COMPLETED;
        }

        public boolean isScrollBarNeeded() {
            return true;
        }
    }
}

