/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.util.productinfo;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.util.productinfo.HelpAddonItem;
import com.mathworks.mlwidgets.util.productinfo.PrefPanelItem;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.mlwidgets.util.productinfo.ProductItem;
import com.mathworks.util.StringUtils;
import com.mathworks.xml.XMLValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class Product
implements Comparable {
    static final String TOOLBOX_TYPE = "toolbox";
    static final String BLOCKSET_TYPE = "blockset";
    static final String MATLAB_TYPE = "matlab";
    static final String SIMULINK_TYPE = "simulink";
    static final String LINKS_TYPE = "links_targets";
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.util.productinfo.resources.RES_ProductInfo");
    private String fFilename;
    private String fName;
    private int fID = -1;
    private String fCategory;
    private boolean fProductNameEndsWithType;
    private boolean fValidationResultsReported = false;
    private String fIconLoc;
    private String fHelpLoc;
    private String fHelpIconLoc;
    private String fDocDir;
    private HelpAddonItem[] fHelpAddonItems;
    private List<HelpAddonItem> fProductLevelHelpAddons;
    private PrefPanelItem[] fPrefPanelItems;
    private String[] fDialogPrefPanelItems;
    private ProductItem[] fItems;
    private Element fDocElement;
    private Product fParent;
    private static final String sSchemaPath = "/sys/namespace/info/v1/info.xsd";
    private static String sFullSchemaPath;
    private XMLValidator.ValidationResults fValidationResults;

    Product(String string, String string2, int n, String string3, boolean bl, String string4, String string5, String string6, PrefPanelItem[] prefPanelItemArray, String[] stringArray, ProductItem[] productItemArray, Element element) {
        this.setFilename(string);
        this.setName(string2);
        this.setMathWorksID(n);
        this.setCategory(string3);
        this.setProductNameEndsWithType(bl);
        this.setIconLoc(string4);
        this.setHelpLoc(string5);
        this.setHelpIconLoc(string6);
        this.setPrefPanelItems(prefPanelItemArray);
        this.setDialogPrefItems(stringArray);
        this.setProductItems(productItemArray);
        sFullSchemaPath = Matlab.matlabRoot() + sSchemaPath;
        this.fDocElement = element;
    }

    public int compareTo(Object object) {
        Product product = (Product)object;
        int n = this.getName().compareTo(product.getName());
        if (n == 0) {
            n = this.getFilename(true).compareTo(product.getFilename(true));
        }
        return n;
    }

    private void setFilename(String string) {
        this.fFilename = string;
    }

    private void setName(String string) {
        this.fName = string;
    }

    private void setMathWorksID(int n) {
        this.fID = n;
    }

    private void setCategory(String string) {
        this.fCategory = string;
    }

    private void setProductNameEndsWithType(boolean bl) {
        this.fProductNameEndsWithType = bl;
    }

    private void setIconLoc(String string) {
        this.fIconLoc = string;
    }

    public String getHelpIconLoc() {
        return this.fHelpIconLoc;
    }

    private void setHelpIconLoc(String string) {
        this.fHelpIconLoc = string;
    }

    private void setHelpLoc(String string) {
        this.fHelpLoc = string;
    }

    void setHelpAddonItems(HelpAddonItem[] helpAddonItemArray) {
        this.fHelpAddonItems = helpAddonItemArray;
    }

    void addProductLevelHelpAddon(HelpAddonItem helpAddonItem) {
        if (this.fProductLevelHelpAddons == null) {
            this.fProductLevelHelpAddons = new ArrayList<HelpAddonItem>();
        }
        this.fProductLevelHelpAddons.add(helpAddonItem);
    }

    private void setPrefPanelItems(PrefPanelItem[] prefPanelItemArray) {
        this.fPrefPanelItems = prefPanelItemArray;
    }

    private void setDialogPrefItems(String[] stringArray) {
        this.fDialogPrefPanelItems = stringArray;
    }

    private void setProductItems(ProductItem[] productItemArray) {
        this.fItems = productItemArray;
    }

    public String getFilename() {
        return this.getFilename(false);
    }

    public String getFilename(boolean bl) {
        if (this.fFilename != null) {
            return this.fFilename;
        }
        if (bl && this.getParent() != null) {
            return this.getParent().getFilename(true);
        }
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public String getFullName() {
        if (this.getProductNameEndsWithType()) {
            return ProductInfoUtils.appendCategoryToProductName(this.getName(), this.getCategory());
        }
        return this.getName();
    }

    public int getMathWorksID() {
        return this.fID;
    }

    public String getCategory() {
        return this.fCategory;
    }

    private boolean getProductNameEndsWithType() {
        return this.fProductNameEndsWithType;
    }

    public String getIconLoc() {
        return this.fIconLoc;
    }

    public String getHelpLoc() {
        return this.fHelpLoc;
    }

    public String getDocDir() {
        return this.fDocDir;
    }

    public void setDocDir(String string) {
        this.fDocDir = string;
    }

    public HelpAddonItem[] getHelpAddonItems() {
        return this.fHelpAddonItems;
    }

    List<HelpAddonItem> getProductLevelHelpAddons() {
        return this.fProductLevelHelpAddons;
    }

    public PrefPanelItem[] getPrefsPanelItems() {
        return this.fPrefPanelItems;
    }

    public String[] getDialogPrefsPanelItems() {
        return this.fDialogPrefPanelItems;
    }

    public Product getParent() {
        return this.fParent;
    }

    public void setParent(Product product) {
        this.fParent = product;
    }

    public synchronized ProductItem[] getItems() {
        if (this.fItems == null && this.getFilename() != null) {
            try {
                this.setValidationResults(XMLValidator.validateFile((String)this.getFilename(), (String)sFullSchemaPath));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.fValidationResults.hasErrors()) {
                this.fItems = null;
                this.printValidationErrors();
            } else {
                this.parseForItems();
            }
        }
        return this.fItems;
    }

    public boolean hasItems() {
        return this.fDocElement.getElementsByTagName("listitem").getLength() > 0;
    }

    private void parseForItems() {
        NodeList nodeList = this.fDocElement.getElementsByTagName("listitem");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            this.addItem(this.createProductItemNode(i));
        }
    }

    private ProductItem createProductItemNode(int n) {
        ProductItem productItem = null;
        try {
            NodeList nodeList = this.fDocElement.getElementsByTagName("listitem");
            Element element = (Element)nodeList.item(n);
            String string = ProductInfoUtils.getValue(element, "label", "");
            String string2 = ProductInfoUtils.getValue(element, "callback", "");
            String string3 = ProductInfoUtils.getValue(element, "icon", "");
            NodeList nodeList2 = element.getElementsByTagName("dependency");
            String[] stringArray = new String[nodeList2.getLength()];
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                if (nodeList2.item(i) == null) continue;
                stringArray[i] = nodeList2.item(i).getFirstChild().getNodeValue();
            }
            NodeList nodeList3 = element.getElementsByTagName("unsupported-platform");
            String[] stringArray2 = new String[nodeList3.getLength()];
            for (int i = 0; i < nodeList3.getLength(); ++i) {
                if (nodeList3.item(i) == null) continue;
                stringArray2[i] = nodeList3.item(i).getFirstChild().getNodeValue();
            }
            productItem = new ProductItem(string, string2, ProductInfoUtils.getAbsolutePath(string3, this.getFilename()), stringArray, stringArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return productItem;
    }

    static void save() {
        System.out.println("Save is not yet implemented");
    }

    private void addItem(ProductItem productItem) {
        ProductItem[] productItemArray = null;
        if (this.fItems == null) {
            this.fItems = new ProductItem[1];
        } else {
            int n = this.fItems.length;
            productItemArray = this.fItems;
            this.fItems = null;
            this.fItems = new ProductItem[n + 1];
        }
        if (productItemArray != null) {
            System.arraycopy(productItemArray, 0, this.fItems, 0, productItemArray.length);
        }
        this.fItems[this.fItems.length - 1] = productItem;
    }

    void removeItem(ProductItem productItem) {
        if (this.fItems == null) {
            return;
        }
        int n = this.fItems.length;
        ProductItem[] productItemArray = this.fItems;
        this.fItems = new ProductItem[n - 1];
        for (int i = 0; i < productItemArray.length; ++i) {
            if (productItemArray[i] == productItem) continue;
            this.fItems[i] = productItemArray[i];
        }
    }

    private void setValidationResults(XMLValidator.ValidationResults validationResults) {
        this.fValidationResults = validationResults;
    }

    public Vector<SAXParseException> getValidationErrors() {
        if (this.fValidationResults != null && this.fValidationResults.hasErrors()) {
            return this.fValidationResults.getErrors();
        }
        return null;
    }

    private String getValidationErrorString() {
        String string = StringUtils.quoteSingleQuotes((String)MessageFormat.format(sRes.getString("msg.infoxml.fail"), "helpview([docroot '/techdoc/matlab_env/matlab_env.map'], 'xml_validation_errors')"));
        if (this.fValidationResults != null && this.fValidationResults.hasErrors()) {
            return this.fValidationResults.getErrorMessage() + "\\n" + string;
        }
        return "";
    }

    public boolean resultsReported() {
        return this.fValidationResultsReported;
    }

    public void setResultsReported(boolean bl) {
        this.fValidationResultsReported = bl;
    }

    private void printValidationErrors() {
        if (this.getValidationErrors() != null && !this.resultsReported()) {
            String string = "warning('MATLAB:infoXmlValidationError', '" + this.getValidationErrorString() + "');";
            MLExecuteServices.consoleEval((String)string);
            this.setResultsReported(true);
        }
    }
}

