/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mlwidgets.array.ArrayDialog;
import com.mathworks.mlwidgets.workspace.WhosInformation;
import com.mathworks.mlwidgets.workspace.WorkspaceChange;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceLog;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mlwidgets.workspace.WorkspaceObserver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Timer;

public class MatlabWorkspaceListener {
    private static final MatlabMCR MATLAB = new MatlabMCR("MatlabWorkspaceListener");
    private static Object sInterestCookieScope = null;
    private static Object sInterestCookieAdd = null;
    private static Object sInterestCookieClear = null;
    private static Object sInterestCookieDelete = null;
    private static Object sInterestCookieArrayAll = null;
    private static Object sInterestCookieArrayChange = null;
    private static boolean sReceivedScope = false;
    private static boolean sReceivedAdd = false;
    private static boolean sReceivedClear = false;
    private static boolean sReceivedDelete = false;
    private static boolean sReceivedArrayAll = false;
    private static boolean sReceivedArrayChange = false;
    private static boolean sReceivedFake = false;
    private static boolean sReceivedANYTHING = false;
    private static final int LONG_DELAY = 160;
    private static final int SHORT_DELAY = 80;
    private static final int INTERPRETER_DELAY = 40;
    private static boolean sRegistered = false;
    private static final Timer WORKSPACE_CHANGE_TIMER = new Timer(80, null);
    private static final Timer INTERPRETER_FREE_TIMER = new Timer(40, null);
    private static WhosInformation sWhosInformation = null;
    private static WhosObserver sLatestWhosObserver = null;
    private static WorkspaceChange sPreviousWorkspaceChange = null;
    private static final int FAKE_WS_ARRAY_CHANGE = 0x8000001;
    private static List<WeakReference<WorkspaceObserver>> sWorkspaceObservers = new Vector<WeakReference<WorkspaceObserver>>(1);
    private static boolean sSuspended = false;
    private static final Object WHOS_COUNT_LOCK = new Object();
    private static int sWaitingForWhosCount = 0;
    protected static final int MAX_WHOS_COUNT = 10;
    private static int sPostWhosRequestCount = 0;
    private static boolean sChangeReportPending = false;

    protected MatlabWorkspaceListener() {
    }

    public static void addWorkspaceChangeObserver(WorkspaceObserver workspaceObserver) {
        MatlabWorkspaceListener.addWorkspaceChangeObserverNoUpdate(workspaceObserver);
        if (sWhosInformation == null) {
            MatlabWorkspaceListener.startWhosQueryForNewObserver(workspaceObserver);
        } else {
            workspaceObserver.workspaceUpdate(WorkspaceChange.getArrayAllInstance(), sWhosInformation);
        }
    }

    public static void addWorkspaceChangeObserverNoUpdate(WorkspaceObserver workspaceObserver) {
        boolean bl = sWorkspaceObservers.isEmpty();
        sWorkspaceObservers.add(new WeakReference<WorkspaceObserver>(workspaceObserver));
        if (bl) {
            MatlabWorkspaceListener.startListeningForWorkspaceEvents();
        }
    }

    public static void removeWorkspaceChangeObserver(WorkspaceObserver workspaceObserver) {
        if (workspaceObserver != null) {
            for (WeakReference<WorkspaceObserver> weakReference : sWorkspaceObservers) {
                if (!workspaceObserver.equals(weakReference.get())) continue;
                sWorkspaceObservers.remove(weakReference);
                break;
            }
        }
        if (sWorkspaceObservers.isEmpty()) {
            MatlabWorkspaceListener.stopListeningForWorkspaceEvents();
        }
    }

    private static void resumeWorkspaceInterests() {
        if (!sSuspended) {
            return;
        }
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!sSuspended) {
                    return;
                }
                sSuspended = false;
                MatlabWorkspaceListener.doWSChangeReport();
            }
        };
        if (Matlab.isMatlabAvailable()) {
            WorkspaceMCRProvider.getMCRForWorkspaceRefresh().eval(";", new CompletionObserver(){

                public void completed(int n, Object object) {
                    runnable.run();
                }
            });
        } else {
            runnable.run();
        }
    }

    private static void suspendWorkspaceInterests() {
        sSuspended = true;
    }

    public static boolean isSuspended() {
        return sSuspended;
    }

    public static boolean swl(boolean bl) {
        boolean bl2 = sSuspended;
        if (bl) {
            MatlabWorkspaceListener.suspendWorkspaceInterests();
        } else {
            MatlabWorkspaceListener.resumeWorkspaceInterests();
        }
        return bl2;
    }

    private static void startListeningForWorkspaceEvents() {
        if (!Matlab.isMatlabAvailable()) {
            return;
        }
        if (!sRegistered) {
            sRegistered = true;
            WORKSPACE_CHANGE_TIMER.setRepeats(false);
            WORKSPACE_CHANGE_TIMER.addActionListener(new WorkspaceChangeTimerCallback());
            INTERPRETER_FREE_TIMER.setRepeats(false);
            INTERPRETER_FREE_TIMER.addActionListener(new InterpreterFreeTimerCallback());
        }
        sInterestCookieScope = MATLAB.registerInterest(3, Integer.MIN_VALUE, (CompletionObserver)new LocalWorkspaceEventObserver(Integer.MIN_VALUE));
        sInterestCookieAdd = MATLAB.registerInterest(3, 0x40000000, (CompletionObserver)new LocalWorkspaceEventObserver(0x40000000));
        sInterestCookieClear = MATLAB.registerInterest(3, 0x20000000, (CompletionObserver)new LocalWorkspaceEventObserver(0x20000000));
        sInterestCookieDelete = MATLAB.registerInterest(3, 0x10000000, (CompletionObserver)new LocalWorkspaceEventObserver(0x10000000));
        sInterestCookieArrayChange = MATLAB.registerInterest(3, 0x8000000, (CompletionObserver)new LocalWorkspaceEventObserver(0x8000000));
        sInterestCookieArrayAll = MATLAB.registerInterest(3, 1, (CompletionObserver)new LocalWorkspaceEventObserver(1));
    }

    private static void stopListeningForWorkspaceEvents() {
        if (MATLAB != null) {
            ActionListener[] actionListenerArray;
            MATLAB.unregisterInterest(sInterestCookieScope);
            MATLAB.unregisterInterest(sInterestCookieAdd);
            MATLAB.unregisterInterest(sInterestCookieClear);
            MATLAB.unregisterInterest(sInterestCookieDelete);
            MATLAB.unregisterInterest(sInterestCookieArrayChange);
            MATLAB.unregisterInterest(sInterestCookieArrayAll);
            ActionListener[] actionListenerArray2 = actionListenerArray = WORKSPACE_CHANGE_TIMER.getActionListeners();
            int n = actionListenerArray2.length;
            for (int i = 0; i < n; ++i) {
                ActionListener actionListener = actionListenerArray2[i];
                WORKSPACE_CHANGE_TIMER.removeActionListener(actionListener);
            }
            WORKSPACE_CHANGE_TIMER.stop();
            for (ActionListener actionListener : actionListenerArray2 = INTERPRETER_FREE_TIMER.getActionListeners()) {
                INTERPRETER_FREE_TIMER.removeActionListener(actionListener);
            }
            INTERPRETER_FREE_TIMER.stop();
            sRegistered = false;
        }
    }

    private static void startWhosQueryForNewObserver(WorkspaceObserver workspaceObserver) {
        MatlabWorkspaceListener.waitForInterpreterForWhos(workspaceObserver, WorkspaceChange.getArrayAllInstance());
    }

    private static void startWhosQueryForTimer() {
        if (MatlabWorkspaceListener.hasRecordedReceipts()) {
            WorkspaceLog.println("MatlabWorkspaceListener: starting WHOS request timer");
            boolean bl = sReceivedAdd;
            sReceivedAdd = false;
            boolean bl2 = sReceivedArrayAll;
            sReceivedArrayAll = false;
            boolean bl3 = sReceivedArrayChange;
            sReceivedArrayChange = false;
            boolean bl4 = sReceivedClear;
            sReceivedClear = false;
            boolean bl5 = sReceivedDelete;
            sReceivedDelete = false;
            boolean bl6 = sReceivedScope;
            sReceivedScope = false;
            boolean bl7 = sReceivedFake;
            sReceivedFake = false;
            if (bl7) {
                bl3 = true;
            }
            sReceivedANYTHING = false;
            WorkspaceChange workspaceChange = WorkspaceChange.getInstance(bl, bl2, bl3, bl4, bl5, bl6);
            if (bl7) {
                workspaceChange.setUndoTrigger(false);
            }
            MatlabWorkspaceListener.waitForInterpreterForWhos(null, workspaceChange);
        }
    }

    private static void recordReceiptOfType(int n) {
        if (sSuspended) {
            WorkspaceLog.println("MatlabWorkspaceListener: ignoring: " + WorkspaceCommands.getEventNameFromCode(n));
            return;
        }
        String string = WorkspaceCommands.getEventNameFromCode(n);
        if (n == 0x8000001) {
            string = "FAKE_WS_ARRAY_CHANGE";
        }
        WorkspaceLog.println("MatlabWorkspaceListener: receiving: " + string);
        if (WORKSPACE_CHANGE_TIMER.isRunning()) {
            WORKSPACE_CHANGE_TIMER.setDelay(160);
        }
        WORKSPACE_CHANGE_TIMER.restart();
        switch (n) {
            case 0x40000000: {
                sReceivedAdd = true;
                break;
            }
            case 0x10000000: {
                sReceivedDelete = true;
                break;
            }
            case 0x20000000: {
                sReceivedClear = true;
                break;
            }
            case 1: {
                sReceivedArrayAll = true;
                break;
            }
            case 0x8000000: {
                sReceivedArrayChange = true;
                break;
            }
            case -2147483648: {
                sReceivedScope = true;
                break;
            }
            case 0x8000001: {
                sReceivedFake = true;
                break;
            }
            default: {
                System.err.println("MatlabWorkspaceListener: Unknown switch case.");
            }
        }
        sReceivedANYTHING = true;
    }

    public static void workspaceChangeTimerCallback() {
        WORKSPACE_CHANGE_TIMER.setDelay(80);
        MatlabWorkspaceListener.startWhosQueryForTimer();
    }

    private static boolean hasRecordedReceipts() {
        return sReceivedANYTHING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getWaitingForWhosCount() {
        Object object = WHOS_COUNT_LOCK;
        synchronized (object) {
            return sWaitingForWhosCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean incrementAndCheckWaitingForWhosCount() {
        boolean bl = true;
        Object object = WHOS_COUNT_LOCK;
        synchronized (object) {
            if (++sWaitingForWhosCount > 10) {
                bl = false;
            }
        }
        return bl;
    }

    private static void waitForInterpreterForWhos(WorkspaceObserver workspaceObserver, WorkspaceChange workspaceChange) {
        sPreviousWorkspaceChange = workspaceChange.merge(sPreviousWorkspaceChange);
        if (MatlabWorkspaceListener.incrementAndCheckWaitingForWhosCount()) {
            ++sPostWhosRequestCount;
            if (Matlab.isMatlabAvailable()) {
                WorkspaceMCRProvider.getMCRForWorkspaceRefresh().eval(";", (CompletionObserver)new InterpreterObserver(new WhosObserver(workspaceObserver, sPreviousWorkspaceChange)));
            }
        }
    }

    protected static void resetPostWhosRequestCount() {
        sPostWhosRequestCount = 0;
    }

    protected static int getPostWhosRequestCount() {
        return sPostWhosRequestCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void resetWaitingForWhosCount() {
        Object object = WHOS_COUNT_LOCK;
        synchronized (object) {
            sWaitingForWhosCount = 0;
        }
    }

    protected static void startWhosQuery() {
        WorkspaceLog.println("MatlabWorkspaceListener: receiving: startWhosQuery request");
        MatlabWorkspaceListener.reportWSChange();
    }

    private static void doWSChangeReport() {
        if (sSuspended) {
            return;
        }
        if (!sChangeReportPending) {
            return;
        }
        sChangeReportPending = false;
        MatlabWorkspaceListener.recordReceiptOfType(0x8000001);
    }

    public static void reportWSChange() {
        if (sChangeReportPending) {
            return;
        }
        sChangeReportPending = true;
        MatlabWorkspaceListener.doWSChangeReport();
    }

    private static void notifyListeners(WorkspaceObserver workspaceObserver, WorkspaceChange workspaceChange) {
        WorkspaceLog.println("MatlabWorkspaceListener: notifying any listeners: " + workspaceChange.toString());
        if (workspaceObserver != null) {
            workspaceObserver.workspaceUpdate(workspaceChange, sWhosInformation);
        } else {
            Iterator<WeakReference<WorkspaceObserver>> iterator = sWorkspaceObservers.iterator();
            while (iterator.hasNext()) {
                WeakReference<WorkspaceObserver> weakReference = iterator.next();
                if (weakReference.get() != null) {
                    ((WorkspaceObserver)weakReference.get()).workspaceUpdate(workspaceChange, sWhosInformation);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private static class WhosObserver
    implements CompletionObserver {
        private WorkspaceObserver fCO;
        private WorkspaceChange fWC;

        WhosObserver(WorkspaceObserver workspaceObserver, WorkspaceChange workspaceChange) {
            this.fCO = workspaceObserver;
            this.fWC = workspaceChange;
        }

        public void completed(int n, Object object) {
            if (object instanceof String) {
                ArrayDialog.showErrorDialog((String)object);
                return;
            }
            sWhosInformation = (WhosInformation)object;
            WorkspaceLog.println("MatlabWorkspaceListener: received " + sWhosInformation + " from MATLAB");
            MatlabWorkspaceListener.notifyListeners(this.fCO, this.fWC);
        }
    }

    private static class InterpreterFreeTimerCallback
    implements ActionListener {
        private InterpreterFreeTimerCallback() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            assert (Matlab.isMatlabAvailable()) : "Timer should not be running in unit tests - refactor if desired.";
            WorkspaceLog.println("MatlabWorkspaceListener: requesting WHOS information from MATLAB");
            WhosObserver whosObserver = sLatestWhosObserver;
            sLatestWhosObserver = null;
            sPreviousWorkspaceChange = null;
            WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("eval", (Object[])new String[]{"workspacefunc('getwhosinformation', builtin('whos'));", "lasterr"}, 1, (CompletionObserver)whosObserver);
        }
    }

    private static class InterpreterObserver
    implements CompletionObserver {
        private WhosObserver iWO;

        InterpreterObserver(WhosObserver whosObserver) {
            this.iWO = whosObserver;
        }

        public void completed(int n, Object object) {
            MatlabWorkspaceListener.resetWaitingForWhosCount();
            sLatestWhosObserver = this.iWO;
            INTERPRETER_FREE_TIMER.restart();
        }
    }

    private static class LocalWorkspaceEventObserver
    implements CompletionObserver {
        private int fType;

        LocalWorkspaceEventObserver(int n) {
            this.fType = n;
        }

        public void completed(int n, Object object) {
            MatlabWorkspaceListener.recordReceiptOfType(this.fType);
        }
    }

    private static class WorkspaceChangeTimerCallback
    implements ActionListener {
        private WorkspaceChangeTimerCallback() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MatlabWorkspaceListener.workspaceChangeTimerCallback();
        }
    }
}

