/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.guiutil;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.testmeas.guiutil.EditTextFieldTableCellEditor;
import com.mathworks.toolbox.testmeas.guiutil.TMFileDialog;
import com.mathworks.toolbox.testmeas.guiutil.TMHelpViewer;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public abstract class ObjectExporter
extends JPanel
implements ActionListener,
Runnable {
    private static ResourceBundle RES = ResourceBundle.getBundle("com.mathworks.toolbox.testmeas.guiutil.resources.RES_ObjectExporter");
    private static final String ACTION = "ACTION";
    private static final int EXPORT = 0;
    private static final int CLOSE = 1;
    private static final int HELP = 2;
    private static final int MATLAB_WORKSPACE = 0;
    private static final int M_FILE = 1;
    private static final int MAT_FILE = 2;
    private static final String[] destinations = new String[]{RES.getString("combobox.MATLAB_Workspace"), RES.getString("combobox.MFile"), RES.getString("combobox.MATFile")};
    public static String directoryName = "";
    private String filename;
    private ExportTableModel model;
    private Object[][] data;
    private String[] columnNames = new String[]{" ", RES.getString("table.column1"), RES.getString("table.column2"), RES.getString("table.column3")};
    private JComboBox destinationComboBox;
    private MJDialog dialog;
    private MJFrame exporterFrame;
    private Object[] matlabArgs;
    private Vector<Object> allObjects = new Vector();

    public abstract Object[][] defineTableData();

    public abstract String getGatewayFunction();

    public abstract String getCallbackFunction();

    public abstract Vector<Object> defineObjects();

    public abstract String getHelpDirectory();

    public abstract String getHelpFile();

    public abstract String getHelpTitle();

    public void layoutPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(10, 4, 4, 4));
        this.add((Component)this.createDestinationPanel(), "North");
        this.add((Component)this.createTablePanel(), "Center");
        this.add((Component)this.createButtonPanel(), "South");
    }

    private JPanel createDestinationPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.destinationComboBox = new JComboBox<String>(destinations);
        this.destinationComboBox.setSelectedItem(RES.getString("combobox.MATLAB_Workspace"));
        this.destinationComboBox.setName("Destination Combobox");
        jPanel.add((Component)new JLabel(RES.getString("combobox.label")), "West");
        jPanel.add((Component)this.destinationComboBox, "Center");
        return jPanel;
    }

    private JPanel createTablePanel() {
        this.data = this.defineTableData();
        this.allObjects = this.defineObjects();
        JPanel jPanel = new JPanel(new BorderLayout(0, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel.add((Component)new JLabel(RES.getString("table.title")), "North");
        this.model = new ExportTableModel();
        ExportTable exportTable = new ExportTable(this.model);
        exportTable.setName("Export Table");
        JScrollPane jScrollPane = new JScrollPane(exportTable);
        jPanel.add((Component)jScrollPane, "Center");
        JTableHeader jTableHeader = exportTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        exportTable.setSelectionMode(0);
        exportTable.getColumnModel().getColumn(0).setPreferredWidth(10);
        exportTable.getColumnModel().getColumn(1).setPreferredWidth(45);
        exportTable.getColumnModel().getColumn(2).setPreferredWidth(125);
        exportTable.getColumnModel().getColumn(3).setPreferredWidth(85);
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 0));
        JButton jButton = new JButton(RES.getString("button.export"));
        jButton.addActionListener(this);
        jButton.setMnemonic(69);
        jButton.putClientProperty(ACTION, new Integer(0));
        jButton.setName("Export Button");
        JButton jButton2 = new JButton(RES.getString("button.close"));
        jButton2.addActionListener(this);
        jButton2.setMnemonic(67);
        jButton2.putClientProperty(ACTION, new Integer(1));
        jButton2.setName("Close Button");
        JButton jButton3 = new JButton(RES.getString("button.help"));
        jButton3.setMnemonic(72);
        jButton3.addActionListener(this);
        jButton3.putClientProperty(ACTION, new Integer(2));
        jButton3.setName("Help button");
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public int getNumberOfColumns() {
        return this.columnNames.length;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                if (!this.okToExport()) {
                    return;
                }
                int n2 = this.destinationComboBox.getSelectedIndex();
                if (n2 != 0) {
                    this.createSaveDialog(n2);
                    if (this.filename == null) {
                        return;
                    }
                }
                this.export(n2);
                this.saveOptions();
                this.dialog.dispose();
                break;
            }
            case 1: {
                this.dialog.dispose();
                break;
            }
            case 2: {
                TMHelpViewer tMHelpViewer = TMHelpViewer.getInstance();
                tMHelpViewer.update(this.getHelpDirectory(), this.getHelpFile(), this.getHelpTitle());
                tMHelpViewer.addToDialog();
            }
        }
    }

    public void saveOptions() {
    }

    private void export(int n) {
        switch (n) {
            case 0: {
                this.matlabArgs = new Object[3];
                this.matlabArgs[0] = this.getCallbackFunction();
                this.matlabArgs[1] = "workspace";
                this.matlabArgs[2] = this.getSelectedInfo();
                break;
            }
            case 2: {
                this.matlabArgs = new Object[4];
                this.matlabArgs[0] = this.getCallbackFunction();
                this.matlabArgs[1] = "mat-file";
                this.matlabArgs[2] = this.filename;
                this.matlabArgs[3] = this.getSelectedInfo();
                break;
            }
            case 1: {
                this.matlabArgs = new Object[4];
                this.matlabArgs[0] = this.getCallbackFunction();
                this.matlabArgs[1] = "matlab code file";
                this.matlabArgs[2] = this.filename;
                this.matlabArgs[3] = this.getSelectedInfo();
            }
        }
        Matlab.whenMatlabReady((Runnable)this);
    }

    private boolean okToExport() {
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < this.data.length; ++i) {
            if (!((Boolean)this.data[i][0]).booleanValue()) continue;
            if (vector.contains(this.data[i][3]) && !vector2.contains(this.data[i][3])) {
                int n = TMStringUtil.confirm(this.exporterFrame, RES.getString("duplicateVariable.title"), RES.getString("duplicateVariable.string1") + this.data[i][3] + RES.getString("duplicateVariable.string2"));
                switch (n) {
                    case 0: {
                        vector2.addElement(this.data[i][3]);
                        break;
                    }
                    case 1: {
                        return false;
                    }
                }
                continue;
            }
            vector.addElement(this.data[i][3]);
        }
        vector = null;
        vector2 = null;
        return true;
    }

    private Vector<Object> getSelectedInfo() {
        int n = this.model.getRowCount();
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < n; ++i) {
            if (!((Boolean)this.data[i][0]).booleanValue()) continue;
            vector.addElement(this.data[i][3]);
            vector.addElement(this.allObjects.elementAt(i));
        }
        return vector;
    }

    @Override
    public void run() {
        try {
            Matlab.mtFeval((String)this.getGatewayFunction(), (Object[])this.matlabArgs, (int)0);
        }
        catch (Exception exception) {
            System.out.println("Exporter Exception: " + exception.getMessage());
        }
    }

    private void createSaveDialog(int n) {
        TMFileDialog tMFileDialog = null;
        String string = "untitled";
        switch (n) {
            case 1: {
                tMFileDialog = new TMFileDialog(RES.getString("savedialog.MFileTitle"), 1);
                string = string + ".m";
                break;
            }
            case 2: {
                tMFileDialog = new TMFileDialog(RES.getString("savedialog.MATFileTitle"), 0);
                string = string + ".mat";
            }
        }
        if (!directoryName.equals("")) {
            tMFileDialog.setCurrentDirectory(new File(directoryName));
        }
        tMFileDialog.setSelectedFile(new File(string));
        tMFileDialog.showSaveDialog((Component)this.exporterFrame);
        if (tMFileDialog.getState() == 0) {
            int n2;
            File file = tMFileDialog.getSelectedFile();
            directoryName = tMFileDialog.getCurrentDirectory().getAbsolutePath();
            this.filename = file.getPath();
            if (this.filename.indexOf(".") == -1) {
                switch (n) {
                    case 1: {
                        if (!new File(this.filename + ".m").exists()) break;
                        int n3 = TMStringUtil.confirm(this.exporterFrame, RES.getString("saveconfirmdialog.title"), RES.getString("saveconfirmdialog.file") + file.getName() + ".m " + RES.getString("saveconfirmdialog.overwrite"));
                        if (n3 == 0) {
                            this.filename = this.filename + ".m";
                            break;
                        }
                        this.filename = null;
                        break;
                    }
                    case 2: {
                        if (!new File(this.filename + ".mat").exists()) break;
                        int n4 = TMStringUtil.confirm(this.exporterFrame, RES.getString("saveconfirmdialog.title"), RES.getString("saveconfirmdialog.file") + file.getName() + ".mat " + RES.getString("saveconfirmdialog.overwrite"));
                        this.filename = n4 == 0 ? this.filename + ".mat" : null;
                    }
                }
            } else if (file.exists() && (n2 = TMStringUtil.confirm(this.exporterFrame, RES.getString("saveconfirmdialog.title"), RES.getString("saveconfirmdialog.file") + file.getName() + RES.getString("saveconfirmdialog.overwrite"))) != 0) {
                this.filename = null;
            }
        } else {
            this.filename = null;
        }
    }

    public Dimension getDialogSize() {
        return new Dimension(404, 451);
    }

    public void showAsDialog(MJFrame mJFrame) {
        this.exporterFrame = mJFrame;
        this.dialog = new MJDialog((Frame)mJFrame, RES.getString("dialog.title"), true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getContentPane().add(this);
        Dimension dimension = this.getDialogSize();
        this.dialog.setSize((int)dimension.getWidth(), (int)dimension.getHeight());
        Point point = mJFrame.getLocation();
        this.dialog.setLocation(point.x, point.y);
        this.dialog.show();
    }

    public class ExportTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return ObjectExporter.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (ObjectExporter.this.data == null) {
                return 0;
            }
            return ObjectExporter.this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return ObjectExporter.this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return ObjectExporter.this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ((ObjectExporter)ObjectExporter.this).data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 3 || n2 == 0;
        }
    }

    public class ExportTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public ExportTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == ObjectExporter.this.columnNames.length - 1) {
                EditTextFieldTableCellEditor editTextFieldTableCellEditor = new EditTextFieldTableCellEditor(ObjectExporter.this.model, new JTextField(), n, n2);
                editTextFieldTableCellEditor.checkForValidVariableName(ObjectExporter.this.exporterFrame);
                return editTextFieldTableCellEditor;
            }
            return super.getCellEditor(n, n2);
        }
    }
}

