/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.propertyeditor;

import com.mathworks.toolbox.testmeas.propertyeditor.Constraint;
import com.mathworks.toolbox.testmeas.propertyeditor.ConstraintValues;
import com.mathworks.toolbox.testmeas.propertyeditor.PropertyType;
import com.mathworks.toolbox.testmeas.propertyeditor.ReadStatus;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;

public class Property {
    private String fName = "";
    private PropertyType fType = PropertyType.STRING;
    private Constraint fConstraint = Constraint.NONE;
    private ConstraintValues fConstraintInfo = new ConstraintValues();
    private ReadStatus fReadStatus = ReadStatus.WRITABLE;
    private Object fValue = "";
    private Object fDefaultValue = "";
    private boolean isMatrix = false;
    private StringBuilder fHelp = new StringBuilder();
    private boolean fIsInfinityValid = false;
    private String fUserFriendlyLabel = "";
    private PropertyChangeSupport fPropertyChangeSupport = new PropertyChangeSupport(this);
    private boolean isBeingEdited = false;
    public static final String VALUE_PROP = "value";

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        this.fName = string;
    }

    public PropertyType getType() {
        return this.fType;
    }

    public void setType(PropertyType propertyType) {
        this.fType = propertyType;
    }

    public Constraint getConstraint() {
        return this.fConstraint;
    }

    public void setConstraint(Constraint constraint) {
        this.fConstraint = constraint;
    }

    public ReadStatus getReadStauts() {
        return this.fReadStatus;
    }

    public void setReadStatus(ReadStatus readStatus) {
        this.fReadStatus = readStatus;
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(final Object object) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setValueEDT(object);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Property.this.setValueEDT(object);
                }
            });
        }
    }

    private void setValueEDT(Object object) {
        assert (SwingUtilities.isEventDispatchThread()) : "set should be invoked on EDT!";
        String string = "i";
        if (string.equals(this.fValue)) {
            string = "I";
        }
        this.fValue = object;
        this.fPropertyChangeSupport.firePropertyChange(VALUE_PROP, string, this.fValue);
    }

    public Object getDefaultValue() {
        return this.fDefaultValue;
    }

    public void setDefaultValue(Object object) {
        this.fDefaultValue = this.fType == PropertyType.STRING && object == null ? "" : object;
    }

    public ConstraintValues getConstraintValues() {
        return this.fConstraintInfo;
    }

    public void setConstraintValues(ConstraintValues constraintValues) {
        this.fConstraintInfo = constraintValues;
    }

    public StringBuilder getHelp() {
        return this.fHelp;
    }

    public void setHelp(String string) {
        if (this.fHelp.length() > 0) {
            this.fHelp.delete(0, this.fHelp.length());
        }
        this.fHelp.append(string);
    }

    public String getUserFriendlyLabel() {
        return this.fUserFriendlyLabel;
    }

    public void setUserFriendlyLabel(String string) {
        this.fUserFriendlyLabel = string;
    }

    public boolean isMatrix() {
        return this.isMatrix;
    }

    public void setMatrix(boolean bl) {
        this.isMatrix = bl;
    }

    public boolean isInfinityValid() {
        return this.fIsInfinityValid;
    }

    public void setIsInfinityValid(boolean bl) {
        this.fIsInfinityValid = bl;
    }

    public boolean isNumeric() {
        return this.getType() == PropertyType.DOUBLE || this.getType() == PropertyType.INTEGER;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public boolean isBeingEdited() {
        return this.isBeingEdited;
    }

    public void setBeingEdited(boolean bl) {
        this.isBeingEdited = bl;
    }
}

