/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.toolstrip;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.text.EditorKit;

public final class CodeViewer {
    private final SyntaxTextPane fMatlabTextPane;
    private final MJScrollPane fMatlabTextPaneScroller;
    private final MJPanel fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));

    public CodeViewer() {
        this.fMatlabTextPane = new SyntaxTextPane();
        this.fMatlabTextPane.setEditable(false);
        MKit mKit = new MKit(){

            public String getContentType() {
                return MLanguage.INSTANCE.getMimeType();
            }
        };
        this.fMatlabTextPane.registerEditorKit(MLanguage.INSTANCE.getMimeType(), (EditorKit)mKit);
        this.fMatlabTextPane.setContentType(MLanguage.INSTANCE.getMimeType());
        this.fMatlabTextPane.setSyntaxHighlightingEnabled(MLanguage.INSTANCE, true);
        this.fMatlabTextPane.setShowLineNumbers(false, false);
        this.fMatlabTextPane.setContextMenuEnabled(true, false);
        this.fMatlabTextPane.setShowRightMargin(false, false);
        this.fMatlabTextPaneScroller = new MJScrollPane((Component)this.fMatlabTextPane);
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void displayFile(File file) {
        if (file != null) {
            this.fComponent.removeAll();
            this.fMatlabTextPane.setCaretPosition(0);
            try {
                this.fMatlabTextPane.setText(FileSystemUtils.readText((FileSystemEntry)RealFileSystem.getInstance().getEntry(new FileLocation(file))));
                this.fMatlabTextPane.setCaretPosition(0);
                this.fComponent.add((Component)this.fMatlabTextPaneScroller, (Object)"Center");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }
}

