/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xom;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Value;
import net.sf.saxon.xom.DocumentWrapper;
import nu.xom.Document;
import nu.xom.Node;

public class XOMObjectModel
implements ExternalObjectModel,
Serializable {
    public boolean isRecognizedNode(Object object) {
        return object instanceof Node;
    }

    public boolean isRecognizedNodeClass(Class nodeClass) {
        return Node.class.isAssignableFrom(nodeClass);
    }

    public boolean isRecognizedNodeListClass(Class nodeClass) {
        return false;
    }

    public Receiver getDocumentBuilder(Result result) {
        return null;
    }

    public boolean sendSource(Source source, Receiver receiver, PipelineConfiguration pipe) throws XPathException {
        return false;
    }

    public NodeInfo unravel(Source source, Configuration config) {
        return null;
    }

    public Value convertObjectToXPathValue(Object object, Configuration config) throws XPathException {
        if (object instanceof Node) {
            return new SingletonNode(this.wrapNode((Node)object, config));
        }
        if (object instanceof Node[]) {
            NodeInfo[] nodes = new NodeInfo[((Node[])object).length];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = this.wrapNode(((Node[])object)[i], config);
            }
            return new SequenceExtent((Item[])nodes);
        }
        return null;
    }

    private synchronized NodeInfo wrapNode(Node node, Configuration config) {
        return new DocumentWrapper((Node)node.getDocument(), "", config).wrap(node);
    }

    public Object convertXPathValueToObject(Value value, Class targetClass, XPathContext context) throws XPathException {
        Item item;
        boolean allowXOM;
        boolean requireXOM = Node.class.isAssignableFrom(targetClass) || targetClass.isArray() && Node.class.isAssignableFrom(targetClass.getComponentType());
        boolean bl = targetClass == Object.class || targetClass.isAssignableFrom(ArrayList.class) || targetClass.isAssignableFrom(HashSet.class) || targetClass.isArray() && targetClass.getComponentType() == Object.class ? true : (allowXOM = false);
        if (!requireXOM && !allowXOM) {
            return null;
        }
        ArrayList<Object> nodes = new ArrayList<Object>(20);
        SequenceIterator iter = value.iterate();
        while ((item = iter.next()) != null) {
            if (item instanceof VirtualNode) {
                Object o = ((VirtualNode)item).getUnderlyingNode();
                if (o instanceof Node) {
                    nodes.add(o);
                    continue;
                }
                if (!requireXOM) continue;
                XPathException err = new XPathException("Extension function required class " + targetClass.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
                throw err;
            }
            if (requireXOM) {
                XPathException err = new XPathException("Extension function required class " + targetClass.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
                throw err;
            }
            return null;
        }
        if (nodes.size() == 0 && !requireXOM) {
            return null;
        }
        if (Node.class.isAssignableFrom(targetClass)) {
            if (nodes.size() != 1) {
                XPathException err = new XPathException("Extension function requires a single XOM Node; supplied value contains " + nodes.size() + " nodes");
                throw err;
            }
            return nodes.get(0);
        }
        if (targetClass.isArray() && Node.class.isAssignableFrom(targetClass.getComponentType())) {
            Node[] array = (Node[])Array.newInstance(targetClass.getComponentType(), nodes.size());
            nodes.toArray(array);
            return array;
        }
        if (targetClass.isAssignableFrom(ArrayList.class)) {
            return nodes;
        }
        if (targetClass.isAssignableFrom(HashSet.class)) {
            return new HashSet(nodes);
        }
        return null;
    }

    public DocumentInfo wrapDocument(Object node, String baseURI, Configuration config) {
        Document documentNode = ((Node)node).getDocument();
        return new DocumentWrapper((Node)documentNode, baseURI, config);
    }

    public NodeInfo wrapNode(DocumentInfo document, Object node) {
        if (!(node instanceof Node)) {
            throw new IllegalArgumentException("Object to be wrapped is not a XOM Node: " + node.getClass());
        }
        return ((DocumentWrapper)document).wrap((Node)node);
    }

    public Object convertToNodeList(SequenceExtent extent) {
        return null;
    }
}

