/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlPanelSupport;
import com.mathworks.html.HtmlPanelSupportFactory;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.StatusTextListener;
import com.mathworks.html.jxbrowser.JxBrowserPanel;
import com.teamdev.jxbrowser.Browser;
import java.awt.Component;
import javax.swing.SwingUtilities;

public class JxBrowserFactory
implements HtmlPanelSupportFactory {
    private final Browser fBrowser;
    private Component fBrowserComponent;
    private HtmlPanelSupportFactory.ComponentCreatedListener fCreatedListener;

    public JxBrowserFactory() {
        this(null);
    }

    JxBrowserFactory(Browser browser) {
        this.fBrowser = browser;
    }

    @Override
    public HtmlPanelSupport buildSupport(PageChangedListener pageChangedListener, StatusTextListener statusTextListener) {
        final JxBrowserPanel jxBrowserPanel = this.createJxBrowserPanel(pageChangedListener, statusTextListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JxBrowserFactory.this.setBrowserComponent(jxBrowserPanel.getComponent());
            }
        });
        return jxBrowserPanel;
    }

    private JxBrowserPanel createJxBrowserPanel(PageChangedListener pageChangedListener, StatusTextListener statusTextListener) {
        if (this.fBrowser == null) {
            return new JxBrowserPanel(pageChangedListener, statusTextListener);
        }
        return new JxBrowserPanel(this.fBrowser, pageChangedListener, statusTextListener);
    }

    private synchronized void setBrowserComponent(Component component) {
        if (this.fCreatedListener != null) {
            this.fCreatedListener.panelCreated(component);
            this.fCreatedListener = null;
        } else {
            this.fBrowserComponent = component;
        }
    }

    @Override
    public synchronized void doWhenPanelCreated(HtmlPanelSupportFactory.ComponentCreatedListener componentCreatedListener) {
        if (this.fBrowserComponent == null) {
            this.fCreatedListener = componentCreatedListener;
        } else {
            componentCreatedListener.panelCreated(this.fBrowserComponent);
            this.fBrowserComponent = null;
        }
    }
}

