/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CharsetDetectionStrategy;
import com.mathworks.html.EncodingUtils;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlFileWriter;
import com.mathworks.html.HtmlFindInPage;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.HtmlPanelContextMenuHandler;
import com.mathworks.html.HtmlPanelSupport;
import com.mathworks.html.HtmlSourceReader;
import com.mathworks.html.HtmlUtils;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.PopupWindowListener;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.StatusTextChangedEvent;
import com.mathworks.html.StatusTextListener;
import com.mathworks.html.jxbrowser.AggregateNewWindowManager;
import com.mathworks.html.jxbrowser.AggregateWebPolicyDelegate;
import com.mathworks.html.jxbrowser.BrowserBuilder;
import com.mathworks.html.jxbrowser.BrowserTypeConfig;
import com.mathworks.html.jxbrowser.CompoundPrintStrategy;
import com.mathworks.html.jxbrowser.DefaultHtmlTextWriter;
import com.mathworks.html.jxbrowser.DesktopPrintStrategy;
import com.mathworks.html.jxbrowser.HtmlTextWriter;
import com.mathworks.html.jxbrowser.IEConfig;
import com.mathworks.html.jxbrowser.JxBrowserPopupHandler;
import com.mathworks.html.jxbrowser.JxBrowserProxyBridge;
import com.mathworks.html.jxbrowser.JxBrowserScriptTask;
import com.mathworks.html.jxbrowser.JxBrowserSelectionListener;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.mathworks.html.jxbrowser.JxBrowserSwingWorker;
import com.mathworks.html.jxbrowser.MWContextMenuHandler;
import com.mathworks.html.jxbrowser.MWPromptService;
import com.mathworks.html.jxbrowser.MozillaConfig;
import com.mathworks.html.jxbrowser.NavigationFinishedListener;
import com.mathworks.html.jxbrowser.PrintStrategy;
import com.mathworks.html.jxbrowser.RequestHandlerPolicyDelegate;
import com.mathworks.html.jxbrowser.SafariConfig;
import com.mathworks.html.jxbrowser.SelectionListener;
import com.mathworks.html.jxbrowser.StreamingTextHandler;
import com.mathworks.html.jxbrowser.SystemBrowserPrintStrategy;
import com.mathworks.html.jxbrowser.TextUrlRequestHandler;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserServices;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.ContextMenuHandler;
import com.teamdev.jxbrowser.NewWindowManager;
import com.teamdev.jxbrowser.WebPolicyDelegate;
import com.teamdev.jxbrowser.events.NavigationListener;
import com.teamdev.jxbrowser.events.StatusChangedEvent;
import com.teamdev.jxbrowser.events.StatusListener;
import com.teamdev.jxbrowser.prompt.PromptService;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;

public class JxBrowserPanel
implements HtmlPanelSupport {
    private static boolean sInitialized = false;
    private final JxBrowserSwingComponent fPanel;
    private final Browser fBrowser;
    private final BrowserTypeConfig fBrowserConfig;
    private final StreamingTextHandler fTextHandler;
    private final PrintStrategy fPrintStrategy;
    private final AggregateWebPolicyDelegate fAggregateDelegate;
    private final AggregateNewWindowManager fAggregateWindowManager;
    private final SelectionListener fSelectionListener;
    private final RequestHandlerPolicyDelegate fRequestHandlerDelegate = new RequestHandlerPolicyDelegate();
    private boolean fDisposed = false;

    private static void disableJxBrowserLogging() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"com.jniwrapper", "com.teamdev"}) {
            Logger logger = Logger.getLogger((String)string);
            logger.addAppender((Appender)new NullAppender());
            logger.setLevel(Level.OFF);
        }
    }

    private static synchronized void initOnce() {
        if (!sInitialized) {
            JxBrowserProxyBridge.init();
            sInitialized = true;
        }
    }

    public JxBrowserPanel(PageChangedListener pageChangedListener, StatusTextListener statusTextListener) {
        this(BrowserBuilder.createBrowser(), pageChangedListener, statusTextListener);
    }

    public JxBrowserPanel(Browser browser, PageChangedListener pageChangedListener, StatusTextListener statusTextListener) {
        this(browser, new DefaultBrowserConfigurator(browser, pageChangedListener, statusTextListener));
    }

    public JxBrowserPanel(Browser browser, BrowserConfigurator browserConfigurator) {
        this.fBrowser = browser;
        JxBrowserPanel.initOnce();
        JxBrowserSwingComponent jxBrowserSwingComponent = new JxBrowserSwingComponent(browser);
        Component component = browser.getComponent();
        jxBrowserSwingComponent.add(component, "Center");
        this.fPanel = jxBrowserSwingComponent;
        component.addFocusListener(new JxBrowserFocusAdapter());
        this.fBrowserConfig = browserConfigurator.getBrowserTypeConfig();
        this.fAggregateDelegate = browserConfigurator.getPolicyDelegate();
        this.fAggregateWindowManager = browserConfigurator.getNewWindowManager();
        HtmlTextWriter htmlTextWriter = browserConfigurator.getHtmlTextWriter(this);
        this.fTextHandler = new StreamingTextHandler(browser, htmlTextWriter);
        this.fTextHandler.setFileDir(HtmlPanel.getResourceDirectory());
        this.fPrintStrategy = JxBrowserPanel.getPrintStrategy();
        this.fAggregateDelegate.addDelegate(browser, this.fTextHandler);
        this.addRequestHandler(new TextUrlRequestHandler(this, this.fTextHandler));
        this.fAggregateDelegate.addDelegate(browser, this.fRequestHandlerDelegate);
        this.fSelectionListener = browserConfigurator.createSelectionListener(this);
        browserConfigurator.configureBrowser(this);
    }

    @Override
    public HtmlPanel.BrowserType getBrowserType() {
        return HtmlPanel.BrowserType.JXBROWSER;
    }

    @Override
    public JxBrowserSwingComponent getComponent() {
        return this.fPanel;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public void setCurrentLocation(String string) {
        this.setCurrentLocation(string, BrowserRequest.Origin.SET_LOCATION);
    }

    @Override
    public void setHtmlText(String string) {
        if (!this.isDisposed()) {
            String string2 = this.fTextHandler.getHtmlTextUrl(string);
            this.setCurrentLocation(string2, BrowserRequest.Origin.SET_HTML_TEXT);
        }
    }

    private void setCurrentLocation(String string, BrowserRequest.Origin origin) {
        if (!this.isDisposed()) {
            string = HtmlUtils.correctUrl(string);
            this.fRequestHandlerDelegate.setPendingRequest(string, origin);
            this.fBrowser.navigate(string);
        }
    }

    @Override
    public String getCurrentLocation() {
        return this.isDisposed() ? null : this.fBrowser.getCurrentLocation();
    }

    @Override
    public String getTitle() {
        return this.isDisposed() ? null : this.fBrowser.getTitle();
    }

    @Override
    public void executeScript(String string, HtmlDataListener<String> htmlDataListener) {
        if (!this.isDisposed()) {
            JxBrowserScriptTask jxBrowserScriptTask = new JxBrowserScriptTask(this.fBrowser, string);
            new JxBrowserSwingWorker<String>(jxBrowserScriptTask, htmlDataListener).execute();
        }
    }

    @Override
    public boolean canGoBack() {
        return !this.isDisposed() && this.fBrowser.canGoBack();
    }

    @Override
    public void goBack() {
        if (!this.isDisposed()) {
            this.fRequestHandlerDelegate.setPendingRequest(null, BrowserRequest.Origin.GO_BACK);
            this.fBrowser.goBack();
        }
    }

    @Override
    public boolean canGoForward() {
        return !this.isDisposed() && this.fBrowser.canGoForward();
    }

    @Override
    public void goForward() {
        if (!this.isDisposed()) {
            this.fRequestHandlerDelegate.setPendingRequest(null, BrowserRequest.Origin.GO_FORWARD);
            this.fBrowser.goForward();
        }
    }

    @Override
    public void reload() {
        if (!this.isDisposed()) {
            this.fRequestHandlerDelegate.setPendingRequest(null, BrowserRequest.Origin.REFRESH);
            this.fBrowser.refresh();
        }
    }

    @Override
    public String getSelectedText() {
        return this.fSelectionListener.getCurrentSelection();
    }

    @Override
    public void addSelectedTextListener(HtmlDataListener<String> htmlDataListener) {
        this.fSelectionListener.addSelectionListener(htmlDataListener);
    }

    @Override
    public void removeSelectedTextListener(HtmlDataListener<String> htmlDataListener) {
        this.fSelectionListener.removeSelectionListener(htmlDataListener);
    }

    @Override
    public String getHtmlText() {
        if (this.isDisposed()) {
            return null;
        }
        String string = this.getCurrentLocation();
        String string2 = this.fBrowserConfig.getUrlEncodingCharset();
        if (string2 != null) {
            string = EncodingUtils.changeUrlEncoding(string, string2, "UTF-8");
        }
        return this.getSourceForUrl(string);
    }

    protected String getSourceForUrl(String string) {
        return HtmlSourceReader.getSource(string, CharsetDetectionStrategy.getAutoDetectStrategy());
    }

    @Override
    public boolean isPrintingSupported() {
        return true;
    }

    @Override
    public void print() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JxBrowserPanel.this.fPrintStrategy.print(JxBrowserPanel.this);
            }
        };
        new Thread(runnable).start();
    }

    private static PrintStrategy getPrintStrategy() {
        return new CompoundPrintStrategy(new DesktopPrintStrategy(true), new SystemBrowserPrintStrategy());
    }

    @Override
    public void saveAs(File file) {
        if (!this.isDisposed()) {
            new HtmlFileWriter(file, this.getHtmlText(), this.getCurrentLocation(), true).saveFile();
        }
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean bl) {
        this.fDisposed = true;
        if (this.fAggregateDelegate != null) {
            this.fAggregateDelegate.clearBrowserDelegates(this.fBrowser);
        }
        if (this.fTextHandler != null) {
            this.fTextHandler.dispose();
        }
        if (this.fPanel != null) {
            this.fPanel.dispose();
        }
        if (this.fBrowser != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    JxBrowserPanel.this.fBrowser.stop();
                    JxBrowserPanel.this.fBrowser.waitReady();
                    JxBrowserPanel.this.fBrowser.dispose();
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            if (bl) {
                try {
                    thread.join(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setContextMenuHandler(HtmlPanelContextMenuHandler htmlPanelContextMenuHandler) {
        if (!this.isDisposed() && this.fBrowser.getType() != BrowserType.Safari) {
            this.fBrowser.setContextMenuHandler((ContextMenuHandler)new MWContextMenuHandler(htmlPanelContextMenuHandler, this.fPanel));
        }
    }

    @Override
    public void addRequestHandler(RequestHandler requestHandler) {
        if (!this.isDisposed()) {
            this.fRequestHandlerDelegate.addRequestHandler(requestHandler);
        }
    }

    @Override
    public HtmlFindInPage getFindInPage() {
        return this.fBrowserConfig.getFindInPage(this);
    }

    @Override
    public <T extends HtmlActions> void setPopupWindowListener(PopupWindowListener<T> popupWindowListener) {
        if (!this.isDisposed()) {
            this.fAggregateWindowManager.addBrowserWindowManager(this.fBrowser, new JxBrowserPopupHandler<T>(popupWindowListener));
        }
    }

    Browser getBrowser() {
        return this.fBrowser;
    }

    BrowserTypeConfig getBrowserTypeConfig() {
        return this.fBrowserConfig;
    }

    boolean isDisposed() {
        return this.fDisposed;
    }

    AggregateWebPolicyDelegate getWebPolicyDelegate() {
        return this.fAggregateDelegate;
    }

    private RequestHandlerPolicyDelegate getRequestHandlerDelegate() {
        return this.fRequestHandlerDelegate;
    }

    public StreamingTextHandler getStreamingTextHandler() {
        return this.fTextHandler;
    }

    static {
        JxBrowserPanel.disableJxBrowserLogging();
    }

    private class JxBrowserFocusAdapter
    extends FocusAdapter {
        private JxBrowserFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JxBrowserPanel.this.fPanel.revalidate();
            JxBrowserPanel.this.fPanel.repaint();
        }
    }

    private static class StatusTextListenerAdapter
    implements StatusListener {
        private final StatusTextListener iStatusTextListener;

        private StatusTextListenerAdapter(StatusTextListener statusTextListener) {
            this.iStatusTextListener = statusTextListener;
        }

        public void statusChanged(StatusChangedEvent statusChangedEvent) {
            String string = statusChangedEvent.getStatusText();
            if (string != null && EncodingUtils.needsDecoding(string)) {
                string = EncodingUtils.decodeUrl(string);
            }
            this.iStatusTextListener.statusChanged(new StatusTextChangedEvent(string));
        }
    }

    private static class DefaultBrowserConfigurator
    implements BrowserConfigurator {
        private static final AggregateWebPolicyDelegate SHARED_POLICY_DELEGATE = new AggregateWebPolicyDelegate(BrowserServices.getInstance().getWebPolicyDelegate());
        private static final AggregateNewWindowManager SHARED_WINDOW_MANAGER = new AggregateNewWindowManager();
        private final PageChangedListener iPageChangedListener;
        private final StatusTextListener iStatusTextListener;
        private final Browser iBrowser;
        private final BrowserTypeConfig iBrowserTypeConfig;

        private DefaultBrowserConfigurator(Browser browser, PageChangedListener pageChangedListener, StatusTextListener statusTextListener) {
            this.iBrowser = browser;
            this.iPageChangedListener = pageChangedListener;
            this.iStatusTextListener = statusTextListener;
            this.iBrowserTypeConfig = DefaultBrowserConfigurator.createBrowserTypeConfig(browser.getType());
        }

        private static BrowserTypeConfig createBrowserTypeConfig(BrowserType browserType) {
            switch (browserType) {
                case Mozilla: {
                    return new MozillaConfig();
                }
                case IE: {
                    return new IEConfig();
                }
                case Safari: {
                    return new SafariConfig();
                }
            }
            assert (false) : "Unknown browser type: " + browserType;
            return null;
        }

        @Override
        public BrowserTypeConfig getBrowserTypeConfig() {
            return this.iBrowserTypeConfig;
        }

        @Override
        public HtmlTextWriter getHtmlTextWriter(JxBrowserPanel jxBrowserPanel) {
            return new DefaultHtmlTextWriter();
        }

        @Override
        public AggregateWebPolicyDelegate getPolicyDelegate() {
            return SHARED_POLICY_DELEGATE;
        }

        @Override
        public AggregateNewWindowManager getNewWindowManager() {
            return SHARED_WINDOW_MANAGER;
        }

        @Override
        public SelectionListener createSelectionListener(JxBrowserPanel jxBrowserPanel) {
            JxBrowserSelectionListener jxBrowserSelectionListener = new JxBrowserSelectionListener(jxBrowserPanel, jxBrowserPanel.getBrowserTypeConfig());
            jxBrowserPanel.getBrowser().addNavigationListener((NavigationListener)jxBrowserSelectionListener);
            jxBrowserPanel.addRequestHandler(jxBrowserSelectionListener);
            return jxBrowserSelectionListener;
        }

        @Override
        public void configureBrowser(JxBrowserPanel jxBrowserPanel) {
            this.iBrowserTypeConfig.configureBrowser(jxBrowserPanel);
            this.iBrowser.addNavigationListener((NavigationListener)new NavigationFinishedListener(jxBrowserPanel.getStreamingTextHandler(), this.iPageChangedListener));
            this.iBrowser.addStatusListener((StatusListener)new StatusTextListenerAdapter(this.iStatusTextListener));
            this.iBrowser.addNavigationListener((NavigationListener)jxBrowserPanel.getRequestHandlerDelegate());
            jxBrowserPanel.getComponent().initialize();
        }

        private static void configureBrowserServices(BrowserServices browserServices) {
            if (browserServices != null) {
                PromptService promptService = browserServices.getPromptService();
                browserServices.setPromptService((PromptService)new MWPromptService(promptService));
                browserServices.setWebPolicyDelegate((WebPolicyDelegate)SHARED_POLICY_DELEGATE);
                browserServices.setNewWindowManager((NewWindowManager)SHARED_WINDOW_MANAGER);
            }
        }

        static {
            DefaultBrowserConfigurator.configureBrowserServices(BrowserServices.getInstance());
        }
    }

    public static interface BrowserConfigurator {
        public BrowserTypeConfig getBrowserTypeConfig();

        public HtmlTextWriter getHtmlTextWriter(JxBrowserPanel var1);

        public void configureBrowser(JxBrowserPanel var1);

        public AggregateWebPolicyDelegate getPolicyDelegate();

        public AggregateNewWindowManager getNewWindowManager();

        public SelectionListener createSelectionListener(JxBrowserPanel var1);
    }
}

