/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters;

import ice.debug.Debug;
import ice.scripters.FramesList;
import ice.scripters.HistoryObj;
import ice.scripters.LocationObj;
import ice.scripters.NavigatorObj;
import ice.scripters.ScreenObj;
import ice.storm.CallbackAdapter;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Pilot;
import ice.storm.Scripter;
import ice.storm.ScripterCallback;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.storm.ViewportGuiParams;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.Session;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.awt.Component;
import java.util.StringTokenizer;

public final class WindowObj
extends DynamicObject {
    private static final boolean EMPTY_OBJECT_ARRAY = Debug.extra && Defs.booleanProperty((String)"ice.debug.ignore_window_decoration");
    private static final Object J = new Object();
    private static final Object OEAB = new Object();
    private static final Object TRUE = new Object();
    private static final Object Z = new Object();
    private static final int append = WindowObj.getId();
    private int args = 0;
    Object pageTag = new Object();
    final HashArray timerMap = new HashArray();
    StormBase storm;
    Viewport theView;
    WindowObj theOpener;
    String _defaultStatus = "";
    String _currentStatus = "";
    final HistoryObj theHistory = new HistoryObj(this);
    final LocationObj theLocation = new LocationObj(this);
    final FramesList theFrames = new FramesList(this);
    private Object arraycopy = null;
    private Object booleanProperty = null;
    private Object box_allowScriptClose = null;

    public static WindowObj create(StormBase stormBase, Viewport viewport) {
        return new WindowObj(stormBase, viewport);
    }

    public WindowObj(StormBase stormBase, Viewport viewport) {
        this.storm = stormBase;
        this.theView = viewport;
        this.theOpener = (WindowObj)((Object)viewport.getProperty(J));
        this.arraycopy = viewport.getProperty(OEAB);
    }

    public void unlinkAllSlots() {
        if (this.theOpener != null) {
            this.theOpener.box_allowScriptClose = this.booleanProperty;
        }
        this.pageTag = new Object();
        this.timerMap.clear();
        super.unlinkAllSlots();
        this.theHistory.unlinkAllSlots();
        this.theLocation.unlinkAllSlots();
        this.theFrames.unlinkAllSlots();
    }

    public static WindowObj getWindow(Viewport viewport) {
        return (WindowObj)viewport.getWindowObj();
    }

    private boolean EMPTY_OBJECT_ARRAY() {
        boolean bl = false;
        if (this.theView == null) {
            bl = true;
        } else if (this.theView.getTopLevelContainer() == null) {
            bl = true;
        }
        return bl;
    }

    public DynamicObject getDocument() {
        DynamicObject dynamicObject = this.theView.getDocumentObject();
        return dynamicObject;
    }

    public String getName() {
        if (this.theView.isSyntheticName()) {
            return "";
        }
        return this.theView.getName();
    }

    public Viewport getViewport() {
        return this.theView;
    }

    public WindowObj getParent() {
        Viewport viewport = this.theView.getParent();
        if (viewport != null) {
            return WindowObj.getWindow(viewport);
        }
        return null;
    }

    public WindowObj script_getParent() {
        WindowObj windowObj = this.getParent();
        if (windowObj == null) {
            windowObj = this;
        }
        return windowObj;
    }

    public FramesList getFrames() {
        return this.theFrames;
    }

    public WindowObj getTop() {
        Viewport viewport;
        Viewport viewport2 = this.theView;
        while ((viewport = viewport2.getParent()) != null) {
            viewport2 = viewport;
        }
        return WindowObj.getWindow(viewport2);
    }

    public LocationObj getLocation() {
        return this.theLocation;
    }

    private int J() {
        Component component = this.theView.getPilotComponent();
        return component != null ? component.getSize().height : 0;
    }

    private int NOT_FOUND() {
        Component component = this.theView.getPilotComponent();
        return component != null ? component.getSize().width : 0;
    }

    private DocPane OEAB() {
        Pilot pilot = this._defaultStatus();
        if (pilot != null) {
            return pilot.getDocPane();
        }
        return null;
    }

    private int TRUE() {
        DocPane docPane = this.OEAB();
        if (docPane != null) {
            return docPane.getScrollX();
        }
        return 0;
    }

    private int Z() {
        DocPane docPane = this.OEAB();
        if (docPane != null) {
            return docPane.getScrollY();
        }
        return 0;
    }

    private NavigatorObj _currentStatus() {
        Session session = this.storm.getSession();
        NavigatorObj navigatorObj = (NavigatorObj)((Object)session.getEntry(TRUE));
        if (navigatorObj == null) {
            navigatorObj = new NavigatorObj(this.storm);
            navigatorObj = (NavigatorObj)((Object)session.initEntry(TRUE, (Object)navigatorObj));
        }
        return navigatorObj;
    }

    private Pilot _defaultStatus() {
        Pilot pilot;
        Viewport viewport = this.theView;
        if (viewport != null && (pilot = viewport.getPilot()) != null) {
            return pilot;
        }
        return null;
    }

    private ScreenObj append() {
        Session session = this.storm.getSession();
        ScreenObj screenObj = (ScreenObj)((Object)session.getEntry(Z));
        if (screenObj == null) {
            screenObj = (ScreenObj)((Object)session.initEntry(Z, (Object)new ScreenObj()));
        }
        return screenObj;
    }

    private String args(String string) {
        if (string != null) {
            String string2 = null;
            Viewport viewport = this.theView.getContextViewport();
            if (viewport != null && viewport != this.theView) {
                string2 = viewport.getBaseUrl();
            }
            if (string2 == null && (string2 = this.theView.getBaseUrl()) == null && this.theOpener != null) {
                string2 = this.theOpener.theView.getBaseUrl();
            }
            return this.storm.getUrlMaster().resolve(string2, string);
        }
        return null;
    }

    void setLocation(String string) {
        Scripter scripter = this.storm.getScripterForCodeLocation(string);
        if (scripter != null) {
            scripter.evalCodeLocation(this.theView, string);
        } else {
            this.arraycopy(this.args(string));
        }
    }

    private void arraycopy(String string) {
        this.storm.runOnEventThreadLater(new Runnable(this, string){
            private final String val$uri;
            private final WindowObj this$0;
            {
                this.this$0 = windowObj;
                this.val$uri = string;
            }

            public void run() {
                Viewport viewport = this.this$0.theView;
                if (viewport != null) {
                    this.this$0.storm.renderContent(this.val$uri, null, this.this$0.theView.getId());
                }
            }
        }, 0L);
    }

    private void booleanProperty(String string) {
        if (!this._currentStatus.equals(string)) {
            this._currentStatus = string;
            this.theView.getPilot().firePropertyChange("statusLine", null, (Object)string);
        }
    }

    private void box_allowScriptClose(String string) {
        ScripterCallback scripterCallback;
        if (string == null) {
            string = "";
        }
        if ((scripterCallback = this.storm.getScripterCallback()) != null) {
            SecurityKit.doPrivileged((BoxedCode)CallbackAdapter.box_scriptAlert((ScripterCallback)scripterCallback, (Viewport)this.theView, (String)string));
        }
    }

    private void box_scriptAlert() {
    }

    private void box_scriptConfirm(Object object) {
    }

    private void box_scriptPrint(int n) {
        this.center(n);
    }

    private void box_scriptPrompt(Object[] objectArray, DynEnv dynEnv) {
        long l;
        if (objectArray.length != 0 && (l = dynEnv.toPossibleInt(objectArray[0])) >= 0L) {
            int n = (int)l;
            this.center(n);
            return;
        }
    }

    private void center(int n) {
        this.timerMap.remove(n);
    }

    private void charAt(Object[] objectArray, DynEnv dynEnv) {
        boolean bl;
        boolean bl2 = bl = this.theView.getParent() == null;
        if (bl) {
            Object object;
            boolean bl3 = this.theOpener != null;
            ScripterCallback scripterCallback = this.storm.getScripterCallback();
            bl = scripterCallback != null ? (object = SecurityKit.doPrivileged((BoxedCode)CallbackAdapter.box_allowScriptClose((ScripterCallback)scripterCallback, (Viewport)this.theView, (boolean)bl3))) == Boolean.TRUE : bl3;
        }
        if (Debug.trace) {
            Debug.trace((String)("allowed=" + bl + " view=" + this.theView));
        }
        if (bl) {
            if (!this.storm.isEventThread()) {
                this.storm.runOnEventThreadAndWait((Runnable)new WindowCloser(this.storm, this.theView.getId()), 0L);
            } else {
                this.storm.closeViewport(this.theView.getId());
            }
        }
    }

    private boolean clear(String string) {
        ScripterCallback scripterCallback;
        if (string == null) {
            string = "";
        }
        if ((scripterCallback = this.storm.getScripterCallback()) != null) {
            return Boolean.TRUE == SecurityKit.doPrivileged((BoxedCode)CallbackAdapter.box_scriptConfirm((ScripterCallback)scripterCallback, (Viewport)this.theView, (String)string));
        }
        return false;
    }

    static void script_debug(Object[] objectArray, DynEnv dynEnv) {
        if (Debug.trace) {
            Debug.trace((String)dynEnv.fuseArgsToString(objectArray));
        }
    }

    private void clearContent() {
    }

    private void closeViewport() {
    }

    private Object configureViewport(Object[] objectArray, DynEnv dynEnv) {
        String string = dynEnv.toStr(objectArray, 0);
        return dynEnv.getScripter().eval(this.theView, string, "<source fed to window.execScript()>", 0);
    }

    private boolean createLoader(Object[] objectArray, DynEnv dynEnv) {
        return false;
    }

    private void delay() {
        Pilot pilot = this.theView.getPilot();
        if (pilot == null) {
            return;
        }
        DocPane docPane = pilot.getDocPane();
        if (docPane != null) {
            docPane.reqFocus();
        }
    }

    private void dialog(Object object) {
    }

    private void dialogHide() {
    }

    private void doPrivileged(int n, int n2) {
    }

    private void edge(int n, int n2) {
    }

    private void env(Object[] objectArray, DynEnv dynEnv) {
        if (objectArray.length >= 3) {
            this.equals(objectArray, dynEnv);
        } else {
            String string = null;
            String string2 = null;
            if (objectArray.length != 0) {
                Object object;
                Object object2 = objectArray[0];
                if (object2 != null) {
                    string = dynEnv.toStr(object2);
                }
                if (objectArray.length != 1 && (object = objectArray[1]) != null) {
                    string2 = dynEnv.toStr(object);
                }
            }
            this.openDocument(string, string2);
        }
    }

    private void openDocument(String string, String string2) {
    }

    private Object equals(Object[] objectArray, DynEnv dynEnv) {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = objectArray.length;
        if (n >= 1) {
            string = dynEnv.toStr(objectArray, 0);
            if (string != null && string.length() == 0) {
                string = null;
            }
            if (n >= 2) {
                if (objectArray[1] != null) {
                    string2 = dynEnv.toStr(objectArray, 1);
                }
                if (n >= 3) {
                    string3 = dynEnv.toStr(objectArray, 2);
                    if (n >= 4) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(string3);
                        int n2 = 3;
                        while (n2 != n) {
                            stringBuffer.append(',');
                            stringBuffer.append(dynEnv.toStr(objectArray[n2]));
                            ++n2;
                        }
                        string3 = stringBuffer.toString();
                    }
                }
            }
        }
        return this.open(string, string2, string3);
    }

    private String eval(String string) {
        Viewport viewport;
        if (string != null && (viewport = this.theView.findViewportInTreeByName(string)) != null) {
            string = viewport.getId();
        }
        return string;
    }

    private Object open(String string, String string2, String string3) {
        ViewportGuiParams viewportGuiParams;
        String string4 = this.args(string);
        string2 = this.eval(string2);
        Viewport viewport = null;
        if (string2 != null) {
            viewport = this.storm.findViewportByName(string2);
        }
        if (Debug.trace) {
            Debug.trace((String)("windowName=" + string2 + " uri=" + string4));
        }
        if (viewport == null) {
            viewportGuiParams = null;
            if (string3 != null) {
                viewportGuiParams = new ViewportGuiParams();
                this.execDynamicMethodOnWindow(viewportGuiParams, string3);
            }
            if (EMPTY_OBJECT_ARRAY) {
                viewportGuiParams = null;
            }
            viewport = new Viewport(this.storm, string2);
            if (viewportGuiParams != null) {
                if (viewportGuiParams.scrollbars) {
                    viewport.setProperty((Object)"scrolling", (Object)"true");
                }
                viewport.setGuiParams(viewportGuiParams);
            }
            viewport.setProperty(J, (Object)this);
            if (!this.storm.configureViewport(viewport)) {
                return null;
            }
            this.storm.clearContent("text/html", viewport.getId());
        }
        if (string4 != null) {
            viewportGuiParams = this.storm.getUrlMaster().createLoader(string4);
            this.storm.renderContent((ContentLoader)viewportGuiParams, viewport.getId());
        }
        return WindowObj.getWindow(viewport);
    }

    private Object evalCodeLocation(Object[] objectArray, boolean bl, DynEnv dynEnv) {
        String string = null;
        String string2 = null;
        Object object = null;
        if (objectArray.length > 0) {
            string = dynEnv.toStr(objectArray, 0);
        }
        if (objectArray.length > 1 && objectArray[1] != null) {
            object = objectArray[1];
        }
        if (objectArray.length > 2 && objectArray[2] != null) {
            string2 = dynEnv.toStr(objectArray, 2);
        }
        if (string != null) {
            string = this.args(string);
        }
        ViewportGuiParams viewportGuiParams = new ViewportGuiParams();
        if (string2 != null) {
            this.execDynamicMethod(viewportGuiParams, string2);
        }
        if (bl) {
            viewportGuiParams.modal = true;
        }
        if (EMPTY_OBJECT_ARRAY) {
            viewportGuiParams = null;
        }
        Viewport viewport = new Viewport(this.storm);
        if (viewportGuiParams != null) {
            viewport.setGuiParams(viewportGuiParams);
        }
        viewport.setProperty(J, (Object)this);
        viewport.setProperty(OEAB, object);
        if (!this.storm.configureViewport(viewport)) {
            return null;
        }
        if (string != null) {
            this.storm.renderContent(string, null, viewport.getId());
        } else {
            this.storm.clearContent("text/html", viewport.getId());
        }
        Object object2 = bl ? this.box_allowScriptClose : WindowObj.getWindow(viewport);
        return object2;
    }

    private void execDynamicMethod(ViewportGuiParams viewportGuiParams, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.hasMoreTokens()) {
            viewportGuiParams.center = true;
            viewportGuiParams.dialogHide = false;
            viewportGuiParams.edge = 0;
            viewportGuiParams.help = true;
            viewportGuiParams.scroll = true;
            viewportGuiParams.status = true;
            viewportGuiParams.unadorned = false;
            viewportGuiParams.location = false;
            viewportGuiParams.toolbar = false;
            viewportGuiParams.menubar = false;
            viewportGuiParams.dialog = true;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            String string4 = null;
            int n = string2.indexOf(58);
            if (n > 0) {
                string3 = string2.substring(0, n).trim();
                string4 = string2.substring(n + 1).trim();
            }
            if (string3 == null || string3.length() <= 0 || string4 == null || string4.length() <= 0) continue;
            viewportGuiParams.setValue(string3, string4);
        }
    }

    private void execDynamicMethodOnWindow(ViewportGuiParams viewportGuiParams, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.hasMoreTokens()) {
            viewportGuiParams.location = false;
            viewportGuiParams.menubar = false;
            viewportGuiParams.status = false;
            viewportGuiParams.toolbar = false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            String string4 = null;
            int n = string2.indexOf(61);
            if (n > 0) {
                string3 = string2.substring(0, n).trim();
                string4 = string2.substring(n + 1).trim();
            } else {
                string3 = string2.trim();
                string4 = "yes";
            }
            if (string3 == null || string3.length() <= 0 || string4 == null || string4.length() <= 0) continue;
            viewportGuiParams.setValue(string3.toLowerCase(), string4);
        }
    }

    private Object extra() {
        return this.arraycopy;
    }

    private Object findViewportByName() {
        return this.booleanProperty;
    }

    private void findViewportInTreeByName(Object object) {
        this.booleanProperty = object;
    }

    private void firePropertyChange() {
        ScripterCallback scripterCallback = this.storm.getScripterCallback();
        if (scripterCallback != null) {
            SecurityKit.doPrivileged((BoxedCode)CallbackAdapter.box_scriptPrint((ScripterCallback)scripterCallback, (Viewport)this.theView));
        }
    }

    private String function(String string, String string2) {
        ScripterCallback scripterCallback;
        if (string == null) {
            string = "";
        }
        if ((scripterCallback = this.storm.getScripterCallback()) != null) {
            return (String)SecurityKit.doPrivileged((BoxedCode)CallbackAdapter.box_scriptPrompt((ScripterCallback)scripterCallback, (Viewport)this.theView, (String)string, (String)string2));
        }
        return string2;
    }

    private void fuseArgsToString(Object object) {
    }

    private void getBaseUrl(int n, int n2) {
    }

    private void getContextViewport(int n, int n2) {
    }

    private void getDocPane(Object object) {
    }

    private void getDocument(int n, int n2) {
        DocPane docPane = this.OEAB();
        if (docPane != null) {
            int n3 = docPane.getScrollX() + n;
            int n4 = docPane.getScrollY() + n2;
            docPane.setScrollPosition(n3, n4);
        }
    }

    private void getDocumentObject(int n, int n2) {
        DocPane docPane = this.OEAB();
        if (docPane != null) {
            docPane.setScrollPosition(n, n2);
        }
    }

    private int getDynamicValue(Object[] objectArray, DynEnv dynEnv) {
        return this.getEntry(objectArray, dynEnv, true);
    }

    private int getDynamicValueOnWindow(Object[] objectArray, DynEnv dynEnv) {
        return this.getEntry(objectArray, dynEnv, false);
    }

    private int getEntry(Object[] objectArray, DynEnv dynEnv, boolean bl) {
        Object object;
        int n;
        Object object2 = dynEnv.getRawObject(objectArray, 0);
        int n2 = dynEnv.toInt(objectArray, 1);
        if (n2 < append) {
            n2 = append;
        }
        if ((n = objectArray.length - 2) <= 0) {
            objectArray = Defs.EMPTY_OBJECT_ARRAY;
        } else {
            object = new Object[n];
            System.arraycopy(objectArray, 2, object, 0, n);
            objectArray = object;
        }
        object = new ScriptTimer(this);
        object.timer_id = this.args++;
        this.timerMap.put(object.timer_id, object);
        if (this.args < 0) {
            this.args = 0;
        }
        object.shouldRepeat = bl;
        object.function = object2;
        object.delay = n2;
        object.args = objectArray;
        object.env = dynEnv;
        this.storm.runOnEventThreadLater((Runnable)object, (long)n2);
        return object.timer_id;
    }

    private static int getId() {
        return Defs.sysPropertyInt((String)"ice.scripters.minTimeout", (int)5);
    }

    private void getLength() {
        this.storm.stopLoading(this.theView.getId());
    }

    public String toString() {
        return "[Window " + this.getName() + "]";
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        Object object;
        Pilot pilot = this._defaultStatus();
        if (pilot != null && (object = pilot.getDynamicValueOnWindow((DynamicObject)this, string, dynEnv)) != DynamicObject.NOT_FOUND) {
            return object;
        }
        int n = WindowObj.getPilot(string);
        if (n < 0) {
            return dynEnv.wrapMethod((DynamicObject)this, string);
        }
        if (n > 0) {
            return this.getLocation(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n;
        Pilot pilot = this._defaultStatus();
        if (pilot != null && (n = pilot.setDynamicValueOnWindow((DynamicObject)this, string, object, dynEnv)) != 0) {
            return n;
        }
        n = WindowObj.getPilot(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.getName(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        Object object;
        Pilot pilot = this._defaultStatus();
        if (pilot != null && (object = pilot.execDynamicMethodOnWindow((DynamicObject)this, string, objectArray, dynEnv)) != DynamicObject.NOT_FOUND) {
            return object;
        }
        int n = WindowObj.getPilot(string);
        if (n < 0) {
            return this.getParent(n, objectArray, dynEnv);
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object getLocation(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return dynEnv.wrapBoolean(this.EMPTY_OBJECT_ARRAY());
            }
            case 2: {
                return this._defaultStatus;
            }
            case 3: {
                return this.extra();
            }
            case 4: {
                return this.getDocument();
            }
            case 5: {
                return this.getFrames();
            }
            case 6: {
                return this.theHistory;
            }
            case 7: {
                return this.theView.getId();
            }
            case 8: 
            case 17: {
                return dynEnv.wrapInt(this.J());
            }
            case 9: 
            case 18: {
                return dynEnv.wrapInt(this.NOT_FOUND());
            }
            case 10: {
                return dynEnv.wrapInt(this.getFrames().getLength());
            }
            case 11: {
                return this.getLocation();
            }
            case 12: {
                return null;
            }
            case 13: {
                return dynEnv.onNotImplemented();
            }
            case 14: {
                return this.getName();
            }
            case 15: {
                return this._currentStatus();
            }
            case 16: {
                return this.theOpener;
            }
            case 19: {
                return dynEnv.wrapInt(this.TRUE());
            }
            case 20: {
                return dynEnv.wrapInt(this.Z());
            }
            case 21: {
                return this.script_getParent();
            }
            case 22: {
                return dynEnv.onNotImplemented();
            }
            case 24: {
                return this.findViewportByName();
            }
            case 27: {
                return this.append();
            }
            case 25: {
                return dynEnv.onNotImplemented();
            }
            case 26: {
                return this;
            }
            case 28: {
                return this._currentStatus;
            }
            case 29: {
                return dynEnv.onNotImplemented();
            }
            case 30: {
                return dynEnv.onNotImplemented();
            }
            case 31: {
                return this.getTop();
            }
            case 32: {
                return this;
            }
        }
        return null;
    }

    private int getName(int n, Object object, DynEnv dynEnv) {
        switch (n) {
            case 2: {
                this._defaultStatus = dynEnv.toStr(object);
                return 1;
            }
            case 4: {
                return 1;
            }
            case 11: {
                this.setLocation(dynEnv.toStr(object));
                return 1;
            }
            case 14: {
                this.theView.setName(dynEnv.toStr(object));
                return 1;
            }
            case 21: {
                return 1;
            }
            case 24: {
                this.findViewportInTreeByName(object);
                return 1;
            }
            case 26: {
                return 1;
            }
            case 28: {
                this.booleanProperty(dynEnv.toStr(object));
                return 1;
            }
            case 31: {
                return 1;
            }
            case 32: {
                return 1;
            }
        }
        return 2;
    }

    private Object getParent(int n, Object[] objectArray, DynEnv dynEnv) {
        switch (n) {
            case -1: {
                this.box_allowScriptClose(dynEnv.toStr(objectArray, 0));
                break;
            }
            case -2: {
                return this.theHistory.execDynamicMethod("back", objectArray, dynEnv);
            }
            case -3: {
                this.box_scriptAlert();
                break;
            }
            case -4: {
                this.box_scriptConfirm(dynEnv.toNative(objectArray, 0));
                break;
            }
            case -5: {
                this.box_scriptPrint(dynEnv.toInt(objectArray, 0));
                break;
            }
            case -6: {
                this.box_scriptPrompt(objectArray, dynEnv);
                break;
            }
            case -7: {
                this.charAt(objectArray, dynEnv);
                break;
            }
            case -8: {
                return dynEnv.wrapBoolean(this.clear(dynEnv.toStr(objectArray, 0)));
            }
            case -9: {
                WindowObj.script_debug(objectArray, dynEnv);
                break;
            }
            case -10: {
                this.clearContent();
                break;
            }
            case -11: {
                this.closeViewport();
                break;
            }
            case -12: {
                return this.configureViewport(objectArray, dynEnv);
            }
            case -13: {
                return dynEnv.wrapBoolean(this.createLoader(objectArray, dynEnv));
            }
            case -14: {
                this.delay();
                break;
            }
            case -15: {
                return this.theHistory.execDynamicMethod("forward", objectArray, dynEnv);
            }
            case -16: {
                this.dialog(dynEnv.toNative(objectArray, 0));
                break;
            }
            case -17: {
                this.dialogHide();
                break;
            }
            case -18: {
                int n2 = dynEnv.toInt(objectArray, 0);
                int n3 = dynEnv.toInt(objectArray, 1);
                this.doPrivileged(n2, n3);
                break;
            }
            case -19: {
                int n4 = dynEnv.toInt(objectArray, 0);
                int n5 = dynEnv.toInt(objectArray, 1);
                this.edge(n4, n5);
                break;
            }
            case -20: {
                this.setLocation(dynEnv.toStr(objectArray, 0));
                break;
            }
            case -21: {
                return this.equals(objectArray, dynEnv);
            }
            case -22: {
                this.env(objectArray, dynEnv);
                break;
            }
            case -23: {
                this.firePropertyChange();
                break;
            }
            case -24: {
                return this.function(dynEnv.toStr(objectArray, 0), dynEnv.toStr(objectArray, 1));
            }
            case -25: {
                this.fuseArgsToString(dynEnv.toNative(objectArray, 0));
                break;
            }
            case -26: {
                int n6 = dynEnv.toInt(objectArray, 0);
                int n7 = dynEnv.toInt(objectArray, 1);
                this.getBaseUrl(n6, n7);
                break;
            }
            case -27: {
                int n8 = dynEnv.toInt(objectArray, 0);
                int n9 = dynEnv.toInt(objectArray, 1);
                this.getContextViewport(n8, n9);
                break;
            }
            case -28: {
                this.getDocPane(dynEnv.toNative(objectArray, 0));
                break;
            }
            case -29: {
                int n10 = dynEnv.toInt(objectArray, 0);
                int n11 = dynEnv.toInt(objectArray, 1);
                this.getDocument(n10, n11);
                break;
            }
            case -30: {
                int n12 = dynEnv.toInt(objectArray, 0);
                int n13 = dynEnv.toInt(objectArray, 1);
                this.getDocumentObject(n12, n13);
                break;
            }
            case -31: {
                return dynEnv.wrapInt(this.getDynamicValue(objectArray, dynEnv));
            }
            case -32: {
                return dynEnv.wrapInt(this.getDynamicValueOnWindow(objectArray, dynEnv));
            }
            case -33: {
                return this.evalCodeLocation(objectArray, true, dynEnv);
            }
            case -34: {
                return this.evalCodeLocation(objectArray, false, dynEnv);
            }
            case -35: {
                this.getLength();
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int getPilot(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 2: {
                string2 = "id";
                n = 7;
                break;
            }
            case 3: {
                string2 = "top";
                n = 31;
                break;
            }
            case 4: {
                switch (string.charAt(1)) {
                    case 'a': {
                        char c = string.charAt(0);
                        if (c == 'b') {
                            string2 = "back";
                            n = -2;
                            break block0;
                        }
                        if (c != 'n') break block0;
                        string2 = "name";
                        n = 14;
                        break block0;
                    }
                    case 'e': {
                        string2 = "self";
                        n = 26;
                        break block0;
                    }
                    case 'i': {
                        string2 = "find";
                        n = -13;
                        break block0;
                    }
                    case 'l': {
                        string2 = "blur";
                        n = -3;
                        break block0;
                    }
                    case 'o': {
                        string2 = "home";
                        n = -17;
                        break block0;
                    }
                    case 'p': {
                        string2 = "open";
                        n = -21;
                        break block0;
                    }
                    case 't': {
                        string2 = "stop";
                        n = -35;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (string.charAt(2)) {
                    case 'b': {
                        string2 = "debug";
                        n = -9;
                        break block0;
                    }
                    case 'c': {
                        string2 = "focus";
                        n = -14;
                        break block0;
                    }
                    case 'e': {
                        string2 = "alert";
                        n = -1;
                        break block0;
                    }
                    case 'i': {
                        string2 = "print";
                        n = -23;
                        break block0;
                    }
                    case 'l': {
                        string2 = "pilot";
                        n = 23;
                        break block0;
                    }
                    case 'o': {
                        string2 = "close";
                        n = -7;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (string.charAt(5)) {
                    case 'd': {
                        string2 = "closed";
                        n = 1;
                        break block0;
                    }
                    case 'h': {
                        string2 = "length";
                        n = 10;
                        break block0;
                    }
                    case 'l': {
                        string2 = "scroll";
                        n = -30;
                        break block0;
                    }
                    case 'n': {
                        string2 = "screen";
                        n = 27;
                        break block0;
                    }
                    case 'o': {
                        string2 = "moveTo";
                        n = -19;
                        break block0;
                    }
                    case 'r': {
                        string2 = "opener";
                        n = 16;
                        break block0;
                    }
                    case 's': {
                        char c = string.charAt(0);
                        if (c == 'f') {
                            string2 = "frames";
                            n = 5;
                            break block0;
                        }
                        if (c != 's') break block0;
                        string2 = "status";
                        n = 28;
                        break block0;
                    }
                    case 't': {
                        char c = string.charAt(1);
                        if (c == 'a') {
                            string2 = "parent";
                            n = 21;
                            break block0;
                        }
                        if (c != 'r') break block0;
                        string2 = "prompt";
                        n = -24;
                        break block0;
                    }
                    case 'w': {
                        string2 = "window";
                        n = 32;
                        break block0;
                    }
                    case 'y': {
                        string2 = "moveBy";
                        n = -18;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (string.charAt(0)) {
                    case 'c': {
                        string2 = "confirm";
                        n = -8;
                        break block0;
                    }
                    case 'f': {
                        string2 = "forward";
                        n = -15;
                        break block0;
                    }
                    case 'h': {
                        string2 = "history";
                        n = 6;
                        break block0;
                    }
                    case 'm': {
                        string2 = "menubar";
                        n = 13;
                        break block0;
                    }
                    case 't': {
                        string2 = "toolbar";
                        n = 30;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (string.charAt(0)) {
                    case 'd': {
                        string2 = "document";
                        n = 4;
                        break block0;
                    }
                    case 'l': {
                        string2 = "location";
                        n = 11;
                        break block0;
                    }
                    case 'n': {
                        string2 = "navigate";
                        n = -20;
                        break block0;
                    }
                    case 'r': {
                        char c = string.charAt(7);
                        if (c == 'o') {
                            string2 = "resizeTo";
                            n = -27;
                            break block0;
                        }
                        if (c != 'y') break block0;
                        string2 = "resizeBy";
                        n = -26;
                        break block0;
                    }
                    case 's': {
                        char c = string.charAt(7);
                        if (c == 'o') {
                            string2 = "scrollTo";
                            n = -30;
                            break block0;
                        }
                        if (c != 'y') break block0;
                        string2 = "scrollBy";
                        n = -29;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c = string.charAt(0);
                if (c == 'n') {
                    string2 = "navigator";
                    n = 15;
                    break;
                }
                if (c != 's') break;
                string2 = "statusbar";
                n = 29;
                break;
            }
            case 10: {
                switch (string.charAt(1)) {
                    case 'c': {
                        string2 = "scrollbars";
                        n = 25;
                        break block0;
                    }
                    case 'e': {
                        string2 = "setTimeout";
                        n = -32;
                        break block0;
                    }
                    case 'n': {
                        string2 = "innerWidth";
                        n = 9;
                        break block0;
                    }
                    case 'o': {
                        string2 = "routeEvent";
                        n = -28;
                        break block0;
                    }
                    case 'u': {
                        string2 = "outerWidth";
                        n = 18;
                        break block0;
                    }
                    case 'x': {
                        string2 = "execScript";
                        n = -12;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                switch (string.charAt(0)) {
                    case 'h': {
                        string2 = "handleEvent";
                        n = -16;
                        break block0;
                    }
                    case 'i': {
                        string2 = "innerHeight";
                        n = 8;
                        break block0;
                    }
                    case 'l': {
                        string2 = "locationbar";
                        n = 12;
                        break block0;
                    }
                    case 'o': {
                        string2 = "outerHeight";
                        n = 17;
                        break block0;
                    }
                    case 'p': {
                        char c = string.charAt(4);
                        if (c == 'X') {
                            string2 = "pageXOffset";
                            n = 19;
                            break block0;
                        }
                        if (c == 'Y') {
                            string2 = "pageYOffset";
                            n = 20;
                            break block0;
                        }
                        if (c != 'o') break block0;
                        string2 = "personalbar";
                        n = 22;
                        break block0;
                    }
                    case 'r': {
                        string2 = "returnValue";
                        n = 24;
                        break block0;
                    }
                    case 's': {
                        string2 = "setInterval";
                        n = -31;
                        break block0;
                    }
                }
                break;
            }
            case 12: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "clearTimeout";
                    n = -6;
                    break;
                }
                if (c != 'o') break;
                string2 = "openDocument";
                n = -22;
                break;
            }
            case 13: {
                switch (string.charAt(2)) {
                    case 'e': {
                        string2 = "clearInterval";
                        n = -5;
                        break block0;
                    }
                    case 'f': {
                        string2 = "defaultStatus";
                        n = 2;
                        break block0;
                    }
                    case 'l': {
                        string2 = "releaseEvents";
                        n = -25;
                        break block0;
                    }
                    case 'p': {
                        string2 = "captureEvents";
                        n = -4;
                        break block0;
                    }
                }
                break;
            }
            case 15: {
                char c = string.charAt(0);
                if (c == 'd') {
                    string2 = "dialogArguments";
                    n = 3;
                    break;
                }
                if (c != 's') break;
                string2 = "showModalDialog";
                n = -33;
                break;
            }
            case 17: {
                string2 = "clientInformation";
                n = 15;
                break;
            }
            case 18: {
                string2 = "showModelessDialog";
                n = -34;
                break;
            }
            case 21: {
                string2 = "enableExternalCapture";
                n = -11;
                break;
            }
            case 22: {
                string2 = "disableExternalCapture";
                n = -10;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    private static final class WindowCloser
    implements Runnable {
        private StormBase OEAB;
        private String closeViewport;

        WindowCloser(StormBase stormBase, String string) {
            this.OEAB = stormBase;
            this.closeViewport = string;
        }

        public void run() {
            this.OEAB.closeViewport(this.closeViewport);
        }
    }

    private static final class ScriptTimer
    implements Runnable {
        final WindowObj window;
        int timer_id;
        boolean shouldRepeat;
        Object function;
        long delay;
        Object[] args;
        DynEnv env;

        ScriptTimer(WindowObj windowObj) {
            this.window = windowObj;
        }

        public void run() {
            Viewport viewport;
            HashArray hashArray = this.window.timerMap;
            if (this == hashArray.get(this.timer_id) && (viewport = this.window.theView) != null) {
                boolean bl = this.env.getScripter().evalCallback(viewport, this.function, this.args);
                if (bl && this.shouldRepeat) {
                    this.window.storm.runOnEventThreadLater((Runnable)this, this.delay);
                } else {
                    hashArray.remove(this.timer_id);
                }
            }
        }
    }
}

