/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LabelTable;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.DebugFrame;

public class Interpreter {
    static PrintWriter out;
    private boolean FALSE;
    private InterpreterData I;
    private VariableTable NOT_FOUND;
    private int NaNobj = 0;
    private int NumberClass = 0;
    private String OEAB;
    private int S = 0;
    private LabelTable TRUE = new LabelTable();
    private int Z;
    private ObjToIntMap acquireLabel = new ObjToIntMap(20);
    private String addChildAfter;
    private int addChildToFront;
    private String addLabelFixup;
    private static final Object append;

    public IRFactory createIRFactory(TokenStream tokenStream, ClassNameHelper classNameHelper, Scriptable scriptable) {
        return new IRFactory(tokenStream, scriptable);
    }

    public Node transform(Node node, TokenStream tokenStream, Scriptable scriptable) {
        return new NodeTransformer().transform(node, null, tokenStream, scriptable);
    }

    public Object compile(Context context, Scriptable scriptable, Node node, Object object, SecurityController securityController, ClassNameHelper classNameHelper) {
        this.addChildToFront = context.getLanguageVersion();
        this.I = new InterpreterData(object);
        if (node instanceof FunctionNode) {
            FunctionNode functionNode = (FunctionNode)node;
            this.I.itsFunctionType = functionNode.getFunctionType();
            this.I(context, scriptable, functionNode);
            return Interpreter.delete(context, scriptable, this.I, false);
        }
        this.FALSE(context, scriptable, node);
        return new InterpretedScript(context, this.I);
    }

    private void FALSE(Context context, Scriptable scriptable, Node node) {
        this.I.itsSourceFile = this.OEAB = (String)node.getProp(16);
        this.addLabelFixup = (String)node.getProp(31);
        this.NOT_FOUND(context, scriptable, node);
        this.NaNobj(context, scriptable, node);
        this.NOT_FOUND = (VariableTable)node.getProp(10);
        this.NumberClass(node);
        if (context.debugger != null) {
            context.debugger.handleCompilationDone(context, this.I, this.addLabelFixup);
        }
    }

    private void I(Context context, Scriptable scriptable, FunctionNode functionNode) {
        String string = this.addLabelFixup;
        this.addLabelFixup = (String)functionNode.getProp(31);
        if (this.addLabelFixup == null) {
            this.addLabelFixup = string;
        }
        this.NOT_FOUND(context, scriptable, functionNode);
        this.NaNobj(context, scriptable, functionNode);
        this.I.itsNeedsActivation = functionNode.requiresActivation();
        this.NOT_FOUND = functionNode.getVariableTable();
        this.NumberClass(functionNode.getLastChild());
        this.I.itsName = functionNode.getFunctionName();
        this.I.itsSourceFile = (String)functionNode.getProp(16);
        this.I.itsSource = (String)functionNode.getProp(17);
        if (context.debugger != null) {
            context.debugger.handleCompilationDone(context, this.I, this.addLabelFixup);
        }
        this.addLabelFixup = string;
    }

    private void NOT_FOUND(Context context, Scriptable scriptable, Node node) {
        ObjArray objArray = (ObjArray)node.getProp(5);
        if (objArray == null) {
            return;
        }
        int n = objArray.size();
        InterpreterData[] interpreterDataArray = new InterpreterData[n];
        int n2 = 0;
        while (n2 != n) {
            FunctionNode functionNode = (FunctionNode)objArray.get(n2);
            Interpreter interpreter = new Interpreter();
            interpreter.OEAB = this.OEAB;
            interpreter.I = new InterpreterData(this.I.securityDomain);
            interpreter.I.itsCheckThis = functionNode.getCheckThis();
            interpreter.I.itsFunctionType = functionNode.getFunctionType();
            interpreter.FALSE = true;
            interpreter.addLabelFixup = this.addLabelFixup;
            interpreter.I(context, scriptable, functionNode);
            interpreterDataArray[n2] = interpreter.I;
            functionNode.putIntProp(5, n2);
            ++n2;
        }
        this.I.itsNestedFunctions = interpreterDataArray;
    }

    private void NaNobj(Context context, Scriptable scriptable, Node node) {
        ObjArray objArray = (ObjArray)node.getProp(12);
        if (objArray == null) {
            return;
        }
        RegExpProxy regExpProxy = context.getRegExpProxy();
        if (regExpProxy == null) {
            throw Context.reportRuntimeError0("msg.no.regexp");
        }
        int n = objArray.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 != n) {
            Node node2 = (Node)objArray.get(n2);
            Node node3 = node2.getFirstChild();
            Node node4 = node2.getLastChild();
            String string = node3.getString();
            String string2 = node3 != node4 ? node4.getString() : null;
            objectArray[n2] = regExpProxy.newRegExp(context, scriptable, string, string2, false);
            node2.putIntProp(12, n2);
            ++n2;
        }
        this.I.itsRegExpLiterals = objectArray;
    }

    private void NumberClass(Node node) {
        Object object;
        int n = 0;
        n = this.TRUE(node, n);
        this.TRUE.fixLabelGotos(this.I.itsICode);
        if (this.I.itsFunctionType == 0) {
            n = this.argNames(152, n);
        }
        this.I.itsICodeTop = n;
        if (this.I.itsICode.length != n) {
            object = new byte[n];
            System.arraycopy(this.I.itsICode, 0, object, 0, n);
            this.I.itsICode = object;
        }
        if (this.acquireLabel.size() == 0) {
            this.I.itsStringTable = null;
        } else {
            this.I.itsStringTable = new String[this.acquireLabel.size()];
            object = this.acquireLabel.newIterator();
            ((ObjToIntMap.Iterator)object).start();
            while (!((ObjToIntMap.Iterator)object).done()) {
                String string = (String)((ObjToIntMap.Iterator)object).getKey();
                int n2 = ((ObjToIntMap.Iterator)object).getValue();
                if (this.I.itsStringTable[n2] != null) {
                    Context.codeBug();
                }
                this.I.itsStringTable[n2] = string;
                ((ObjToIntMap.Iterator)object).next();
            }
        }
        if (this.Z == 0) {
            this.I.itsDoubleTable = null;
        } else if (this.I.itsDoubleTable.length != this.Z) {
            object = new double[this.Z];
            System.arraycopy(this.I.itsDoubleTable, 0, object, 0, this.Z);
            this.I.itsDoubleTable = (double[])object;
        }
        this.I.itsMaxVars = this.NOT_FOUND.size();
        this.I.itsMaxFrameArray = this.I.itsMaxVars + this.I.itsMaxLocals + this.I.itsMaxTryDepth + this.I.itsMaxStack;
        this.I.argNames = new String[this.NOT_FOUND.size()];
        this.NOT_FOUND.getAllVariables(this.I.argNames);
        this.I.argCount = this.NOT_FOUND.getParameterCount();
    }

    private int OEAB(Node node, int n) {
        int n2 = node.getLineno();
        if (n2 != this.S && n2 >= 0) {
            this.S = n2;
            n = this.argNames(147, n);
            n = this.arraycopy(n2, n);
        }
        return n;
    }

    private void S(Node node) {
        try {
            out = new PrintWriter(new FileOutputStream("icode.txt", true));
            out.println("Un-handled node : " + node.toString());
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new RuntimeException("Un-handled node : " + node.toString());
    }

    private int TRUE(Node node, int n) {
        Node node2;
        int n2 = node.getType();
        Node node3 = node2 = node.getFirstChild();
        block0 : switch (n2) {
            case 110: {
                FunctionNode functionNode = (FunctionNode)node.getProp(5);
                if (functionNode.itsFunctionType == 1) break;
                int n3 = functionNode.getExistingIntProp(5);
                n = this.argNames(55, n);
                n = this.bind(n3, n);
                ++this.NumberClass;
                if (this.NumberClass <= this.I.itsMaxStack) break;
                this.I.itsMaxStack = this.NumberClass;
                break;
            }
            case 146: {
                n = this.OEAB(node, n);
                while (node2 != null) {
                    if (node2.getType() != 110) {
                        n = this.TRUE(node2, n);
                    }
                    node2 = node2.getNext();
                }
                break;
            }
            case 116: {
                n = this.OEAB(node, n);
                node2 = node2.getNext();
                while (node2 != null) {
                    n = this.TRUE(node2, n);
                    node2 = node2.getNext();
                }
                break;
            }
            case 117: 
            case 124: 
            case 128: 
            case 132: 
            case 133: 
            case 136: 
            case 138: {
                n = this.OEAB(node, n);
                while (node2 != null) {
                    n = this.TRUE(node2, n);
                    node2 = node2.getNext();
                }
                break;
            }
            case 96: {
                n = this.TRUE(node2, n);
                while (null != (node2 = node2.getNext())) {
                    n = this.argNames(57, n);
                    --this.NumberClass;
                    n = this.TRUE(node2, n);
                }
                break;
            }
            case 115: {
                Node node4;
                Node node5;
                n = this.OEAB(node, n);
                n = this.TRUE(node2, n);
                int n4 = this.I.itsMaxLocals++;
                n = this.argNames(69, n);
                n = this.argNames(n4, n);
                n = this.argNames(57, n);
                --this.NumberClass;
                ObjArray objArray = (ObjArray)node.getProp(13);
                int n5 = 0;
                while (n5 < objArray.size()) {
                    node5 = (Node)objArray.get(n5);
                    node4 = node5.getFirstChild();
                    n = this.TRUE(node4, n);
                    n = this.argNames(70, n);
                    n = this.argNames(n4, n);
                    ++this.NumberClass;
                    if (this.NumberClass > this.I.itsMaxStack) {
                        this.I.itsMaxStack = this.NumberClass;
                    }
                    n = this.argNames(53, n);
                    --this.NumberClass;
                    Node node6 = new Node(137);
                    node5.addChildAfter(node6, node4);
                    n = this.addChildToFront(node6, 7, n);
                    ++n5;
                }
                node5 = (Node)node.getProp(14);
                if (node5 != null) {
                    node4 = new Node(137);
                    node5.getFirstChild().addChildToFront(node4);
                    n = this.addChildToFront(node4, 6, n);
                }
                node4 = (Node)node.getProp(2);
                n = this.addChildToFront(node4, 6, n);
                break;
            }
            case 137: {
                this.addChildAfter(node, n);
                if (node.getProp(21) == null) break;
                this.NumberClass = 1;
                if (this.NumberClass <= this.I.itsMaxStack) break;
                this.I.itsMaxStack = this.NumberClass;
                break;
            }
            case 102: 
            case 103: {
                n = this.TRUE(node2, n);
                node2 = node2.getNext();
                n = this.TRUE(node2, n);
                int n6 = node.getOperation();
                if (this.addChildToFront == 120) {
                    if (n6 == 14) {
                        n6 = 53;
                    } else if (n6 == 15) {
                        n6 = 54;
                    }
                }
                n = this.argNames(n6, n);
                --this.NumberClass;
                break;
            }
            case 30: 
            case 43: {
                if (!(this.OEAB == null || this.I.itsSourceFile != null && this.OEAB.equals(this.I.itsSourceFile))) {
                    this.I.itsSourceFile = this.OEAB;
                }
                n = this.argNames(148, n);
                int n7 = 0;
                String string = null;
                while (node2 != null) {
                    int n8;
                    n = this.TRUE(node2, n);
                    if (string == null && ((n8 = node2.getType()) == 44 || n8 == 39)) {
                        string = this.addChildAfter;
                    }
                    node2 = node2.getNext();
                    ++n7;
                }
                if (node.getProp(30) != null) {
                    n = this.argNames(67, n);
                    n = this.arraycopy(this.S, n);
                    n = this.callSpecial(this.OEAB, n);
                } else {
                    n = this.argNames(n2, n);
                    n = this.callSpecial(string, n);
                }
                this.NumberClass -= n7 - 1;
                n7 = n2 == 30 ? --n7 : (n7 -= 2);
                n = this.bind(n7, n);
                if (n7 > this.I.itsMaxCalleeArgs) {
                    this.I.itsMaxCalleeArgs = n7;
                }
                n = this.argNames(148, n);
                break;
            }
            case 69: 
            case 144: {
                n = this.TRUE(node2, n);
                n = this.argNames(69, n);
                n = this.Z(node, n);
                break;
            }
            case 145: {
                if (node.getProp(1) != null) {
                    n = this.argNames(66, n);
                } else {
                    n = this.argNames(70, n);
                    ++this.NumberClass;
                    if (this.NumberClass > this.I.itsMaxStack) {
                        this.I.itsMaxStack = this.NumberClass;
                    }
                }
                Node node7 = (Node)node.getProp(7);
                n = this.Z(node7, n);
                break;
            }
            case 70: {
                n = this.argNames(70, n);
                Node node8 = (Node)node.getProp(6);
                n = this.Z(node8, n);
                ++this.NumberClass;
                if (this.NumberClass <= this.I.itsMaxStack) break;
                this.I.itsMaxStack = this.NumberClass;
                break;
            }
            case 7: 
            case 8: {
                n = this.TRUE(node2, n);
                --this.NumberClass;
            }
            case 6: {
                Node node9 = (Node)node.getProp(1);
                n = this.addChildToFront(node9, (byte)n2, n);
                break;
            }
            case 143: {
                Node node10 = (Node)node.getProp(1);
                node10.putProp(21, node);
                n = this.addChildToFront(node10, 65, n);
                break;
            }
            case 101: {
                n = this.TRUE(node2, n);
                n = this.argNames(9, n);
                ++this.NumberClass;
                if (this.NumberClass > this.I.itsMaxStack) {
                    this.I.itsMaxStack = this.NumberClass;
                }
                int n9 = n;
                n = this.addLabelFixup(8, n);
                n = this.argNames(57, n);
                --this.NumberClass;
                node2 = node2.getNext();
                n = this.TRUE(node2, n);
                this.append(n9, n);
                break;
            }
            case 100: {
                n = this.TRUE(node2, n);
                n = this.argNames(9, n);
                ++this.NumberClass;
                if (this.NumberClass > this.I.itsMaxStack) {
                    this.I.itsMaxStack = this.NumberClass;
                }
                int n10 = n;
                n = this.addLabelFixup(7, n);
                n = this.argNames(57, n);
                --this.NumberClass;
                node2 = node2.getNext();
                n = this.TRUE(node2, n);
                this.append(n10, n);
                break;
            }
            case 39: {
                n = this.TRUE(node2, n);
                String string = (String)node.getProp(19);
                if (string != null) {
                    if (string.equals("__proto__")) {
                        n = this.argNames(81, n);
                        break;
                    }
                    if (string.equals("__parent__")) {
                        n = this.argNames(86, n);
                        break;
                    }
                    this.S(node);
                    break;
                }
                node2 = node2.getNext();
                n = this.TRUE(node2, n);
                n = this.argNames(39, n);
                --this.NumberClass;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 41: {
                n = this.TRUE(node2, n);
                node2 = node2.getNext();
                n = this.TRUE(node2, n);
                n = this.argNames(n2, n);
                --this.NumberClass;
                break;
            }
            case 142: {
                n = this.TRUE(node2, n);
                Object object = node.getProp(18);
                if (object == ScriptRuntime.NumberClass) {
                    n = this.argNames(58, n);
                    break;
                }
                this.S(node);
                break;
            }
            case 105: {
                n = this.TRUE(node2, n);
                switch (node.getOperation()) {
                    case 132: {
                        n = this.argNames(57, n);
                        n = this.argNames(74, n);
                        break block0;
                    }
                    case 129: {
                        int n11 = n;
                        n = this.addLabelFixup(7, n);
                        int n12 = n = this.argNames(52, n);
                        n = this.addLabelFixup(6, n);
                        this.append(n11, n);
                        n = this.argNames(51, n);
                        this.append(n12, n);
                        break block0;
                    }
                    case 28: {
                        n = this.argNames(28, n);
                        break block0;
                    }
                    case 32: {
                        n = this.argNames(32, n);
                        break block0;
                    }
                    case 24: {
                        n = this.argNames(29, n);
                        break block0;
                    }
                    case 23: {
                        n = this.argNames(58, n);
                        break block0;
                    }
                }
                this.S(node);
                break;
            }
            case 40: {
                n = this.TRUE(node2, n);
                node2 = node2.getNext();
                n = this.TRUE(node2, n);
                String string = (String)node.getProp(19);
                if (string != null) {
                    if (string.equals("__proto__")) {
                        n = this.argNames(83, n);
                        break;
                    }
                    if (string.equals("__parent__")) {
                        n = this.argNames(84, n);
                        break;
                    }
                    this.S(node);
                    break;
                }
                node2 = node2.getNext();
                n = this.TRUE(node2, n);
                n = this.argNames(40, n);
                this.NumberClass -= 2;
                break;
            }
            case 42: {
                n = this.TRUE(node2, n);
                node2 = node2.getNext();
                n = this.TRUE(node2, n);
                node2 = node2.getNext();
                n = this.TRUE(node2, n);
                n = this.argNames(n2, n);
                this.NumberClass -= 2;
                break;
            }
            case 10: {
                n = this.TRUE(node2, n);
                node2 = node2.getNext();
                n = this.TRUE(node2, n);
                n = this.argNames(10, n);
                n = this.callSpecial(node3.getString(), n);
                --this.NumberClass;
                break;
            }
            case 32: {
                String string = node.getString();
                int n13 = -1;
                if (this.FALSE && !this.I.itsNeedsActivation) {
                    n13 = this.NOT_FOUND.getOrdinal(string);
                }
                if (n13 == -1) {
                    n = this.argNames(78, n);
                    n = this.callSpecial(string, n);
                } else {
                    n = this.argNames(72, n);
                    n = this.argNames(n13, n);
                    n = this.argNames(32, n);
                }
                ++this.NumberClass;
                if (this.NumberClass <= this.I.itsMaxStack) break;
                this.I.itsMaxStack = this.NumberClass;
                break;
            }
            case 141: {
                n = this.TRUE(node2, n);
                n = this.argNames(82, n);
                break;
            }
            case 44: 
            case 46: 
            case 61: 
            case 71: {
                n = this.argNames(n2, n);
                n = this.callSpecial(node.getString(), n);
                ++this.NumberClass;
                if (this.NumberClass <= this.I.itsMaxStack) break;
                this.I.itsMaxStack = this.NumberClass;
                break;
            }
            case 106: 
            case 107: {
                int n14 = node2.getType();
                switch (n14) {
                    case 72: {
                        String string = node2.getString();
                        if (this.I.itsNeedsActivation) {
                            n = this.argNames(85, n);
                            n = this.argNames(46, n);
                            n = this.callSpecial(string, n);
                            this.NumberClass += 2;
                            if (this.NumberClass > this.I.itsMaxStack) {
                                this.I.itsMaxStack = this.NumberClass;
                            }
                            n = this.argNames(n2 == 106 ? 34 : 37, n);
                            --this.NumberClass;
                            break;
                        }
                        int n15 = this.NOT_FOUND.getOrdinal(string);
                        n = this.argNames(n2 == 106 ? 59 : 60, n);
                        n = this.argNames(n15, n);
                        ++this.NumberClass;
                        if (this.NumberClass <= this.I.itsMaxStack) break block0;
                        this.I.itsMaxStack = this.NumberClass;
                        break;
                    }
                    case 39: 
                    case 41: {
                        Node node11 = node2.getFirstChild();
                        n = this.TRUE(node11, n);
                        node11 = node11.getNext();
                        n = this.TRUE(node11, n);
                        n = n14 == 39 ? this.argNames(n2 == 106 ? 34 : 37, n) : this.argNames(n2 == 106 ? 35 : 38, n);
                        --this.NumberClass;
                        break;
                    }
                    default: {
                        n = this.argNames(n2 == 106 ? 33 : 36, n);
                        n = this.callSpecial(node2.getString(), n);
                        ++this.NumberClass;
                        if (this.NumberClass <= this.I.itsMaxStack) break block0;
                        this.I.itsMaxStack = this.NumberClass;
                        break;
                    }
                }
                break;
            }
            case 45: {
                double d = node.getDouble();
                int n16 = (int)d;
                if ((double)n16 == d) {
                    if (n16 == 0) {
                        n = this.argNames(47, n);
                    } else if (n16 == 1) {
                        n = this.argNames(48, n);
                    } else if ((short)n16 == n16) {
                        n = this.argNames(149, n);
                        n = this.arraycopy(n16, n);
                    } else {
                        n = this.argNames(150, n);
                        n = this.booleanValue(n16, n);
                    }
                } else {
                    n = this.argNames(45, n);
                    n = this.call(d, n);
                }
                ++this.NumberClass;
                if (this.NumberClass <= this.I.itsMaxStack) break;
                this.I.itsMaxStack = this.NumberClass;
                break;
            }
            case 2: 
            case 57: {
                n = this.OEAB(node, n);
            }
            case 3: {
                n = this.TRUE(node2, n);
                n = this.argNames(n2, n);
                --this.NumberClass;
                break;
            }
            case 68: {
                n = this.TRUE(node2, n);
                n = this.argNames(n2, n);
                break;
            }
            case 77: {
                n = this.argNames(n2, n);
                ++this.NumberClass;
                if (this.NumberClass <= this.I.itsMaxStack) break;
                this.I.itsMaxStack = this.NumberClass;
                break;
            }
            case 4: {
                n = this.argNames(n2, n);
                break;
            }
            case 75: {
                ++this.NaNobj;
                if (this.NaNobj > this.I.itsMaxTryDepth) {
                    this.I.itsMaxTryDepth = this.NaNobj;
                }
                Node node12 = (Node)node.getProp(1);
                Node node13 = (Node)node.getProp(21);
                int n17 = n;
                if (node12 == null) {
                    n = this.argNames(75, n);
                    n = this.arraycopy(0, n);
                } else {
                    n = this.addChildToFront(node12, 75, n);
                }
                n = this.arraycopy(0, n);
                Node node14 = null;
                boolean bl = false;
                while (node2 != null) {
                    if (node12 != null && node14 == node12) {
                        this.NumberClass = 1;
                        if (this.NumberClass > this.I.itsMaxStack) {
                            this.I.itsMaxStack = this.NumberClass;
                        }
                    }
                    Node node15 = node2.getNext();
                    if (!(bl || node15 == null || node15 != node12 && node15 != node13)) {
                        n = this.argNames(76, n);
                        bl = true;
                    }
                    n = this.TRUE(node2, n);
                    node14 = node2;
                    node2 = node2.getNext();
                }
                this.NumberClass = 0;
                if (node13 != null) {
                    int n18 = n;
                    n = this.addLabelFixup(6, n);
                    int n19 = n - n17;
                    this.argCount(n17 + 3, n19);
                    this.NumberClass = 1;
                    if (this.NumberClass > this.I.itsMaxStack) {
                        this.I.itsMaxStack = this.NumberClass;
                    }
                    int n20 = this.I.itsMaxLocals++;
                    n = this.argNames(69, n);
                    n = this.argNames(n20, n);
                    n = this.argNames(57, n);
                    n = this.addChildToFront(node13, 65, n);
                    n = this.argNames(70, n);
                    n = this.argNames(n20, n);
                    n = this.argNames(88, n);
                    this.NumberClass = 0;
                    this.append(n18, n);
                }
                --this.NaNobj;
                break;
            }
            case 62: {
                n = this.OEAB(node, n);
                n = this.TRUE(node2, n);
                n = this.argNames(62, n);
                --this.NumberClass;
                break;
            }
            case 5: {
                n = this.OEAB(node, n);
                if (node2 != null) {
                    n = this.TRUE(node2, n);
                    n = this.argNames(5, n);
                    --this.NumberClass;
                    break;
                }
                n = this.argNames(151, n);
                break;
            }
            case 72: {
                String string = node.getString();
                if (this.I.itsNeedsActivation) {
                    n = this.argNames(85, n);
                    n = this.argNames(46, n);
                    n = this.callSpecial(string, n);
                    this.NumberClass += 2;
                    if (this.NumberClass > this.I.itsMaxStack) {
                        this.I.itsMaxStack = this.NumberClass;
                    }
                    n = this.argNames(39, n);
                    --this.NumberClass;
                    break;
                }
                int n21 = this.NOT_FOUND.getOrdinal(string);
                n = this.argNames(72, n);
                n = this.argNames(n21, n);
                ++this.NumberClass;
                if (this.NumberClass <= this.I.itsMaxStack) break;
                this.I.itsMaxStack = this.NumberClass;
                break;
            }
            case 73: {
                if (this.I.itsNeedsActivation) {
                    node2.setType(61);
                    node.setType(10);
                    n = this.TRUE(node, n);
                    break;
                }
                String string = node2.getString();
                node2 = node2.getNext();
                n = this.TRUE(node2, n);
                int n22 = this.NOT_FOUND.getOrdinal(string);
                n = this.argNames(73, n);
                n = this.argNames(n22, n);
                break;
            }
            case 109: {
                n = this.argNames(node.getOperation(), n);
                ++this.NumberClass;
                if (this.NumberClass <= this.I.itsMaxStack) break;
                this.I.itsMaxStack = this.NumberClass;
                break;
            }
            case 79: {
                n = this.TRUE(node2, n);
                n = this.argNames(79, n);
                n = this.Z(node, n);
                --this.NumberClass;
                break;
            }
            case 80: {
                n = this.argNames(80, n);
                Node node16 = (Node)node.getProp(4);
                n = this.Z(node16, n);
                ++this.NumberClass;
                if (this.NumberClass <= this.I.itsMaxStack) break;
                this.I.itsMaxStack = this.NumberClass;
                break;
            }
            case 139: {
                break;
            }
            case 56: {
                Node node17 = (Node)node.getProp(12);
                int n23 = node17.getExistingIntProp(12);
                n = this.argNames(56, n);
                n = this.bind(n23, n);
                ++this.NumberClass;
                if (this.NumberClass <= this.I.itsMaxStack) break;
                this.I.itsMaxStack = this.NumberClass;
                break;
            }
            default: {
                this.S(node);
            }
        }
        return n;
    }

    private int Z(Node node, int n) {
        int n2 = node.getIntProp(7, -1);
        if (n2 == -1) {
            n2 = this.I.itsMaxLocals++;
            node.putIntProp(7, n2);
        }
        n = this.argNames(n2, n);
        if (n2 >= this.I.itsMaxLocals) {
            this.I.itsMaxLocals = n2 + 1;
        }
        return n;
    }

    private int acquireLabel(Node node) {
        int n = node.getIntProp(20, -1);
        if (n == -1) {
            n = this.TRUE.acquireLabel();
            node.putIntProp(20, n);
        }
        return n;
    }

    private void addChildAfter(Node node, int n) {
        int n2 = this.acquireLabel(node);
        this.TRUE.markLabel(n2, n);
    }

    private int addChildToFront(Node node, int n, int n2) {
        int n3 = this.acquireLabel(node);
        int n4 = n2;
        n2 = this.argNames(n, n2);
        n2 = this.arraycopy(0, n2);
        int n5 = this.TRUE.getLabelPC(n3);
        if (n5 != -1) {
            this.argCount(n4 + 1, n5 - n4);
        } else {
            this.TRUE.addLabelFixup(n3, n4 + 1);
        }
        return n2;
    }

    private int addLabelFixup(int n, int n2) {
        n2 = this.argNames(n, n2);
        n2 = this.arraycopy(0, n2);
        return n2;
    }

    private void append(int n, int n2) {
        if (n + 3 > n2) {
            Context.codeBug();
        }
        int n3 = n2 - n;
        this.argCount(n + 1, n3);
    }

    private void argCount(int n, int n2) {
        if (n2 != (short)n2) {
            throw Context.reportRuntimeError0("msg.too.big.jump");
        }
        this.I.itsICode[n] = (byte)(n2 >> 8);
        this.I.itsICode[n + 1] = (byte)n2;
    }

    private int argNames(int n, int n2) {
        byte[] byArray = this.I.itsICode;
        if (n2 == byArray.length) {
            byArray = this.close(n2, 1);
        }
        byArray[n2++] = (byte)n;
        return n2;
    }

    private int arraycopy(int n, int n2) {
        byte[] byArray = this.I.itsICode;
        if (n2 + 2 > byArray.length) {
            byArray = this.close(n2, 2);
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        return n2 + 2;
    }

    private int bind(int n, int n2) {
        if (n < 0) {
            Context.codeBug();
        }
        if (n > 65535) {
            throw Context.reportRuntimeError0("msg.too.big.index");
        }
        byte[] byArray = this.I.itsICode;
        if (n2 + 2 > byArray.length) {
            byArray = this.close(n2, 2);
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        return n2 + 2;
    }

    private int booleanValue(int n, int n2) {
        byte[] byArray = this.I.itsICode;
        if (n2 + 4 > byArray.length) {
            byArray = this.close(n2, 4);
        }
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
        return n2 + 4;
    }

    private int call(double d, int n) {
        int n2 = this.Z;
        if (n2 == 0) {
            this.I.itsDoubleTable = new double[64];
        } else if (this.I.itsDoubleTable.length == n2) {
            double[] dArray = new double[n2 * 2];
            System.arraycopy(this.I.itsDoubleTable, 0, dArray, 0, n2);
            this.I.itsDoubleTable = dArray;
        }
        this.I.itsDoubleTable[n2] = d;
        this.Z = n2 + 1;
        n = this.bind(n2, n);
        return n;
    }

    private int callSpecial(String string, int n) {
        int n2 = this.acquireLabel.get(string, -1);
        if (n2 == -1) {
            n2 = this.acquireLabel.size();
            this.acquireLabel.put(string, n2);
        }
        n = this.bind(n2, n);
        this.addChildAfter = string;
        return n;
    }

    private byte[] close(int n, int n2) {
        int n3 = this.I.itsICode.length;
        if (n + n2 <= n3) {
            Context.codeBug();
        }
        if (n + n2 > (n3 *= 2)) {
            n3 = n + n2;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.I.itsICode, 0, byArray, 0, n);
        this.I.itsICode = byArray;
        return byArray;
    }

    private static int cmp_LE(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int cmp_LT(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int codeBug(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int construct(byte[] byArray, int n) {
        int n2 = Interpreter.cmp_LE(byArray, n);
        return n - 1 + n2;
    }

    private static void createObject(InterpreterData interpreterData) {
    }

    private static int debugger(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 62: 
            case 63: 
            case 64: 
            case 68: 
            case 74: 
            case 76: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 148: 
            case 151: 
            case 152: {
                return 1;
            }
            case 6: 
            case 7: 
            case 8: 
            case 65: {
                return 3;
            }
            case 75: {
                return 5;
            }
            case 59: 
            case 60: 
            case 66: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 79: 
            case 80: {
                return 2;
            }
            case 67: {
                return 7;
            }
            case 56: {
                return 3;
            }
            case 55: {
                return 3;
            }
            case 30: 
            case 43: {
                return 5;
            }
            case 149: {
                return 3;
            }
            case 150: {
                return 5;
            }
            case 45: {
                return 3;
            }
            case 10: 
            case 33: 
            case 36: 
            case 44: 
            case 46: 
            case 61: 
            case 71: 
            case 78: {
                return 3;
            }
            case 147: {
                return 3;
            }
        }
        Context.codeBug();
        return 0;
    }

    static int[] getLineNumbers(InterpreterData interpreterData) {
        UintMap uintMap = new UintMap();
        int n = interpreterData.itsICodeTop;
        byte[] byArray = interpreterData.itsICode;
        int n2 = 0;
        while (n2 != n) {
            int n3 = byArray[n2] & 0xFF;
            int n4 = Interpreter.debugger(n3);
            if (n3 == 147) {
                if (n4 != 3) {
                    Context.codeBug();
                }
                int n5 = Interpreter.cmp_LE(byArray, n2 + 1);
                uintMap.put(n5, 0);
            }
            n2 += n4;
        }
        return uintMap.getKeys();
    }

    static Object getSourcesTree(InterpreterData interpreterData) {
        InterpreterData[] interpreterDataArray = interpreterData.itsNestedFunctions;
        if (interpreterDataArray == null || interpreterDataArray.length == 0) {
            return interpreterData.itsSource;
        }
        int n = interpreterDataArray.length;
        Object[] objectArray = new Object[n + 1];
        objectArray[0] = interpreterData.itsSource;
        int n2 = 0;
        while (n2 != n) {
            objectArray[1 + n2] = Interpreter.getSourcesTree(interpreterDataArray[n2]);
            ++n2;
        }
        return objectArray;
    }

    private static InterpretedFunction delete(Context context, Scriptable scriptable, InterpreterData interpreterData, boolean bl) {
        InterpretedFunction interpretedFunction = new InterpretedFunction(context, interpreterData);
        if (context.hasCompileFunctionsWithDynamicScope() && !(scriptable instanceof NativeCall) && !(scriptable instanceof NativeWith)) {
            interpretedFunction.itsUseDynamicScope = true;
        }
        ScriptRuntime.initFunction(context, scriptable, interpretedFunction, interpreterData.itsFunctionType, bl);
        return interpretedFunction;
    }

    static Object interpret(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, double[] dArray, int n, int n2, NativeFunction nativeFunction, InterpreterData interpreterData) throws JavaScriptException {
        int n3;
        Object object;
        if (context.interpreterSecurityDomain != interpreterData.securityDomain) {
            return Interpreter.getDouble(context, scriptable, scriptable2, objectArray, dArray, n, n2, nativeFunction, interpreterData);
        }
        Object object2 = append;
        Scriptable scriptable3 = Undefined.instance;
        boolean bl = false;
        int n4 = interpreterData.itsMaxFrameArray;
        int n5 = interpreterData.itsMaxVars;
        int n6 = 0 + n5;
        int n7 = n6 + interpreterData.itsMaxLocals;
        int n8 = n7 + interpreterData.itsMaxTryDepth;
        if (n4 != n8 + interpreterData.itsMaxStack) {
            Context.codeBug();
        }
        Object[] objectArray2 = new Object[n4];
        double[] dArray2 = new double[n4];
        int n9 = n8 - 1;
        int n10 = 0;
        int n11 = nativeFunction.argCount;
        if (n11 > n2) {
            n11 = n2;
        }
        int n12 = 0;
        while (n12 != n11) {
            Object object3;
            objectArray2[0 + n12] = object3 = objectArray[n + n12];
            if (object3 == object2) {
                dArray2[0 + n12] = dArray[n + n12];
            }
            ++n12;
        }
        int n13 = n11;
        while (n13 != n5) {
            objectArray2[0 + n13] = scriptable3;
            ++n13;
        }
        DebugFrame debugFrame = null;
        if (context.debugger != null) {
            debugFrame = context.debugger.getFrame(context, interpreterData);
        }
        if (interpreterData.itsFunctionType != 0) {
            InterpretedFunction interpretedFunction = (InterpretedFunction)nativeFunction;
            if (!interpretedFunction.itsUseDynamicScope) {
                scriptable = nativeFunction.getParentScope();
            }
            if (interpreterData.itsCheckThis) {
                scriptable2 = ScriptRuntime.getThis(scriptable2);
            }
            if (interpreterData.itsNeedsActivation) {
                if (dArray != null) {
                    objectArray = Interpreter.getBase(objectArray, dArray, n, n2);
                    n = 0;
                    dArray = null;
                }
                scriptable = ScriptRuntime.initVarObj(context, scriptable, nativeFunction, scriptable2, objectArray);
            }
        } else {
            scriptable = ScriptRuntime.initScript(context, scriptable, nativeFunction, scriptable2, interpreterData.itsFromEvalCode);
        }
        if (interpreterData.itsNestedFunctions != null) {
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                Context.codeBug();
            }
            int n14 = 0;
            while (n14 < interpreterData.itsNestedFunctions.length) {
                object = interpreterData.itsNestedFunctions[n14];
                if (((InterpreterData)object).itsFunctionType == 1) {
                    Interpreter.delete(context, scriptable, (InterpreterData)object, interpreterData.itsFromEvalCode);
                }
                ++n14;
            }
        }
        boolean bl2 = false;
        if (debugFrame != null) {
            if (dArray != null) {
                objectArray = Interpreter.getBase(objectArray, dArray, n, n2);
                n = 0;
                dArray = null;
            }
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                bl2 = true;
                scriptable = ScriptRuntime.initVarObj(context, scriptable, nativeFunction, scriptable2, objectArray);
            }
            debugFrame.onEnter(context, scriptable, scriptable2, objectArray);
        }
        object = scriptable3;
        byte[] byArray = interpreterData.itsICode;
        String[] stringArray = interpreterData.itsStringTable;
        int n15 = n3 = 0;
        int n16 = context.instructionThreshold;
        int n17 = context.instructionCount;
        int n18 = 100;
        block100: while (true) {
            Object[] objectArray3;
            Object object4;
            try {
                block101: while (true) {
                    switch (byArray[n3] & 0xFF) {
                        case 76: {
                            --n10;
                            break block101;
                        }
                        case 75: {
                            objectArray2[n7 + n10] = scriptable;
                            dArray2[n7 + n10] = n3;
                            ++n10;
                            n3 += 4;
                            break block101;
                        }
                        case 19: {
                            boolean bl3;
                            Object object5 = objectArray2[--n9 + 1];
                            Object object6 = objectArray2[n9];
                            if (object5 == object2 || object6 == object2) {
                                double d = Interpreter.emptyArgs(objectArray2, dArray2, n9 + 1);
                                double d2 = Interpreter.emptyArgs(objectArray2, dArray2, n9);
                                bl3 = d == d && d2 == d2 && d <= d2;
                            } else {
                                bl3 = 1 == ScriptRuntime.cmp_LE(object5, object6);
                            }
                            objectArray2[n9] = bl3 ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 17: {
                            boolean bl4;
                            Object object7 = objectArray2[--n9 + 1];
                            Object object8 = objectArray2[n9];
                            if (object7 == object2 || object8 == object2) {
                                double d = Interpreter.emptyArgs(objectArray2, dArray2, n9 + 1);
                                double d3 = Interpreter.emptyArgs(objectArray2, dArray2, n9);
                                bl4 = d == d && d3 == d3 && d3 <= d;
                            } else {
                                bl4 = 1 == ScriptRuntime.cmp_LE(object8, object7);
                            }
                            objectArray2[n9] = bl4 ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 18: {
                            boolean bl5;
                            Object object9 = objectArray2[--n9 + 1];
                            Object object10 = objectArray2[n9];
                            if (object9 == object2 || object10 == object2) {
                                double d = Interpreter.emptyArgs(objectArray2, dArray2, n9 + 1);
                                double d4 = Interpreter.emptyArgs(objectArray2, dArray2, n9);
                                bl5 = d == d && d4 == d4 && d < d4;
                            } else {
                                bl5 = 1 == ScriptRuntime.cmp_LT(object9, object10);
                            }
                            objectArray2[n9] = bl5 ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 16: {
                            boolean bl6;
                            Object object11 = objectArray2[--n9 + 1];
                            Object object12 = objectArray2[n9];
                            if (object11 == object2 || object12 == object2) {
                                double d = Interpreter.emptyArgs(objectArray2, dArray2, n9 + 1);
                                double d5 = Interpreter.emptyArgs(objectArray2, dArray2, n9);
                                bl6 = d == d && d5 == d5 && d5 < d;
                            } else {
                                bl6 = 1 == ScriptRuntime.cmp_LT(object12, object11);
                            }
                            objectArray2[n9] = bl6 ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 63: {
                            boolean bl7;
                            Object object13;
                            Object object14 = objectArray2[n9];
                            if (object14 == object2) {
                                object14 = Interpreter.done(dArray2[n9]);
                            }
                            if ((object13 = objectArray2[--n9]) == object2) {
                                object13 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = (bl7 = ScriptRuntime.in(object13, object14, scriptable)) ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 64: {
                            boolean bl8;
                            Object object15;
                            Object object16 = objectArray2[n9];
                            if (object16 == object2) {
                                object16 = Interpreter.done(dArray2[n9]);
                            }
                            if ((object15 = objectArray2[--n9]) == object2) {
                                object15 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = (bl8 = ScriptRuntime.instanceOf(scriptable, object15, object16)) ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 14: {
                            boolean bl9 = Interpreter.equals(objectArray2, dArray2, --n9);
                            objectArray2[n9] = bl9 ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 15: {
                            boolean bl10 = !Interpreter.equals(objectArray2, dArray2, --n9);
                            objectArray2[n9] = bl10 ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 53: {
                            boolean bl11 = Interpreter.fixLabelGotos(objectArray2, dArray2, --n9);
                            objectArray2[n9] = bl11 ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 54: {
                            boolean bl12 = !Interpreter.fixLabelGotos(objectArray2, dArray2, --n9);
                            objectArray2[n9] = bl12 ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 8: {
                            double d;
                            Object object17 = objectArray2[n9];
                            boolean bl13 = object17 != object2 ? !ScriptRuntime.toBoolean(object17) : (d = dArray2[n9]) != d || d == 0.0;
                            --n9;
                            if (bl13) {
                                if (n16 != 0 && (n17 += n3 + 3 - n15) > n16) {
                                    context.observeInstructionCount(n17);
                                    n17 = 0;
                                }
                                n15 = n3 = Interpreter.construct(byArray, n3 + 1);
                                continue block101;
                            }
                            n3 += 2;
                            break block101;
                        }
                        case 7: {
                            double d;
                            Object object18 = objectArray2[n9];
                            boolean bl14 = object18 != object2 ? ScriptRuntime.toBoolean(object18) : (d = dArray2[n9]) == d && d != 0.0;
                            --n9;
                            if (bl14) {
                                if (n16 != 0 && (n17 += n3 + 3 - n15) > n16) {
                                    context.observeInstructionCount(n17);
                                    n17 = 0;
                                }
                                n15 = n3 = Interpreter.construct(byArray, n3 + 1);
                                continue block101;
                            }
                            n3 += 2;
                            break block101;
                        }
                        case 6: {
                            if (n16 != 0 && (n17 += n3 + 3 - n15) > n16) {
                                context.observeInstructionCount(n17);
                                n17 = 0;
                            }
                            n15 = n3 = Interpreter.construct(byArray, n3 + 1);
                            continue block101;
                        }
                        case 65: {
                            dArray2[++n9] = n3 + 3;
                            if (n16 != 0 && (n17 += n3 + 3 - n15) > n16) {
                                context.observeInstructionCount(n17);
                                n17 = 0;
                            }
                            n15 = n3 = Interpreter.construct(byArray, n3 + 1);
                            continue block101;
                        }
                        case 66: {
                            int n19 = byArray[n3 + 1] & 0xFF;
                            if (n16 != 0 && (n17 += n3 + 2 - n15) > n16) {
                                context.observeInstructionCount(n17);
                                n17 = 0;
                            }
                            n15 = n3 = (int)dArray2[n6 + n19];
                            continue block101;
                        }
                        case 57: {
                            --n9;
                            break block101;
                        }
                        case 9: {
                            objectArray2[n9 + 1] = objectArray2[n9];
                            dArray2[n9 + 1] = dArray2[n9];
                            ++n9;
                            break block101;
                        }
                        case 2: {
                            object = objectArray2[n9];
                            if (object == object2) {
                                object = Interpreter.done(dArray2[n9]);
                            }
                            --n9;
                            break block101;
                        }
                        case 5: {
                            object = objectArray2[n9];
                            if (object == object2) {
                                object = Interpreter.done(dArray2[n9]);
                            }
                            --n9;
                            break block100;
                        }
                        case 151: {
                            object = scriptable3;
                            break block100;
                        }
                        case 152: {
                            break block100;
                        }
                        case 28: {
                            int n20 = Interpreter.doubleValue(objectArray2, dArray2, n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = ~n20;
                            break block101;
                        }
                        case 13: {
                            int n21 = Interpreter.doubleValue(objectArray2, dArray2, n9);
                            int n22 = Interpreter.doubleValue(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = n22 & n21;
                            break block101;
                        }
                        case 11: {
                            int n23 = Interpreter.doubleValue(objectArray2, dArray2, n9);
                            int n24 = Interpreter.doubleValue(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = n24 | n23;
                            break block101;
                        }
                        case 12: {
                            int n25 = Interpreter.doubleValue(objectArray2, dArray2, n9);
                            int n26 = Interpreter.doubleValue(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = n26 ^ n25;
                            break block101;
                        }
                        case 20: {
                            int n27 = Interpreter.doubleValue(objectArray2, dArray2, n9);
                            int n28 = Interpreter.doubleValue(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = n28 << n27;
                            break block101;
                        }
                        case 21: {
                            int n29 = Interpreter.doubleValue(objectArray2, dArray2, n9);
                            int n30 = Interpreter.doubleValue(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = n30 >> n29;
                            break block101;
                        }
                        case 22: {
                            int n31 = Interpreter.doubleValue(objectArray2, dArray2, n9) & 0x1F;
                            double d = Interpreter.emptyArgs(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = ScriptRuntime.toUint32(d) >>> n31;
                            break block101;
                        }
                        case 23: {
                            Interpreter.enterWith(objectArray2, dArray2, --n9);
                            break block101;
                        }
                        case 24: {
                            double d = Interpreter.emptyArgs(objectArray2, dArray2, n9);
                            double d6 = Interpreter.emptyArgs(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = d6 - d;
                            break block101;
                        }
                        case 29: {
                            double d = Interpreter.emptyArgs(objectArray2, dArray2, n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = -d;
                            break block101;
                        }
                        case 58: {
                            double d = Interpreter.emptyArgs(objectArray2, dArray2, n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = d;
                            break block101;
                        }
                        case 25: {
                            double d = Interpreter.emptyArgs(objectArray2, dArray2, n9);
                            double d7 = Interpreter.emptyArgs(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = d7 * d;
                            break block101;
                        }
                        case 26: {
                            double d = Interpreter.emptyArgs(objectArray2, dArray2, n9);
                            double d8 = Interpreter.emptyArgs(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = d8 / d;
                            break block101;
                        }
                        case 27: {
                            double d = Interpreter.emptyArgs(objectArray2, dArray2, n9);
                            double d9 = Interpreter.emptyArgs(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object2;
                            dArray2[n9] = d9 % d;
                            break block101;
                        }
                        case 61: {
                            String string = stringArray[Interpreter.cmp_LT(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.bind(scriptable, string);
                            n3 += 2;
                            break block101;
                        }
                        case 71: {
                            String string = stringArray[Interpreter.cmp_LT(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.getBase(scriptable, string);
                            n3 += 2;
                            break block101;
                        }
                        case 10: {
                            String string = stringArray[Interpreter.cmp_LT(byArray, n3 + 1)];
                            Object object19 = objectArray2[n9];
                            if (object19 == object2) {
                                object19 = Interpreter.done(dArray2[n9]);
                            }
                            Scriptable scriptable4 = (Scriptable)objectArray2[--n9];
                            objectArray2[n9] = ScriptRuntime.setName(scriptable4, object19, scriptable, string);
                            n3 += 2;
                            break block101;
                        }
                        case 31: {
                            Object object20;
                            Object object21 = objectArray2[n9];
                            if (object21 == object2) {
                                object21 = Interpreter.done(dArray2[n9]);
                            }
                            if ((object20 = objectArray2[--n9]) == object2) {
                                object20 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.delete(object20, object21);
                            break block101;
                        }
                        case 39: {
                            String string = (String)objectArray2[n9];
                            Object object22 = objectArray2[--n9];
                            if (object22 == object2) {
                                object22 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.getProp(object22, string, scriptable);
                            break block101;
                        }
                        case 40: {
                            Object object23;
                            Object object24 = objectArray2[n9];
                            if (object24 == object2) {
                                object24 = Interpreter.done(dArray2[n9]);
                            }
                            String string = (String)objectArray2[--n9];
                            if ((object23 = objectArray2[--n9]) == object2) {
                                object23 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.setProp(object23, string, object24, scriptable);
                            break block101;
                        }
                        case 41: {
                            Interpreter.get(context, objectArray2, dArray2, n9, scriptable);
                            --n9;
                            break block101;
                        }
                        case 42: {
                            Interpreter.getAllVariables(context, objectArray2, dArray2, n9, scriptable);
                            n9 -= 2;
                            break block101;
                        }
                        case 34: {
                            String string = (String)objectArray2[n9];
                            Object object25 = objectArray2[--n9];
                            if (object25 == object2) {
                                object25 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.postIncrement(object25, string, scriptable);
                            break block101;
                        }
                        case 37: {
                            String string = (String)objectArray2[n9];
                            Object object26 = objectArray2[--n9];
                            if (object26 == object2) {
                                object26 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.postDecrement(object26, string, scriptable);
                            break block101;
                        }
                        case 35: {
                            Object object27;
                            Object object28 = objectArray2[n9];
                            if (object28 == object2) {
                                object28 = Interpreter.done(dArray2[n9]);
                            }
                            if ((object27 = objectArray2[--n9]) == object2) {
                                object27 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.postIncrementElem(object27, object28, scriptable);
                            break block101;
                        }
                        case 38: {
                            Object object29;
                            Object object30 = objectArray2[n9];
                            if (object30 == object2) {
                                object30 = Interpreter.done(dArray2[n9]);
                            }
                            if ((object29 = objectArray2[--n9]) == object2) {
                                object29 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.postDecrementElem(object29, object30, scriptable);
                            break block101;
                        }
                        case 68: {
                            Scriptable scriptable5 = (Scriptable)objectArray2[n9];
                            objectArray2[n9] = ScriptRuntime.getThis(scriptable5);
                            break block101;
                        }
                        case 69: {
                            int n32 = byArray[++n3] & 0xFF;
                            objectArray2[n6 + n32] = objectArray2[n9];
                            dArray2[n6 + n32] = dArray2[n9];
                            break block101;
                        }
                        case 70: {
                            int n33 = byArray[++n3] & 0xFF;
                            objectArray2[++n9] = objectArray2[n6 + n33];
                            dArray2[n9] = dArray2[n6 + n33];
                            break block101;
                        }
                        case 67: {
                            Object object31;
                            if (n16 != 0) {
                                context.instructionCount = n17 += 100;
                                n17 = -1;
                            }
                            int n34 = Interpreter.cmp_LE(byArray, n3 + 1);
                            String string = stringArray[Interpreter.cmp_LT(byArray, n3 + 3)];
                            int n35 = Interpreter.cmp_LT(byArray, n3 + 5);
                            Object[] objectArray4 = Interpreter.getBase(objectArray2, dArray2, (n9 -= n35) + 1, n35);
                            Object object32 = objectArray2[n9];
                            if (object32 == object2) {
                                object32 = Interpreter.done(dArray2[n9]);
                            }
                            if ((object31 = objectArray2[--n9]) == object2) {
                                object31 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.callSpecial(context, object31, object32, objectArray4, scriptable2, scriptable, string, n34);
                            n3 += 6;
                            n17 = context.instructionCount;
                            break block101;
                        }
                        case 43: {
                            if (n16 != 0) {
                                context.instructionCount = n17 += 100;
                                n17 = -1;
                            }
                            context.instructionCount = n17;
                            int n36 = Interpreter.cmp_LT(byArray, n3 + 3);
                            int n37 = (n9 -= n36) + 1;
                            Object object33 = objectArray2[n9];
                            if (object33 == object2) {
                                object33 = Interpreter.done(dArray2[n9]);
                            }
                            Object object34 = objectArray2[--n9];
                            Scriptable scriptable6 = scriptable;
                            if (interpreterData.itsNeedsActivation) {
                                scriptable6 = ScriptableObject.getTopLevelScope(scriptable);
                            }
                            Scriptable scriptable7 = object33 instanceof Scriptable || object33 == null ? (Scriptable)object33 : ScriptRuntime.toObject(context, scriptable6, object33);
                            if (object34 instanceof InterpretedFunction) {
                                object4 = (InterpretedFunction)object34;
                                objectArray2[n9] = Interpreter.interpret(context, scriptable6, scriptable7, objectArray2, dArray2, n37, n36, (NativeFunction)object4, ((InterpretedFunction)object4).itsData);
                            } else if (object34 instanceof Function) {
                                object4 = (Function)object34;
                                objectArray3 = Interpreter.getBase(objectArray2, dArray2, n37, n36);
                                objectArray2[n9] = object4.call(context, scriptable6, scriptable7, objectArray3);
                            } else {
                                if (object34 == object2) {
                                    object34 = Interpreter.done(dArray2[n9]);
                                } else if (object34 == scriptable3 && (object34 = stringArray[Interpreter.cmp_LT(byArray, n3 + 1)]) == null) {
                                    object34 = scriptable3;
                                }
                                throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(object34), scriptable6);
                            }
                            n3 += 4;
                            n17 = context.instructionCount;
                            break block101;
                        }
                        case 30: {
                            Object[] objectArray5;
                            Function function;
                            if (n16 != 0) {
                                context.instructionCount = n17 += 100;
                                n17 = -1;
                            }
                            int n38 = Interpreter.cmp_LT(byArray, n3 + 3);
                            int n39 = (n9 -= n38) + 1;
                            Object object35 = objectArray2[n9];
                            if (object35 instanceof InterpretedFunction) {
                                function = (InterpretedFunction)object35;
                                objectArray5 = ((BaseFunction)function).createObject(context, scriptable);
                                Object object36 = Interpreter.interpret(context, scriptable, (Scriptable)objectArray5, objectArray2, dArray2, n39, n38, (NativeFunction)function, ((InterpretedFunction)function).itsData);
                                objectArray2[n9] = object36 instanceof Scriptable && object36 != scriptable3 ? object36 : objectArray5;
                            } else if (object35 instanceof Function) {
                                function = (Function)object35;
                                objectArray5 = Interpreter.getBase(objectArray2, dArray2, n39, n38);
                                objectArray2[n9] = function.construct(context, scriptable, objectArray5);
                            } else {
                                if (object35 == object2) {
                                    object35 = Interpreter.done(dArray2[n9]);
                                } else if (object35 == scriptable3 && (object35 = stringArray[Interpreter.cmp_LT(byArray, n3 + 1)]) == null) {
                                    object35 = scriptable3;
                                }
                                throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(object35), scriptable);
                            }
                            n3 += 4;
                            n17 = context.instructionCount;
                            break block101;
                        }
                        case 32: {
                            Object object37 = objectArray2[n9];
                            if (object37 == object2) {
                                object37 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.typeof(object37);
                            break block101;
                        }
                        case 78: {
                            String string = stringArray[Interpreter.cmp_LT(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.typeofName(scriptable, string);
                            n3 += 2;
                            break block101;
                        }
                        case 46: {
                            objectArray2[++n9] = stringArray[Interpreter.cmp_LT(byArray, n3 + 1)];
                            n3 += 2;
                            break block101;
                        }
                        case 149: {
                            objectArray2[++n9] = object2;
                            dArray2[n9] = Interpreter.cmp_LE(byArray, n3 + 1);
                            n3 += 2;
                            break block101;
                        }
                        case 150: {
                            objectArray2[++n9] = object2;
                            dArray2[n9] = Interpreter.codeBug(byArray, n3 + 1);
                            n3 += 4;
                            break block101;
                        }
                        case 45: {
                            objectArray2[++n9] = object2;
                            dArray2[n9] = interpreterData.itsDoubleTable[Interpreter.cmp_LT(byArray, n3 + 1)];
                            n3 += 2;
                            break block101;
                        }
                        case 44: {
                            String string = stringArray[Interpreter.cmp_LT(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.name(scriptable, string);
                            n3 += 2;
                            break block101;
                        }
                        case 33: {
                            String string = stringArray[Interpreter.cmp_LT(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.postIncrement(scriptable, string);
                            n3 += 2;
                            break block101;
                        }
                        case 36: {
                            String string = stringArray[Interpreter.cmp_LT(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.postDecrement(scriptable, string);
                            n3 += 2;
                            break block101;
                        }
                        case 73: {
                            int n40 = byArray[++n3] & 0xFF;
                            if (!bl2) {
                                objectArray2[0 + n40] = objectArray2[n9];
                                dArray2[0 + n40] = dArray2[n9];
                                break block101;
                            }
                            Object object38 = objectArray2[n9];
                            if (object38 == object2) {
                                object38 = Interpreter.done(dArray2[n9]);
                            }
                            Interpreter.getDefaultValue(nativeFunction, scriptable, n40, object38);
                            break block101;
                        }
                        case 72: {
                            int n41 = byArray[++n3] & 0xFF;
                            ++n9;
                            if (!bl2) {
                                objectArray2[n9] = objectArray2[0 + n41];
                                dArray2[n9] = dArray2[0 + n41];
                                break block101;
                            }
                            objectArray2[n9] = Interpreter.getCheckThis(nativeFunction, scriptable, n41);
                            break block101;
                        }
                        case 59: {
                            Object object39;
                            int n42 = byArray[++n3] & 0xFF;
                            ++n9;
                            if (!bl2) {
                                objectArray2[n9] = objectArray2[0 + n42];
                                dArray2[n9] = dArray2[0 + n42];
                                objectArray2[0 + n42] = object2;
                                dArray2[0 + n42] = Interpreter.emptyArgs(objectArray2, dArray2, n9) + 1.0;
                                break block101;
                            }
                            objectArray2[n9] = object39 = Interpreter.getCheckThis(nativeFunction, scriptable, n42);
                            object39 = Interpreter.done(ScriptRuntime.toNumber(object39) + 1.0);
                            Interpreter.getDefaultValue(nativeFunction, scriptable, n42, object39);
                            break block101;
                        }
                        case 60: {
                            Object object40;
                            int n43 = byArray[++n3] & 0xFF;
                            ++n9;
                            if (!bl2) {
                                objectArray2[n9] = objectArray2[0 + n43];
                                dArray2[n9] = dArray2[0 + n43];
                                objectArray2[0 + n43] = object2;
                                dArray2[0 + n43] = Interpreter.emptyArgs(objectArray2, dArray2, n9) - 1.0;
                                break block101;
                            }
                            objectArray2[n9] = object40 = Interpreter.getCheckThis(nativeFunction, scriptable, n43);
                            object40 = Interpreter.done(ScriptRuntime.toNumber(object40) - 1.0);
                            Interpreter.getDefaultValue(nativeFunction, scriptable, n43, object40);
                            break block101;
                        }
                        case 47: {
                            objectArray2[++n9] = object2;
                            dArray2[n9] = 0.0;
                            break block101;
                        }
                        case 48: {
                            objectArray2[++n9] = object2;
                            dArray2[n9] = 1.0;
                            break block101;
                        }
                        case 49: {
                            objectArray2[++n9] = null;
                            break block101;
                        }
                        case 50: {
                            objectArray2[++n9] = scriptable2;
                            break block101;
                        }
                        case 87: {
                            objectArray2[++n9] = nativeFunction;
                            break block101;
                        }
                        case 51: {
                            objectArray2[++n9] = Boolean.FALSE;
                            break block101;
                        }
                        case 52: {
                            objectArray2[++n9] = Boolean.TRUE;
                            break block101;
                        }
                        case 74: {
                            objectArray2[++n9] = Undefined.instance;
                            break block101;
                        }
                        case 62: {
                            Object object41 = objectArray2[n9];
                            if (object41 == object2) {
                                object41 = Interpreter.done(dArray2[n9]);
                            }
                            --n9;
                            throw new JavaScriptException(object41);
                        }
                        case 88: {
                            Object object42 = objectArray2[n9];
                            --n9;
                            if (object42 instanceof JavaScriptException) {
                                throw (JavaScriptException)object42;
                            }
                            throw (RuntimeException)object42;
                        }
                        case 3: {
                            Object object43 = objectArray2[n9];
                            if (object43 == object2) {
                                object43 = Interpreter.done(dArray2[n9]);
                            }
                            --n9;
                            scriptable = ScriptRuntime.enterWith(object43, scriptable);
                            break block101;
                        }
                        case 4: {
                            scriptable = ScriptRuntime.leaveWith(scriptable);
                            break block101;
                        }
                        case 77: {
                            objectArray2[++n9] = ScriptRuntime.newScope();
                            break block101;
                        }
                        case 79: {
                            int n44 = byArray[++n3] & 0xFF;
                            Object object44 = objectArray2[n9];
                            if (object44 == object2) {
                                object44 = Interpreter.done(dArray2[n9]);
                            }
                            --n9;
                            objectArray2[n6 + n44] = ScriptRuntime.initEnum(object44, scriptable);
                            break block101;
                        }
                        case 80: {
                            int n45 = byArray[++n3] & 0xFF;
                            Object object45 = objectArray2[n6 + n45];
                            objectArray2[++n9] = ScriptRuntime.nextEnum(object45);
                            break block101;
                        }
                        case 81: {
                            Object object46 = objectArray2[n9];
                            if (object46 == object2) {
                                object46 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.getProto(object46, scriptable);
                            break block101;
                        }
                        case 82: {
                            Object object47 = objectArray2[n9];
                            if (object47 == object2) {
                                object47 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.getParent(object47);
                            break block101;
                        }
                        case 86: {
                            Object object48 = objectArray2[n9];
                            if (object48 == object2) {
                                object48 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.getParent(object48, scriptable);
                            break block101;
                        }
                        case 83: {
                            Object object49;
                            Object object50 = objectArray2[n9];
                            if (object50 == object2) {
                                object50 = Interpreter.done(dArray2[n9]);
                            }
                            if ((object49 = objectArray2[--n9]) == object2) {
                                object49 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.setProto(object49, object50, scriptable);
                            break block101;
                        }
                        case 84: {
                            Object object51;
                            Object object52 = objectArray2[n9];
                            if (object52 == object2) {
                                object52 = Interpreter.done(dArray2[n9]);
                            }
                            if ((object51 = objectArray2[--n9]) == object2) {
                                object51 = Interpreter.done(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.setParent(object51, object52, scriptable);
                            break block101;
                        }
                        case 85: {
                            objectArray2[++n9] = scriptable;
                            break block101;
                        }
                        case 55: {
                            int n46 = Interpreter.cmp_LT(byArray, n3 + 1);
                            InterpreterData interpreterData2 = interpreterData.itsNestedFunctions[n46];
                            objectArray2[++n9] = Interpreter.delete(context, scriptable, interpreterData2, interpreterData.itsFromEvalCode);
                            n3 += 2;
                            break block101;
                        }
                        case 56: {
                            int n47 = Interpreter.cmp_LT(byArray, n3 + 1);
                            objectArray2[++n9] = interpreterData.itsRegExpLiterals[n47];
                            n3 += 2;
                            break block101;
                        }
                        case 148: {
                            context.interpreterSourceFile = interpreterData.itsSourceFile;
                            break block101;
                        }
                        case 147: {
                            int n48;
                            context.interpreterLine = n48 = Interpreter.cmp_LE(byArray, n3 + 1);
                            if (debugFrame != null) {
                                debugFrame.onLineChange(context, n48);
                            }
                            n3 += 2;
                            break block101;
                        }
                        default: {
                            Interpreter.createObject(interpreterData);
                            throw new RuntimeException("Unknown icode : " + (byArray[n3] & 0xFF) + " @ pc : " + n3);
                        }
                    }
                    break;
                }
                ++n3;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                int n49;
                block211: {
                    block212: {
                        if (n16 != 0) {
                            if (n17 < 0) {
                                n17 = context.instructionCount;
                            } else {
                                context.instructionCount = n17 += n3 - n15;
                            }
                        }
                        boolean bl15 = false;
                        boolean bl16 = true;
                        int n50 = 2;
                        int n51 = 3;
                        object4 = throwable;
                        while (true) {
                            if (object4 instanceof JavaScriptException) {
                                object4 = ScriptRuntime.unwrapJavaScriptException((JavaScriptException)object4);
                                n49 = 0;
                                break block211;
                            }
                            if (object4 instanceof EcmaError) {
                                object4 = ((EcmaError)object4).getErrorObject();
                                n49 = 1;
                                break block211;
                            }
                            if (!(object4 instanceof RuntimeException)) break block212;
                            if (!(object4 instanceof WrappedException) || !((objectArray3 = ((WrappedException)object4).unwrap()) instanceof Throwable)) break;
                            throwable2 = (Throwable)objectArray3;
                            object4 = throwable2;
                        }
                        object4 = null;
                        n49 = 2;
                        break block211;
                    }
                    object4 = null;
                    n49 = 3;
                }
                if (n49 != 3 && debugFrame != null) {
                    debugFrame.onExceptionThrown(context, throwable2);
                }
                boolean bl17 = true;
                if (n49 != 3 && n10 > 0) {
                    int n52;
                    int n53 = (int)dArray2[n7 + --n10];
                    if ((n49 == 0 || n49 == 1) && (n52 = Interpreter.cmp_LE(byArray, n53 + 1)) != 0) {
                        bl17 = false;
                        n3 = n53 + n52;
                        n9 = n8;
                        objectArray2[n9] = object4;
                    }
                    if (bl17 && (n52 = Interpreter.cmp_LE(byArray, n53 + 3)) != 0) {
                        bl17 = false;
                        n3 = n53 + n52;
                        n9 = n8;
                        objectArray2[n9] = throwable2;
                    }
                }
                if (bl17) {
                    if (debugFrame != null) {
                        debugFrame.onExit(context, true, throwable2);
                    }
                    if (interpreterData.itsNeedsActivation) {
                        ScriptRuntime.popActivation(context);
                    }
                    if (n49 == 0) {
                        throw (JavaScriptException)throwable2;
                    }
                    if (n49 == 1 || n49 == 2) {
                        throw (RuntimeException)throwable2;
                    }
                    throw (Error)throwable2;
                }
                if (n16 != 0 && n17 > n16) {
                    context.observeInstructionCount(n17);
                    n17 = 0;
                }
                n15 = n3;
                scriptable = (Scriptable)objectArray2[n7 + n10];
            }
        }
        if (debugFrame != null) {
            debugFrame.onExit(context, false, object);
        }
        if (interpreterData.itsNeedsActivation) {
            ScriptRuntime.popActivation(context);
        }
        if (n16 != 0) {
            if (n17 > n16) {
                context.observeInstructionCount(n17);
                n17 = 0;
            }
            context.instructionCount = n17;
        }
        return object;
    }

    private static Object done(double d) {
        return new Double(d);
    }

    private static int doubleValue(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n];
        return object != append ? ScriptRuntime.toInt32(object) : ScriptRuntime.toInt32(dArray[n]);
    }

    private static double emptyArgs(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n];
        return object != append ? ScriptRuntime.toNumber(object) : dArray[n];
    }

    private static void enterWith(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == append) {
            double d = dArray[n + 1];
            if (object2 == append) {
                int n2 = n;
                dArray[n2] = dArray[n2] + d;
            } else {
                Interpreter.eq(object2, d, objectArray, dArray, n, true);
            }
        } else if (object2 == append) {
            Interpreter.eq(object, dArray[n], objectArray, dArray, n, false);
        } else {
            if (object2 instanceof Scriptable) {
                object2 = ((Scriptable)object2).getDefaultValue(null);
            }
            if (object instanceof Scriptable) {
                object = ((Scriptable)object).getDefaultValue(null);
            }
            if (object2 instanceof String || object instanceof String) {
                objectArray[n] = ScriptRuntime.toString(object2) + ScriptRuntime.toString(object);
            } else {
                double d = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
                double d2 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
                objectArray[n] = append;
                dArray[n] = d + d2;
            }
        }
    }

    private static void eq(Object object, double d, Object[] objectArray, double[] dArray, int n, boolean bl) {
        if (object instanceof Scriptable) {
            object = object == Undefined.instance ? ScriptRuntime.NaNobj : ((Scriptable)object).getDefaultValue(null);
        }
        if (object instanceof String) {
            objectArray[n] = bl ? (String)object + ScriptRuntime.toString(d) : ScriptRuntime.toString(d) + (String)object;
        } else {
            double d2 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
            objectArray[n] = append;
            dArray[n] = d2 + d;
        }
    }

    private static boolean equals(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        boolean bl = object == append ? (object2 == append ? dArray[n] == dArray[n + 1] : Interpreter.execWithDomain(dArray[n + 1], object2)) : (object2 == append ? Interpreter.execWithDomain(dArray[n], object) : ScriptRuntime.eq(object2, object));
        return bl;
    }

    private static boolean execWithDomain(double d, Object object) {
        while (true) {
            if (object instanceof Number) {
                return d == ((Number)object).doubleValue();
            }
            if (object instanceof String) {
                return d == ScriptRuntime.toNumber((String)object);
            }
            if (object instanceof Boolean) {
                return d == ((Boolean)object != false ? 1.0 : 0.0);
            }
            if (!(object instanceof Scriptable)) break;
            if (object == Undefined.instance) {
                return false;
            }
            object = ScriptRuntime.toPrimitive(object);
        }
        return false;
    }

    private static boolean fixLabelGotos(Object[] objectArray, double[] dArray, int n) {
        boolean bl;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == append) {
            double d = dArray[n + 1];
            if (object2 == append) {
                bl = dArray[n] == d;
            } else {
                bl = object2 instanceof Number;
                if (bl) {
                    bl = ((Number)object2).doubleValue() == d;
                }
            }
        } else if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (object2 == append) {
                bl = dArray[n] == d;
            } else {
                bl = object2 instanceof Number;
                if (bl) {
                    bl = ((Number)object2).doubleValue() == d;
                }
            }
        } else {
            bl = ScriptRuntime.shallowEq(object2, object);
        }
        return bl;
    }

    private static void get(Context context, Object[] objectArray, double[] dArray, int n, Scriptable scriptable) {
        Object object;
        Object object2;
        Object object3 = objectArray[n - 1];
        if (object3 == append) {
            object3 = Interpreter.done(dArray[n - 1]);
        }
        if ((object2 = objectArray[n]) != append) {
            object = ScriptRuntime.getElem(object3, object2, scriptable);
        } else {
            Scriptable scriptable2 = object3 instanceof Scriptable ? (Scriptable)object3 : ScriptRuntime.toObject(context, scriptable, object3);
            double d = dArray[n];
            int n2 = (int)d;
            if ((double)n2 == d) {
                object = ScriptRuntime.getElem(scriptable2, n2);
            } else {
                String string = ScriptRuntime.toString(d);
                object = ScriptRuntime.getStrIdElem(scriptable2, string);
            }
        }
        objectArray[n - 1] = object;
    }

    private static void getAllVariables(Context context, Object[] objectArray, double[] dArray, int n, Scriptable scriptable) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = objectArray[n];
        if (object4 == append) {
            object4 = Interpreter.done(dArray[n]);
        }
        if ((object3 = objectArray[n - 2]) == append) {
            object3 = Interpreter.done(dArray[n - 2]);
        }
        if ((object2 = objectArray[n - 1]) != append) {
            object = ScriptRuntime.setElem(object3, object2, object4, scriptable);
        } else {
            Scriptable scriptable2 = object3 instanceof Scriptable ? (Scriptable)object3 : ScriptRuntime.toObject(context, scriptable, object3);
            double d = dArray[n - 1];
            int n2 = (int)d;
            if ((double)n2 == d) {
                object = ScriptRuntime.setElem(scriptable2, n2, object4);
            } else {
                String string = ScriptRuntime.toString(d);
                object = ScriptRuntime.setStrIdElem(scriptable2, string, object4, scriptable);
            }
        }
        objectArray[n - 2] = object;
    }

    private static Object[] getBase(Object[] objectArray, double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        while (n3 != n2) {
            Object object = objectArray[n];
            if (object == append) {
                object = Interpreter.done(dArray[n]);
            }
            objectArray2[n3] = object;
            ++n3;
            ++n;
        }
        return objectArray2;
    }

    private static Object getCheckThis(NativeFunction nativeFunction, Scriptable scriptable, int n) {
        String string = nativeFunction.argNames[n];
        Object object = scriptable.get(string, scriptable);
        if (object == Scriptable.NOT_FOUND) {
            Context.codeBug();
        }
        return object;
    }

    private static void getDefaultValue(NativeFunction nativeFunction, Scriptable scriptable, int n, Object object) {
        String string = nativeFunction.argNames[n];
        scriptable.put(string, scriptable, object);
    }

    private static Object getDouble(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, double[] dArray, int n, int n2, NativeFunction nativeFunction, InterpreterData interpreterData) throws JavaScriptException {
        if (context.interpreterSecurityDomain == interpreterData.securityDomain) {
            Context.codeBug();
        }
        Script script = new Script(scriptable2, objectArray, dArray, n, n2, nativeFunction, interpreterData){
            private final Scriptable val$thisObj;
            private final Object[] val$args;
            private final double[] val$argsDbl;
            private final int val$argShift;
            private final int val$argCount;
            private final NativeFunction val$fnOrScript;
            private final InterpreterData val$idata;
            {
                this.val$thisObj = scriptable;
                this.val$args = objectArray;
                this.val$argsDbl = dArray;
                this.val$argShift = n;
                this.val$argCount = n2;
                this.val$fnOrScript = nativeFunction;
                this.val$idata = interpreterData;
            }

            public Object exec(Context context, Scriptable scriptable) throws JavaScriptException {
                return Interpreter.interpret(context, scriptable, this.val$thisObj, this.val$args, this.val$argsDbl, this.val$argShift, this.val$argCount, this.val$fnOrScript, this.val$idata);
            }
        };
        Object object = context.interpreterSecurityDomain;
        context.interpreterSecurityDomain = interpreterData.securityDomain;
        try {
            Object object2 = context.getSecurityController().execWithDomain(context, scriptable, script, interpreterData.securityDomain);
            Object var13_12 = null;
            context.interpreterSecurityDomain = object;
            return object2;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            context.interpreterSecurityDomain = object;
            throw throwable;
        }
    }

    static {
        append = new Object();
    }
}

