/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

public class LabelTable {
    private int[] OEAB;
    private int arraycopy;
    private long[] I;
    private int Z;

    public int acquireLabel() {
        int n = this.arraycopy;
        if (this.OEAB == null || n == this.OEAB.length) {
            if (this.OEAB == null) {
                this.OEAB = new int[32];
            } else {
                int[] nArray = new int[this.OEAB.length * 2];
                System.arraycopy(this.OEAB, 0, nArray, 0, n);
                this.OEAB = nArray;
            }
        }
        this.arraycopy = n + 1;
        this.OEAB[n] = -1;
        return n;
    }

    public int getLabelPC(int n) {
        if (n > this.arraycopy) {
            throw new RuntimeException();
        }
        return this.OEAB[n];
    }

    public void markLabel(int n, int n2) {
        if (n > this.arraycopy || n2 < 0) {
            throw new RuntimeException();
        }
        if (this.OEAB[n] != -1) {
            throw new RuntimeException();
        }
        this.OEAB[n] = n2;
    }

    public void addLabelFixup(int n, int n2) {
        if (n > this.arraycopy || n2 < 0) {
            throw new RuntimeException();
        }
        int n3 = this.Z;
        if (this.I == null || n3 == this.I.length) {
            if (this.I == null) {
                this.I = new long[40];
            } else {
                long[] lArray = new long[this.I.length * 2];
                System.arraycopy(this.I, 0, lArray, 0, n3);
                this.I = lArray;
            }
        }
        this.Z = n3 + 1;
        this.I[n3] = (long)n << 32 | (long)n2;
    }

    public void fixLabelGotos(byte[] byArray) {
        int n = 0;
        while (n < this.Z) {
            long l = this.I[n];
            int n2 = (int)(l >> 32);
            int n3 = (int)l;
            int n4 = this.OEAB[n2];
            if (n4 == -1) {
                throw new RuntimeException();
            }
            int n5 = n4 - (n3 - 1);
            if ((short)n5 != n5) {
                throw new RuntimeException("Program too complex: too big jump offset");
            }
            byArray[n3] = (byte)(n5 >> 8);
            byArray[n3 + 1] = (byte)n5;
            ++n;
        }
        this.Z = 0;
    }

    public void clearLabels() {
        this.arraycopy = 0;
        this.Z = 0;
    }
}

