/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.WrappedException;

public class NativeFunction
extends BaseFunction {
    protected String[] argNames;
    protected short argCount;
    protected short version;
    boolean fromFunctionConstructor;

    public String decompile(Context context, int n, boolean bl) {
        Object object = this.getSourcesTree();
        if (object == null) {
            return super.decompile(context, n, bl);
        }
        return Parser.decompile(object, this.fromFunctionConstructor, this.version, n, bl);
    }

    public int getLength() {
        Context context = Context.getContext();
        if (context != null && context.getLanguageVersion() != 120) {
            return this.argCount;
        }
        NativeCall nativeCall = this.getActivation(context);
        if (nativeCall == null) {
            return this.argCount;
        }
        return nativeCall.getOriginalArguments().length;
    }

    public int getArity() {
        return this.argCount;
    }

    public String getFunctionName() {
        if (this.fromFunctionConstructor) {
            return this.version == 120 ? "" : "anonymous";
        }
        return super.getFunctionName();
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }

    protected Object getSourcesTree() {
        Class<?> clazz = this.getClass();
        try {
            Method method = clazz.getDeclaredMethod("getSourcesTreeImpl", new Class[0]);
            return method.invoke(null, ScriptRuntime.emptyArgs);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (Exception exception) {
            throw WrappedException.wrapException(exception);
        }
    }
}

