/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.debug.DebuggableObject;

public abstract class ScriptableObject
implements Scriptable,
Serializable,
DebuggableObject {
    static final long serialVersionUID = 2762574228534679611L;
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    protected Scriptable prototype;
    protected Scriptable parent;
    private static final Object B = Void.TYPE;
    private static final Slot ByteClass = new Slot(null);
    private static Hashtable FloatClass = null;
    private transient Slot[] FunctionClass;
    private int count;
    private transient Slot IntegerClass = ByteClass;
    private static final Class NumberClass = class$org$mozilla$javascript$Context == null ? (class$org$mozilla$javascript$Context = ScriptableObject.class$("org.mozilla.javascript.Context")) : class$org$mozilla$javascript$Context;
    static Class class$org$mozilla$javascript$Scriptable;
    static Class class$org$mozilla$javascript$Function;
    static Class class$org$mozilla$javascript$FunctionObject;
    static Class class$org$mozilla$javascript$ScriptableObject;
    static Class class$org$mozilla$javascript$Context;

    public abstract String getClassName();

    public boolean has(String string, Scriptable scriptable) {
        Slot slot = this.IntegerClass;
        if (string != slot.stringKey || slot.wasDeleted != 0) {
            slot = this.FALSE(string, string.hashCode());
            if (slot == null) {
                return false;
            }
            slot.stringKey = string;
            this.IntegerClass = slot;
        }
        return true;
    }

    public boolean has(int n, Scriptable scriptable) {
        return this.FALSE(null, n) != null;
    }

    public Object get(String string, Scriptable scriptable) {
        Slot slot = this.IntegerClass;
        if (string != slot.stringKey || slot.wasDeleted != 0) {
            slot = this.FALSE(string, string.hashCode());
            if (slot == null) {
                return Scriptable.NOT_FOUND;
            }
            slot.stringKey = string;
            this.IntegerClass = slot;
        }
        if ((slot.flags & 1) != 0) {
            return this.B((GetterSlot)slot, scriptable);
        }
        return slot.value;
    }

    private Object B(GetterSlot getterSlot, Scriptable scriptable) {
        try {
            if (getterSlot.delegateTo == null) {
                Class<?> clazz = getterSlot.getter.getDeclaringClass();
                while (!clazz.isInstance(scriptable)) {
                    if ((scriptable = scriptable.getPrototype()) != null) continue;
                    scriptable = this;
                    break;
                }
                return getterSlot.getter.invoke((Object)scriptable, ScriptRuntime.emptyArgs);
            }
            Object[] objectArray = new Object[]{this};
            return getterSlot.getter.invoke(getterSlot.delegateTo, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw WrappedException.wrapException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
    }

    public Object get(int n, Scriptable scriptable) {
        Slot slot = this.FALSE(null, n);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.value;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        int n;
        Slot slot = this.IntegerClass;
        if ((string != slot.stringKey || slot.wasDeleted != 0) && (slot = this.FALSE(string, n = string.hashCode())) == null) {
            if (scriptable != this) {
                scriptable.put(string, scriptable, object);
                return;
            }
            slot = this.FunctionClass(string, n);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if ((slot.flags & 2) != 0) {
            this.BooleanClass((GetterSlot)slot, scriptable, object);
            return;
        }
        if (this == scriptable) {
            slot.value = object;
        } else {
            scriptable.put(string, scriptable, object);
        }
    }

    private void BooleanClass(GetterSlot getterSlot, Scriptable scriptable, Object object) {
        Object object2;
        Object[] objectArray;
        Object object3;
        Serializable serializable;
        Context context = Context.getContext();
        Class<?>[] classArray = getterSlot.setter.getParameterTypes();
        Class<?> clazz = classArray[classArray.length - 1];
        Object object4 = FunctionObject.convertArg(context, scriptable, object, clazz);
        if (getterSlot.delegateTo == null) {
            serializable = getterSlot.setter.getDeclaringClass();
            while (!serializable.isInstance(scriptable)) {
                if ((scriptable = scriptable.getPrototype()) != null) continue;
                scriptable = this;
                break;
            }
            object3 = scriptable;
            objectArray = new Object[]{object4};
        } else {
            object3 = getterSlot.delegateTo;
            objectArray = new Object[]{this, object4};
        }
        try {
            object2 = getterSlot.setter.invoke(object3, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw WrappedException.wrapException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        if (getterSlot.setterReturnsValue) {
            serializable = new Slot(null);
            ((Slot)serializable).intKey = getterSlot.intKey;
            ((Slot)serializable).stringKey = getterSlot.stringKey;
            ((Slot)serializable).attributes = getterSlot.attributes;
            ((Slot)serializable).value = object2;
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                int n = ScriptableObject.FloatClass(this.FunctionClass, getterSlot.stringKey, getterSlot.intKey);
                if (n >= 0 && this.FunctionClass[n] == getterSlot) {
                    this.FunctionClass[n] = serializable;
                }
            }
        }
    }

    public void put(int n, Scriptable scriptable, Object object) {
        Slot slot = this.FALSE(null, n);
        if (slot == null) {
            if (scriptable != this) {
                scriptable.put(n, scriptable, object);
                return;
            }
            slot = this.FunctionClass(null, n);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (this == scriptable) {
            slot.value = object;
        } else {
            scriptable.put(n, scriptable, object);
        }
    }

    public void delete(String string) {
        this.NumberClass(string, string.hashCode());
    }

    public void delete(int n) {
        this.NumberClass(null, n);
    }

    public int getAttributes(String string, Scriptable scriptable) throws PropertyException {
        Slot slot = this.FALSE(string, string.hashCode());
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        return slot.attributes;
    }

    public int getAttributes(int n, Scriptable scriptable) throws PropertyException {
        Slot slot = this.FALSE(null, n);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        return slot.attributes;
    }

    public void setAttributes(String string, Scriptable scriptable, int n) throws PropertyException {
        int n2 = 7;
        n &= 7;
        Slot slot = this.FALSE(string, string.hashCode());
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        slot.attributes = (short)n;
    }

    public void setAttributes(int n, Scriptable scriptable, int n2) throws PropertyException {
        int n3 = 7;
        n2 &= 7;
        Slot slot = this.FALSE(null, n);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        slot.attributes = (short)n2;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    public Object[] getIds() {
        return this.getIds(false);
    }

    public Object[] getAllIds() {
        return this.getIds(true);
    }

    public Object getDefaultValue(Class clazz) {
        Context context = null;
        try {
            int n = 0;
            while (n < 2) {
                block23: {
                    Object object;
                    Object object2;
                    block24: {
                        Object object3;
                        block22: {
                            boolean bl = clazz == ScriptRuntime.StringClass ? n == 0 : n == 1;
                            if (!bl) break block22;
                            object2 = ScriptableObject.getProperty((Scriptable)this, "toString");
                            if (!(object2 instanceof Function)) break block23;
                            object3 = (Function)object2;
                            if (context == null) {
                                context = Context.getContext();
                            }
                            object = object3.call(context, object3.getParentScope(), this, ScriptRuntime.emptyArgs);
                            break block24;
                        }
                        if (clazz == null) {
                            object2 = "undefined";
                        } else if (clazz == ScriptRuntime.StringClass) {
                            object2 = "string";
                        } else if (clazz == ScriptRuntime.ScriptableClass) {
                            object2 = "object";
                        } else if (clazz == ScriptRuntime.FunctionClass) {
                            object2 = "function";
                        } else if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
                            object2 = "boolean";
                        } else if (clazz == ScriptRuntime.NumberClass || clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE || clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE || clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE || clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
                            object2 = "number";
                        } else {
                            throw Context.reportRuntimeError1("msg.invalid.type", clazz.toString());
                        }
                        object3 = ScriptableObject.getProperty((Scriptable)this, "valueOf");
                        if (!(object3 instanceof Function)) break block23;
                        Function function = (Function)object3;
                        Object[] objectArray = new Object[]{object2};
                        if (context == null) {
                            context = Context.getContext();
                        }
                        object = function.call(context, function.getParentScope(), this, objectArray);
                    }
                    if (!(object == null || object != Undefined.instance && object instanceof Scriptable && clazz != (class$org$mozilla$javascript$Scriptable == null ? ScriptableObject.class$("org.mozilla.javascript.Scriptable") : class$org$mozilla$javascript$Scriptable) && clazz != (class$org$mozilla$javascript$Function == null ? ScriptableObject.class$("org.mozilla.javascript.Function") : class$org$mozilla$javascript$Function))) {
                        return object;
                    }
                    if (object instanceof NativeJavaObject && (object2 = ((Wrapper)object).unwrap()) instanceof String) {
                        return object2;
                    }
                }
                ++n;
            }
        }
        catch (JavaScriptException javaScriptException) {
            // empty catch block
        }
        String string = clazz == null ? "undefined" : clazz.toString();
        throw NativeGlobal.typeError1("msg.default.value", string, this);
    }

    public boolean hasInstance(Scriptable scriptable) {
        return ScriptRuntime.jsDelegatesTo(scriptable, this);
    }

    public static void defineClass(Scriptable scriptable, Class clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        ScriptableObject.defineClass(scriptable, clazz, false);
    }

    public static void defineClass(Scriptable scriptable, Class clazz, boolean bl) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        Object object;
        Object object2;
        Object object3;
        GenericDeclaration[] genericDeclarationArray;
        Object object4;
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        int n = 0;
        while (n < methodArray.length) {
            object4 = methodArray[n];
            if (((Method)object4).getName().equals("init")) {
                genericDeclarationArray = ((Method)object4).getParameterTypes();
                if (genericDeclarationArray.length == 3 && genericDeclarationArray[0] == NumberClass && genericDeclarationArray[1] == ScriptRuntime.ScriptableClass && genericDeclarationArray[2] == Boolean.TYPE && Modifier.isStatic(((Method)object4).getModifiers())) {
                    Object[] objectArray = new Object[]{Context.getContext(), scriptable, bl ? Boolean.TRUE : Boolean.FALSE};
                    ((Method)object4).invoke(null, objectArray);
                    return;
                }
                if (genericDeclarationArray.length == 1 && genericDeclarationArray[0] == ScriptRuntime.ScriptableClass && Modifier.isStatic(((Method)object4).getModifiers())) {
                    Object[] objectArray = new Object[]{scriptable};
                    ((Method)object4).invoke(null, objectArray);
                    return;
                }
            }
            ++n;
        }
        object4 = ScriptableObject.ScriptableClass();
        genericDeclarationArray = clazz.getConstructors();
        GenericDeclaration genericDeclaration = null;
        int n2 = 0;
        while (n2 < genericDeclarationArray.length) {
            if (((Constructor)genericDeclarationArray[n2]).getParameterTypes().length == 0) {
                genericDeclaration = genericDeclarationArray[n2];
                break;
            }
            ++n2;
        }
        if (genericDeclaration == null) {
            throw new ClassDefinitionException(Context.getMessage1("msg.zero.arg.ctor", clazz.getName()));
        }
        Scriptable scriptable2 = (Scriptable)genericDeclaration.newInstance(ScriptRuntime.emptyArgs);
        scriptable2.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        String string = scriptable2.getClassName();
        String string2 = "js_";
        String string3 = "jsFunction_";
        String string4 = "jsStaticFunction_";
        String string5 = "jsProperty_";
        String string6 = "jsGet_";
        String string7 = "jsSet_";
        String string8 = "jsConstructor";
        boolean bl2 = false;
        Method[] methodArray2 = FunctionObject.findMethods(clazz, "jsConstructor");
        GenericDeclaration genericDeclaration2 = null;
        if (methodArray2 != null) {
            if (methodArray2.length > 1) {
                throw new ClassDefinitionException(Context.getMessage2("msg.multiple.ctors", methodArray2[0], methodArray2[1]));
            }
            genericDeclaration2 = methodArray2[0];
            bl2 = true;
        }
        int n3 = 0;
        while (n3 < methodArray.length) {
            object3 = methodArray[n3].getName();
            object2 = null;
            if (!((String)object3).startsWith("js")) {
                object2 = null;
            } else if (((String)object3).startsWith("js_")) {
                object2 = "js_";
            } else if (((String)object3).startsWith("jsFunction_")) {
                object2 = "jsFunction_";
            } else if (((String)object3).startsWith("jsStaticFunction_")) {
                object2 = "jsStaticFunction_";
            } else if (((String)object3).startsWith("jsProperty_")) {
                object2 = "jsProperty_";
            } else if (((String)object3).startsWith("jsGet_")) {
                object2 = "jsGet_";
            } else if (((String)object3).startsWith("jsSet_")) {
                object2 = "jsSet_";
            }
            if (object2 != null) {
                bl2 = true;
                object3 = ((String)object3).substring(((String)object2).length());
            }
            if (((String)object3).equals(string)) {
                if (genericDeclaration2 != null) {
                    throw new ClassDefinitionException(Context.getMessage2("msg.multiple.ctors", genericDeclaration2, methodArray[n3]));
                }
                genericDeclaration2 = methodArray[n3];
            }
            ++n3;
        }
        if (genericDeclaration2 == null) {
            if (genericDeclarationArray.length == 1) {
                genericDeclaration2 = genericDeclarationArray[0];
            } else if (genericDeclarationArray.length == 2) {
                if (((Constructor)genericDeclarationArray[0]).getParameterTypes().length == 0) {
                    genericDeclaration2 = genericDeclarationArray[1];
                } else if (((Constructor)genericDeclarationArray[1]).getParameterTypes().length == 0) {
                    genericDeclaration2 = genericDeclarationArray[0];
                }
            }
            if (genericDeclaration2 == null) {
                throw new ClassDefinitionException(Context.getMessage1("msg.ctor.multiple.parms", clazz.getName()));
            }
        }
        if (((FunctionObject)(object3 = new FunctionObject(string, (Member)((Object)genericDeclaration2), scriptable))).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", genericDeclaration2.getName());
        }
        ((FunctionObject)object3).addAsConstructor(scriptable, scriptable2);
        if (!bl2 && object4 == null) {
            object4 = ScriptableObject.ScriptableClass();
        }
        object2 = null;
        int n4 = 0;
        while (n4 < methodArray.length) {
            block58: {
                Object object5;
                block67: {
                    block60: {
                        block62: {
                            block66: {
                                block65: {
                                    block64: {
                                        block63: {
                                            block61: {
                                                block59: {
                                                    if (!bl2 && methodArray[n4].getDeclaringClass() != clazz) break block58;
                                                    object = methodArray[n4].getName();
                                                    if (!((String)object).equals("finishInit") || ((Class<?>[])(object5 = methodArray[n4].getParameterTypes())).length != 3 || object5[0] != ScriptRuntime.ScriptableClass || object5[1] != (class$org$mozilla$javascript$FunctionObject == null ? ScriptableObject.class$("org.mozilla.javascript.FunctionObject") : class$org$mozilla$javascript$FunctionObject) || object5[2] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(methodArray[n4].getModifiers())) break block59;
                                                    object2 = methodArray[n4];
                                                    break block58;
                                                }
                                                if (((String)object).indexOf(36) != -1 || ((String)object).equals("jsConstructor")) break block58;
                                                object5 = null;
                                                if (!bl2) break block60;
                                                if (!((String)object).startsWith("js_")) break block61;
                                                object5 = "js_";
                                                break block62;
                                            }
                                            if (!((String)object).startsWith("jsFunction_")) break block63;
                                            object5 = "jsFunction_";
                                            break block62;
                                        }
                                        if (!((String)object).startsWith("jsStaticFunction_")) break block64;
                                        object5 = "jsStaticFunction_";
                                        if (!Modifier.isStatic(methodArray[n4].getModifiers())) {
                                            throw new ClassDefinitionException("jsStaticFunction must be used with static method.");
                                        }
                                        break block62;
                                    }
                                    if (!((String)object).startsWith("jsProperty_")) break block65;
                                    object5 = "jsProperty_";
                                    break block62;
                                }
                                if (!((String)object).startsWith("jsGet_")) break block66;
                                object5 = "jsGet_";
                                break block62;
                            }
                            if (!((String)object).startsWith("jsSet_")) break block58;
                            object5 = "jsSet_";
                        }
                        object = ((String)object).substring(((String)object5).length());
                        break block67;
                    }
                    if (((Hashtable)object4).get(object) != null) break block58;
                }
                if (!(methodArray[n4] == genericDeclaration2 || object5 != null && ((String)object5).equals("jsSet_"))) {
                    Object object6;
                    Object object7;
                    if (object5 != null && ((String)object5).equals("jsGet_")) {
                        if (!(scriptable2 instanceof ScriptableObject)) {
                            throw PropertyException.withMessage2("msg.extend.scriptable", scriptable2.getClass().toString(), object);
                        }
                        object7 = FunctionObject.findMethods(clazz, "jsSet_" + (String)object);
                        if (object7 != null && ((Method[])object7).length != 1) {
                            throw PropertyException.withMessage2("msg.no.overload", object, clazz.getName());
                        }
                        int n5 = 6 | (object7 != null ? 0 : 1);
                        object6 = object7 == null ? null : object7[0];
                        ((ScriptableObject)scriptable2).defineProperty((String)object, null, methodArray[n4], (Method)object6, n5);
                    } else if (!(!((String)object).startsWith("get") && !((String)object).startsWith("set") || ((String)object).length() <= 3 || bl2 && (((String)object5).equals("jsFunction_") || ((String)object5).equals("jsStaticFunction_")))) {
                        if (!(scriptable2 instanceof ScriptableObject)) {
                            throw PropertyException.withMessage2("msg.extend.scriptable", scriptable2.getClass().toString(), object);
                        }
                        if (!((String)object).startsWith("set")) {
                            object7 = new StringBuffer();
                            char c = ((String)object).charAt(3);
                            ((StringBuffer)object7).append(Character.toLowerCase(c));
                            if (((String)object).length() > 4) {
                                ((StringBuffer)object7).append(((String)object).substring(4));
                            }
                            object6 = ((StringBuffer)object7).toString();
                            ((StringBuffer)object7).setCharAt(0, c);
                            ((StringBuffer)object7).insert(0, "set");
                            String string9 = ((StringBuffer)object7).toString();
                            Method[] methodArray3 = FunctionObject.findMethods(clazz, bl2 ? "js_" + string9 : string9);
                            if (methodArray3 != null && methodArray3.length != 1) {
                                throw PropertyException.withMessage2("msg.no.overload", object, clazz.getName());
                            }
                            if (methodArray3 == null && bl2) {
                                methodArray3 = FunctionObject.findMethods(clazz, "jsProperty_" + string9);
                            }
                            int n6 = 6 | (methodArray3 != null ? 0 : 1);
                            Method method = methodArray3 == null ? null : methodArray3[0];
                            ((ScriptableObject)scriptable2).defineProperty((String)object6, null, methodArray[n4], method, n6);
                        }
                    } else {
                        object7 = new FunctionObject((String)object, methodArray[n4], scriptable2);
                        if (((FunctionObject)object7).isVarArgsConstructor()) {
                            throw Context.reportRuntimeError1("msg.varargs.fun", genericDeclaration2.getName());
                        }
                        Object object8 = object5 == "jsStaticFunction_" ? object3 : scriptable2;
                        ScriptableObject.defineProperty((Scriptable)object8, (String)object, object7, 2);
                        if (bl) {
                            ((ScriptableObject)object7).sealObject();
                            ((IdScriptable)object7).addPropertyAttribute(1);
                        }
                    }
                }
            }
            ++n4;
        }
        if (object2 != null) {
            object = new Object[]{scriptable, object3, scriptable2};
            ((Method)object2).invoke(null, (Object[])object);
        }
        if (bl) {
            ((ScriptableObject)object3).sealObject();
            ((IdScriptable)object3).addPropertyAttribute(1);
            if (scriptable2 instanceof ScriptableObject) {
                ((ScriptableObject)scriptable2).sealObject();
                ((ScriptableObject)scriptable2).addPropertyAttribute(1);
            }
        }
    }

    public void defineProperty(String string, Object object, int n) {
        this.put(string, (Scriptable)this, object);
        try {
            this.setAttributes(string, (Scriptable)this, n);
        }
        catch (PropertyException propertyException) {
            throw new RuntimeException("Cannot create property");
        }
    }

    public static void defineProperty(Scriptable scriptable, String string, Object object, int n) {
        ScriptableObject scriptableObject;
        try {
            scriptableObject = (ScriptableObject)scriptable;
        }
        catch (ClassCastException classCastException) {
            scriptable.put(string, scriptable, object);
            return;
        }
        scriptableObject.defineProperty(string, object, n);
    }

    public void defineProperty(String string, Class clazz, int n) throws PropertyException {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(string.charAt(0)));
        String string2 = stringBuffer.toString();
        Method[] methodArray = FunctionObject.findMethods(clazz, "get" + string2);
        Method[] methodArray2 = FunctionObject.findMethods(clazz, "set" + string2);
        if (methodArray2 == null) {
            n |= 1;
        }
        if (methodArray.length != 1 || methodArray2 != null && methodArray2.length != 1) {
            throw PropertyException.withMessage2("msg.no.overload", string, clazz.getName());
        }
        this.defineProperty(string, null, methodArray[0], methodArray2 == null ? null : methodArray2[0], n);
    }

    public void defineProperty(String string, Object object, Method method, Method method2, int n) throws PropertyException {
        Class<?>[] classArray;
        int n2 = 1;
        if (object == null && Modifier.isStatic(method.getModifiers())) {
            object = B;
        }
        if ((classArray = method.getParameterTypes()).length != 0) {
            if (classArray.length != 1 || classArray[0] != (class$org$mozilla$javascript$ScriptableObject == null ? (class$org$mozilla$javascript$ScriptableObject = ScriptableObject.class$("org.mozilla.javascript.ScriptableObject")) : class$org$mozilla$javascript$ScriptableObject)) {
                throw PropertyException.withMessage1("msg.bad.getter.parms", method.toString());
            }
        } else if (object != null) {
            throw PropertyException.withMessage1("msg.obj.getter.parms", method.toString());
        }
        if (method2 != null) {
            n2 |= 2;
            if (object == B != Modifier.isStatic(method2.getModifiers())) {
                throw PropertyException.withMessage0("msg.getter.static");
            }
            classArray = method2.getParameterTypes();
            if (classArray.length == 2) {
                if (classArray[0] != (class$org$mozilla$javascript$ScriptableObject == null ? (class$org$mozilla$javascript$ScriptableObject = ScriptableObject.class$("org.mozilla.javascript.ScriptableObject")) : class$org$mozilla$javascript$ScriptableObject)) {
                    throw PropertyException.withMessage0("msg.setter2.parms");
                }
                if (object == null) {
                    throw PropertyException.withMessage1("msg.setter1.parms", method2.toString());
                }
            } else if (classArray.length == 1) {
                if (object != null) {
                    throw PropertyException.withMessage1("msg.setter2.expected", method2.toString());
                }
            } else {
                throw PropertyException.withMessage0("msg.setter.parms");
            }
        }
        GetterSlot getterSlot = new GetterSlot();
        getterSlot.delegateTo = object;
        getterSlot.getter = method;
        getterSlot.setter = method2;
        getterSlot.setterReturnsValue = method2 != null && method2.getReturnType() != Void.TYPE;
        getterSlot.value = null;
        getterSlot.attributes = (short)n;
        getterSlot.flags = (byte)n2;
        Slot slot = this.IntegerClass(string, string.hashCode(), getterSlot);
        if (slot != getterSlot) {
            throw new RuntimeException("Property already exists");
        }
    }

    public void defineFunctionProperties(String[] stringArray, Class clazz, int n) throws PropertyException {
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            Method[] methodArray = FunctionObject.findMethods(clazz, string);
            if (methodArray == null) {
                throw PropertyException.withMessage2("msg.method.not.found", string, clazz.getName());
            }
            if (methodArray.length > 1) {
                throw PropertyException.withMessage2("msg.no.overload", string, clazz.getName());
            }
            FunctionObject functionObject = new FunctionObject(string, methodArray[0], this);
            this.defineProperty(string, functionObject, n);
            ++n2;
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Object");
    }

    public static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Function");
    }

    public static Scriptable getClassPrototype(Scriptable scriptable, String string) {
        Object object = ScriptableObject.getProperty(scriptable = ScriptableObject.getTopLevelScope(scriptable), string);
        if (object == Scriptable.NOT_FOUND || !(object instanceof Scriptable)) {
            return null;
        }
        Scriptable scriptable2 = (Scriptable)object;
        if (!scriptable2.has("prototype", scriptable2)) {
            return null;
        }
        Object object2 = scriptable2.get("prototype", scriptable2);
        if (!(object2 instanceof Scriptable)) {
            return null;
        }
        return (Scriptable)object2;
    }

    public static Scriptable getTopLevelScope(Scriptable scriptable) {
        Scriptable scriptable2 = scriptable;
        while ((scriptable2 = (scriptable = scriptable2).getParentScope()) != null) {
        }
        return scriptable;
    }

    public synchronized void sealObject() {
        if (this.count >= 0) {
            this.count = -1 - this.count;
        }
    }

    public boolean isSealed() {
        return this.count < 0;
    }

    public static Object getProperty(Scriptable scriptable, String string) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(string, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static Object getProperty(Scriptable scriptable, int n) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(n, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static boolean hasProperty(Scriptable scriptable, String string) {
        return null != ScriptableObject.ByteClass(scriptable, string);
    }

    public static boolean hasProperty(Scriptable scriptable, int n) {
        return null != ScriptableObject.DoubleClass(scriptable, n);
    }

    public static void putProperty(Scriptable scriptable, String string, Object object) {
        Scriptable scriptable2 = ScriptableObject.ByteClass(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(string, scriptable, object);
    }

    public static void putProperty(Scriptable scriptable, int n, Object object) {
        Scriptable scriptable2 = ScriptableObject.DoubleClass(scriptable, n);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(n, scriptable, object);
    }

    public static boolean deleteProperty(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptableObject.ByteClass(scriptable, string);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(string);
        return !scriptable2.has(string, scriptable);
    }

    public static boolean deleteProperty(Scriptable scriptable, int n) {
        Scriptable scriptable2 = ScriptableObject.DoubleClass(scriptable, n);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(n);
        return !scriptable2.has(n, scriptable);
    }

    public static Object[] getPropertyIds(Scriptable scriptable) {
        ObjToIntMap objToIntMap = new ObjToIntMap();
        while (scriptable != null) {
            Object[] objectArray = scriptable.getIds();
            int n = 0;
            while (n < objectArray.length) {
                objToIntMap.put(objectArray[n], 0);
                ++n;
            }
            scriptable = scriptable.getPrototype();
        }
        return objToIntMap.getKeys();
    }

    public static Object callMethod(Scriptable scriptable, String string, Object[] objectArray) throws JavaScriptException {
        Object object;
        Context context = Context.enter();
        try {
            Object object2 = ScriptableObject.getProperty(scriptable, string);
            if (object2 == Scriptable.NOT_FOUND) {
                object2 = string;
            }
            object = ScriptRuntime.call(context, object2, scriptable, objectArray, ScriptableObject.getTopLevelScope(scriptable));
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    private static Scriptable ByteClass(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (!scriptable.has(string, scriptable2) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    private static Scriptable DoubleClass(Scriptable scriptable, int n) {
        Scriptable scriptable2 = scriptable;
        while (!scriptable.has(n, scriptable2) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    synchronized void addPropertyAttribute(int n) {
        if (this.FunctionClass == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.FunctionClass.length) {
            Slot slot = this.FunctionClass[n2];
            if (slot != null && slot != ByteClass) {
                slot.attributes = (short)(slot.attributes | n);
            }
            ++n2;
        }
    }

    private Slot FALSE(String string, int n) {
        Slot[] slotArray = this.FunctionClass;
        int n2 = ScriptableObject.FloatClass(slotArray, string, n);
        return n2 < 0 ? null : slotArray[n2];
    }

    private static int FloatClass(Slot[] slotArray, String string, int n) {
        if (slotArray != null) {
            Slot slot;
            int n2;
            int n3 = n2 = (n & Integer.MAX_VALUE) % slotArray.length;
            while ((slot = slotArray[n3]) != null) {
                if (slot != ByteClass && slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                    return n3;
                }
                if (++n3 == slotArray.length) {
                    n3 = 0;
                }
                if (n3 != n2) continue;
            }
        }
        return -1;
    }

    private Slot FunctionClass(String string, int n) {
        Slot[] slotArray = this.FunctionClass;
        if (slotArray == null) {
            return this.IntegerClass(string, n, null);
        }
        int n2 = (n & Integer.MAX_VALUE) % slotArray.length;
        boolean bl = false;
        int n3 = n2;
        do {
            Slot slot;
            if ((slot = slotArray[n3]) == null) {
                return this.IntegerClass(string, n, null);
            }
            if (slot == ByteClass) {
                bl = true;
            } else if (slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                return slot;
            }
            if (++n3 != slotArray.length) continue;
            n3 = 0;
        } while (n3 != n2);
        if (!bl) {
            Context.codeBug();
        }
        return this.IntegerClass(string, n, null);
    }

    private synchronized Slot IntegerClass(String string, int n, Slot slot) {
        if (this.count < 0) {
            throw Context.reportRuntimeError0("msg.add.sealed");
        }
        if (this.FunctionClass == null) {
            this.FunctionClass = new Slot[5];
        }
        return this.NOT_FOUND(string, n, slot);
    }

    private Slot NOT_FOUND(String string, int n, Slot slot) {
        int n2;
        int n3 = n2 = (n & Integer.MAX_VALUE) % this.FunctionClass.length;
        do {
            Slot slot2;
            if ((slot2 = this.FunctionClass[n3]) == null || slot2 == ByteClass) {
                if (4 * (this.count + 1) > 3 * this.FunctionClass.length) {
                    this.S();
                    return this.NOT_FOUND(string, n, slot);
                }
                slot2 = slot == null ? new Slot(null) : slot;
                slot2.stringKey = string;
                slot2.intKey = n;
                this.FunctionClass[n3] = slot2;
                ++this.count;
                return slot2;
            }
            if (slot2.intKey == n && (slot2.stringKey == string || string != null && string.equals(slot2.stringKey))) {
                return slot2;
            }
            if (++n3 != this.FunctionClass.length) continue;
            n3 = 0;
        } while (n3 != n2);
        Context.codeBug();
        return null;
    }

    private synchronized void NumberClass(String string, int n) {
        if (this.count < 0) {
            throw Context.reportRuntimeError0("msg.remove.sealed");
        }
        int n2 = ScriptableObject.FloatClass(this.FunctionClass, string, n);
        if (n2 >= 0) {
            Slot slot = this.FunctionClass[n2];
            if ((slot.attributes & 4) == 0) {
                slot.wasDeleted = 1;
                this.FunctionClass[n2] = ByteClass;
                --this.count;
                if (slot == this.IntegerClass) {
                    this.IntegerClass = ByteClass;
                }
            }
        }
    }

    private void S() {
        Slot[] slotArray = new Slot[this.FunctionClass.length * 2 + 1];
        int n = this.FunctionClass.length - 1;
        while (n >= 0) {
            Slot slot = this.FunctionClass[n];
            if (slot != null && slot != ByteClass) {
                int n2 = (slot.intKey & Integer.MAX_VALUE) % slotArray.length;
                while (slotArray[n2] != null) {
                    if (++n2 != slotArray.length) continue;
                    n2 = 0;
                }
                slotArray[n2] = slot;
            }
            --n;
        }
        this.FunctionClass = slotArray;
    }

    private static Hashtable ScriptableClass() {
        if (FloatClass != null) {
            return FloatClass;
        }
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>(17);
        Method[] methodArray = ScriptRuntime.FunctionClass.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            hashtable.put(methodArray[n].getName(), Boolean.TRUE);
            ++n;
        }
        FloatClass = hashtable;
        return hashtable;
    }

    Object[] getIds(boolean bl) {
        Object[] objectArray;
        Slot[] slotArray = this.FunctionClass;
        Object[] objectArray2 = ScriptRuntime.emptyArgs;
        if (slotArray == null) {
            return objectArray2;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < slotArray.length) {
            objectArray = slotArray[n2];
            if (objectArray != null && objectArray != ByteClass && (bl || (objectArray.attributes & 2) == 0)) {
                if (n == 0) {
                    objectArray2 = new Object[slotArray.length - n2];
                }
                objectArray2[n++] = objectArray.stringKey != null ? objectArray.stringKey : new Integer(objectArray.intKey);
            }
            ++n2;
        }
        if (n == objectArray2.length) {
            return objectArray2;
        }
        objectArray = new Object[n];
        System.arraycopy(objectArray2, 0, objectArray, 0, n);
        return objectArray;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Slot[] slotArray;
        objectOutputStream.defaultWriteObject();
        int n = this.count;
        if (n < 0) {
            n = -1 - this.count;
        }
        if ((slotArray = this.FunctionClass) == null) {
            if (n != 0) {
                Context.codeBug();
            }
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(slotArray.length);
            int n2 = 0;
            while (n != 0) {
                Slot slot = slotArray[n2];
                if (slot != null && slot != ByteClass) {
                    --n;
                    objectOutputStream.writeObject(slot);
                }
                ++n2;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.IntegerClass = ByteClass;
        int n = objectInputStream.readInt();
        if (n != 0) {
            this.FunctionClass = new Slot[n];
            int n2 = this.count;
            boolean bl = false;
            if (n2 < 0) {
                n2 = -1 - n2;
                bl = true;
            }
            this.count = 0;
            int n3 = 0;
            while (n3 != n2) {
                Slot slot = (Slot)objectInputStream.readObject();
                this.NOT_FOUND(slot.stringKey, slot.intKey, slot);
                ++n3;
            }
            if (bl) {
                this.count = -1 - this.count;
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class 1 {
    }

    static class GetterSlot
    extends Slot
    implements Serializable {
        Object delegateTo;
        transient Method getter;
        transient Method setter;
        boolean setterReturnsValue;

        GetterSlot() {
            super(null);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            FunctionObject.writeMember(objectOutputStream, this.getter);
            FunctionObject.writeMember(objectOutputStream, this.setter);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.getter = (Method)FunctionObject.readMember(objectInputStream);
            this.setter = (Method)FunctionObject.readMember(objectInputStream);
        }
    }

    private static class Slot
    implements Serializable {
        static final int HAS_GETTER = 1;
        static final int HAS_SETTER = 2;
        static final long serialVersionUID = -2158009919774350004L;
        int intKey;
        String stringKey;
        Object value;
        short attributes;
        byte flags;
        transient byte wasDeleted;

        private Slot() {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.stringKey != null) {
                this.intKey = this.stringKey.hashCode();
            }
        }

        Slot(1 var1_1) {
            this();
        }
    }
}

