/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.collection.WeakTable;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.norm.LeaseSet;
import com.sun.jini.norm.NormServerBaseImpl;
import com.sun.jini.thread.WakeupManager;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class LeaseExpirationMgr
implements WeakTable.KeyGCHandler {
    static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    private WeakTable ticketMap = new WeakTable(this);
    private NormServerBaseImpl server;
    private WakeupManager runQueue = new WakeupManager();
    final List expireQueue = new LinkedList();
    private final Thread expireThread = new ExpirationThread();

    LeaseExpirationMgr(NormServerBaseImpl normServerBaseImpl) {
        this.server = normServerBaseImpl;
    }

    void terminate() {
        this.runQueue.stop();
        this.runQueue.cancelAll();
        this.expireThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(LeasedResource leasedResource) {
        LeasedResource leasedResource2 = leasedResource;
        synchronized (leasedResource2) {
            this.schedule(leasedResource);
        }
    }

    void reschedule(LeasedResource leasedResource) {
        WakeupManager.Ticket ticket = (WakeupManager.Ticket)this.ticketMap.remove(leasedResource);
        if (ticket != null) {
            this.runQueue.cancel(ticket);
        }
        this.schedule(leasedResource);
    }

    void schedule(LeasedResource leasedResource) {
        WakeupManager.Ticket ticket;
        MgrTask mgrTask;
        LeaseSet leaseSet = (LeaseSet)leasedResource;
        if (leaseSet.haveWarningRegistration()) {
            mgrTask = new SendWarning(leaseSet);
            ticket = this.runQueue.schedule(leaseSet.getWarningTime(), mgrTask);
        } else {
            mgrTask = new QueueExpiration(leaseSet);
            ticket = this.runQueue.schedule(leaseSet.getExpiration(), mgrTask);
        }
        mgrTask.setTicket(ticket);
        this.ticketMap.getOrAdd(leaseSet, ticket);
    }

    public void keyGC(Object object) {
        WakeupManager.Ticket ticket = (WakeupManager.Ticket)object;
        this.runQueue.cancel(ticket);
    }

    private class SendWarning
    extends MgrTask {
        private SendWarning(LeaseSet leaseSet) {
            super(leaseSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LeaseSet leaseSet = (LeaseSet)this.resourceRef.get();
            if (leaseSet == null) {
                return;
            }
            LeaseSet leaseSet2 = leaseSet;
            synchronized (leaseSet2) {
                LeaseSet leaseSet3 = this.removeOurTicket();
                if (leaseSet3 == null) {
                    return;
                }
                LeaseExpirationMgr.this.server.sendWarningEvent(leaseSet3);
                QueueExpiration queueExpiration = new QueueExpiration(leaseSet3);
                WakeupManager.Ticket ticket = LeaseExpirationMgr.this.runQueue.schedule(leaseSet3.getExpiration(), queueExpiration);
                ((MgrTask)queueExpiration).setTicket(ticket);
                LeaseExpirationMgr.this.ticketMap.getOrAdd(leaseSet3, ticket);
            }
        }
    }

    private class Expiration
    extends MgrTask {
        private Expiration(LeaseSet leaseSet) {
            super(leaseSet);
        }

        public void run() {
            LeaseSet leaseSet = this.removeOurTicket();
            if (leaseSet == null) {
                return;
            }
            LeaseExpirationMgr.this.server.expireIfTime(leaseSet);
        }
    }

    private class QueueExpiration
    extends MgrTask {
        QueueExpiration(LeaseSet leaseSet) {
            super(leaseSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LeaseSet leaseSet = (LeaseSet)this.resourceRef.get();
            if (leaseSet != null) {
                List list = LeaseExpirationMgr.this.expireQueue;
                synchronized (list) {
                    LeaseExpirationMgr.this.expireQueue.add(new Expiration(leaseSet));
                    LeaseExpirationMgr.this.expireQueue.notifyAll();
                }
            }
        }
    }

    private abstract class MgrTask
    implements Runnable {
        protected final WeakReference resourceRef;
        private WakeupManager.Ticket ticket;

        protected MgrTask(LeaseSet leaseSet) {
            this.resourceRef = new WeakReference<LeaseSet>(leaseSet);
        }

        private void setTicket(WakeupManager.Ticket ticket) {
            this.ticket = ticket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected LeaseSet removeOurTicket() {
            LeaseSet leaseSet = (LeaseSet)this.resourceRef.get();
            if (leaseSet != null) {
                LeaseSet leaseSet2 = leaseSet;
                synchronized (leaseSet2) {
                    WakeupManager.Ticket ticket = (WakeupManager.Ticket)LeaseExpirationMgr.this.ticketMap.get(leaseSet);
                    if (!this.ticket.equals(ticket)) {
                        return null;
                    }
                    LeaseExpirationMgr.this.ticketMap.remove(leaseSet);
                }
            }
            return leaseSet;
        }

        public abstract void run();
    }

    private class ExpirationThread
    extends Thread {
        private boolean interrupted;

        ExpirationThread() {
            super("expire lease sets thread");
            this.setDaemon(true);
        }

        public void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.interrupted) {
                try {
                    MgrTask mgrTask;
                    List list = LeaseExpirationMgr.this.expireQueue;
                    synchronized (list) {
                        if (LeaseExpirationMgr.this.expireQueue.isEmpty()) {
                            LeaseExpirationMgr.this.expireQueue.wait();
                            continue;
                        }
                        mgrTask = (MgrTask)LeaseExpirationMgr.this.expireQueue.remove(0);
                    }
                    mgrTask.run();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "Exception in lease set expiration thread -- attempting to continue", throwable);
                }
            }
        }
    }
}

