/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.client.core.auth;

import com.mathworks.webservices.client.core.auth.CredentialsUnavailableException;
import com.mathworks.webservices.client.core.auth.ProxyServerCredentialsProvider;
import java.net.PasswordAuthentication;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;

public class ProxyServerCredentialsProviderAdapter
implements CredentialsProvider {
    private ProxyServerCredentialsProvider provider;

    public ProxyServerCredentialsProviderAdapter(ProxyServerCredentialsProvider credentialsProvider) {
        this.provider = credentialsProvider;
    }

    public synchronized Credentials getCredentials(AuthScheme authScheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        PasswordAuthentication passwordAuthentication = null;
        try {
            passwordAuthentication = this.provider.getCredentials(host, port, proxy);
        }
        catch (CredentialsUnavailableException e) {
            throw new CredentialsNotAvailableException();
        }
        if (passwordAuthentication == null) {
            throw new CredentialsNotAvailableException();
        }
        if (authScheme instanceof NTLMScheme) {
            return ProxyServerCredentialsProviderAdapter.createNTCredentials(passwordAuthentication, host);
        }
        return new UsernamePasswordCredentials(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()));
    }

    private static NTCredentials createNTCredentials(PasswordAuthentication passwordAuthentication, String host) {
        String[] array;
        String proxyUser = passwordAuthentication.getUserName();
        String proxyPassword = String.valueOf(passwordAuthentication.getPassword());
        String proxyDomain = null;
        if (proxyUser != null && (array = proxyUser.split("\\\\")).length == 2) {
            proxyDomain = array[0];
            proxyUser = array[1];
        }
        return new NTCredentials(proxyUser, proxyPassword, host, proxyDomain);
    }
}

