/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.landlord.ConstrainableLandlordLease;
import com.sun.jini.norm.AbstractProxy;
import com.sun.jini.norm.GetLeasesResult;
import com.sun.jini.norm.NormServer;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import com.sun.jini.proxy.ThrowThis;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.LinkedList;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.id.Uuid;
import net.jini.io.MarshalledInstance;
import net.jini.lease.LeaseRenewalSet;
import net.jini.lease.LeaseUnmarshalException;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class SetProxy
extends AbstractProxy
implements LeaseRenewalSet {
    private static final long serialVersionUID = 2L;
    final Lease ourLease;
    static /* synthetic */ Class class$net$jini$core$lease$Lease;
    static /* synthetic */ Class class$net$jini$lease$LeaseRenewalSet;
    static /* synthetic */ Class class$net$jini$id$Uuid;
    static /* synthetic */ Class class$com$sun$jini$norm$NormServer;
    static /* synthetic */ Class class$net$jini$core$event$RemoteEventListener;
    static /* synthetic */ Class class$java$rmi$MarshalledObject;

    static SetProxy create(NormServer normServer, Uuid uuid, Lease lease) {
        if (normServer instanceof RemoteMethodControl) {
            return new ConstrainableSetProxy(normServer, uuid, lease, null);
        }
        return new SetProxy(normServer, uuid, lease);
    }

    private SetProxy(NormServer normServer, Uuid uuid, Lease lease) {
        super(normServer, uuid);
        if (lease == null) {
            throw new NullPointerException("lease cannot be null");
        }
        this.ourLease = lease;
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("server, uuid, and ourLease must be non-null");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.ourLease == null) {
            throw new InvalidObjectException("ourLease cannot be null");
        }
    }

    public void renewFor(Lease lease, long l) throws RemoteException {
        try {
            this.server2().renewFor(this.uuid, lease, l, Long.MAX_VALUE);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
    }

    public void renewFor(Lease lease, long l, long l2) throws RemoteException {
        try {
            this.server.renewFor(this.uuid, lease, l, l2);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
    }

    public Lease remove(Lease lease) throws RemoteException {
        try {
            return this.server.remove(this.uuid, lease);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
            return null;
        }
    }

    public Lease[] getLeases() throws LeaseUnmarshalException, RemoteException {
        try {
            MarshalledObject[] marshalledObjectArray;
            Throwable[] throwableArray;
            GetLeasesResult getLeasesResult = this.server.getLeases(this.uuid);
            MarshalledInstance[] marshalledInstanceArray = getLeasesResult.marshalledLeases;
            if (marshalledInstanceArray == null || marshalledInstanceArray.length == 0) {
                return new Lease[0];
            }
            LinkedList<MarshalledObject[]> linkedList = new LinkedList<MarshalledObject[]>();
            LinkedList<MarshalledObject> linkedList2 = new LinkedList<MarshalledObject>();
            LinkedList<Throwable> linkedList3 = new LinkedList<Throwable>();
            for (int i = 0; i < marshalledInstanceArray.length; ++i) {
                throwableArray = marshalledInstanceArray[i];
                try {
                    marshalledObjectArray = (MarshalledObject[])throwableArray.get(getLeasesResult.verifyCodebaseIntegrity());
                    linkedList.add(marshalledObjectArray);
                    continue;
                }
                catch (Throwable throwable) {
                    linkedList2.add(throwableArray.convertToMarshalledObject());
                    linkedList3.add(throwable);
                }
            }
            Lease[] leaseArray = linkedList.toArray(new Lease[linkedList.size()]);
            if (linkedList2.isEmpty()) {
                return leaseArray;
            }
            marshalledObjectArray = linkedList2.toArray(new MarshalledObject[linkedList2.size()]);
            throwableArray = linkedList3.toArray(new Throwable[linkedList3.size()]);
            throw new LeaseUnmarshalException("Problem unmarshalling lease(s)", leaseArray, marshalledObjectArray, throwableArray);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
            return null;
        }
    }

    public EventRegistration setExpirationWarningListener(RemoteEventListener remoteEventListener, long l, MarshalledObject marshalledObject) throws RemoteException {
        if (remoteEventListener == null) {
            throw new NullPointerException("LeaseRenewalSet.setExpirationWarningListener:Must pass a non-null listener");
        }
        try {
            return this.server.setExpirationWarningListener(this.uuid, remoteEventListener, l, marshalledObject);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
            return null;
        }
    }

    public void clearExpirationWarningListener() throws RemoteException {
        try {
            this.server2().setExpirationWarningListener(this.uuid, null, -1L, null);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
    }

    public EventRegistration setRenewalFailureListener(RemoteEventListener remoteEventListener, MarshalledObject marshalledObject) throws RemoteException {
        if (remoteEventListener == null) {
            throw new NullPointerException("LeaseRenewalSet.setRenewalFailureListener:Must pass a non-null listener");
        }
        try {
            return this.server.setRenewalFailureListener(this.uuid, remoteEventListener, marshalledObject);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
            return null;
        }
    }

    public void clearRenewalFailureListener() throws RemoteException {
        try {
            this.server2().setRenewalFailureListener(this.uuid, null, null);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
    }

    NormServer server2() {
        return this.server;
    }

    public Lease getRenewalSetLease() {
        return this.ourLease;
    }

    static final class ConstrainableSetProxy
    extends SetProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 1L;
        private static final Method[] methodMap1;
        private static final Method[] methodMap2;
        private MethodConstraints methodConstraints;
        private transient NormServer server2;

        ConstrainableSetProxy(NormServer normServer, Uuid uuid, Lease lease, MethodConstraints methodConstraints) {
            super(ConstrainableSetProxy.constrainServer(normServer, methodConstraints, methodMap1), uuid, lease);
            if (!(lease instanceof ConstrainableLandlordLease)) {
                throw new IllegalArgumentException("lease must be a ConstrainableLandlordLease");
            }
            this.methodConstraints = methodConstraints;
            this.server2 = ConstrainableSetProxy.constrainServer(normServer, methodConstraints, methodMap2);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (!(this.server instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("server does not implement RemoteMethodControl");
            }
            if (!(this.ourLease instanceof ConstrainableLandlordLease)) {
                throw new InvalidObjectException("ourLease is not a ConstrainableLandlordLease");
            }
            ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.server, methodMap1);
            this.server2 = ConstrainableSetProxy.constrainServer(this.server, this.methodConstraints, methodMap2);
        }

        private static NormServer constrainServer(NormServer normServer, MethodConstraints methodConstraints, Method[] methodArray) {
            return (NormServer)((RemoteMethodControl)normServer).setConstraints(ConstrainableProxyUtil.translateConstraints(methodConstraints, methodArray));
        }

        public RemoteMethodControl setConstraints(MethodConstraints methodConstraints) {
            return new ConstrainableSetProxy(this.server, this.uuid, this.ourLease, methodConstraints);
        }

        public MethodConstraints getConstraints() {
            return this.methodConstraints;
        }

        NormServer server2() {
            return this.server2;
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.server);
        }

        static {
            try {
                methodMap1 = new Method[]{(class$net$jini$lease$LeaseRenewalSet == null ? (class$net$jini$lease$LeaseRenewalSet = SetProxy.class$("net.jini.lease.LeaseRenewalSet")) : class$net$jini$lease$LeaseRenewalSet).getMethod("renewFor", class$net$jini$core$lease$Lease == null ? (class$net$jini$core$lease$Lease = SetProxy.class$("net.jini.core.lease.Lease")) : class$net$jini$core$lease$Lease, Long.TYPE, Long.TYPE), (class$com$sun$jini$norm$NormServer == null ? (class$com$sun$jini$norm$NormServer = SetProxy.class$("com.sun.jini.norm.NormServer")) : class$com$sun$jini$norm$NormServer).getMethod("renewFor", class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = SetProxy.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, class$net$jini$core$lease$Lease == null ? (class$net$jini$core$lease$Lease = SetProxy.class$("net.jini.core.lease.Lease")) : class$net$jini$core$lease$Lease, Long.TYPE, Long.TYPE), (class$net$jini$lease$LeaseRenewalSet == null ? (class$net$jini$lease$LeaseRenewalSet = SetProxy.class$("net.jini.lease.LeaseRenewalSet")) : class$net$jini$lease$LeaseRenewalSet).getMethod("remove", class$net$jini$core$lease$Lease == null ? (class$net$jini$core$lease$Lease = SetProxy.class$("net.jini.core.lease.Lease")) : class$net$jini$core$lease$Lease), (class$com$sun$jini$norm$NormServer == null ? (class$com$sun$jini$norm$NormServer = SetProxy.class$("com.sun.jini.norm.NormServer")) : class$com$sun$jini$norm$NormServer).getMethod("remove", class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = SetProxy.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, class$net$jini$core$lease$Lease == null ? (class$net$jini$core$lease$Lease = SetProxy.class$("net.jini.core.lease.Lease")) : class$net$jini$core$lease$Lease), (class$net$jini$lease$LeaseRenewalSet == null ? (class$net$jini$lease$LeaseRenewalSet = SetProxy.class$("net.jini.lease.LeaseRenewalSet")) : class$net$jini$lease$LeaseRenewalSet).getMethod("getLeases", new Class[0]), (class$com$sun$jini$norm$NormServer == null ? (class$com$sun$jini$norm$NormServer = SetProxy.class$("com.sun.jini.norm.NormServer")) : class$com$sun$jini$norm$NormServer).getMethod("getLeases", class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = SetProxy.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid), (class$net$jini$lease$LeaseRenewalSet == null ? (class$net$jini$lease$LeaseRenewalSet = SetProxy.class$("net.jini.lease.LeaseRenewalSet")) : class$net$jini$lease$LeaseRenewalSet).getMethod("setExpirationWarningListener", class$net$jini$core$event$RemoteEventListener == null ? (class$net$jini$core$event$RemoteEventListener = SetProxy.class$("net.jini.core.event.RemoteEventListener")) : class$net$jini$core$event$RemoteEventListener, Long.TYPE, class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = SetProxy.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject), (class$com$sun$jini$norm$NormServer == null ? (class$com$sun$jini$norm$NormServer = SetProxy.class$("com.sun.jini.norm.NormServer")) : class$com$sun$jini$norm$NormServer).getMethod("setExpirationWarningListener", class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = SetProxy.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, class$net$jini$core$event$RemoteEventListener == null ? (class$net$jini$core$event$RemoteEventListener = SetProxy.class$("net.jini.core.event.RemoteEventListener")) : class$net$jini$core$event$RemoteEventListener, Long.TYPE, class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = SetProxy.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject), (class$net$jini$lease$LeaseRenewalSet == null ? (class$net$jini$lease$LeaseRenewalSet = SetProxy.class$("net.jini.lease.LeaseRenewalSet")) : class$net$jini$lease$LeaseRenewalSet).getMethod("setRenewalFailureListener", class$net$jini$core$event$RemoteEventListener == null ? (class$net$jini$core$event$RemoteEventListener = SetProxy.class$("net.jini.core.event.RemoteEventListener")) : class$net$jini$core$event$RemoteEventListener, class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = SetProxy.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject), (class$com$sun$jini$norm$NormServer == null ? (class$com$sun$jini$norm$NormServer = SetProxy.class$("com.sun.jini.norm.NormServer")) : class$com$sun$jini$norm$NormServer).getMethod("setRenewalFailureListener", class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = SetProxy.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, class$net$jini$core$event$RemoteEventListener == null ? (class$net$jini$core$event$RemoteEventListener = SetProxy.class$("net.jini.core.event.RemoteEventListener")) : class$net$jini$core$event$RemoteEventListener, class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = SetProxy.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject)};
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchMethodError(noSuchMethodException.getMessage());
            }
            try {
                methodMap2 = new Method[]{(class$net$jini$lease$LeaseRenewalSet == null ? (class$net$jini$lease$LeaseRenewalSet = SetProxy.class$("net.jini.lease.LeaseRenewalSet")) : class$net$jini$lease$LeaseRenewalSet).getMethod("renewFor", class$net$jini$core$lease$Lease == null ? (class$net$jini$core$lease$Lease = SetProxy.class$("net.jini.core.lease.Lease")) : class$net$jini$core$lease$Lease, Long.TYPE), (class$com$sun$jini$norm$NormServer == null ? (class$com$sun$jini$norm$NormServer = SetProxy.class$("com.sun.jini.norm.NormServer")) : class$com$sun$jini$norm$NormServer).getMethod("renewFor", class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = SetProxy.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, class$net$jini$core$lease$Lease == null ? (class$net$jini$core$lease$Lease = SetProxy.class$("net.jini.core.lease.Lease")) : class$net$jini$core$lease$Lease, Long.TYPE, Long.TYPE), (class$net$jini$lease$LeaseRenewalSet == null ? (class$net$jini$lease$LeaseRenewalSet = SetProxy.class$("net.jini.lease.LeaseRenewalSet")) : class$net$jini$lease$LeaseRenewalSet).getMethod("clearExpirationWarningListener", new Class[0]), (class$com$sun$jini$norm$NormServer == null ? (class$com$sun$jini$norm$NormServer = SetProxy.class$("com.sun.jini.norm.NormServer")) : class$com$sun$jini$norm$NormServer).getMethod("setExpirationWarningListener", class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = SetProxy.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, class$net$jini$core$event$RemoteEventListener == null ? (class$net$jini$core$event$RemoteEventListener = SetProxy.class$("net.jini.core.event.RemoteEventListener")) : class$net$jini$core$event$RemoteEventListener, Long.TYPE, class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = SetProxy.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject), (class$net$jini$lease$LeaseRenewalSet == null ? (class$net$jini$lease$LeaseRenewalSet = SetProxy.class$("net.jini.lease.LeaseRenewalSet")) : class$net$jini$lease$LeaseRenewalSet).getMethod("clearRenewalFailureListener", new Class[0]), (class$com$sun$jini$norm$NormServer == null ? (class$com$sun$jini$norm$NormServer = SetProxy.class$("com.sun.jini.norm.NormServer")) : class$com$sun$jini$norm$NormServer).getMethod("setRenewalFailureListener", class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = SetProxy.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, class$net$jini$core$event$RemoteEventListener == null ? (class$net$jini$core$event$RemoteEventListener = SetProxy.class$("net.jini.core.event.RemoteEventListener")) : class$net$jini$core$event$RemoteEventListener, class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = SetProxy.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject)};
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchMethodError(noSuchMethodException.getMessage());
            }
        }
    }
}

