/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mlservices.MLInspectorServices;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.DeleteListenerObject;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.PropertyChangedListener;
import com.mathworks.toolbox.instrument.PropertyListenerObject;
import com.mathworks.toolbox.instrument.ToolboxInitializer;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.instrument.events.ActionQueue;
import com.mathworks.toolbox.instrument.events.ICErrorEvent;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.events.ICPinEvent;
import com.mathworks.toolbox.instrument.events.ICTriggerEvent;
import com.mathworks.toolbox.instrument.events.NotificationQueue;
import com.mathworks.toolbox.instrument.util.PropertyUtil;
import com.mathworks.toolbox.instrument.util.RecordFileWriter;
import com.mathworks.toolbox.testmeas.util.PreferenceFile;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.util.Timer;
import java.io.File;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.SwingUtilities;

public abstract class Instrument
implements MatlabListener,
AutoConvertStringToMatlabChar {
    protected static final ResourceBundle sInstrumentResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.resources.RES_INSTRUMENT");
    public static String IC_FILENAME = "instrumentcontrol.cache";
    private static PreferenceFile preferenceFile = new PreferenceFile(IC_FILENAME);
    private static ToolboxInitializer toolboxInitializer = new ToolboxInitializer();
    protected static int numberOfObjects = 0;
    private String identificationLabel = "";
    private Object isValidObj = null;
    private static boolean ENABLE_EVENTS = true;
    private static Vector<Object> SCAN_COMMANDS = new Vector();
    private static boolean INIT_SCAN_COMMANDS = false;
    protected static Hashtable<Object, Boolean> SCAN_COMMANDS_STATE = new Hashtable();
    protected static Boolean TRUE = new Boolean(true);
    private static Random randomGenerator = new Random();
    private static Vector<Double> allTimes = new Vector();
    protected static int SLEEPTIME = 2;
    protected static boolean ctrlc_flag = false;
    protected static final int LITTLE_ENDIAN = 0;
    protected static final int BIG_ENDIAN = 1;
    protected static final String[] BYTE_ORDER = new String[]{"littleEndian", "bigEndian"};
    public static final int PC = 0;
    public static final int LINUX = 1;
    public static final int MAC = 2;
    public static final int SOLARIS = 3;
    protected static final int TERMINATOR = 0;
    protected static final int BYTE = 1;
    protected static final String[] BYTES_FMODE = new String[]{"terminator", "byte"};
    public static final int CLOSED = 0;
    public static final int OPEN = 1;
    public static final int OVERWRITE = 0;
    public static final int APPEND = 1;
    public static final int INDEX = 2;
    public static final String[] RECORD_MODE = new String[]{"overwrite", "append", "index"};
    protected static final int SYNCHRONOUS = 0;
    protected static final int ASYNCHRONOUS = 1;
    protected static final int IDLE = 0;
    protected static final int READ = 1;
    protected static final int WRITE = 2;
    protected static final int READWRITE = 3;
    public static final int MINT8 = 0;
    public static final int MINT16 = 1;
    public static final int MINT32 = 2;
    public static final int MSINGLE = 3;
    public static final int MDOUBLE = 4;
    public static final int MCHAR = 5;
    public static final int VISIBLE = 0;
    public static final int GRANDFATHERED = 1;
    public static final int HIDDEN = 2;
    protected static final int[] DATASIZE = new int[]{1, 2, 4, 4, 8, 1};
    protected static final Integer INTEGER_ZERO = new Integer(0);
    public static final int COMPACT = 0;
    public static final int VERBOSE = 1;
    protected static final String[] RECORD_DETAIL = new String[]{"compact", "verbose"};
    protected static final char CARRIAGE = '\r';
    protected static final char LINEFEED = '\n';
    public static String LINESEP = new Character('\n').toString();
    public static final String FILESEP = File.separator;
    protected static final String BLANKS = "                                         ";
    protected static final String[] PULLUP_VALS = new String[]{"none", "both"};
    protected static final String[] byteOVals = new String[]{"littleEndian", "bigEndian"};
    protected static final String[] STATUS_ENUM = new String[]{"closed", "open"};
    protected static final String[] TRANSFER_MODE_ENUM = new String[]{"synchronous", "asynchronous"};
    protected static final String[] RECORD_STATUS_ENUM = new String[]{"off", "on"};
    protected static final String[] TRANSFER_STATUS_ENUM = new String[]{"idle", "read", "write", "read&write"};
    public static final int NONE = 0;
    public static final int BOTH = 1;
    protected static final String[] boolVals = new String[]{"on", "off"};
    protected static final MLArrayRef ACTION = new MLArrayRef(4);
    protected static final MLArrayRef USERDATA = new MLArrayRef(6);
    protected static final int EVAL = 0;
    protected static final int FEVAL = 1;
    protected static final int BREAK_INTERRUPT_FCN = 0;
    protected static final int BYTES_AVAILABLE_FCN = 1;
    protected static final int ERROR_FCN = 2;
    protected static final int INTERRUPT_FCN = 3;
    protected static final int OUTPUT_EMPTY_FCN = 4;
    protected static final int PINSTATUS_FCN = 5;
    protected static final int TIMER_FCN = 6;
    protected static final int TRIGGER_FCN = 7;
    protected static final int DATAGRAM_RECEIVED_FCN = 8;
    protected static final int PROPERTY_CHANGED = 9;
    protected static final int OBJECT_CREATED = 10;
    protected static final int OBJECT_DELETED = 11;
    protected static final int DEFAULT_BUFFER_SIZE = 512;
    protected static final int TOTAL_FCN_PROPERTIES = 12;
    protected static int platform;
    public static int platformByteOrder;
    protected static Vector<Instrument> allInstrumentObjects;
    protected static boolean IS_TOOLBOX_INSTALLED;
    protected static Vector<String> openRecordFileNames;
    private static byte[] singleByteMessage;
    private static short[] singleShortMessage;
    private static int[] singleIntegerMessage;
    private static float[] singleFloatMessage;
    private static double[] singleDoubleMessage;
    private static char[] singleCharacterMessage;
    protected static final String ACTIONERROR;
    protected static final String MUSTCONNECT = "OBJ must be connected to the hardware with FOPEN.";
    protected static final String INVALIDOBJ = "Instrument object OBJ is an invalid object.";
    protected static final String OPENOBJECT = "cannot be set while OBJ is open.";
    protected static final String NOTOOLBOX = "Undefined function or variable ";
    protected static final String NOASYNCOP;
    protected static final String NOSETALIAS = " cannot be set for a VISA object that has an alias.";
    protected int byteOrder = 0;
    protected int bytesAvailable = 0;
    protected MLArrayRef bytesAvailableFcn = ACTION;
    protected int bytesAvailableFcnCount = 48;
    protected int bytesAvailableFcnMode = 0;
    protected int bytesToOutput = 0;
    protected double creationTime = 0.0;
    protected MLArrayRef errorFcn = ACTION;
    protected int handle = 0;
    protected int inputBufferSize = 512;
    protected double id = 0.0;
    protected String name = "";
    protected boolean objectVisibility = true;
    protected int outputBufferSize = 512;
    protected MLArrayRef outputEmptyFcn = ACTION;
    protected int recordDetail = 0;
    protected int recordMode = 0;
    protected String recordName = "record.txt";
    protected String MATLABClassName = "";
    protected boolean recordStatus = false;
    protected int status = 0;
    protected String tag = "";
    protected double timeout = 10.0;
    protected MLArrayRef timerFcn = ACTION;
    protected double timerPeriod = 1.0;
    protected int transferStatus = 0;
    protected String type = "";
    protected MLArrayRef userData = USERDATA;
    protected long valuesReceived = 0L;
    protected long valuesSent = 0L;
    protected Vector<ICDevice> deviceObject = null;
    private String variableName = "";
    protected MLArrayRef MATLABObject = ACTION;
    protected ICProp[] objectProps;
    protected boolean nameStandardFormat = true;
    protected Vector<Integer> actionQueue = new Vector();
    protected Timer timer = null;
    protected boolean wasTimerStarted = false;
    public int timerCallbackCount = 0;
    public int[] disabledCallbacks = new int[12];
    public int[] callbackType = new int[12];
    public String[] evalString = new String[12];
    public MLArrayRef[] callbackData = new MLArrayRef[12];
    protected String displayName = "";
    protected RecordFileWriter recordFileWriter = null;
    protected Calendar eventTime = null;
    private static Vector<InstrumentObjectListener> listeners;
    private static Vector<PropertyChangedListener> propertyChangedListeners;
    private static Vector<Object> propertyChangedCallbacks;
    private static Vector<Object> objectCreateCallbacks;
    private static Vector<Object> objectDestroyCallbacks;
    protected static String gpib32DllVendor;
    protected MatlabMCR matlabMCR = MatlabMCRFactory.getForCurrentMCR();
    private Calendar oldCreationTime;

    public Instrument() {
        this.id = numberOfObjects + 1;
        ++numberOfObjects;
        allInstrumentObjects.addElement(this);
        Matlab.addListener((MatlabListener)this);
        this.creationTime = this.findUniqueCreationTime();
        this.isValidObj = new Object();
    }

    protected static void updateInstall(double d) {
        int n;
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(6);
        double d2 = (double)n2 * 6.23 + (double)(n = calendar.get(3)) * 0.003451;
        if (d == d2) {
            IS_TOOLBOX_INSTALLED = true;
        }
    }

    protected static void updateGpib32DllVendor(String string) {
        gpib32DllVendor = string;
    }

    private double findUniqueCreationTime() {
        Double d = new Double(randomGenerator.nextDouble());
        while (allTimes.contains(d)) {
            d = null;
            d = new Double(randomGenerator.nextDouble());
        }
        allTimes.addElement(d);
        return d;
    }

    public final void setMATLABObject(final MLArrayRef mLArrayRef) {
        if (this.MATLABObject != ACTION) {
            this.MATLABObject.dispose();
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.postInstrumentObjectAddedEvent(mLArrayRef);
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Instrument.this.postInstrumentObjectAddedEvent(mLArrayRef);
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.MATLABObject = mLArrayRef;
    }

    public MLArrayRef getMATLABObject() {
        return this.MATLABObject;
    }

    public void cleanup() {
        if (MLInspectorServices.isInspectorOpen()) {
            MLInspectorServices.closeWindow();
        }
        if (this.MATLABObject != ACTION) {
            this.MATLABObject.dispose();
        }
    }

    public void setDeviceObject(ICDevice iCDevice) {
        if (this.deviceObject == null) {
            this.deviceObject = new Vector();
        }
        this.deviceObject.addElement(iCDevice);
    }

    public void removeDeviceObject(ICDevice iCDevice) {
        if (this.deviceObject == null) {
            return;
        }
        this.deviceObject.removeElement(iCDevice);
        iCDevice = null;
    }

    private static void initScanCommands() {
        INIT_SCAN_COMMANDS = true;
        if (!preferenceFile.exist()) {
            SCAN_COMMANDS.addElement("*IDN?");
            SCAN_COMMANDS_STATE.put("*IDN?", TRUE);
        } else {
            try {
                Instrument.loadScanCommands();
            }
            catch (Exception exception) {
                SCAN_COMMANDS.addElement("*IDN?");
                SCAN_COMMANDS_STATE.put("*IDN?", TRUE);
            }
        }
    }

    public static void addScanCommand(String string) {
        if (!INIT_SCAN_COMMANDS) {
            Instrument.initScanCommands();
        }
        if (string.equals("")) {
            return;
        }
        if (SCAN_COMMANDS == null) {
            Instrument.initScanCommands();
        }
        SCAN_COMMANDS.addElement(string);
        SCAN_COMMANDS_STATE.put(string, TRUE);
        Instrument.saveScanCommands();
    }

    public static void removeScanCommand(String string) {
        if (!INIT_SCAN_COMMANDS) {
            Instrument.initScanCommands();
        }
        SCAN_COMMANDS.removeElement(string);
        SCAN_COMMANDS_STATE.remove(string);
        string = null;
        Instrument.saveScanCommands();
    }

    public static Vector<String> getScanCommands() {
        if (!INIT_SCAN_COMMANDS) {
            Instrument.initScanCommands();
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < SCAN_COMMANDS.size(); ++i) {
            String string = (String)SCAN_COMMANDS.elementAt(i);
            if (!SCAN_COMMANDS_STATE.get(string).equals(TRUE)) continue;
            vector.addElement(string);
        }
        return vector;
    }

    public static void setScanCommands(Vector<Object> vector) {
        SCAN_COMMANDS.removeAllElements();
        SCAN_COMMANDS_STATE = new Hashtable();
        while (vector.contains(null)) {
            vector.removeElement(null);
        }
        SCAN_COMMANDS = vector;
        for (int i = 0; i < SCAN_COMMANDS.size(); ++i) {
            SCAN_COMMANDS_STATE.put(SCAN_COMMANDS.elementAt(i), TRUE);
        }
        Instrument.saveScanCommands();
    }

    public static void setScanCommandSelection(Hashtable<Object, Boolean> hashtable) {
        SCAN_COMMANDS_STATE = hashtable;
    }

    public static Hashtable<Object, Boolean> getScanCommandSelection() {
        return SCAN_COMMANDS_STATE;
    }

    private static void saveScanCommands() {
        if (!INIT_SCAN_COMMANDS) {
            Instrument.initScanCommands();
        }
        String string = "";
        for (int i = 0; i < SCAN_COMMANDS.size(); ++i) {
            string = string + "    <Command>" + SCAN_COMMANDS.elementAt(i) + "</Command>\n";
        }
        preferenceFile.update("ScanCommands", string);
    }

    private static void loadScanCommands() {
        String string = preferenceFile.read("ScanCommands");
        if (string.equals("") && !preferenceFile.tagExists("ScanCommands")) {
            SCAN_COMMANDS.addElement("*IDN?");
            SCAN_COMMANDS_STATE.put("*IDN?", TRUE);
            return;
        }
        string = TMStringUtil.strrep((String)string, (String)"    <Command>", (String)"");
        string = TMStringUtil.strrep((String)string, (String)"</Command>", (String)"");
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf("\n", 0);
        while (n != -1) {
            vector.addElement(string.substring(0, n));
            string = string.substring(n + 1);
            n = string.indexOf("\n", 0);
        }
        SCAN_COMMANDS.removeAllElements();
        SCAN_COMMANDS = vector;
        for (int i = 0; i < SCAN_COMMANDS.size(); ++i) {
            SCAN_COMMANDS_STATE.put(SCAN_COMMANDS.elementAt(i), TRUE);
        }
    }

    public static PreferenceFile getPreferenceFile() {
        return preferenceFile;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setIdentificationLabel(String string) {
        this.identificationLabel = string;
    }

    public String getIdentificationLabel() {
        return this.identificationLabel;
    }

    public static void enableInstrumentObjectEvents(boolean bl) {
        ENABLE_EVENTS = bl;
    }

    public static Vector<InstrumentObjectListener> getListeners() {
        return listeners;
    }

    public static Vector<PropertyChangedListener> getPropertyListeners() {
        return propertyChangedListeners;
    }

    public static void addInstrumentObjectListener(InstrumentObjectListener instrumentObjectListener) {
        if (instrumentObjectListener == null) {
            return;
        }
        if (listeners == null) {
            listeners = new Vector();
        }
        if (!listeners.contains(instrumentObjectListener)) {
            listeners.addElement(instrumentObjectListener);
        }
    }

    public static void removeInstrumentObjectListener(InstrumentObjectListener instrumentObjectListener) {
        if (listeners == null) {
            return;
        }
        listeners.removeElement(instrumentObjectListener);
        instrumentObjectListener = null;
    }

    private void postInstrumentObjectAddedEvent(MLArrayRef mLArrayRef) {
        if (!ENABLE_EVENTS) {
            return;
        }
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                InstrumentObjectListener instrumentObjectListener = listeners.elementAt(i);
                if (instrumentObjectListener == null) continue;
                instrumentObjectListener.instrumentObjectAdded(this, this.getType(), this.getName());
            }
        }
        this.objectCreatedNotification(mLArrayRef);
    }

    private void postInstrumentObjectDeletedEvent() {
        if (!ENABLE_EVENTS) {
            return;
        }
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                InstrumentObjectListener instrumentObjectListener = listeners.elementAt(i);
                if (instrumentObjectListener == null) continue;
                instrumentObjectListener.instrumentObjectDeleted(this, this.getType(), this.getName());
            }
        }
        this.objectDeletedNotification();
    }

    public static void addPropertyChangedListener(PropertyChangedListener propertyChangedListener) {
        if (propertyChangedListener == null) {
            return;
        }
        if (propertyChangedListeners == null) {
            propertyChangedListeners = new Vector();
        }
        if (!propertyChangedListeners.contains(propertyChangedListener)) {
            propertyChangedListeners.addElement(propertyChangedListener);
        }
    }

    public static void removePropertyChangedListener(PropertyChangedListener propertyChangedListener) {
        if (propertyChangedListeners == null) {
            return;
        }
        propertyChangedListeners.removeElement(propertyChangedListener);
        propertyChangedListener = null;
    }

    public void postPropertyChangedEvent(String string, Object object) {
        if (!ENABLE_EVENTS) {
            return;
        }
        if (propertyChangedListeners != null) {
            for (int i = 0; i < propertyChangedListeners.size(); ++i) {
                PropertyChangedListener propertyChangedListener = propertyChangedListeners.elementAt(i);
                if (propertyChangedListener == null) continue;
                propertyChangedListener.propertyChanged(this, string, object);
            }
        }
        this.propertyChangedNotification(string, object);
    }

    public static void addNotification(String string, MLArrayRef mLArrayRef) throws TMException {
        if ((string = string.toLowerCase()).equals("propertychangedpostset")) {
            propertyChangedCallbacks.addElement(new PropertyListenerObject(mLArrayRef));
        } else if (string.equals("objectcreated")) {
            objectCreateCallbacks.addElement(mLArrayRef);
        } else if (string.equals("objectdeleted")) {
            objectDestroyCallbacks.addElement(new DeleteListenerObject(mLArrayRef));
        } else {
            throw new TMException("Invalid TYPE. TYPE can be 'PropertyChangedPostSet', 'ObjectCreated' or 'ObjectDeleted'.");
        }
    }

    public static void addNotification(String string, Vector<Instrument> vector, String[] stringArray, MLArrayRef mLArrayRef) throws TMException {
        if ((string = string.toLowerCase()).equals("propertychangedpostset")) {
            propertyChangedCallbacks.addElement(new PropertyListenerObject(mLArrayRef, vector, stringArray));
        } else if (string.equals("objectcreated")) {
            TMStringUtil.warning((String)"The CALLBACK will not be evaluated since OBJ is already created.");
        } else if (string.equals("objectdeleted")) {
            objectDestroyCallbacks.addElement(new DeleteListenerObject(mLArrayRef, vector));
        } else {
            throw new TMException("Invalid syntax. Type 'instrhelp instrnotify' for more information.");
        }
    }

    public static void removeNotification(String string, int n) throws TMException {
        if (n == -1) {
            throw new TMException("The specified CALLBACK was not found.");
        }
        if ((string = string.toLowerCase()).equals("propertychangedpostset")) {
            propertyChangedCallbacks.removeElementAt(n);
        } else if (string.equals("objectcreated")) {
            objectCreateCallbacks.removeElementAt(n);
        } else if (string.equals("objectdeleted")) {
            objectDestroyCallbacks.removeElementAt(n);
        } else {
            throw new TMException("Invalid TYPE. TYPE can be 'PropertyChangedPostSet', 'ObjectCreated' or 'ObjectDeleted'.");
        }
    }

    private void propertyChangedNotification(String string, Object object) {
        for (int i = 0; i < propertyChangedCallbacks.size(); ++i) {
            PropertyListenerObject propertyListenerObject = (PropertyListenerObject)propertyChangedCallbacks.elementAt(i);
            if (!propertyListenerObject.throwEvent(this, string)) continue;
            ICEvent iCEvent = new ICEvent("PropertyChangedPostSet", Instrument.constructClockVector(Calendar.getInstance()), string, object);
            this.matlabMCR.whenMatlabReady((Runnable)new NotificationQueue(this.MATLABObject, propertyListenerObject.getCallback(), iCEvent));
        }
    }

    private void objectCreatedNotification(MLArrayRef mLArrayRef) {
        for (int i = 0; i < objectCreateCallbacks.size(); ++i) {
            ICEvent iCEvent = new ICEvent("ObjectCreated", Instrument.constructClockVector(Calendar.getInstance()));
            this.matlabMCR.whenMatlabReady((Runnable)new NotificationQueue(mLArrayRef, (MLArrayRef)objectCreateCallbacks.elementAt(i), iCEvent));
        }
    }

    private void objectDeletedNotification() {
        for (int i = 0; i < objectDestroyCallbacks.size(); ++i) {
            DeleteListenerObject deleteListenerObject = (DeleteListenerObject)objectDestroyCallbacks.elementAt(i);
            if (!deleteListenerObject.throwEvent(this)) continue;
            ICEvent iCEvent = new ICEvent("ObjectDeleted", Instrument.constructClockVector(Calendar.getInstance()));
            this.matlabMCR.whenMatlabReady((Runnable)new NotificationQueue(this.MATLABObject, deleteListenerObject.getCallback(), iCEvent));
        }
    }

    public static Object[] getNotificationCallbacks() {
        Object[] objectArray = new Object[]{propertyChangedCallbacks, objectCreateCallbacks, objectDestroyCallbacks};
        return objectArray;
    }

    public static Vector<Object> getNotificationCallbacks(String string) throws TMException {
        if ((string = string.toLowerCase()).equals("propertychangedpostset")) {
            return propertyChangedCallbacks;
        }
        if (string.equals("objectcreated")) {
            return objectCreateCallbacks;
        }
        if (string.equals("objectdeleted")) {
            return objectDestroyCallbacks;
        }
        throw new TMException("Invalid TYPE. TYPE can be 'PropertyChangedPostSet', 'ObjectCreated' or 'ObjectDeleted'.");
    }

    public void matlabEvent(MatlabEvent matlabEvent) {
        switch (matlabEvent.getEventType()) {
            case 1: {
                try {
                    Poller.dispose();
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                ctrlc_flag = true;
            }
        }
    }

    protected Vector<Comparable<?>> getPVPairs() {
        Vector vector = new Vector();
        this.addPVPair(vector, "ByteOrder", BYTE_ORDER[this.byteOrder]);
        this.addPVPair(vector, "BytesAvailableFcnCount", this.bytesAvailableFcnCount);
        this.addPVPair(vector, "InputBufferSize", this.inputBufferSize);
        this.addPVPair(vector, "ObjectVisibility", this.bool2OnOff(this.objectVisibility));
        this.addPVPair(vector, "OutputBufferSize", this.outputBufferSize);
        this.addPVPair(vector, "RecordDetail", RECORD_DETAIL[this.recordDetail]);
        this.addPVPair(vector, "RecordMode", RECORD_MODE[this.recordMode]);
        this.addPVPair(vector, "RecordName", this.recordName);
        this.addPVPair(vector, "Tag", this.tag);
        this.addPVPair(vector, "Timeout", this.timeout);
        this.addPVPair(vector, "TimerPeriod", this.timerPeriod);
        if (!this.nameStandardFormat) {
            vector.addElement((Comparable<?>)((Object)"Name"));
            vector.addElement((Comparable<?>)((Object)this.name));
        }
        return vector;
    }

    protected void addPVPair(Vector<Comparable<?>> vector, String string, int n) {
        Object object = this.getDefaultValue(string);
        if (n != (Integer)object) {
            vector.addElement((Comparable<?>)((Object)string));
            vector.addElement(new Integer(n));
        }
    }

    protected void addPVPair(Vector<Comparable<?>> vector, String string, double d) {
        Integer n = (Integer)this.getDefaultValue(string);
        double d2 = n.intValue();
        if (d != d2) {
            vector.addElement((Comparable<?>)((Object)string));
            vector.addElement(new Double(d));
        }
    }

    protected void addPVPair(Vector<Comparable<?>> vector, String string, Object object) {
        Object object2 = this.getDefaultValue(string);
        if (!object.equals(object2)) {
            vector.addElement((Comparable<?>)((Object)string));
            vector.addElement((Comparable)object);
        }
    }

    protected Object getDefaultValue(String string) {
        for (int i = 0; i < this.objectProps.length; ++i) {
            if (!this.objectProps[i].name.equals(string)) continue;
            return this.objectProps[i].defaultValue;
        }
        return null;
    }

    public final void setByteOrder(int n) {
        this.byteOrder = n;
        this.postPropertyChangedEvent("ByteOrder", BYTE_ORDER[this.byteOrder]);
    }

    public final int getByteOrder() {
        return this.byteOrder;
    }

    public final void setBytesAvailableFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("BytesAvailableFcn", 1, mLArrayRef);
        if (this.bytesAvailableFcn != ACTION) {
            this.bytesAvailableFcn.dispose();
        }
        this.bytesAvailableFcn = mLArrayRef2;
        this.disabledCallbacks[1] = 0;
        this.postPropertyChangedEvent("BytesAvailableFcn", this.bytesAvailableFcn);
    }

    public final MLArrayRef getBytesAvailableFcn() {
        return this.bytesAvailableFcn;
    }

    public final void setBytesAvailableFcnCount(int n) throws TMException {
        if (this.status == 1) {
            Instrument.displayError("BytesAvailableFcnCount cannot be set while OBJ is open.");
        }
        if (n <= 0) {
            Instrument.displayError("BytesAvailableFcnCount must be greater than or equal to 1.");
        }
        this.bytesAvailableFcnCount = n;
        this.postPropertyChangedEvent("BytesAvailableFcnCount", new Integer(this.bytesAvailableFcnCount));
    }

    public final int getBytesAvailableFcnCount() {
        return this.bytesAvailableFcnCount;
    }

    public final void setBytesAvailableFcnMode(int n) throws TMException {
        if (this.status == 1) {
            Instrument.displayError("BytesAvailableFcnMode cannot be set while OBJ is open.");
        }
        this.bytesAvailableFcnMode = n;
        this.postPropertyChangedEvent("BytesAvailableFcnMode", BYTES_FMODE[this.bytesAvailableFcnMode]);
    }

    public final int getBytesAvailableFcnMode() {
        return this.bytesAvailableFcnMode;
    }

    public final void setCreationTime(Calendar calendar) {
        this.oldCreationTime = calendar;
    }

    public final Calendar getCreationTime() {
        return this.oldCreationTime;
    }

    public final void setUniqueCreationTime(double d) {
        this.creationTime = d;
        if (!allTimes.contains(new Double(this.creationTime))) {
            allTimes.addElement(new Double(this.creationTime));
        }
    }

    public final double getUniqueCreationTime() {
        return this.creationTime;
    }

    public final void setErrorFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("ErrorFcn", 2, mLArrayRef);
        if (this.errorFcn != ACTION) {
            this.errorFcn.dispose();
        }
        this.errorFcn = mLArrayRef2;
        this.disabledCallbacks[2] = 0;
        this.postPropertyChangedEvent("ErrorFcn", this.errorFcn);
    }

    public final MLArrayRef getErrorFcn() {
        return this.errorFcn;
    }

    public final void setHandle(int n) throws TMException {
        Instrument.displayError(this.createReadOnlyPropertyError("Handle"));
    }

    public final int getHandle() {
        return this.handle;
    }

    public final void setID(double d) throws TMException {
        Instrument.displayError(this.createReadOnlyPropertyError("ID"));
    }

    public final double getID() {
        return this.id;
    }

    public final void setName(String string) {
        this.name = string;
        this.nameStandardFormat();
        this.postPropertyChangedEvent("Name", this.name);
    }

    public final String getName() {
        return this.name;
    }

    public final void setObjectVisibility(boolean bl) throws TMException {
        this.objectVisibility = bl;
        this.postPropertyChangedEvent("ObjectVisibility", this.bool2OnOff(this.objectVisibility));
    }

    public final boolean getObjectVisibility() {
        return this.objectVisibility;
    }

    public final void setOutputEmptyFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("OutputEmptyFcn", 4, mLArrayRef);
        if (this.outputEmptyFcn != ACTION) {
            this.outputEmptyFcn.dispose();
        }
        this.outputEmptyFcn = mLArrayRef2;
        this.disabledCallbacks[4] = 0;
        this.postPropertyChangedEvent("OutputEmptyFcn", this.outputEmptyFcn);
    }

    public final MLArrayRef getOutputEmptyFcn() {
        return this.outputEmptyFcn;
    }

    public final void setRecordDetail(int n) {
        this.recordDetail = n;
        this.postPropertyChangedEvent("RecordDetail", RECORD_DETAIL[this.recordDetail]);
    }

    public final int getRecordDetail() {
        return this.recordDetail;
    }

    public final void setRecordMode(int n) throws TMException {
        if (this.recordStatus) {
            Instrument.displayError("RecordMode cannot be set while OBJ is recording.");
        }
        this.recordMode = n;
        this.postPropertyChangedEvent("RecordMode", RECORD_MODE[this.recordMode]);
    }

    public final int getRecordMode() {
        return this.recordMode;
    }

    public final void setMATLABClassName(String string) throws TMException {
        if (string.equals("")) {
            Instrument.displayError("MATLABClassName cannot be set to an empty string.");
        }
        this.MATLABClassName = string;
    }

    public final String getMATLABClassName() {
        return this.MATLABClassName;
    }

    public final void setRecordName(String string) throws TMException {
        if (this.recordStatus) {
            Instrument.displayError("RecordName cannot be set while OBJ is recording.");
        }
        if (string.equals("")) {
            Instrument.displayError("RecordName cannot be set to an empty string.");
        }
        this.recordName = string;
        this.postPropertyChangedEvent("RecordName", this.recordName);
    }

    public final String getRecordName() {
        return this.recordName;
    }

    public final void setRecordStatus(boolean bl) throws TMException {
        Instrument.displayError(this.createReadOnlyPropertyError("RecordStatus"));
    }

    public final boolean getRecordStatus() {
        return this.recordStatus;
    }

    public final void setStatus(int n) throws TMException {
        Instrument.displayError(this.createReadOnlyPropertyError("Status"));
    }

    public final int getStatus() {
        return this.status;
    }

    public final void setTag(String string) {
        this.tag = string;
        this.postPropertyChangedEvent("Tag", this.tag);
    }

    public final String getTag() {
        return this.tag;
    }

    public final void setTimeout(double d) throws TMException {
        if (new Double(d).toString().equals("NaN")) {
            Instrument.displayError("Timeout cannot be set to NaN. Timeout must be greater than or equal to 0.");
        }
        if (d < 0.0) {
            Instrument.displayError("Timeout must be greater than or equal to 0.");
        }
        if (this.status == 0) {
            this.timeout = d;
            if (this.deviceObject != null) {
                for (int i = 0; i < this.deviceObject.size(); ++i) {
                    this.deviceObject.elementAt(i).setTimeoutFromInterfaceObject(this.timeout);
                }
            }
            this.postPropertyChangedEvent("Timeout", new Double(this.timeout));
            return;
        }
        if (this.getTransferStatus() != 0) {
            Instrument.displayError("Timeout " + NOASYNCOP);
        }
        try {
            this.setHardwareTimeout(d);
            this.timeout = this.getHardwareTimeout();
        }
        catch (Exception exception) {
            Instrument.displayError(exception.getMessage());
        }
        if (this.deviceObject != null) {
            for (int i = 0; i < this.deviceObject.size(); ++i) {
                this.deviceObject.elementAt(i).setTimeoutFromInterfaceObject(this.timeout);
            }
        }
        this.postPropertyChangedEvent("Timeout", new Double(this.timeout));
    }

    public final double getTimeout() {
        return this.timeout;
    }

    public void setTimerFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("TimerFcn", 6, mLArrayRef);
        if (this.timerFcn != ACTION) {
            this.timerFcn.dispose();
        }
        this.timerFcn = mLArrayRef2;
        this.disabledCallbacks[6] = 0;
        if (this.status == 0) {
            this.postPropertyChangedEvent("TimerFcn", this.timerFcn);
            return;
        }
        if (this.timerFcn == ACTION) {
            if (this.wasTimerStarted) {
                this.timer.hold();
            }
        } else if (this.wasTimerStarted) {
            this.timer.setDelay((int)(this.timerPeriod * 1000.0));
            this.timer.reset();
        } else {
            this.createTimer();
        }
        this.postPropertyChangedEvent("TimerFcn", this.timerFcn);
    }

    public MLArrayRef getTimerFcn() {
        return this.timerFcn;
    }

    public void setTimerPeriod(double d) throws TMException {
        if (this.status == 1) {
            Instrument.displayError("TimerPeriod cannot be set while OBJ is open.");
        }
        if (new Double(d).toString().equals("NaN")) {
            Instrument.displayError("TimerPeriod cannot be set to NaN. TimerPeriod must be greater than or equal to 0.01s.");
        }
        if (d == Double.POSITIVE_INFINITY) {
            Instrument.displayError("TimerPeriod cannot be set to Inf.");
        }
        if (d < 0.01) {
            Instrument.displayError("TimerPeriod must be greater than or equal to 0.01s.");
        }
        this.timerPeriod = d;
        this.postPropertyChangedEvent("TimerPeriod", new Double(this.timerPeriod));
    }

    public double getTimerPeriod() {
        return this.timerPeriod;
    }

    public final void setTransferStatus(int n) throws TMException {
        Instrument.displayError(this.createReadOnlyPropertyError("TransferStatus"));
    }

    public final int getTransferStatus() {
        return this.transferStatus;
    }

    public final void setType(String string) throws TMException {
        Instrument.displayError(this.createReadOnlyPropertyError("Type"));
    }

    public final String getType() {
        return this.type;
    }

    public final void setUserData(MLArrayRef mLArrayRef) {
        if (this.userData != USERDATA) {
            this.userData.dispose();
        }
        this.userData = mLArrayRef;
        this.postPropertyChangedEvent("UserData", this.userData);
    }

    public final MLArrayRef getUserData() {
        return this.userData;
    }

    public final void fopen() throws TMException {
        int n;
        if (!this.isvalid()) {
            Instrument.displayError(INVALIDOBJ);
            return;
        }
        if (this.status == 1) {
            Instrument.displayError("OBJ has already been opened.");
        }
        try {
            this.openHardware();
        }
        catch (Exception exception) {
            Instrument.displayError(exception.getMessage());
        }
        long l = this.valuesReceived;
        long l2 = this.valuesSent;
        int n2 = this.status;
        try {
            this.status = 1;
            this.valuesSent = 0L;
            this.valuesReceived = 0L;
            this.updatePropsOnOpen();
            this.flushinput();
            this.flushoutput();
            for (n = 0; n < this.disabledCallbacks.length; ++n) {
                this.disabledCallbacks[n] = 0;
            }
            this.addToPoller();
            this.postPropertyChangedEvent("Status", "open");
        }
        catch (Exception exception) {
            this.status = n2;
            this.valuesSent = l2;
            this.valuesReceived = l;
            try {
                this.closeHardware();
            }
            catch (Exception exception2) {
                Instrument.displayError("Could not disconnect.");
            }
            Instrument.displayError(exception.getMessage());
        }
        if (this.deviceObject != null) {
            for (n = 0; n < this.deviceObject.size(); ++n) {
                this.deviceObject.elementAt(n).connectFromInterfaceObject();
            }
        }
    }

    public final void fclose() throws TMException {
        if (!this.isvalid()) {
            Instrument.displayError(INVALIDOBJ);
        }
        if (this.status == 0) {
            return;
        }
        if (this.transferStatus == 2 || this.transferStatus == 3) {
            Instrument.displayError("OBJ cannot be closed while an asynchronous write is in progress." + LINESEP + "Use STOPASYNC to stop the asynchronous write operation.");
        }
        this.cleanupInterface();
    }

    protected final void cleanupInterface() throws TMException {
        this.stopAsyncRead();
        this.record("off");
        this.status = 0;
        this.transferStatus = 0;
        this.postPropertyChangedEvent("Status", "closed");
        try {
            this.closeHardware();
        }
        catch (Exception exception) {
            Instrument.displayError(exception.getMessage());
        }
        if (this.deviceObject != null) {
            for (int i = 0; i < this.deviceObject.size(); ++i) {
                this.deviceObject.elementAt(i).disconnectFromInterfaceObject();
            }
        }
        try {
            if (Poller.getDelay() == 0) {
                Poller.setDelay();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public final void setValuesSent(int n) throws TMException {
        Instrument.displayError(this.createReadOnlyPropertyError("ValuesSent"));
    }

    public final long getValuesSent() {
        return this.getWrappedValues(this.valuesSent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws TMException {
        int n;
        Object object = this.isValidObj;
        synchronized (object) {
            if (!this.isvalid()) {
                return;
            }
            if (this.status == 1) {
                Instrument.displayError("OBJ must be disconnected from the hardware with FCLOSE before deleting.");
            }
            if (this.wasTimerStarted) {
                this.timer.stop();
            }
            for (int i = 0; i < objectDestroyCallbacks.size(); ++i) {
                DeleteListenerObject deleteListenerObject = (DeleteListenerObject)objectDestroyCallbacks.elementAt(i);
                if (!deleteListenerObject.okToDispose()) continue;
                deleteListenerObject.cleanup();
            }
            this.isValidObj = null;
        }
        Matlab.removeListener((MatlabListener)this);
        this.disposeMLArrayRefs();
        this.timer = null;
        this.deleteInstrumentObject(this);
        this.disposeInputBuffer();
        for (n = 0; n < propertyChangedCallbacks.size(); ++n) {
            PropertyListenerObject propertyListenerObject = (PropertyListenerObject)propertyChangedCallbacks.elementAt(n);
            if (!propertyListenerObject.okToDispose()) continue;
            propertyListenerObject.cleanup();
        }
        if (this.deviceObject != null) {
            for (n = this.deviceObject.size() - 1; n >= 0; --n) {
                ICDevice iCDevice = this.deviceObject.elementAt(n);
                iCDevice.cleanup();
                iCDevice.dispose();
            }
            this.deviceObject = null;
        }
        this.cleanup();
        this.actionQueue = null;
        this.disabledCallbacks = null;
        this.callbackType = null;
        this.evalString = null;
    }

    protected void superDisposeMLArrayRef() {
        if (this.bytesAvailableFcn != ACTION) {
            this.bytesAvailableFcn.dispose();
        }
        if (this.errorFcn != ACTION) {
            this.errorFcn.dispose();
        }
        if (this.outputEmptyFcn != ACTION) {
            this.outputEmptyFcn.dispose();
        }
        if (this.timerFcn != ACTION) {
            this.timerFcn.dispose();
        }
        if (this.userData != USERDATA) {
            this.userData.dispose();
        }
        for (int i = 0; i < this.callbackData.length; ++i) {
            if (this.callbackData[i] == null) continue;
            this.callbackData[i].dispose();
            this.callbackData[i] = null;
        }
        this.bytesAvailableFcn = null;
        this.errorFcn = null;
        this.outputEmptyFcn = null;
        this.timerFcn = null;
        this.userData = null;
        this.callbackData = null;
    }

    protected void verifyObjectState() throws TMException {
        ctrlc_flag = false;
        if (!this.isvalid()) {
            Instrument.displayError(INVALIDOBJ);
        }
        if (this.status == 0) {
            Instrument.displayError(MUSTCONNECT);
        }
    }

    protected final void deleteInstrumentObject(Instrument instrument) {
        int n = allInstrumentObjects.indexOf(instrument);
        if (n != -1) {
            allInstrumentObjects.removeElementAt(n);
        }
        instrument = null;
        n = allTimes.indexOf(this.creationTime);
        if (n != -1) {
            allTimes.removeElementAt(n);
        }
        this.creationTime = 0.0;
        this.postInstrumentObjectDeletedEvent();
    }

    protected static final void deleteLastCreatedObject() {
        int n = allInstrumentObjects.size();
        if (n != 0) {
            allInstrumentObjects.removeElementAt(n - 1);
        }
    }

    public static final String extension() {
        String string = platform == 0 ? ".dll" : (platform == 2 ? ".jnilib" : ".so");
        return string;
    }

    public final boolean isvalid() {
        ctrlc_flag = false;
        return allInstrumentObjects.indexOf(this) != -1 && this.isValidObj != null;
    }

    public static final Vector<Instrument> jinstrfind() {
        return allInstrumentObjects;
    }

    public static final Vector<Instrument> getNonLockedObjects() {
        Vector<Instrument> vector = new Vector<Instrument>();
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            if (!Instrument.allInstrumentObjects.elementAt((int)i).objectVisibility) continue;
            vector.addElement(allInstrumentObjects.elementAt(i));
        }
        return vector;
    }

    public static final Vector<Instrument> jinstrfindall() {
        return allInstrumentObjects;
    }

    public final void record() throws TMException {
        if (this.recordStatus) {
            this.record("off");
        } else {
            this.record("on");
        }
    }

    public final void record(String string) throws TMException {
        if (!this.isvalid()) {
            Instrument.displayError(INVALIDOBJ);
        }
        string = string.toLowerCase();
        switch (this.status) {
            case 1: {
                if (string.equals("on")) {
                    this.turnOnRecordStatus();
                } else if (string.equals("off")) {
                    this.turnOffRecordStatus();
                }
                return;
            }
            case 0: {
                if (string.equals("off")) {
                    return;
                }
                if (!string.equals("on")) break;
                Instrument.displayError(MUSTCONNECT);
            }
        }
        this.postPropertyChangedEvent("RecordStatus", string);
    }

    private final void turnOnRecordStatus() throws TMException {
        if (this.recordStatus) {
            return;
        }
        if (this.recordFileWriter == null) {
            this.recordFileWriter = new RecordFileWriter();
        }
        this.recordFileWriter.setObject(this);
        int n = openRecordFileNames.indexOf(this.recordName);
        if (n != -1) {
            Instrument.displayError("Another instrument object is currently recording to " + this.recordName + "." + " The RecordName " + LINESEP + "property should be set to a new filename or" + " recording should be turned off " + LINESEP + "with the RECORD function.");
        } else {
            openRecordFileNames.addElement(this.recordName);
        }
        this.recordStatus = true;
        this.recordFileWriter.open();
    }

    public final void turnOffRecordStatus() throws TMException {
        openRecordFileNames.removeElement(this.recordName);
        if (this.recordFileWriter != null) {
            this.recordFileWriter.close();
        }
        String string = null;
        if (this.recordFileWriter != null) {
            string = this.recordFileWriter.updateRecordName();
        }
        this.recordStatus = false;
        if (string != null) {
            this.recordName = null;
            this.recordName = string;
        }
    }

    protected void writeRawDataToFile(String string, String string2) {
        if (this.recordStatus) {
            try {
                this.recordFileWriter.appendAsciiDataToFile(string, string.length(), string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void writeRawDataToFile(Object object, int n, int n2, String string, String string2, int n3) {
        if (this.recordStatus) {
            try {
                this.recordFileWriter.appendBinaryDataToFile(object, n, n2, string, string2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object[] ObjectHardwareInfo(String[] stringArray) throws TMException {
        Object[] objectArray = this.getHwInfoStruct();
        String[] stringArray2 = this.getHwInfoFields();
        Object[] objectArray2 = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            try {
                n = TMStringUtil.findPropertyCompleteName((String)stringArray[i], (String[])stringArray2);
            }
            catch (TMException tMException) {
                throw new TMException("Invalid FieldName: '" + stringArray[i] + "' specified.");
            }
            objectArray2[i] = objectArray[n];
        }
        return objectArray2;
    }

    public final Object[] propinfo(String[] stringArray) throws TMException {
        int n;
        if (!IS_TOOLBOX_INSTALLED) {
            Instrument.displayError("Undefined function or variable 'propinfo'.");
        }
        if (!this.isvalid()) {
            Instrument.displayError(INVALIDOBJ);
        }
        this.updateObjectSpecificProperties(this.objectProps);
        int n2 = this.objectProps.length;
        Object[] objectArray = new Object[6];
        Object[] objectArray2 = new Object[stringArray.length];
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray2[n] = this.extractClassProperty(this.objectProps[n].name).toLowerCase();
        }
        for (n = 0; n < stringArray.length; ++n) {
            Object object;
            int n3 = TMStringUtil.findPropertyCompleteName((String)stringArray[n], (String[])stringArray2);
            if (this.objectProps[n3].hidden != 0) {
                throw new TMException("Invalid property: '" + this.extractClassProperty(this.objectProps[n3].name) + "' specified.");
            }
            objectArray[0] = this.objectProps[n3].type;
            objectArray[1] = this.objectProps[n3].constraint;
            objectArray[2] = this.objectProps[n3].constraintValue;
            objectArray[3] = this.objectProps[n3].defaultValue;
            objectArray[4] = this.objectProps[n3].readOnly;
            objectArray[5] = new Integer(this.objectProps[n3].interfaceSpecific);
            objectArray2[n] = object = objectArray.clone();
        }
        return objectArray2;
    }

    private String extractClassProperty(String string) {
        return string.charAt(0) == 'f' ? string.substring(1) : string;
    }

    public final Object[] propinfo() throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            Instrument.displayError("Undefined function or variable 'propinfo'.");
        }
        if (!this.isvalid()) {
            Instrument.displayError(INVALIDOBJ);
        }
        this.updateObjectSpecificProperties(this.objectProps);
        int n = this.objectProps.length;
        Object[] objectArray = new Object[PropertyUtil.getNumberOfValidProps(this.objectProps)];
        Object[] objectArray2 = new Object[7];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.objectProps[i].hidden != 0) continue;
            objectArray2[0] = this.extractClassProperty(this.objectProps[i].name);
            objectArray2[1] = this.objectProps[i].type;
            objectArray2[2] = this.objectProps[i].constraint;
            objectArray2[3] = this.objectProps[i].constraintValue;
            objectArray2[4] = this.objectProps[i].defaultValue;
            objectArray2[5] = this.objectProps[i].readOnly;
            objectArray2[6] = new Integer(this.objectProps[i].interfaceSpecific);
            Object object = objectArray2.clone();
            objectArray[n2++] = object;
        }
        return objectArray;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ICProp[] getProps() {
        return this.objectProps;
    }

    public String[] getPropertyNames() throws TMException {
        return PropertyUtil.getPropertyNames(this);
    }

    public final int[] isInterfaceSpecific() throws TMException {
        return PropertyUtil.isInterfaceSpecific(this);
    }

    public final Object createPropSetArray(String string) throws TMException {
        return PropertyUtil.createPropSetArray(this, string);
    }

    public final String createPropSetDisplay(String[] stringArray) throws TMException {
        return PropertyUtil.createPropSetDisplay(this, stringArray);
    }

    public synchronized void executeEvent(int n, String string, Calendar calendar, Object object) {
        if (this.disabledCallbacks[n] == 1) {
            return;
        }
        if (n == 6 && this.timerCallbackCount++ > 100) {
            return;
        }
        this.matlabMCR.whenMatlabReady((Runnable)new ActionQueue(this, n, object));
        if (this.recordStatus) {
            ICEvent iCEvent = (ICEvent)object;
            try {
                this.recordFileWriter.appendEvent(string, calendar);
                if (iCEvent.Data instanceof ICErrorEvent) {
                    this.recordFileWriter.appendToFile(BLANKS.substring(0, 7) + ((ICErrorEvent)iCEvent.Data).Message);
                } else if (iCEvent.Data instanceof ICPinEvent) {
                    this.recordFileWriter.appendToFile(BLANKS.substring(0, 7) + ((ICPinEvent)iCEvent.Data).Pin + " is '" + ((ICPinEvent)iCEvent.Data).PinValue + "'.");
                } else if (iCEvent.Data instanceof ICTriggerEvent) {
                    this.recordFileWriter.appendToFile(BLANKS.substring(0, 7) + "Trigger line is " + ((ICTriggerEvent)iCEvent.Data).TriggerLine + ".");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected synchronized void executeErrorEvent(Calendar calendar, String string) {
        if (!this.errorFcn.equals(ACTION)) {
            this.executeEvent(2, "Error", calendar, new ICEvent("Error", Instrument.constructClockVector(calendar), string));
        }
    }

    protected static final double[][] constructClockVector(Calendar calendar) {
        double[][] dArray = new double[1][6];
        double d = calendar.get(14);
        dArray[0][0] = calendar.get(1);
        dArray[0][1] = calendar.get(2) + 1;
        dArray[0][2] = calendar.get(5);
        dArray[0][3] = calendar.get(11);
        dArray[0][4] = calendar.get(12);
        dArray[0][5] = (int)Math.round((double)calendar.get(13) + d / 1000.0);
        return dArray;
    }

    protected final long getWrappedValues(long l) {
        if (l < 0L) {
            return l - Long.MIN_VALUE;
        }
        return l;
    }

    protected Object convertBinaryData(byte[] byArray, int n, int n2) throws Exception {
        if (n2 == 0) {
            return null;
        }
        if (n == 0 || n == 5) {
            return byArray;
        }
        if (platformByteOrder == this.byteOrder) {
            if (platformByteOrder == 0) {
                return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
            }
            if (platformByteOrder == 1) {
                return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
            }
        } else {
            if (platformByteOrder == 0) {
                return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
            }
            if (platformByteOrder == 1) {
                return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
            }
        }
        throw new TMException("Invalid ByteOrder specified.");
    }

    public void queueAction(int n) {
        this.actionQueue.addElement(new Integer(n));
    }

    public void queueAction(Integer n) {
        this.actionQueue.addElement(n);
    }

    protected boolean isActionAvailable() {
        return this.actionQueue.size() >= 2;
    }

    protected int getNextAction() {
        int n = this.actionQueue.firstElement();
        this.actionQueue.removeElementAt(0);
        return n;
    }

    protected final String getVendorName(String string) {
        if (string.startsWith("mw")) {
            int n = string.indexOf(".");
            string = string.substring(2, n - 4).toUpperCase();
        }
        return string;
    }

    protected final MLArrayRef verifyActionValue(String string, int n, MLArrayRef mLArrayRef) throws TMException {
        int n2 = mLArrayRef.getType();
        if (n2 != 1 && n2 != 4 && n2 != 16) {
            Instrument.displayError(string + ACTIONERROR);
        }
        if (mLArrayRef.getM() == 0 && mLArrayRef.getN() == 0) {
            if (n2 == 1) {
                Instrument.displayError(string + ACTIONERROR);
            }
            return ACTION;
        }
        if (mLArrayRef.getM() != 1) {
            Instrument.displayError(string + ACTIONERROR);
        }
        if (n2 == 1) {
            MLArrayRef mLArrayRef2 = mLArrayRef.cellInfoAt(0);
            if (mLArrayRef2.getType() != 4 && mLArrayRef2.getType() != 16) {
                mLArrayRef2.dispose();
                Instrument.displayError(string + ACTIONERROR);
            }
            if (mLArrayRef2.getM() == 0 && mLArrayRef2.getN() == 0) {
                mLArrayRef2.dispose();
                Instrument.displayError(string + ACTIONERROR);
            }
            mLArrayRef2.dispose();
        }
        if (n2 == 4) {
            this.callbackType[n] = 0;
            this.evalString[n] = (String)mLArrayRef.getData();
        } else {
            this.callbackType[n] = 1;
            this.callbackData[n] = mLArrayRef;
        }
        return mLArrayRef;
    }

    protected final boolean verifySetValues(double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] != d) continue;
            return true;
        }
        return false;
    }

    protected final boolean verifySetRange(int n, int n2, int n3) {
        return n <= n3 && n >= n2;
    }

    protected final int str2num(String string) {
        return Integer.valueOf(string);
    }

    public static final byte[] object2byteArray(Object object) {
        Byte by = (Byte)object;
        Instrument.singleByteMessage[0] = by;
        return singleByteMessage;
    }

    public static final short[] object2shortArray(Object object) {
        Short s = (Short)object;
        Instrument.singleShortMessage[0] = s;
        return singleShortMessage;
    }

    public static final int[] object2intArray(Object object) {
        Integer n = (Integer)object;
        Instrument.singleIntegerMessage[0] = n;
        return singleIntegerMessage;
    }

    public static final float[] object2floatArray(Object object) {
        Float f = (Float)object;
        Instrument.singleFloatMessage[0] = f.floatValue();
        return singleFloatMessage;
    }

    public static final double[] object2doubleArray(Object object) {
        Double d = (Double)object;
        Instrument.singleDoubleMessage[0] = d;
        return singleDoubleMessage;
    }

    public static final char[] object2charArray(Object object) {
        Character c = (Character)object;
        Instrument.singleCharacterMessage[0] = c.charValue();
        return singleCharacterMessage;
    }

    protected final String int2OnOff(int n) {
        switch (n) {
            case 0: {
                return "off";
            }
        }
        return "on";
    }

    protected final String bool2OnOff(boolean bl) {
        if (bl) {
            return "on";
        }
        return "off";
    }

    protected final int bool2int(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    protected final boolean int2bool(int n) {
        return n > 0;
    }

    public static final void displayError(String string) throws TMException {
        throw new TMException(string);
    }

    public static final void displayWarning(String string) {
        Object[] objectArray = new Object[]{string};
        try {
            Matlab.mtFevalConsoleOutput((String)"warning", (Object[])objectArray, (int)0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean nanoTicTimeout(long l, double d) {
        return (double)((Instrument.currentNanoTicTime() - l) / 1000000000L) >= d;
    }

    public static long nanoBadTime() {
        return Instrument.currentNanoTicTime() - 1000000000000L;
    }

    public static long currentNanoTicTime() {
        return System.nanoTime();
    }

    protected final String createReadOnlyPropertyError(String string) {
        return "The property: '" + string + "' is read-only.";
    }

    public static final String jarVersion() {
        Object[] objectArray;
        Object[] objectArray2 = new Object[]{"instrument"};
        try {
            objectArray = (Object[])Matlab.mtFeval((String)"ver", (Object[])objectArray2, (int)1);
        }
        catch (Exception exception) {
            return "";
        }
        Object[] objectArray3 = (Object[])objectArray[1];
        Object[] objectArray4 = (Object[])objectArray3[0];
        return "Version " + (String)objectArray4[1];
    }

    public final int getDefaultInputBufferSize() {
        return this.inputBufferSize;
    }

    public final int getDefaultOutputBufferSize() {
        return this.outputBufferSize;
    }

    protected abstract void openHardware() throws Exception;

    protected abstract void closeHardware() throws Exception;

    protected abstract void addToPoller();

    protected abstract boolean poll();

    protected abstract void createTimer();

    protected abstract void disposeMLArrayRefs();

    protected abstract void updatePropsOnOpen() throws Exception;

    public abstract void setInputBufferSize(int var1) throws TMException;

    public abstract int getInputBufferSize();

    public abstract void setOutputBufferSize(int var1) throws TMException;

    public abstract int getOutputBufferSize();

    protected abstract void setHardwareTimeout(double var1) throws TMException;

    protected abstract double getHardwareTimeout();

    protected abstract void nameStandardFormat();

    protected abstract void updateObjectSpecificProperties(ICProp[] var1);

    protected abstract void disposeInputBuffer();

    protected abstract void flushinput() throws TMException;

    protected abstract void flushoutput() throws TMException;

    public abstract void stopasync() throws Exception;

    protected abstract void stopAsyncRead();

    protected abstract int getSuccessValue();

    protected abstract String getErrorMessageFromHardware(int var1);

    protected abstract Object[] getHwInfoStruct();

    protected abstract String[] getHwInfoFields();

    public abstract String getConstructor();

    public abstract String getConstructorDescription();

    public abstract String getInstrfindArgs();

    public abstract Object[] getNonDefaultPVPairs();

    public abstract String display();

    public abstract String setDisplay() throws Exception;

    public abstract String[] getBrowserInfo();

    public abstract String getBrowserString();

    public abstract Object[] constructorargs();

    static {
        platformByteOrder = 0;
        allInstrumentObjects = new Vector();
        IS_TOOLBOX_INSTALLED = false;
        openRecordFileNames = new Vector(5);
        singleByteMessage = new byte[1];
        singleShortMessage = new short[1];
        singleIntegerMessage = new int[1];
        singleFloatMessage = new float[1];
        singleDoubleMessage = new double[1];
        singleCharacterMessage = new char[1];
        ACTIONERROR = " must be set to a string, function handle or a 1-by-N cell array." + LINESEP + "The first element of the 1-by-N cell array must be the callback function name or a function handle.";
        NOASYNCOP = "cannot be modified while an asynchronous operation is in progress." + LINESEP + "Use STOPASYNC to stop the asynchronous operation.";
        propertyChangedCallbacks = new Vector();
        objectCreateCallbacks = new Vector();
        objectDestroyCallbacks = new Vector();
        gpib32DllVendor = "";
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            platform = 0;
        } else if (string.startsWith("Mac")) {
            platform = 2;
        } else if (string.startsWith("Sol") | string.startsWith("Sun")) {
            platform = 3;
            platformByteOrder = 1;
        } else {
            platform = 1;
        }
        if (!NativeMatlab.nativeIsMatlabThread()) {
            Matlab.whenMatlabReady((Runnable)toolboxInitializer);
        } else {
            Object object;
            Object[] objectArray;
            try {
                objectArray = new String[]{"Instr_Control_Toolbox"};
                object = (boolean[])Matlab.mtSendLicenseCheck((Object[])objectArray);
                IS_TOOLBOX_INSTALLED = object[0];
            }
            catch (Exception exception) {
                IS_TOOLBOX_INSTALLED = false;
            }
            try {
                if (IS_TOOLBOX_INSTALLED && platform == 0) {
                    objectArray = new String[]{"instrgate"};
                    object = (String)Matlab.mtFeval((String)"which", (Object[])objectArray, (int)1);
                    if (object != null && ((String)object).length() > 0) {
                        Object[] objectArray2 = new String[]{"privateGetGpib32DllVendor"};
                        gpib32DllVendor = (String)Matlab.mtFeval((String)"instrgate", (Object[])objectArray2, (int)1);
                    } else {
                        gpib32DllVendor = "";
                    }
                }
            }
            catch (Exception exception) {
                gpib32DllVendor = "";
            }
        }
    }
}

