/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.driver;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.instrument.browser.driver.DriverPage;
import com.mathworks.toolbox.instrument.browser.driver.MLDriverPageInfo;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MLDriverPage
extends DriverPage
implements ItemListener,
WindowListener,
ListSelectionListener,
Runnable {
    private static final long serialVersionUID = 1L;
    private static final int PROPERTIES = 0;
    private static final int FUNCTIONS = 1;
    private JComboBox selectionComboBox;
    private MLDriverPageInfo currentInfo;

    public MLDriverPage() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.layoutPanel();
    }

    @Override
    public void update(BrowserTreeNode browserTreeNode) {
        this.currentInfo = (MLDriverPageInfo)browserTreeNode.getUserData();
        this.currentInfo.setup((MJFrame)SwingUtilities.windowForComponent((Component)((Object)this)));
        if (!this.currentInfo.isValid()) {
            this.setVisible(false);
            MJOptionPane.showMessageDialog((Component)((Object)this), (Object)"The selected driver could not be located.  Update the driver\nlist using the Scan button on the MATLAB Instrument Driver panel.", (String)"Test & Measurement Tool", (int)0);
            return;
        }
        this.setVisible(true);
        this.updateHeadingPanel();
        this.updateSelectionPanel();
        this.updateListBox();
        this.nameScrollPane.getViewport().setViewPosition(TOP_POINT);
        this.list.addListSelectionListener((ListSelectionListener)this);
        MJFrame mJFrame = (MJFrame)SwingUtilities.windowForComponent((Component)((Object)this));
        if (mJFrame != null) {
            mJFrame.addWindowListener((WindowListener)this);
        }
    }

    @Override
    public void cleanup() {
        this.list.removeListSelectionListener((ListSelectionListener)this);
        MJFrame mJFrame = (MJFrame)SwingUtilities.windowForComponent((Component)((Object)this));
        if (mJFrame != null) {
            mJFrame.removeWindowListener((WindowListener)this);
        }
    }

    private void layoutPanel() {
        MJPanel mJPanel = this.add((JComponent)this.createHeadingPanel(true), this.createSelectionPanel(), 4);
        MJPanel mJPanel2 = this.add((JComponent)mJPanel, (JComponent)this.createInfoPanel(), 4);
        this.add((Component)mJPanel2, "North");
        this.add((Component)this.getHelpPanel(), "Center");
    }

    private JPanel createSelectionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(4, 0));
        this.selectionComboBox = new JComboBox();
        this.selectionComboBox.addItem("Properties");
        this.selectionComboBox.addItem("Functions");
        this.selectionComboBox.addItemListener(this);
        jPanel.add((Component)new JLabel("View available:"), "West");
        jPanel.add((Component)this.selectionComboBox, "Center");
        return jPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateListBox();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateHelp();
    }

    private void updateHeadingPanel() {
        this.driverLabel.setText(this.currentInfo.getDirectory());
        this.manufacturerLabel.setText(this.currentInfo.getManufacturer());
        this.modelLabel.setText(this.currentInfo.getModel());
        this.instrumentTypeLabel.setText(this.currentInfo.getInstrumentType());
        this.instrumentVerLabel.setText(this.currentInfo.getInstrumentVersion());
    }

    private void updateSelectionPanel() {
    }

    private void updateListBox() {
        switch (this.selectionComboBox.getSelectedIndex()) {
            case 0: {
                this.list.setListData(this.currentInfo.getProperties());
                break;
            }
            case 1: {
                this.list.setListData(this.currentInfo.getFunctions());
            }
        }
        if (this.list.getModel().getSize() > 1) {
            this.list.setSelectedIndex(1);
        }
        this.nameScrollPane.getViewport().setViewPosition(TOP_POINT);
        this.updateHelp();
    }

    private void updateHelp() {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            this.help.setText("<html></html>");
            return;
        }
        switch (this.selectionComboBox.getSelectedIndex()) {
            case 0: {
                this.help.setText("<pre>" + this.currentInfo.getPropertyHelp(n) + "</pre>");
                break;
            }
            case 1: {
                this.help.setText("<pre>" + this.currentInfo.getFunctionHelp(n) + "</pre>");
            }
        }
        this.help.setCaretPosition(0);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)this);
            }
            catch (Throwable throwable) {}
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        this.currentInfo.setup((MJFrame)SwingUtilities.windowForComponent((Component)((Object)this)));
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }
}

