/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.driver;

import com.mathworks.toolbox.instrument.browser.driver.DriverPageInfo;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.VXIPnPLoader;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFunction;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.util.Vector;

public class VXIPnPDriverPageInfo
extends DriverPageInfo {
    private DriverModel model = null;
    private Vector<String> methods = null;
    private Vector<String> help = null;
    private Vector<String> inputs = null;

    public VXIPnPDriverPageInfo(String string, String string2, int n) {
        super(string, string2, n);
    }

    public void setup() {
        this.defineModel();
        this.defineData();
    }

    private void defineModel() {
        if (this.model == null) {
            try {
                this.model = VXIPnPLoader.toBasicMatlabDriverModel(this.nameWithPath + ".fp");
            }
            catch (TMException tMException) {
                // empty catch block
            }
        }
    }

    private void defineData() {
        if (this.methods != null) {
            return;
        }
        this.methods = new Vector();
        this.help = new Vector();
        this.inputs = new Vector();
        DriverGroup[] driverGroupArray = this.model.getGroups();
        for (int i = 0; i < driverGroupArray.length; ++i) {
            String string = driverGroupArray[i].getDisplayName();
            this.methods.addElement(string + " group methods:");
            this.help.addElement(driverGroupArray[i].getHelpText());
            this.inputs.addElement("");
            Vector<DriverFunction> vector = driverGroupArray[i].getFunctions();
            for (int j = 0; j < vector.size(); ++j) {
                DriverFunction driverFunction = vector.elementAt(j);
                this.methods.addElement("    " + driverFunction.getName());
                this.help.addElement(driverFunction.getDescription());
                String string2 = driverFunction.getInputs().toString();
                this.inputs.addElement(string2.substring(1, string2.length() - 1));
            }
        }
    }

    public String getManufacturer() {
        if (this.model == null) {
            return new String("");
        }
        return this.model.getInstrumentManufacturer();
    }

    public String getModel() {
        return this.model.getInstrumentModel();
    }

    public String getInstrumentVersion() {
        return this.model.getInstrumentVersion();
    }

    public Vector<String> getMethodList() {
        return this.methods;
    }

    public String getMethodHelp(int n) {
        return this.help.elementAt(n);
    }

    public String getMethodInputs(int n) {
        return this.inputs.elementAt(n);
    }
}

