/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.interfaceobj;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.PropertyChangedListener;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.PropertyPage;
import com.mathworks.toolbox.instrument.browser.interfaceobj.BrowserCommunicationLabel;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfo;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.instrument.browser.objects.GPIBObject;
import com.mathworks.toolbox.instrument.browser.objects.SerialObject;
import com.mathworks.toolbox.instrument.guiutil.DataExporter;
import com.mathworks.toolbox.instrument.instrcomm.CommunicationLabel;
import com.mathworks.toolbox.instrument.instrcomm.CommunicationPanel;
import com.mathworks.toolbox.instrument.instrcomm.HistoryTable;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.util.Log;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CommunicationPage
extends InstrumentControlBrowserPage
implements PropertyChangedListener,
ChangeListener,
ActionListener,
MouseListener {
    static final long serialVersionUID = 0L;
    private static final int SERIAL_VISA = 0;
    private static final int GPIB_VISA = 1;
    private static final int NO_VISA = 2;
    private static CommunicationPage communicationPage = null;
    private CommunicationInfo currentInfo = null;
    protected Instrument instrumentObject;
    protected BrowserObject browserObject;
    protected MJTabbedPane tabPanel;
    protected PropertyPage propertyPanel = null;
    protected MJPanel configureTabPanel;
    protected MJScrollPane propertyPanelScrollPane;
    protected MJPanel propertyContainer;
    protected HistoryTable table;
    private SyntaxTextPane MCodeTextArea;
    private JComponent MCodeTextAreaPane;
    private MJButton saveButton;
    private MJPanel communicationTabOuterPanel;
    private CommunicationPanel communicationPanel;
    private MJPanel centerHeadingPanel = null;
    private InstrumentControlBrowser browser;
    private MJLabel identificationLabel;
    private HeadingPanel headingPanel = null;
    private CommunicationLabel communicationLabel;
    private CommunicationLabel communicationLabelScannedHW;
    private CommunicationLabel communicationLabelInstrumentObject;
    private String toolTipStr = null;
    private boolean needToolTip = false;
    private MJPanel configurePanel;
    private MJRadioButton visaButton;
    private MJRadioButton nonvisaButton;
    private MJComboBox visaSerialComboBox;
    private MJPanel VISAPanel = null;
    private boolean isSerialComboBoxAdded = false;
    private int isVISAAdded = 2;
    private MJPanel visaRadioButtonPanel = null;
    private static String sConnected = sResources.getString("Heading.Connected");
    private static String sDisconnected = sResources.getString("Heading.Disconnected");
    private ObjectRegistry registry;

    public static CommunicationPage getInstance(InstrumentControlBrowser instrumentControlBrowser) {
        if (communicationPage == null) {
            communicationPage = new CommunicationPage(instrumentControlBrowser);
        }
        return communicationPage;
    }

    public static boolean hasInstance() {
        return communicationPage != null;
    }

    private CommunicationPage(InstrumentControlBrowser instrumentControlBrowser) {
        this.browser = instrumentControlBrowser;
        this.registry = new ObjectRegistry();
        Instrument.addPropertyChangedListener(this);
        this.layoutPanel();
    }

    @Override
    public void dispose() {
        Instrument.removePropertyChangedListener(this);
        if (this.currentInfo != null && this.currentInfo.getHeadingPanel() != null) {
            this.currentInfo.getHeadingPanel().cleanup();
        }
        if (this.table != null) {
            this.table.cleanup();
        }
        this.saveButton.removeActionListener((ActionListener)this);
        this.tabPanel.removeChangeListener((ChangeListener)this);
        if (this.communicationPanel != null) {
            this.communicationPanel.dispose();
        }
        if (this.visaSerialComboBox != null) {
            this.visaSerialComboBox.removeActionListener((ActionListener)this);
        }
        if (this.visaButton != null) {
            this.visaButton.removeActionListener((ActionListener)this);
        }
        if (this.nonvisaButton != null) {
            this.nonvisaButton.removeActionListener((ActionListener)this);
        }
        if (this.communicationLabel != null) {
            this.communicationLabel.dispose();
        }
        if (this.communicationLabelScannedHW != null && this.communicationLabelScannedHW != this.communicationLabel) {
            this.communicationLabelScannedHW.dispose();
        }
        if (this.communicationLabelInstrumentObject != null && this.communicationLabelInstrumentObject != this.communicationLabel) {
            this.communicationLabelInstrumentObject.dispose();
        }
        if (this.propertyPanel != null) {
            this.propertyPanel.cleanup();
        }
        this.propertyPanel = null;
        this.communicationLabel = null;
        this.communicationLabelScannedHW = null;
        this.communicationLabelInstrumentObject = null;
        communicationPage = null;
        this.tabPanel = null;
        this.MCodeTextArea.cleanup();
        this.MCodeTextArea = null;
    }

    @Override
    public void propertyChanged(Instrument instrument, String string, Object object) {
        if (this.communicationLabel == null) {
            return;
        }
        if (string.equals("Status")) {
            if (object.equals("open")) {
                this.communicationLabel.addConnectRow();
            } else {
                this.communicationLabel.addDisconnectRow();
            }
        }
        if (this.tabPanel.getSelectedIndex() == 2) {
            this.updateMCodeTextArea();
        }
    }

    @Override
    public void update(BrowserTreeNode browserTreeNode) {
        boolean bl = false;
        if (this.currentInfo != null) {
            this.headingPanel = null;
            this.remove((Component)((Object)this.currentInfo.getHeadingPanel()));
            this.currentInfo.getHeadingPanel().cleanup();
            this.currentInfo.setLastSelectedTab(this.tabPanel.getSelectedIndex());
            this.currentInfo.setNeedToolTip(this.needToolTip);
            this.currentInfo.setToolTipString(this.toolTipStr);
            this.currentInfo.setIdentificationLabel(this.identificationLabel);
            if (this.identificationLabel != null) {
                this.identificationLabel.removeMouseListener((MouseListener)this);
            }
            this.currentInfo.setWritePanelCommandIndex(this.communicationPanel.getWritePanelCommandIndex());
            this.currentInfo.setWritePanelFormatIndex(this.communicationPanel.getWritePanelFormatIndex());
            this.currentInfo.setWritePanelEvaluateCommand(this.communicationPanel.getWritePanelEvaluateCommand());
            this.currentInfo.setWritePanelCommands(this.communicationPanel.getWritePanelCommands());
            this.currentInfo.setReadPanelCommandIndex(this.communicationPanel.getReadPanelCommandIndex());
            this.currentInfo.setReadPanelFormatIndex(this.communicationPanel.getReadPanelFormatIndex());
            this.currentInfo.setReadSize(this.communicationPanel.getReadSize());
            this.currentInfo.setResponseText(this.communicationPanel.getResponseText());
            this.currentInfo.setTableData(this.table.getTableData());
            this.currentInfo.setCodeBank(this.table.getCodeBank());
            this.currentInfo.setTableVariables(this.table.getVariables());
            this.currentInfo.setLastCommunicatingWithName(this.table.getLastCommunicatingWithName());
            this.currentInfo.setCommands(this.table.getCommands());
            this.currentInfo.setActionColumnWidth(this.table.getActionColumnWidth());
            this.currentInfo.setCommunicationColumnWidth(this.table.getCommunicationColumnWidth());
            this.currentInfo.setSizeColumnWidth(this.table.getSizeColumnWidth());
            this.currentInfo.setFormatColumnWidth(this.table.getFormatColumnWidth());
            this.browser.synchronizeCommunicationInfo(this.currentInfo);
        } else {
            bl = true;
        }
        this.currentInfo = (CommunicationInfo)browserTreeNode.getUserData();
        this.browserObject = this.currentInfo.getBrowserObject();
        this.instrumentObject = this.currentInfo.getInstrumentObject();
        this.update(this.currentInfo, bl);
    }

    private void update(CommunicationInfo communicationInfo, boolean bl) {
        this.needToolTip = this.currentInfo.getNeedToolTip();
        this.toolTipStr = this.currentInfo.getToolTipString();
        this.identificationLabel = this.currentInfo.getIdentificationLabel();
        if (this.identificationLabel != null) {
            this.identificationLabel.addMouseListener((MouseListener)this);
        }
        this.communicationPanel.setWritePanelCommandIndex(this.currentInfo.getWritePanelCommandIndex());
        this.communicationPanel.setWritePanelFormatIndex(this.currentInfo.getWritePanelFormatIndex());
        this.communicationPanel.setWritePanelEvaluateCommand(this.currentInfo.getWritePanelEvaluateCommand());
        this.communicationPanel.setWritePanelCommands(this.currentInfo.getWritePanelCommands());
        this.communicationPanel.setReadPanelCommandIndex(this.currentInfo.getReadPanelCommandIndex());
        this.communicationPanel.setReadPanelFormatIndex(this.currentInfo.getReadPanelFormatIndex());
        this.communicationPanel.setReadSize(this.currentInfo.getReadSize());
        this.communicationPanel.setResponseText(this.currentInfo.getResponseText());
        this.table.setTableData(this.currentInfo.getTableData());
        this.table.setCodeBank(this.currentInfo.getCodeBank());
        this.table.setVariables(this.currentInfo.getTableVariables());
        this.table.setLastCommunicatingWithName(this.currentInfo.getLastCommunicatingWithName());
        this.table.setCommands(this.currentInfo.getCommands());
        this.table.setActionColumnWidth(this.currentInfo.getActionColumnWidth());
        this.table.setCommunicationColumnWidth(this.currentInfo.getCommunicationColumnWidth());
        this.table.setSizeColumnWidth(this.currentInfo.getSizeColumnWidth());
        this.table.setFormatColumnWidth(this.currentInfo.getFormatColumnWidth());
        if (this.currentInfo.getStatus() == 0) {
            this.communicationPanel.setComponentsEnabled(false);
        } else {
            this.communicationPanel.setComponentsEnabled(true);
        }
        this.communicationPanel.setObject(this.currentInfo.getInstrumentObject());
        this.updateObjectInPropertyView();
        if (this.propertyPanel != null) {
            this.propertyPanel.update();
        }
        this.updateConfigurePanelVISAInfo();
        this.tabPanel.setSelectedIndex(communicationInfo.getLastSelectedTab());
        this.stateChanged(null);
        if (bl) {
            // empty if block
        }
        if (this.currentInfo.getType() == 0) {
            this.addHeadingPanelForScannedHW();
        } else {
            this.addHeadingPanelForInstrumentObject();
        }
        this.revalidate();
        this.repaint();
    }

    private void updateObjectInPropertyView() {
        this.registry.register((Object)this.currentInfo.getBrowserObject(), null);
        Object[] objectArray = new Object[]{this.currentInfo.getObject()};
        this.registry.setSelected(objectArray, true);
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.tabPanel = new MJTabbedPane();
        this.tabPanel.setName("Hardware Tab Panel");
        this.tabPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.tabPanel.add("Communicate", (Component)this.createCommunicatePanel());
        this.configurePanel = this.createConfigurePanel();
        this.tabPanel.add("Configure", (Component)this.configurePanel);
        this.tabPanel.add("Session Log", (Component)this.createInfoPanel());
        this.tabPanel.addChangeListener((ChangeListener)this);
        this.add((Component)this.tabPanel, "Center");
    }

    private MJPanel createCommunicatePanel() {
        this.communicationTabOuterPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.table = new HistoryTable();
        this.table.setOkToAddCommunicatingWithRow(false);
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.table);
        mJScrollPane.setBorder(null);
        mJPanel.add((Component)mJScrollPane, (Object)"Center");
        this.table.setPreferredSize(new Dimension(50, 50));
        mJScrollPane.setPreferredSize(new Dimension(50, 50));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.add((Component)mJPanel2, (Object)"North");
        this.communicationPanel = new CommunicationPanel(this.table);
        mJPanel2.add((Component)this.communicationPanel, (Object)"Center");
        this.communicationTabOuterPanel.add((Component)mJPanel, (Object)"Center");
        return this.communicationTabOuterPanel;
    }

    public MJPanel createConfigurePanel() {
        this.configureTabPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        return this.configureTabPanel;
    }

    public void createConfigurePanelInterior() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 5, 8));
        this.propertyContainer = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.add((Component)this.propertyContainer, (Object)"Center");
        this.propertyPanel = new PropertyPage(this.registry);
        this.propertyPanel.setPreferredSize(new Dimension(420, 50));
        this.propertyPanelScrollPane = new MJScrollPane((Component)((Object)this.propertyPanel));
        this.propertyContainer.add((Component)this.propertyPanelScrollPane, (Object)"Center");
        this.propertyPanelScrollPane.setPreferredSize(new Dimension(420, 50));
        this.propertyPanelScrollPane.setBorder(null);
        this.configureTabPanel.add((Component)mJPanel, (Object)"West");
        this.configureTabPanel.invalidate();
    }

    private MJPanel createInfoPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    CommunicationPage.this.MCodeTextArea = new SyntaxTextPane();
                    CommunicationPage.this.MCodeTextArea.setContentType(MLanguage.M_MIME_TYPE);
                    CommunicationPage.this.MCodeTextArea.setName("MCode TextArea");
                }
            });
        }
        catch (Throwable throwable) {
            Log.logThrowable((Throwable)throwable);
        }
        this.MCodeTextAreaPane = SyntaxTextPane.getDisplayComponent((SyntaxTextPaneBase)this.MCodeTextArea);
        this.MCodeTextAreaPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.MCodeTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.MCodeTextArea.setEditable(false);
        mJPanel.add((Component)this.MCodeTextAreaPane, (Object)"Center");
        this.MCodeTextAreaPane.setPreferredSize(new Dimension(100, 100));
        mJPanel.add((Component)this.createButtonPanel(), (Object)"South");
        return mJPanel;
    }

    private MJPanel createButtonPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(0, 0, 5));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(1, 1, 0, 0));
        this.saveButton = new MJButton("Save Session...");
        this.saveButton.setName("MCode Save Button");
        this.saveButton.addActionListener((ActionListener)this);
        this.saveButton.putClientProperty((Object)"ACTION", (Object)new Integer(8));
        this.saveButton.putClientProperty((Object)"PANEL", (Object)this);
        mJPanel2.add((Component)this.saveButton);
        mJPanel.add((Component)mJPanel2);
        return mJPanel;
    }

    private void addHeadingPanelForScannedHW() {
        if (this.communicationLabelScannedHW == null) {
            this.communicationLabelScannedHW = new BrowserCommunicationLabel(this.table, 0, null, this.browser);
            ((BrowserCommunicationLabel)this.communicationLabelScannedHW).setPanel(this.communicationPanel);
            ((BrowserCommunicationLabel)this.communicationLabelScannedHW).setCommunicationPage(this);
            this.communicationLabel = this.communicationLabelScannedHW;
        } else {
            this.communicationLabel = this.communicationLabelScannedHW;
        }
        ((BrowserCommunicationLabel)this.communicationLabel).setBrowserObject(this.currentInfo.getBrowserObject());
        this.communicationLabel.setCurrentObject(this.browserObject.getInstrumentObject());
        this.communicationLabel.updateStateButton(this.currentInfo.getStatus());
        this.headingPanel = this.currentInfo.getHeadingPanel();
        if (this.headingPanel == null) {
            this.headingPanel = new ScannedHardwareHeadingPanel();
            this.headingPanel.setup();
            this.currentInfo.setHeadingPanel(this.headingPanel);
            this.currentInfo.setHeadingCenterPanel(this.centerHeadingPanel);
        } else {
            this.currentInfo.getHeadingCenterPanel().add((Component)((Object)this.communicationLabel));
            this.headingPanel.setup();
        }
        this.headingPanel.setConnected(this.currentInfo.getStatus() == 1);
        this.add((Component)((Object)this.headingPanel), "North");
    }

    private void addHeadingPanelForInstrumentObject() {
        if (this.communicationLabelInstrumentObject == null) {
            this.communicationLabel = this.communicationLabelInstrumentObject = new CommunicationLabel(this.table, 1, this.instrumentObject, false);
        } else {
            this.communicationLabel = this.communicationLabelInstrumentObject;
            this.communicationLabel.setCurrentObject(this.currentInfo.getInstrumentObject());
        }
        this.communicationLabel.updateStateButton(this.currentInfo.getStatus());
        this.headingPanel = this.currentInfo.getHeadingPanel();
        if (this.headingPanel == null) {
            this.headingPanel = new InstrumentObjectHeadingPanel();
            ((InstrumentObjectHeadingPanel)this.headingPanel).setup();
            this.currentInfo.setHeadingPanel(this.headingPanel);
            this.currentInfo.setHeadingCenterPanel(this.centerHeadingPanel);
        } else {
            this.currentInfo.getHeadingCenterPanel().add((Component)((Object)this.communicationLabel));
            this.headingPanel.setup();
        }
        this.headingPanel.setConnected(this.currentInfo.getStatus() == 1);
        this.add((Component)((Object)this.headingPanel), "North");
    }

    public void updateConfigurePanelVISAInfo() {
        int n = this.needToAddVISA();
        if (n == this.isVISAAdded) {
            if (n == 0) {
                SerialObject serialObject = (SerialObject)this.currentInfo.getBrowserObject();
                this.configureSelectedVisaSerialPort(serialObject);
            }
            return;
        }
        if (this.VISAPanel == null) {
            this.VISAPanel = this.createVISAPanel();
        }
        if (n == 0 && this.isVISAAdded == 2) {
            this.configurePanel.add((Component)this.VISAPanel, (Object)"North");
            this.configureVISAPanelForSerial();
        } else if (n == 0 && this.isVISAAdded == 1) {
            this.configureVISAPanelForSerial();
        } else if (n == 1 && this.isVISAAdded == 2) {
            this.configurePanel.add((Component)this.VISAPanel, (Object)"North");
            this.configureVISAPanelForGPIB();
        } else if (n == 1 && this.isVISAAdded == 0) {
            this.configureVISAPanelForGPIB();
        } else if (n == 2) {
            this.configurePanel.remove((Component)this.VISAPanel);
        }
        this.isVISAAdded = n;
    }

    private int needToAddVISA() {
        if (this.currentInfo.getType() == 1) {
            return 2;
        }
        if (!this.browser.isVISASupported()) {
            return 2;
        }
        if (this.browserObject instanceof GPIBObject) {
            return 1;
        }
        if (this.browserObject instanceof SerialObject) {
            return 0;
        }
        return 2;
    }

    private void configureVISAPanelForSerial() {
        if (this.visaSerialComboBox == null) {
            this.visaSerialComboBox = new MJComboBox((Object[])this.browser.getVISAPorts());
        }
        this.visaButton.setText("Use the VISA driver for communicating. Use port: ");
        this.nonvisaButton.setText("Use the MATLAB serial driver for communicating");
        if (!this.isSerialComboBoxAdded) {
            this.isSerialComboBoxAdded = true;
            this.visaRadioButtonPanel.add((Component)this.visaSerialComboBox);
            this.visaSerialComboBox.addActionListener((ActionListener)this);
        }
        SerialObject serialObject = (SerialObject)this.currentInfo.getBrowserObject();
        this.configureSelectedVisaSerialPort(serialObject);
        this.updateVISAState();
    }

    private void configureSelectedVisaSerialPort(SerialObject serialObject) {
        int n = serialObject.getIndex();
        if (n > this.visaSerialComboBox.getItemCount() - 1) {
            this.visaSerialComboBox.setSelectedIndex(0);
        } else {
            this.visaSerialComboBox.setSelectedIndex(serialObject.getIndex());
        }
        serialObject.setVISAPort((String)this.visaSerialComboBox.getSelectedItem());
    }

    private void configureVISAPanelForGPIB() {
        if (this.isSerialComboBoxAdded) {
            this.visaRadioButtonPanel.remove((Component)this.visaSerialComboBox);
            this.visaSerialComboBox.removeActionListener((ActionListener)this);
            this.isSerialComboBoxAdded = false;
        }
        this.visaButton.setText("Use the VISA driver for communicating");
        this.nonvisaButton.setText("Use the GPIB board driver for communicating");
        this.updateVISAState();
    }

    private MJPanel createVISAPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder("Select driver"));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridLayout(2, 1, 0, 0));
        mJPanel.add((Component)mJPanel2, (Object)"Center");
        String string = "Use the VISA driver for communicating";
        String string2 = "Use the GPIB board driver for communicating";
        this.visaButton = new MJRadioButton(string);
        this.nonvisaButton = new MJRadioButton(string2);
        this.nonvisaButton.setSelected(true);
        this.visaButton.setName("VISA RadioButton");
        this.nonvisaButton.setName("Non-VISA RadioButton");
        this.visaButton.addActionListener((ActionListener)this);
        this.nonvisaButton.addActionListener((ActionListener)this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.visaButton);
        buttonGroup.add((AbstractButton)this.nonvisaButton);
        this.visaRadioButtonPanel = new MJPanel((LayoutManager)new FlowLayout(0, 0, 0));
        this.visaRadioButtonPanel.add((Component)this.visaButton);
        mJPanel3.add((Component)this.visaRadioButtonPanel);
        mJPanel3.add((Component)this.nonvisaButton);
        mJPanel2.add((Component)mJPanel3, (Object)"North");
        return mJPanel;
    }

    private void updateVISAState() {
        if (!this.browser.isVISASupported() || this.isVISAAdded == 2) {
            return;
        }
        Instrument instrument = this.browserObject.getInstrumentObject();
        if (instrument != null && instrument.isvalid() && instrument.getStatus() == 1) {
            this.setVISAEnable(false);
        } else {
            this.setVISAEnable(true);
        }
    }

    private void setVISAEnable(boolean bl) {
        try {
            this.visaButton.setEnabled(bl);
            this.nonvisaButton.setEnabled(bl);
            this.visaSerialComboBox.setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MJButton) {
            this.browser.actionPerformed(actionEvent);
        } else if (actionEvent.getSource() instanceof MJRadioButton) {
            this.browserObject.setUseVISA(this.visaButton.isSelected());
        } else {
            ((SerialObject)this.browserObject).setVISAPort((String)this.visaSerialComboBox.getSelectedItem());
        }
    }

    public void setIdentification(String string) {
        if (this.identificationLabel != null) {
            this.identificationLabel.setText(this.getIdentificationLabel(string));
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        switch (this.tabPanel.getSelectedIndex()) {
            case 0: {
                break;
            }
            case 1: {
                if (this.propertyPanel == null) {
                    this.createConfigurePanelInterior();
                }
                this.propertyPanel.update();
                this.updateVISAState();
                break;
            }
            case 2: {
                this.updateMCodeTextArea();
            }
        }
    }

    private void updateMCodeTextArea() {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommunicationPage.this.updateMCodeTextArea();
                }
            });
        } else {
            int n = this.MCodeTextArea.getCaretPosition();
            String string = this.table.getFileText();
            try {
                this.MCodeTextArea.delete(0, this.MCodeTextArea.getLength());
                if (string.length() > 0) {
                    this.MCodeTextArea.insert(0, string.substring(1, string.length()));
                    this.saveButton.setEnabled(true);
                } else {
                    this.MCodeTextArea.insert(0, string);
                    this.saveButton.setEnabled(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n < 0 || n > string.length()) {
                n = 0;
            }
            this.MCodeTextArea.setCaretPosition(n);
        }
    }

    private String getIdentificationLabel(String string) {
        String string2 = string;
        this.toolTipStr = string;
        this.needToolTip = false;
        return string2;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.needToolTip) {
            this.identificationLabel.setToolTipText(this.toolTipStr);
        } else {
            this.identificationLabel.setToolTipText(null);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.identificationLabel.setToolTipText("");
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void exportHistoryTable(MJFrame mJFrame) {
        new DataExporter(this.table).showAsDialog(mJFrame);
    }

    public void saveHistoryTable(String string) {
        this.table.save(string);
    }

    class ScannedHardwareHeadingPanel
    extends HeadingPanel
    implements PropertyChangedListener {
        static final long serialVersionUID = 0L;

        public ScannedHardwareHeadingPanel() {
            this.layoutPanel();
        }

        public void layoutPanel() {
            this.setLayout(new BorderLayout(0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
            mJPanel.setBorder((Border)BorderFactory.createTitledBorder("Connection"));
            MJLabel mJLabel = new MJLabel("Connection status to " + CommunicationPage.this.browserObject.getDescriptiveText() + ":");
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0);
            mJPanel.add((Component)mJLabel, (Object)gridBagConstraints);
            this.fConnectionStatusLabel = new MJLabel(sDisconnected);
            gridBagConstraints.gridx = 1;
            mJPanel.add((Component)this.fConnectionStatusLabel, (Object)gridBagConstraints);
            Font font = this.fConnectionStatusLabel.getFont();
            font = font.deriveFont(1);
            this.fConnectionStatusLabel.setFont(font);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            CommunicationPage.this.centerHeadingPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
            CommunicationPage.this.centerHeadingPanel.add((Component)((Object)CommunicationPage.this.communicationLabel));
            mJPanel.add((Component)CommunicationPage.this.centerHeadingPanel, (Object)gridBagConstraints);
            mJLabel = new MJLabel("Last identification request on " + CommunicationPage.this.browserObject.getScanDate() + ": " + CommunicationPage.this.getIdentificationLabel(CommunicationPage.this.browserObject.getIdentification()));
            mJLabel.setHorizontalAlignment(2);
            gridBagConstraints = new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0);
            mJPanel.add((Component)mJLabel, (Object)gridBagConstraints);
            this.add((Component)mJPanel, "Center");
        }

        @Override
        public void propertyChanged(Instrument instrument, String string, Object object) {
            if (string.equals("Status")) {
                this.setConnected(instrument.getStatus() == 1);
                return;
            }
        }
    }

    class InstrumentObjectHeadingPanel
    extends HeadingPanel
    implements PropertyChangedListener {
        static final long serialVersionUID = 0L;
        private MJLabel fConnectionInfo;
        protected String[] props;

        public InstrumentObjectHeadingPanel() {
            String[] stringArray = CommunicationPage.this.instrumentObject.getBrowserInfo();
            this.props = new String[stringArray.length / 2];
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i] = this.cleanupString(stringArray[i * 2]);
            }
            this.layoutPanel();
        }

        public void layoutPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
            mJPanel.setBorder((Border)BorderFactory.createTitledBorder("Connection"));
            this.fConnectionInfo = new MJLabel("Connection status to " + CommunicationPage.this.instrumentObject.getBrowserString() + ":");
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0);
            mJPanel.add((Component)this.fConnectionInfo, (Object)gridBagConstraints);
            this.fConnectionStatusLabel = new MJLabel(sDisconnected);
            gridBagConstraints.gridx = 1;
            mJPanel.add((Component)this.fConnectionStatusLabel, (Object)gridBagConstraints);
            Font font = this.fConnectionStatusLabel.getFont();
            font = font.deriveFont(1);
            this.fConnectionStatusLabel.setFont(font);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            CommunicationPage.this.centerHeadingPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
            CommunicationPage.this.centerHeadingPanel.add((Component)((Object)CommunicationPage.this.communicationLabel));
            mJPanel.add((Component)CommunicationPage.this.centerHeadingPanel, (Object)gridBagConstraints);
            this.add((Component)mJPanel, "Center");
        }

        protected int isPropertyToListenFor(String string) {
            string = string.toLowerCase();
            for (int i = 0; i < this.props.length; ++i) {
                if (!string.equals(this.props[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void propertyChanged(Instrument instrument, String string, Object object) {
            if (string.equals("Status")) {
                this.setConnected(instrument.getStatus() == 1);
                return;
            }
            int n = this.isPropertyToListenFor(string);
            if (n == -1) {
                return;
            }
            this.fConnectionInfo.setText("Connection status to " + instrument.getBrowserString() + ":");
        }
    }

    public abstract class HeadingPanel
    extends MJPanel
    implements PropertyChangedListener {
        protected MJLabel fConnectionStatusLabel;

        @Override
        public void propertyChanged(Instrument instrument, String string, Object object) {
        }

        protected void setConnected(final boolean bl) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            HeadingPanel.this.setConnected(bl);
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            if (bl) {
                this.fConnectionStatusLabel.setText(sConnected);
            } else {
                this.fConnectionStatusLabel.setText(sDisconnected);
            }
        }

        public void setup() {
            Instrument.addPropertyChangedListener(this);
        }

        public void cleanup() {
            Instrument.removePropertyChangedListener(this);
        }

        protected String cleanupString(String string) {
            if ((string = TMStringUtil.strrep((String)string, (String)" ", (String)"")).endsWith(":")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.startsWith("GPIB")) {
                string = string.substring(4, string.length());
            }
            return string.toLowerCase();
        }
    }
}

