/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.editors;

import com.mathworks.beans.editors.ApplyPropertyEditor;
import com.mathworks.beans.editors.EnhancedPropertyEditor;
import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.mlwidgets.inspector.PropertyView;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.device.DeviceChild;
import com.mathworks.toolbox.instrument.device.editors.ICDeviceChildEditorData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

public final class ICDeviceChildEditor
extends MWPropertyEditorSupport
implements MouseListener,
EnhancedPropertyEditor,
ApplyPropertyEditor {
    public static final String VALUE_KEY = "Output";
    private JTable table;
    private String[] columnNames = new String[]{"HwIndex", "HwName"};
    private Object[][] data;
    private Image icon;
    private JPanel outerPanel;
    private ObjectRegistry registry;
    private PropertyView view;
    private ICDeviceChildEditorData info;
    private String typeOfChild = "Input";
    private DeviceChild[] children = null;

    public Component getCustomEditor() {
        if (this.outerPanel == null) {
            this.outerPanel = new JPanel(new BorderLayout(5, 5));
            this.outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.outerPanel.add((Component)this.createPropertyPage(), "Center");
        } else {
            this.table.addMouseListener(this);
        }
        this.table.setRowSelectionInterval(0, 0);
        this.outerPanel.setPreferredSize(new Dimension(375, 400));
        return this.outerPanel;
    }

    protected JPanel createPropertyPage() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel("Select the " + this.typeOfChild.toLowerCase() + "(s) to configure:"), "North");
        jPanel2.add((Component)this.createTable(), "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout(6, 0));
        this.view = new PropertyView(this.registry);
        jPanel3.add((Component)this.view, "Center");
        jPanel3.add((Component)new JLabel("Edit the selected " + this.typeOfChild.toLowerCase() + "(s) properties:"), "North");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    protected JPanel createTable() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 2));
        this.table = new JTable(new OutputTableModel());
        this.table.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(100, 50));
        jPanel.add((Component)jScrollPane, "North");
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(60);
        return jPanel;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int[] nArray = this.table.getSelectedRows();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this.children[nArray[i]];
        }
        this.registry.setSelected(objectArray, true);
    }

    public void apply() {
        this.table.removeMouseListener(this);
        this.view.dispose();
        this.view = null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public boolean supportsInPlaceEditing() {
        return false;
    }

    public boolean canApply() {
        return true;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.grow(-3, -2);
        if (rectangle2.width > 60) {
            rectangle2.width = 60;
        }
        graphics.setColor(Color.black);
        graphics.drawString("[1x" + this.children.length + " " + this.typeOfChild + "]", rectangle2.x, rectangle2.y + rectangle2.height);
    }

    public Image getIcon() {
        if (this.icon == null) {
            ImageIcon imageIcon = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/object_small.gif"));
            this.icon = imageIcon.getImage();
        }
        return this.icon;
    }

    public boolean hasAttachedData() {
        return true;
    }

    public String getDataKey() {
        return VALUE_KEY;
    }

    public void setData(Object object) {
        if (object instanceof ICDeviceChildEditorData) {
            this.info = (ICDeviceChildEditorData)object;
            this.typeOfChild = this.info.getName();
            this.children = this.info.getChildren();
            this.init();
        }
    }

    public void init() {
        int n;
        if (this.children == null || this.children != null && this.children[0] == null) {
            this.typeOfChild = this.info.getName();
            this.children = this.info.getChildren();
        }
        int n2 = this.children.length;
        this.data = new Object[n2][2];
        for (n = 0; n < n2; ++n) {
            this.data[n][0] = String.valueOf(this.children[n].getHwIndex());
            this.data[n][1] = this.children[n].getHwName();
        }
        if (this.registry == null) {
            this.registry = new ObjectRegistry();
        }
        for (n = 0; n < n2; ++n) {
            this.registry.register((Object)this.children[n], null);
        }
        Object[] objectArray = new Object[]{this.children[0]};
        this.registry.setSelected(objectArray, true);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setFrame(Frame frame) {
    }

    public class OutputTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return ICDeviceChildEditor.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (ICDeviceChildEditor.this.data == null) {
                return 0;
            }
            return ICDeviceChildEditor.this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return ICDeviceChildEditor.this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return ICDeviceChildEditor.this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

