/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.guiutil;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJProgressBar;
import com.mathworks.toolbox.instrument.guiutil.FillPanel;
import com.mathworks.toolbox.instrument.util.ICUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;

public abstract class ObjectCreationDialog
extends MJPanel
implements ActionListener,
FocusListener {
    protected static final ResourceBundle sResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.guiutil.resources.RES_GUIUTIL");
    private static final String ACTION = "ACTION";
    public static final int CANCEL = 0;
    public static final int OK = 1;
    private static final int TYPE = 3;
    private static final int PROPERTY = 4;
    protected static final int WAITING_FOR_DATA = 0;
    protected static final int DATA_IS_READY = 1;
    private MJDialog fDialog = null;
    private MJPanel fInitializationPanel;
    private MJLabel fInitializationLabel;
    private MJPanel fOuterPanel;
    private MJComboBox fObjTypeComboBox;
    private MJPanel fConfigureObjectCreatePanel;
    private boolean fNeedsToBeAdded = true;
    private MJButton fOkButton;
    private MJLabel fObjTypeLabel = new MJLabel();
    private MJFrame fFrame;
    private MJProgressBar fProgressBar;

    public abstract String getObjectTypeLabel();

    public abstract MJPanel getPanel(int var1);

    public abstract boolean createObject(int var1);

    public abstract String[] getObjectTypes();

    public ObjectCreationDialog() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.createComponents();
    }

    protected void createComponents() {
        this.createInitializationComponents();
        this.createObjectCreationComponents();
        this.add((Component)this.fInitializationPanel);
    }

    private void createInitializationComponents() {
        this.fInitializationPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fInitializationPanel.add((Component)((Object)new FillPanel(400, 50)), (Object)"North");
        this.fInitializationLabel = new MJLabel(sResources.getString("ObjectCreate.Loading"));
        this.fInitializationLabel.setHorizontalAlignment(0);
        this.fInitializationPanel.add((Component)this.fInitializationLabel, (Object)"Center");
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        this.fProgressBar = new MJProgressBar();
        this.fProgressBar.setIndeterminate(true);
        this.fProgressBar.setPreferredSize(new Dimension(350, 10));
        mJPanel.add((Component)((Object)new FillPanel(400, 50)), (Object)"South");
        this.fInitializationPanel.add((Component)mJPanel, (Object)"South");
    }

    private void createObjectCreationComponents() {
        this.fOuterPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fOuterPanel.add((Component)this.createDefineObjectBox(), (Object)"North");
        this.fConfigureObjectCreatePanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fOuterPanel.add((Component)this.fConfigureObjectCreatePanel, (Object)"Center");
        this.fOuterPanel.add((Component)this.createButtonPanel(), (Object)"South");
    }

    public void setMode(int n) {
        if (n == 0) {
            if (this.fOuterPanel.getParent() == null) {
                return;
            }
            this.remove((Component)this.fOuterPanel);
            this.add((Component)this.fInitializationPanel, "Center");
        } else {
            if (this.fOuterPanel.getParent() != null) {
                return;
            }
            this.remove((Component)this.fInitializationPanel);
            this.add((Component)this.fOuterPanel, "Center");
        }
        if (this.fDialog != null) {
            this.fDialog.pack();
        }
    }

    public void showAsDialog(MJFrame mJFrame) {
        this.fFrame = mJFrame;
        this.fDialog = new MJDialog((Frame)mJFrame, sResources.getString("ObjectCreate.Title"), true);
        this.internalShowAsDialog((Window)mJFrame, false);
    }

    public void showAsDialog(MJFrame mJFrame, boolean bl) {
        this.fFrame = mJFrame;
        this.fDialog = new MJDialog((Frame)mJFrame, sResources.getString("ObjectCreate.Title"), true);
        this.internalShowAsDialog((Window)mJFrame, bl);
    }

    public void showAsDialog(MJDialog mJDialog) {
        this.fDialog = new MJDialog((Dialog)mJDialog, sResources.getString("ObjectCreate.Title"), true);
        this.internalShowAsDialog((Window)mJDialog, false);
    }

    public void showAsDialog(MJDialog mJDialog, boolean bl) {
        this.fDialog = new MJDialog((Dialog)mJDialog, sResources.getString("ObjectCreate.Title"), true);
        this.internalShowAsDialog((Window)mJDialog, bl);
    }

    public void showAsDialog(MJDialog mJDialog, int n, int n2) {
        this.fDialog = new MJDialog((Dialog)mJDialog, sResources.getString("ObjectCreate.Title"), true);
        this.internalShowAsDialog((Window)mJDialog, n, n2);
    }

    protected void internalShowAsDialog(Window window, int n, int n2) {
        this.fDialog.getContentPane().add((Component)((Object)this));
        this.fDialog.pack();
        Point point = window.getLocation();
        this.fDialog.setLocation(point.x + n, point.y + n2);
        this.makeVisible();
    }

    protected void internalShowAsDialog(Window window, boolean bl) {
        this.fDialog.getContentPane().add((Component)((Object)this));
        this.fDialog.pack();
        if (bl) {
            ICUtil.centerWindow(window, (Window)this.fDialog);
        }
        this.makeVisible();
    }

    protected void makeVisible() {
        this.fDialog.setDefaultCloseOperation(1);
        this.fDialog.getRootPane().setDefaultButton((JButton)this.fOkButton);
        this.fObjTypeLabel.setText(this.getObjectTypeLabel());
        this.update();
        this.fDialog.show();
    }

    public Dimension getDialogDefaultSize() {
        return new Dimension(400, 200);
    }

    public MJDialog getDialog() {
        return this.fDialog;
    }

    public MJFrame getFrame() {
        return this.fFrame;
    }

    public MJPanel createPanel(String[] stringArray, JComponent[] jComponentArray, String[] stringArray2, int n) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(n, 0));
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(sResources.getString("ObjectCreate.ConfigureCreation.Border")));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(stringArray.length, 1, 0, 2));
        for (int i = 0; i < stringArray.length; ++i) {
            mJPanel2.add((Component)new MJLabel(stringArray[i]));
        }
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridLayout(jComponentArray.length, 1, 0, 2));
        for (int i = 0; i < jComponentArray.length; ++i) {
            JComponent jComponent = jComponentArray[i];
            mJPanel3.add((Component)jComponent);
            jComponent.setName(stringArray2[i]);
            this.configureListeners(jComponent);
        }
        mJPanel.add((Component)mJPanel2, (Object)"West");
        mJPanel.add((Component)mJPanel3, (Object)"Center");
        return mJPanel;
    }

    private MJPanel createDefineObjectBox() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(8, 0));
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(sResources.getString("ObjectCreate.DefineObject.Border")));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(1, 1, 0, 2));
        mJPanel2.add((Component)this.fObjTypeLabel);
        mJPanel.add((Component)mJPanel2, (Object)"West");
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridLayout(1, 1, 0, 2));
        this.fObjTypeComboBox = new MJComboBox((Object[])this.getObjectTypes());
        this.fObjTypeComboBox.setName("Object Type ComboBox");
        mJPanel3.add((Component)this.fObjTypeComboBox);
        this.fObjTypeComboBox.addActionListener((ActionListener)this);
        this.fObjTypeComboBox.putClientProperty((Object)ACTION, (Object)new Integer(3));
        mJPanel.add((Component)mJPanel3, (Object)"Center");
        return mJPanel;
    }

    private MJPanel createButtonPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)((Object)new FillPanel(400, 1)), (Object)"North");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FlowLayout(2, 0, 5));
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridLayout(1, 4, 5, 0));
        this.fOkButton = new MJButton(sResources.getString("ObjectCreate.Button.Ok"));
        this.fOkButton.addActionListener((ActionListener)this);
        this.fOkButton.putClientProperty((Object)ACTION, (Object)new Integer(1));
        this.fOkButton.setName("OK Button");
        MJButton mJButton = new MJButton(sResources.getString("ObjectCreate.Button.Cancel"));
        mJButton.addActionListener((ActionListener)this);
        mJButton.putClientProperty((Object)ACTION, (Object)new Integer(0));
        mJButton.setName("Cancel Button");
        mJPanel3.add((Component)this.fOkButton);
        mJPanel3.add((Component)mJButton);
        mJPanel2.add((Component)mJPanel3);
        mJPanel.add((Component)mJPanel2, (Object)"Center");
        return mJPanel;
    }

    protected void configureListeners(JComponent jComponent) {
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).addActionListener(this);
            jComponent.addFocusListener(this);
            jComponent.putClientProperty(ACTION, new Integer(4));
        } else if (jComponent instanceof JComboBox) {
            ((JComboBox)jComponent).addActionListener(this);
            jComponent.putClientProperty(ACTION, new Integer(4));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 1: {
                boolean bl = true;
                if (this.fNeedsToBeAdded) {
                    bl = this.createObject(this.fObjTypeComboBox.getSelectedIndex());
                }
                if (!bl) break;
                this.fDialog.dispose();
                break;
            }
            case 0: {
                this.fDialog.dispose();
                break;
            }
            case 3: {
                this.updateObjectCreationPanel();
                this.fNeedsToBeAdded = true;
                jComponent.revalidate();
                jComponent.repaint();
                break;
            }
            case 4: {
                this.fNeedsToBeAdded = true;
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.fNeedsToBeAdded = true;
    }

    public void update() {
        this.fObjTypeComboBox.removeAllItems();
        String[] stringArray = this.getObjectTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.fObjTypeComboBox.addItem((Object)stringArray[i]);
        }
        this.fObjTypeComboBox.setSelectedIndex(0);
        this.updateObjectCreationPanel();
    }

    protected void updateObjectCreationPanel() {
        MJPanel mJPanel = this.getPanel(this.fObjTypeComboBox.getSelectedIndex());
        if (mJPanel == null) {
            return;
        }
        this.fConfigureObjectCreatePanel.removeAll();
        this.fConfigureObjectCreatePanel.add((Component)mJPanel, (Object)"North");
        this.validate();
        this.repaint();
    }

    public int getObjTypeIndex() {
        return this.fObjTypeComboBox.getSelectedIndex();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }
}

