/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class MWSlider
extends MWCanvas
implements Adjustable {
    public static final int NO_PART = -1;
    public static final int DECREMENT_PAGE = 0;
    public static final int THUMB = 1;
    public static final int INCREMENT_PAGE = 2;
    private int fMax;
    private int fMin;
    private int fVal;
    private int fOrientation;
    private boolean fMouseDown;
    private boolean fHasFocus;
    private boolean fSupportsFocus;
    private boolean fHasRollover;
    private Rectangle fRolloverRect;
    private Point fReleasePoint;
    private AdjustmentListener fListener;

    public MWSlider(int n, int n2, int n3, int n4) {
        this.fOrientation = n;
        this.fMax = n4;
        this.fMin = n3;
        this.fVal = n2;
        this.enableEvents(60L);
    }

    public MWSlider(int n) {
        this(n, 0, 0, 100);
    }

    public MWSlider() {
        this(0, 0, 0, 100);
    }

    @Override
    public boolean isFocusTraversable() {
        return this.fSupportsFocus && this.isEnabled();
    }

    public void setFocusBehavior(boolean bl) {
        this.fSupportsFocus = bl;
    }

    @Override
    public int getValue() {
        return this.fVal;
    }

    @Override
    public void setValue(int n) {
        this.fVal = n < this.fMin ? this.fMin : (n > this.fMax ? this.fMax : n);
    }

    @Override
    public int getMinimum() {
        return this.fMin;
    }

    @Override
    public void setMinimum(int n) {
        this.fMin = n > this.fMax ? this.fMax : n;
        if (this.fVal < this.fMin) {
            this.fVal = this.fMin;
        }
    }

    @Override
    public int getMaximum() {
        return this.fMax;
    }

    @Override
    public void setMaximum(int n) {
        this.fMax = n < this.fMin ? this.fMin : n;
        if (this.fVal > this.fMax) {
            this.fVal = this.fMax;
        }
    }

    @Override
    public int getOrientation() {
        return this.fOrientation;
    }

    public void setOrientation(int n) {
        if (this.fOrientation != n) {
            switch (n) {
                case 0: 
                case 1: {
                    this.fOrientation = n;
                }
            }
        }
    }

    public int sliderThumbLength() {
        return Decorations.sliderThumbLength();
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.fListener = AWTEventMulticaster.add(this.fListener, adjustmentListener);
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.fListener = AWTEventMulticaster.remove(this.fListener, adjustmentListener);
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2 = this.sliderThumbLength();
        int n3 = n2 / 2;
        int n4 = this.getMaximum() - this.getMinimum();
        int n5 = this.getValue() - this.getMinimum();
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle();
        int n6 = this.getOrientation();
        int n7 = dimension.width;
        int n8 = dimension.height;
        int n9 = 0;
        if (this.fSupportsFocus) {
            n7 -= 2;
            n8 -= 2;
            n9 = 1;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n10 = n = PlatformInfo.useWindowsXPAppearance() ? 3 : 0;
        if (n6 == 1) {
            int n11 = n5 * (n8 - n2) / n4;
            int n12 = n11 + n2;
            rectangle.setBounds(n9, n9, n7, n11 + n);
            Decorations.drawSliderTrack(graphics, rectangle, 0, n6, this.isEnabled());
            rectangle.setBounds(n9, n12 + n9, n7, n8 - n12 + n);
            Decorations.drawSliderTrack(graphics, rectangle, 2, n6, this.isEnabled());
            rectangle.setBounds(n9, n11 + n9, n7, n2);
            this.fRolloverRect = rectangle;
            if (this.fReleasePoint != null) {
                this.fHasRollover = rectangle.contains(this.fReleasePoint);
                this.fReleasePoint = null;
            }
            Decorations.drawSliderThumb(graphics, rectangle, n6, this.fMouseDown, this.isEnabled(), this.fHasRollover);
        } else {
            int n13 = n5 * (n7 - n2) / n4;
            int n14 = n13 + n2;
            if (this.fSupportsFocus) {
                --n7;
            }
            rectangle.setBounds(n9, n9, n13 + n, n8);
            Decorations.drawSliderTrack(graphics, rectangle, 0, n6, this.isEnabled());
            rectangle.setBounds(n14 + n9, n9, n7 - n14 + n, n8);
            Decorations.drawSliderTrack(graphics, rectangle, 2, n6, this.isEnabled());
            rectangle.setBounds(n13 + n9, n9, n2, n8);
            this.fRolloverRect = rectangle;
            if (this.fReleasePoint != null) {
                this.fHasRollover = rectangle.contains(this.fReleasePoint);
                this.fReleasePoint = null;
            }
            Decorations.drawSliderThumb(graphics, rectangle, n6, this.fMouseDown, this.isEnabled(), this.fHasRollover);
        }
        if (this.fHasFocus) {
            Decorations.drawFocusRect(graphics, 0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int n = PlatformInfo.isWindowsXP() ? 5 : 0;
        Dimension dimension = this.getOrientation() == 1 ? new Dimension(16 + n, 200) : new Dimension(200, 16 + n);
        if (this.fSupportsFocus) {
            dimension.width += 2;
            dimension.height += 2;
        }
        return dimension;
    }

    protected void moveIt(Point point) {
        int n = this.sliderThumbLength();
        int n2 = n / 2;
        int n3 = this.getMinimum();
        int n4 = this.getMaximum();
        int n5 = n4 - n3;
        Dimension dimension = this.getSize();
        if (this.fSupportsFocus) {
            dimension.width -= 2;
            dimension.height -= 2;
        }
        if (n5 > 0) {
            int n6;
            if (this.getOrientation() == 1) {
                int n7 = dimension.height / n5 / 2;
                n2 = point.y > n2 ? n2 : point.y;
                n6 = n3 + n5 * (point.y - n2 + n7) / (dimension.height - n);
            } else {
                int n8 = dimension.width / n5 / 2;
                n2 = point.x > n2 ? n2 : point.x;
                n6 = n3 + n5 * (point.x - n2 + n8) / (dimension.width - n);
            }
            int n9 = this.getValue();
            this.setValue(n6);
            if (this.getValue() != n9) {
                n3 = this.fSupportsFocus ? 1 : 0;
                this.repaint(n3, n3, dimension.width, dimension.height);
                this.fireAdjustmentEvent();
            }
        }
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            if (this.isFocusTraversable()) {
                this.requestFocus();
            }
            this.fMouseDown = true;
            this.moveIt(mouseEvent.getPoint());
            if (PlatformInfo.useWindowsXPAppearance() && this.fRolloverRect != null) {
                this.repaint(this.fRolloverRect.x, this.fRolloverRect.y, this.fRolloverRect.width, this.fRolloverRect.height);
            }
        } else if (mouseEvent.getID() == 502) {
            this.fMouseDown = false;
            this.moveIt(mouseEvent.getPoint());
            if (PlatformInfo.useWindowsXPAppearance() && this.fRolloverRect != null) {
                this.fReleasePoint = mouseEvent.getPoint();
                this.repaint(this.fRolloverRect.x, this.fRolloverRect.y, this.fRolloverRect.width, this.fRolloverRect.height);
            }
        } else if (mouseEvent.getID() == 504) {
            if (PlatformInfo.useWindowsXPAppearance() && this.fRolloverRect != null && this.fRolloverRect.contains(mouseEvent.getPoint())) {
                this.fHasRollover = true;
                if (this.isEnabled()) {
                    this.repaint(this.fRolloverRect.x, this.fRolloverRect.y, this.fRolloverRect.width, this.fRolloverRect.height);
                }
            }
        } else if (mouseEvent.getID() == 505 && this.fHasRollover && PlatformInfo.useWindowsXPAppearance()) {
            this.fHasRollover = false;
            if (this.isEnabled() && this.fRolloverRect != null) {
                this.repaint(this.fRolloverRect.x, this.fRolloverRect.y, this.fRolloverRect.width, this.fRolloverRect.height);
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            this.moveIt(mouseEvent.getPoint());
        } else if (mouseEvent.getID() == 503 && PlatformInfo.useWindowsXPAppearance()) {
            if (this.fHasRollover) {
                if (!this.fRolloverRect.contains(mouseEvent.getPoint())) {
                    this.fHasRollover = false;
                    if (this.isEnabled()) {
                        this.repaint(this.fRolloverRect.x, this.fRolloverRect.y, this.fRolloverRect.width, this.fRolloverRect.height);
                    }
                }
            } else if (this.fRolloverRect.contains(mouseEvent.getPoint())) {
                this.fHasRollover = true;
                if (this.isEnabled()) {
                    this.repaint(this.fRolloverRect.x, this.fRolloverRect.y, this.fRolloverRect.width, this.fRolloverRect.height);
                }
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        int n;
        boolean bl = false;
        int n2 = n = this.getValue();
        if (keyEvent.getID() == 401 && this.isEnabled() && keyEvent.getModifiers() == 0) {
            bl = true;
            switch (keyEvent.getKeyCode()) {
                case 33: {
                    n = n2 + this.getBlockIncrement();
                    break;
                }
                case 34: {
                    n = n2 - this.getBlockIncrement();
                    break;
                }
                case 35: {
                    n = this.getMaximum();
                    break;
                }
                case 36: {
                    n = this.getMinimum();
                    break;
                }
                case 38: 
                case 39: {
                    n = n2 + this.getUnitIncrement();
                    break;
                }
                case 37: 
                case 40: {
                    n = n2 - this.getUnitIncrement();
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (!bl) {
            super.processKeyEvent(keyEvent);
        } else {
            this.setValue(n);
            if (n2 != this.getValue()) {
                Dimension dimension = this.getSize();
                this.repaint(1, 1, dimension.width - 2, dimension.height - 2);
                this.fireAdjustmentEvent();
            }
        }
    }

    @Override
    public void processFocusEvent(FocusEvent focusEvent) {
        boolean bl = focusEvent.getID() != 1005;
        if (bl != this.fHasFocus) {
            this.fHasFocus = bl;
            this.repaint();
        }
        super.processFocusEvent(focusEvent);
    }

    protected boolean setFocusState(boolean bl) {
        boolean bl2 = this.fHasFocus;
        this.fHasFocus = bl;
        return bl2;
    }

    private void fireAdjustmentEvent() {
        if (this.fListener != null) {
            AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, 601, 5, this.getValue());
            this.fListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    @Override
    public int getBlockIncrement() {
        return 0;
    }

    @Override
    public void setBlockIncrement(int n) {
    }

    @Override
    public int getUnitIncrement() {
        return 0;
    }

    @Override
    public void setUnitIncrement(int n) {
    }

    @Override
    public int getVisibleAmount() {
        return 0;
    }

    @Override
    public void setVisibleAmount(int n) {
    }
}

