% MATLAB Video Reader Object.
%
% Video Reader Functions and Properties.
%
% Video reader object construction.
%   VideoReader      - Construct VideoReader object.
%
% Getting and setting parameters.
%   get           - Get value of VideoReader object property.
%   set           - Set value of VideoReader object property.
%
% General.
%   clear         - Remove VideoReader object from memory.
%   display       - Display method for VideoReader objects.
%
% Video reader methods.
%   read          - Reads audio samples and/or video frames into the 
%                   workspace.
%
% Video reader properties.
%
%   Duration         - Total length of file in seconds. 
%   Name             - Name of the file to be read.
%   Path             - Path of the file to be read.
%   Tag              - Generic string for the user to set.
%   Type             - Classname of the object.
%   UserData         - Generic field for any user-defined data.
%
%   BitsPerPixel     - Bits per pixel of the video data.
%   FrameRate        - Frame rate of the video in frames per second.
%   Height           - Height of the video frame in pixels.
%   NumberOfFrames   - Total number of frames in the video stream.  
%   VideoFormat      - Video format as it is represented in MATLAB.
%   Width            - Width of the video frame in pixels.
%
%
% See also MMFILEINFO.

%   JCS
%   Copyright 2004-2010 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $  $Date: 2010/05/10 17:22:59 $
