/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.widgets.STPStateManagerFactory;
import com.mathworks.widgets.StateConstants;
import com.mathworks.widgets.StateManager;
import com.mathworks.widgets.text.STPInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class STPStateManagerImpl
implements StateManager {
    private static StateManager sSTPStateManager = new STPStateManagerImpl();
    private StateManager fFoldStateManager = STPStateManagerFactory.getInstance().getStateManager(StateConstants.Module.CODE_FOLDS);

    private STPStateManagerImpl() {
    }

    public static StateManager getInstance() {
        return sSTPStateManager;
    }

    @Override
    public void loadState(String string, Node node) {
        assert (string != null && node != null);
        Node node2 = this.getCodeFoldsState(node);
        this.fFoldStateManager.loadState(string, node2);
    }

    @Override
    public Node saveState(STPInterface sTPInterface, Node node) {
        assert (sTPInterface != null && node != null);
        String string = sTPInterface.getUniqueKey();
        if (string != null) {
            Node node2 = this.createCodeFoldsState(string, node);
            this.fFoldStateManager.saveState(sTPInterface, node2);
        }
        return node;
    }

    @Override
    public void updateState(STPInterface sTPInterface) {
        assert (sTPInterface != null);
        this.fFoldStateManager.updateState(sTPInterface);
    }

    @Override
    public void cleanup(STPInterface sTPInterface) {
        assert (sTPInterface != null);
        this.fFoldStateManager.cleanup(sTPInterface);
    }

    @Override
    public void clearState(String string) {
        assert (string != null);
        this.fFoldStateManager.clearState(string);
    }

    private Node getCodeFoldsState(Node node) {
        Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1 || !node3.getNodeName().equals("CodeFolds")) continue;
            node2 = node3;
            break;
        }
        return node2;
    }

    public Node createCodeFoldsState(String string, Node node) {
        Element element = null;
        Document document = node.getOwnerDocument();
        Element element2 = document.createElement("CodeFolds");
        element2.setAttribute("version", "1.0");
        element = element2;
        node.appendChild(element);
        return element;
    }
}

