/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.color;

import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MacAppearanceUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.DropdownButton;
import com.mathworks.widgets.PopupMenuCustomizer;
import com.mathworks.widgets.color.ColorPickerUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class ColorPicker
extends DropdownButton {
    public static final int NO_ICON = PickerIcon.NONE.ordinal();
    public static final int FILL_ICON = PickerIcon.FILL.ordinal();
    public static final int LINE_ICON = PickerIcon.LINE.ordinal();
    public static final int TEXT_ICON = PickerIcon.TEXT.ordinal();
    private static final int SMALL_SWATCH_WIDTH = MJUtilities.getPixelSize((int)11);
    private static final int SMALL_SWATCH_HEIGHT = MJUtilities.getPixelSize((int)3);
    private static final int BIG_SWATCH_WIDTH = MJUtilities.getPixelSize((int)11);
    private static final int BIG_SWATCH_HEIGHT = MJUtilities.getPixelSize((int)8);
    public static final Map<String, Color> BUILTIN_COLORS;
    private static final ResourceBundle BUNDLE;
    public static final int NUM_COLS = 8;
    private static final Color[] COLORS;
    private static final ColorSwatch[] COLOR_SWATCHES;
    public static final String MORE_COLORS_LABEL;
    private static final String COLOR_PICKER_COMPONENT_NAME = "ColorPicker";
    protected ActionListener fStringValueListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            ColorPicker.this.setValue(string);
        }
    };
    private ActionListener fColorValueListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (!Character.isDigit(string.charAt(0))) {
                return;
            }
            Color color = ColorPickerUtils.colorForActionCommand(string);
            ColorPicker.this.setValue(color);
        }
    };

    public ColorPicker(PickerIcon pickerIcon) {
        this.setName(COLOR_PICKER_COMPONENT_NAME);
        this.setFocusPainted(true);
        if (PlatformInfo.isMacintosh()) {
            MacAppearanceUtils.ButtonType.BEVEL.apply((AbstractButton)((Object)this));
            this.setMargin(new Insets(0, 0, 0, 0));
        } else {
            this.setMargin(new Insets(3, 3, 2, 3));
        }
        this.setIcon(pickerIcon.getEnabledIcon());
        this.setDisabledIcon(pickerIcon.getDisabledIcon());
        this.setPopupMenuCustomizer(new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                jPopupMenu.removeAll();
                jPopupMenu.setLayout(new GridBagLayout());
                ColorPicker.this.customizeMenu(jPopupMenu, ColorPicker.makePopupConstraints());
            }
        });
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.setShowMenuAutomatically(false);
        this.postMenu();
        this.setShowMenuAutomatically(true);
        return super.getPopupMenu();
    }

    protected void customizeMenu(JPopupMenu jPopupMenu, GridBagConstraints gridBagConstraints) {
        this.addColorSwatchMenuItems(jPopupMenu, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPopupMenu.add((Component)new JSeparator(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addMoreColorsMenuItem(jPopupMenu, gridBagConstraints);
    }

    private static GridBagConstraints makePopupConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        return gridBagConstraints;
    }

    protected void addColorSwatchMenuItems(JPopupMenu jPopupMenu, GridBagConstraints gridBagConstraints) {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = gridBagConstraints.gridy;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        for (int i = 0; i < COLORS.length; ++i) {
            if (i % 8 == 0) {
                ++gridBagConstraints2.gridy;
                gridBagConstraints2.gridx = 0;
                if (i == 16 || i == 32) {
                    gridBagConstraints.gridy = gridBagConstraints2.gridy++;
                    jPopupMenu.add((Component)new JSeparator(), gridBagConstraints);
                }
            } else {
                ++gridBagConstraints2.gridx;
            }
            jPopupMenu.add((Component)this.createSwatchMenuItem(i), gridBagConstraints2);
        }
        gridBagConstraints.gridy = gridBagConstraints2.gridy + 2;
    }

    protected void addMoreColorsMenuItem(JPopupMenu jPopupMenu, GridBagConstraints gridBagConstraints) {
        MJMenuItem mJMenuItem = ColorPicker.createPanelMenuItem(MORE_COLORS_LABEL);
        mJMenuItem.setName(MORE_COLORS_LABEL);
        mJMenuItem.setText(MORE_COLORS_LABEL);
        mJMenuItem.setHorizontalAlignment(0);
        mJMenuItem.setMnemonic(77);
        mJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(SwingUtilities.getWindowAncestor((Component)((Object)ColorPicker.this)), BUNDLE.getString("moreColorsDialog.title"), (Color)(ColorPicker.this.getValue() instanceof Color ? ColorPicker.this.getValue() : null));
                if (color != null) {
                    ColorPicker.this.setValue(color);
                    ColorPicker.this.revalidate();
                }
            }
        });
        jPopupMenu.add((Component)mJMenuItem, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    private JMenuItem createSwatchMenuItem(int n) {
        MJMenuItem mJMenuItem = ColorPicker.createPanelMenuItem(COLOR_SWATCHES[n]);
        mJMenuItem.setActionCommand(ColorPickerUtils.colorToActionCommand(COLORS[n]));
        mJMenuItem.setToolTipText(ColorPickerUtils.createToolTipText(COLORS[n]));
        mJMenuItem.setName(ColorPickerUtils.createToolTipText(COLORS[n]));
        mJMenuItem.addActionListener(this.fColorValueListener);
        return mJMenuItem;
    }

    @Override
    public void setIcon(Icon icon) {
        ColorIcon colorIcon = new ColorIcon(icon);
        super.setIcon(colorIcon);
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        ColorIcon colorIcon = new ColorIcon(icon);
        super.setDisabledIcon(colorIcon);
    }

    public void fireColorAction(ActionEvent actionEvent) {
        this.fColorValueListener.actionPerformed(actionEvent);
    }

    public static Color[] getColors() {
        return (Color[])Collections.unmodifiableList(Arrays.asList(COLORS)).toArray();
    }

    public static ColorSwatch[] getSwatches() {
        return (ColorSwatch[])Collections.unmodifiableList(Arrays.asList(COLOR_SWATCHES)).toArray();
    }

    static {
        BUNDLE = ColorPickerUtils.getBundle();
        Hashtable<String, Color> hashtable = new Hashtable<String, Color>(8);
        hashtable.put("white", new Color(255, 255, 255));
        hashtable.put("black", new Color(0, 0, 0));
        hashtable.put("yellow", new Color(255, 255, 0));
        hashtable.put("magenta", new Color(255, 0, 255));
        hashtable.put("cyan", new Color(0, 255, 255));
        hashtable.put("red", new Color(255, 0, 0));
        hashtable.put("green", new Color(0, 255, 0));
        hashtable.put("blue", new Color(0, 0, 255));
        BUILTIN_COLORS = Collections.unmodifiableMap(hashtable);
        COLORS = new Color[]{new Color(0, 0, 0), new Color(255, 255, 255), new Color(240, 240, 240), new Color(212, 208, 200), new Color(204, 204, 204), new Color(128, 128, 128), new Color(80, 80, 80), new Color(63, 63, 63), new Color(255, 0, 0), new Color(255, 0, 255), new Color(0, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 255, 0), new Color(153, 51, 0), new Color(255, 153, 200), new Color(191, 191, 0), new Color(191, 0, 191), new Color(0, 127, 0), new Color(0, 191, 191), new Color(20, 43, 140), new Color(218, 179, 255), new Color(255, 215, 0), new Color(222, 125, 0), new Color(0, 114, 189), new Color(217, 83, 25), new Color(237, 177, 32), new Color(126, 47, 142), new Color(119, 172, 48), new Color(77, 190, 238), new Color(162, 20, 47), new Color(173, 235, 255), new Color(248, 248, 248), new Color(238, 238, 238), new Color(231, 231, 231), new Color(220, 220, 220), new Color(126, 126, 126), new Color(97, 97, 97), new Color(80, 80, 80), new Color(60, 60, 60), new Color(255, 247, 235), new Color(255, 242, 221), new Color(253, 234, 203), new Color(243, 222, 187), new Color(149, 99, 99), new Color(135, 81, 81), new Color(115, 67, 67), new Color(82, 48, 48), new Color(245, 249, 253), new Color(222, 235, 250), new Color(205, 224, 247), new Color(186, 212, 244), new Color(100, 121, 162), new Color(78, 101, 148), new Color(52, 77, 126), new Color(39, 58, 95), new Color(251, 247, 247), new Color(245, 235, 235), new Color(239, 221, 221), new Color(236, 214, 214), new Color(131, 97, 123), new Color(120, 78, 114), new Color(108, 64, 100), new Color(89, 51, 84), new Color(241, 247, 242), new Color(228, 240, 230), new Color(214, 232, 217), new Color(193, 221, 198), new Color(59, 113, 86), new Color(42, 98, 70), new Color(27, 79, 53), new Color(18, 54, 36)};
        COLOR_SWATCHES = new ColorSwatch[COLORS.length];
        for (int i = 0; i < COLORS.length; ++i) {
            ColorPicker.COLOR_SWATCHES[i] = new ColorSwatch(COLORS[i]);
        }
        MORE_COLORS_LABEL = BUNDLE.getString("label.morecolors");
    }

    private class ColorIcon
    implements Icon {
        private final Icon iBaseIcon;
        private final int iSwatchWidth;
        private final int iSwatchHeight;
        private final int iHeight;
        private final int iWidth;
        private final int iColorX;
        private final int iColorY;

        ColorIcon(Icon icon) {
            this.iBaseIcon = icon;
            if (icon == null) {
                this.iSwatchHeight = BIG_SWATCH_HEIGHT;
                this.iSwatchWidth = BIG_SWATCH_WIDTH;
                this.iHeight = BIG_SWATCH_HEIGHT;
                this.iWidth = BIG_SWATCH_WIDTH;
                this.iColorX = 0;
                this.iColorY = 1;
            } else {
                this.iSwatchHeight = SMALL_SWATCH_HEIGHT;
                this.iSwatchWidth = SMALL_SWATCH_WIDTH;
                this.iHeight = icon.getIconHeight() + SMALL_SWATCH_HEIGHT;
                this.iWidth = Math.max(icon.getIconWidth(), SMALL_SWATCH_WIDTH);
                this.iColorX = Math.max(icon.getIconWidth() - SMALL_SWATCH_WIDTH, 0) / 2;
                this.iColorY = icon.getIconHeight();
            }
        }

        @Override
        public int getIconHeight() {
            return this.iHeight;
        }

        @Override
        public int getIconWidth() {
            return this.iWidth;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.iBaseIcon != null) {
                this.iBaseIcon.paintIcon(component, graphics, n, n2);
            }
            Color color = null;
            Object object = ColorPicker.this.getValue();
            if (object instanceof Color) {
                color = (Color)object;
            }
            if (color != null) {
                graphics.setColor(component.isEnabled() ? color : Color.gray);
                graphics.fillRect(n + this.iColorX, n2 + this.iColorY, this.iSwatchWidth - 1, this.iSwatchHeight - 1);
            } else {
                graphics.setColor(component.isEnabled() ? Color.black : Color.gray);
                if (!(object instanceof String) || !"auto".equals(object)) {
                    graphics.drawRect(n + this.iColorX, n2 + this.iColorY, this.iSwatchWidth - 1, this.iSwatchHeight - 1);
                }
            }
        }
    }

    public static class ColorSwatch
    implements Icon {
        private Color fColor;
        private final int fSize = MJUtilities.getPixelSize((int)9);

        ColorSwatch(Color color) {
            this.setColor(color);
        }

        public Color getColor() {
            return this.fColor;
        }

        public void setColor(Color color) {
            this.fColor = color;
        }

        @Override
        public int getIconHeight() {
            return this.fSize;
        }

        @Override
        public int getIconWidth() {
            return this.fSize;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.fColor == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (!component.isEnabled()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            }
            graphics2D.setColor(this.fColor);
            graphics2D.fillRect(n, n2, this.fSize - 1, this.fSize - 1);
            graphics2D.setColor(Color.gray.darker());
            graphics2D.drawRect(n, n2, this.fSize - 1, this.fSize - 1);
            graphics2D.dispose();
        }
    }

    public static enum PickerIcon {
        NONE(null, null),
        FILL(ColorPickerUtils.Icon.FILL.getIcon(), ColorPickerUtils.Icon.FILL_DISABLED.getIcon()),
        LINE(ColorPickerUtils.Icon.LINE.getIcon(), ColorPickerUtils.Icon.LINE_DISABLED.getIcon()),
        TEXT(ColorPickerUtils.Icon.TEXT.getIcon(), ColorPickerUtils.Icon.TEXT_DISABLED.getIcon());

        private Icon fDisabledIcon;
        private Icon fEnabledIcon;

        private PickerIcon(Icon icon, Icon icon2) {
            this.fEnabledIcon = icon;
            this.fDisabledIcon = icon2;
        }

        public Icon getEnabledIcon() {
            return this.fEnabledIcon;
        }

        public Icon getDisabledIcon() {
            return this.fDisabledIcon;
        }
    }
}

